/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.rmi.ZoneState;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ZoneStateData {
    private long zoneId;
    private String deviceIp = "";
    private Map<EventIdentifier, Integer> partStates = new HashMap<EventIdentifier, Integer>();

    public ZoneStateData(long zoneId) {
        this.zoneId = zoneId;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public ZoneState getZoneState() {
        ZoneState state = new ZoneState();
        state.setDeviceIp(this.getDeviceIp());
        state.setZoneId(this.getZoneId());
        state.setState(this.getCurrentState());
        return state;
    }

    public boolean addStateData(EventIdentifier identifier, int state) {
        int oldState = this.getOverallStateState();
        if (state == 1) {
            this.partStates.remove(identifier);
        } else {
            this.partStates.put(identifier, state);
        }
        int currentState = this.getOverallStateState();
        return currentState != oldState;
    }

    public boolean equals(Object o) {
        ZoneStateData data;
        if (o instanceof ZoneStateData && (data = (ZoneStateData)o).getZoneId() == this.zoneId) {
            if (data.getZoneId() == 1L) {
                return data.getDeviceIp().equals(this.getDeviceIp());
            }
            return true;
        }
        return false;
    }

    public int getCurrentState() {
        return this.getOverallStateState();
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public int hashCode() {
        if (this.getZoneId() == 1L) {
            return this.deviceIp.hashCode();
        }
        return (int)(this.zoneId ^ this.zoneId >>> 32);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).appendSuper("super").append("zoneId", this.zoneId).append("part state:", this.partStates).toString();
    }

    private int getOverallStateState() {
        int state = 1;
        for (Integer partStateValue : this.partStates.values()) {
            state = state > partStateValue ? state : partStateValue;
        }
        return state;
    }
}

