/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process.unicom;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.unicom.AticCleanLogService;
import com.hs.atic.rmi.unicom.CleanLogEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CleanLogProcessThread<T extends Event>
extends Thread {
    private static final CleanLogProcessThread INSTANCE = new CleanLogProcessThread();
    private static final Logger LOGGER = LogManager.getInstance().getFlowLog();
    private static final String CLEAN_LOG_SERVICE = "aticCleanLogService";
    private static final long SLEEP_TIME = 1000L;
    private static final int PERIOD = 70;
    private AticCleanLogService cleanLogService;
    private Map<CleanLogType, CleanLogEntity> cleanLogMap = new HashMap<CleanLogType, CleanLogEntity>();
    private Map<CleanLogType, Long> reportedTimeMap = new HashMap<CleanLogType, Long>();
    private boolean isUnicomSocEnable = false;
    private int loopCount = 5;

    private CleanLogProcessThread() {
        this.initUnicomSocEnable();
    }

    public static CleanLogProcessThread getInstance() {
        return INSTANCE;
    }

    @Override
    public void run() {
        long lastTime = System.currentTimeMillis();
        while (this.isUnicomSocEnable) {
            try {
                Map<CleanLogType, CleanLogEntity> tmpCleanLogMap = this.cleanLogMap;
                this.cleanLogMap = new HashMap<CleanLogType, CleanLogEntity>();
                this.reportAllCleanLogs(tmpCleanLogMap);
                this.threadSleep(1000L);
                long currTime = System.currentTimeMillis();
                if (currTime - lastTime < CollectorConstants.FIVE_MIN * 1000L) continue;
                this.processMapTimeout(currTime);
                lastTime = currTime;
            }
            catch (Exception e) {
                LOGGER.error((Object)("CleanLogProcessThread error." + e.getMessage()));
                this.threadSleep(1000L);
            }
        }
    }

    private void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e1) {
            LOGGER.error((Object)("Thread.sleep." + e1.getMessage()));
        }
    }

    private void processMapTimeout(long currTime) {
        if (this.reportedTimeMap.size() > 0) {
            Iterator<Map.Entry<CleanLogType, Long>> it = this.reportedTimeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CleanLogType, Long> entry = it.next();
                if ((currTime - entry.getValue()) / 1000L < CollectorConstants.FIVE_MIN) continue;
                it.remove();
            }
        }
    }

    private void reportAllCleanLogs(Map<CleanLogType, CleanLogEntity> tmpCleanLogMap) {
        List<CleanLogEntity> cleanLogList = null;
        int size = tmpCleanLogMap.size();
        if (size > 0) {
            Iterator<Map.Entry<CleanLogType, CleanLogEntity>> iterator = tmpCleanLogMap.entrySet().iterator();
            for (int i = 0; i <= size / 10000; ++i) {
                cleanLogList = this.getOnceCleanLogs(iterator);
                this.reportOnceCleanLogs(cleanLogList);
            }
        }
    }

    private boolean reportOnceCleanLogs(List<CleanLogEntity> cleanLogList) {
        if (null != this.getCleanLogService()) {
            try {
                if (!cleanLogList.isEmpty()) {
                    LOGGER.info((Object)("reportOnceCleanLogs, log size=" + cleanLogList.size()));
                    int index = 0;
                    for (CleanLogEntity logEntity : cleanLogList) {
                        LOGGER.info((Object)("reprot index=" + index++ + ",cleanLog=" + logEntity.toString()));
                    }
                    this.cleanLogService.processCleanLogs(cleanLogList);
                }
                return true;
            }
            catch (Exception e) {
                this.cleanLogService = null;
                LOGGER.error((Object)("reportOnceCleanLogs error!" + e.getMessage()));
                return false;
            }
        }
        LOGGER.error((Object)"cleanLogService is null, not reprot.");
        return false;
    }

    private AticCleanLogService getCleanLogService() {
        if (null == this.cleanLogService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.cleanLogService = (AticCleanLogService)CommonUtil.retreiveAticRmiService(CLEAN_LOG_SERVICE);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("get AticCleanLogService failed! " + e.getMessage()));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        LOGGER.error((Object)("get InterruptedException when get AticCleanLogService! " + e2.getMessage()));
                    }
                    continue;
                }
            }
        }
        return this.cleanLogService;
    }

    private List<CleanLogEntity> getOnceCleanLogs(Iterator<Map.Entry<CleanLogType, CleanLogEntity>> iterator) {
        ArrayList<CleanLogEntity> cleanLogList = new ArrayList<CleanLogEntity>();
        int index = 0;
        while (iterator.hasNext() && index < 10000) {
            Map.Entry<CleanLogType, CleanLogEntity> entry = iterator.next();
            CleanLogEntity entity = entry.getValue();
            if (null != entity.getAttackTypes() && !entity.getAttackTypes().isEmpty()) {
                if (0L == entity.getStatTime()) {
                    entity.setStatTime(System.currentTimeMillis());
                    entity.setStatDuration(70L);
                }
                cleanLogList.add(entity);
                ++index;
                this.reportedTimeMap.put(entry.getKey(), entity.getStatTime());
            }
            iterator.remove();
        }
        return cleanLogList;
    }

    private void initUnicomSocEnable() {
        try {
            this.isUnicomSocEnable = Boolean.valueOf(EventUtil.getEventConfigProperty("isUnicomSocEnable"));
        }
        catch (NumberFormatException e) {
            this.isUnicomSocEnable = false;
            LOGGER.error((Object)"Get isUnicomSocEnable from event.conf error");
        }
    }

    public void processAttackExactLog(List<ExceptionEvent> attackEvents) {
        if (this.isUnicomSocEnable && null != attackEvents && !attackEvents.isEmpty()) {
            for (ExceptionEvent attackEvent : attackEvents) {
                if (!attackEvent.isIsEverAttacked() || !attackEvent.isFromCleanDevice()) continue;
                CleanLogType type = new CleanLogType(attackEvent.getDeviceIp(), attackEvent.getZoneIp());
                CleanLogEntity entity = this.cleanLogMap.get(type);
                if (null == entity) {
                    entity = new CleanLogEntity();
                    entity.setCleanDeviceIp(attackEvent.getDeviceIp());
                    entity.setProtectIp(attackEvent.getZoneIp());
                    this.cleanLogMap.put(type, entity);
                }
                entity.getAttackTypes().put(attackEvent.getAttackType().getTypeValue(), attackEvent.getAttackPeakKbps());
                entity.setInFlow(attackEvent.getIpInPeakKbps());
                entity.setOutFlow(attackEvent.getIpInPeakKbps() - attackEvent.getIpAttackPeakKbps());
                this.initStatTime(entity, attackEvent);
                Set<String> srcIps = attackEvent.getAttackers();
                if (srcIps.isEmpty()) continue;
                for (String srcIp : srcIps) {
                    entity.getAttackSrcIpTop().put(srcIp, 0L);
                }
            }
        }
    }

    private void initStatTime(CleanLogEntity entity, AbnormalEvent attackEvent) {
        CleanLogType type = new CleanLogType(attackEvent.getDeviceIp(), attackEvent.getZoneIp());
        Long lastTime = this.reportedTimeMap.get(type);
        long attackStartTime = attackEvent.getAttackStartTime();
        if (null == lastTime) {
            entity.setStatTime(attackStartTime);
            entity.setStatDuration(attackEvent.getDuration());
        } else {
            long currTime = System.currentTimeMillis();
            entity.setStatDuration((currTime - lastTime) / 1000L);
            entity.setStatTime(currTime);
        }
    }

    public boolean isUnicomSocEnable() {
        return this.isUnicomSocEnable;
    }

    private class CleanLogType
    implements Type {
        private String deviceIp;
        private String protectIp;

        public CleanLogType(String devIp, String ptectIp) {
            this.deviceIp = devIp;
            this.protectIp = ptectIp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.deviceIp == null ? 0 : this.deviceIp.hashCode());
            result = 31 * result + (this.protectIp == null ? 0 : this.protectIp.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CleanLogType other = (CleanLogType)obj;
            if (this.deviceIp == null ? other.deviceIp != null : !this.deviceIp.equals(other.deviceIp)) {
                return false;
            }
            return !(this.protectIp == null ? other.protectIp != null : !this.protectIp.equals(other.protectIp));
        }
    }
}

