/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.monitor;

import com.hs.atic.collector.biz.monitor.ISystemTool;
import com.hs.atic.collector.biz.monitor.SystemToolFactory;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.util.LogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LinuxSystemTool
implements ISystemTool {
    private static final int MAX_STR_LEN = Integer.MAX_VALUE;
    private static final String MEM_INFO_PATH = "/proc/meminfo";
    private static final String CPU_INFO_PATH = "/proc/stat";
    private static final int MB2GB = 1024;
    private static final int ONE_HUNDRED = 100;
    private static final int A_THOUSAND = 1000;
    private static final int LINE_KEY_NUM = 7;
    private static final int LINE_TYPE = 1;
    private static final int LINE_TOTAL = 2;
    private static final int LINE_USED = 3;
    private static final int LINE_PERCENT = 5;
    private static final int LINE_NAME = 6;
    private static final int TIME_OUT = 5000;
    private static final int SLEEP_TIME = 5000;
    private static final int MAX_STRING_SIZE = 10240;
    private static final String ISO = "iso9660";
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinuxSystemTool() {
        LOGGER.info((Object)"~~begin to load oscommand.properties");
        Properties props = new Properties();
        InputStream instream = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            if (null != loader) {
                instream = loader.getResourceAsStream("oscommand.properties");
            }
            if (null != instream) {
                props.load(instream);
            }
            String linuxDiskCmd = props.getProperty("cmd.linux.disk", "df -hT");
            System.setProperty("cmd.linux.disk", linuxDiskCmd);
            LOGGER.info((Object)("cmd.linux.disk:" + linuxDiskCmd));
        }
        catch (Exception e) {
            LOGGER.error((Object)("read oscommand.properties error." + e.getMessage()));
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close InputStream of oscommand.properties fail");
                }
            }
        }
    }

    @Override
    public int getPercentMemInfo() {
        int[] result = this.getMemInfo();
        int memUsedPercent = result[0] * 100 / (result[0] + result[1]);
        LOGGER.info((Object)("getPercentMemInfo()=" + memUsedPercent));
        return memUsedPercent;
    }

    @Override
    public long getTotalMemInfo() {
        long total = -1L;
        int[] result = this.getMemInfo();
        if (result.length >= 2) {
            total = result[0] + result[1];
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int[] getMemInfo() {
        String[] strArray;
        int[] result;
        block11: {
            LOGGER.debug((Object)"start");
            result = new int[3];
            strArray = new String[4];
            Runtime rt = Runtime.getRuntime();
            BufferedReader errRead = null;
            BufferedReader bufRead = null;
            Process process = null;
            try {
                process = rt.exec("free");
                errRead = new BufferedReader(new InputStreamReader(process.getErrorStream(), "utf-8"));
                bufRead = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
                String str = null;
                while (null != (str = errRead.readLine())) {
                }
                while ((str = bufRead.readLine()) != null) {
                    if (!str.contains("-/+ buffers/cache:")) continue;
                    StringTokenizer token = new StringTokenizer(str);
                    for (int i = 0; token.hasMoreTokens() && i < 4; ++i) {
                        strArray[i] = token.nextToken();
                    }
                }
                this.destroy(errRead, bufRead, process);
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException error");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception:" + e.getMessage()));
                this.destroy(errRead, bufRead, process);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.destroy(errRead, bufRead, process);
            }
        }
        if (null != strArray[2] && null != strArray[3]) {
            result[0] = Integer.parseInt(strArray[2]);
            result[1] = Integer.parseInt(strArray[3]);
        }
        return result;
    }

    private void destroy(BufferedReader errRead, BufferedReader bufRead, Process process) {
        try {
            if (null != errRead) {
                errRead.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"buf close failure");
        }
        try {
            if (null != bufRead) {
                bufRead.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"buf close failure");
        }
        if (null != process) {
            try {
                process.destroy();
            }
            catch (Exception e2) {
                LOGGER.error((Object)("buf close failure:" + e2.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CpuInfo getSomeTimeCpuInfo() {
        CpuInfo cpuInfo = new CpuInfo();
        FileInputStream fileInput = null;
        InputStreamReader input = null;
        BufferedReader bufReader = null;
        try {
            StringTokenizer token;
            File file = new File(LinuxSystemTool.getCpuInfoPath());
            fileInput = new FileInputStream(file);
            input = new InputStreamReader((InputStream)fileInput, "utf-8");
            bufReader = new BufferedReader(input);
            String str = bufReader.readLine();
            if (str != null && (token = new StringTokenizer(str)).hasMoreTokens()) {
                token.nextToken();
                cpuInfo.user = Long.parseLong(token.nextToken());
                cpuInfo.nice = Long.parseLong(token.nextToken());
                cpuInfo.sys = Long.parseLong(token.nextToken());
                cpuInfo.idle = Long.parseLong(token.nextToken());
                cpuInfo.syswa = Long.parseLong(token.nextToken());
                cpuInfo.syswi = Long.parseLong(token.nextToken());
                cpuInfo.syssi = Long.parseLong(token.nextToken());
                cpuInfo.sysst = Long.parseLong(token.nextToken());
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)"getCpuInfo() | IOException");
        }
        finally {
            try {
                if (null != bufReader) {
                    bufReader.close();
                }
                if (null != input) {
                    input.close();
                }
                if (null != fileInput) {
                    fileInput.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"fail to close buf IOException");
            }
        }
        return cpuInfo;
    }

    @Override
    public int getCpuInfo() {
        double cpuUsedPercent = 0.0;
        CpuInfo infoOfOne = this.getSomeTimeCpuInfo();
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)("getCpuInfo() | sleep interrupted:" + e.getMessage()));
        }
        CpuInfo infoOfTwo = this.getSomeTimeCpuInfo();
        long totalOfFirst = infoOfOne.user + infoOfOne.sys + infoOfOne.nice + infoOfOne.idle + infoOfOne.syswa + infoOfOne.syswi + infoOfOne.syssi + infoOfOne.sysst;
        long totalOfSecond = infoOfTwo.user + infoOfTwo.sys + infoOfTwo.nice + infoOfTwo.idle + infoOfTwo.syswa + infoOfTwo.syswi + infoOfTwo.syssi + infoOfTwo.sysst;
        double total = totalOfSecond - totalOfFirst;
        if (0.0 != total) {
            cpuUsedPercent = 1.0 - (double)(infoOfTwo.idle - infoOfOne.idle) / total;
        }
        if (cpuUsedPercent < 0.0) {
            cpuUsedPercent = 0.0;
        }
        LOGGER.debug((Object)("getCpuInfo() | cpuUsedPercent is:{0} " + cpuUsedPercent));
        return (int)(100.0 * cpuUsedPercent);
    }

    public static String getMemInfoPath() {
        return MEM_INFO_PATH;
    }

    public static String getCpuInfoPath() {
        return CPU_INFO_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CollectorDiskObj> getDisk(long monitorTime) {
        LOGGER.info((Object)"getRootPartition() | start to get root partition");
        ArrayList<CollectorDiskObj> diskList = new ArrayList<CollectorDiskObj>();
        if (!SystemToolFactory.isLinuxSystem()) {
            LOGGER.error((Object)"this is not linux system, getdisk return empty list.");
            return diskList;
        }
        String cmd = "df -hT";
        String cmdAdjust = System.getProperty("cmd.linux.disk");
        if (cmdAdjust != null && !cmdAdjust.isEmpty()) {
            if (Pattern.matches("[0-9A-Za-z./]+", cmdAdjust)) {
                cmd = cmdAdjust;
                LOGGER.info((Object)("use linux disk adjust command: " + cmdAdjust));
            }
        } else {
            LOGGER.info((Object)"use defualt linux disk adjust command: df -hT");
        }
        LOGGER.info((Object)("get disk info cmd is " + cmd));
        Process process = null;
        BufferedReader in = null;
        InputStreamReader ir = null;
        int exitVal = -1;
        try {
            process = Runtime.getRuntime().exec(cmd);
            this.sleep(5000);
            long startTime = System.currentTimeMillis();
            boolean processFinished = false;
            while (System.currentTimeMillis() - startTime < 5000L && !processFinished) {
                exitVal = process.exitValue();
                LOGGER.info((Object)("process.exitValue() = " + exitVal));
                if (0 == exitVal) {
                    processFinished = Boolean.TRUE;
                }
                this.sleep(5000);
            }
            if (0 == exitVal) {
                ir = new InputStreamReader(process.getInputStream(), "utf-8");
                in = new BufferedReader(ir);
                String str = "";
                ArrayList<String> regularOutput = new ArrayList<String>();
                String leftString = "";
                while ((str = in.readLine()) != null) {
                    List<String> result;
                    String temp = str.replaceAll("\\s", " ");
                    if (!leftString.isEmpty()) {
                        temp = leftString + " " + temp;
                    }
                    if ((result = this.getSplitDiskValues(temp)).size() >= 7) {
                        if (temp.length() > 10240 || regularOutput.size() > 10240) break;
                        regularOutput.add(temp);
                        leftString = "";
                        continue;
                    }
                    leftString = str;
                    LOGGER.info((Object)("less line retrived:" + leftString));
                }
                for (String line : regularOutput) {
                    CollectorDiskObj resourceUse = this.getResouceUse(line);
                    if (null == resourceUse) continue;
                    resourceUse.setMonitorTime(monitorTime);
                    diskList.add(resourceUse);
                    LOGGER.info((Object)("get disk info: " + resourceUse.toString()));
                }
            }
            LinuxSystemTool.threadDealStream(process.getErrorStream(), true);
        }
        catch (IllegalThreadStateException e) {
            LOGGER.error((Object)("Fail to get root partition, IOException:" + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Fail to get root partition, IOException");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Fail to get root partition, exception:" + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fail to get root partition, exception:" + e.getMessage()));
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != ir) {
                    ir.close();
                }
            }
            catch (IOException ioex) {
                LOGGER.error((Object)"fail to close input");
            }
            catch (Exception ex) {
                LOGGER.error((Object)("fail to close input!" + ex.getMessage()));
            }
            if (null != process) {
                try {
                    process.destroy();
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("buf close failure:" + ex.getMessage()));
                }
            }
        }
        return diskList;
    }

    private static void threadDealStream(final InputStream input, final boolean errLevel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int intC;
                    BufferedReader bf = new BufferedReader(new InputStreamReader(input, System.getProperty("file.encoding")));
                    String line = null;
                    LOGGER.info((Object)"readStreamBufferLine");
                    StringBuffer sb = new StringBuffer();
                    while ((intC = bf.read()) != -1) {
                        char c = (char)intC;
                        if (c == '\n') {
                            line = sb.toString();
                            if (errLevel) {
                                LOGGER.error((Object)line);
                            } else {
                                LOGGER.info((Object)line);
                            }
                            sb = new StringBuffer();
                        }
                        if (sb.length() >= Integer.MAX_VALUE) {
                            throw new RuntimeException("input content too long");
                        }
                        sb.append(c);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)("threadDealStream Exception! " + e.getMessage()));
                }
            }
        }).start();
    }

    private List<String> getSplitDiskValues(String str) {
        String temp = str.replaceAll("\\s", " ");
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(temp, " ");
        for (int i = 0; tokenizer.hasMoreTokens() && i < 7; ++i) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private CollectorDiskObj getResouceUse(String str) {
        CollectorDiskObj resourceUse = null;
        String keyword1 = "/";
        String keyword2 = "/opt";
        String keyword3 = "/opt/hwlog";
        LOGGER.info((Object)("getResouceUse input: " + str));
        List<String> result = this.getSplitDiskValues(str);
        if (result.size() < 7) {
            LOGGER.error((Object)("input string is no more than 7 : " + str));
            return null;
        }
        if (ISO.equalsIgnoreCase(result.get(1))) {
            LOGGER.error((Object)("ISO.equalsIgnoreCase: " + result.get(1)));
            return null;
        }
        if (keyword1.equals(result.get(6)) || keyword2.equals(result.get(6)) || keyword3.equals(result.get(6))) {
            for (String item : result) {
                if (item != null) continue;
                LOGGER.error((Object)"input string is encount null");
                return null;
            }
            resourceUse = new CollectorDiskObj();
            resourceUse.setDiskName(result.get(6));
            String useRatio = result.get(5);
            useRatio = useRatio.substring(0, useRatio.length() - 1);
            try {
                resourceUse.setDiskUseRatio(Integer.parseInt(useRatio));
            }
            catch (NumberFormatException e) {
                return null;
            }
            String diskSize = result.get(2);
            String unit = diskSize.substring(diskSize.length() - 1);
            diskSize = diskSize.substring(0, diskSize.length() - 1);
            int sizeTotal = 0;
            try {
                float sizeFloat = Float.parseFloat(diskSize);
                sizeTotal = Float.valueOf(sizeFloat).intValue();
                if (0 == sizeTotal) {
                    sizeTotal = 1;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("getResouceUse e " + e.getMessage()));
                return null;
            }
            if ("G".equalsIgnoreCase(unit)) {
                sizeTotal *= 1024;
            } else if ("T".equalsIgnoreCase(unit)) {
                sizeTotal = sizeTotal * 1024 * 1024;
            } else if ("K".equalsIgnoreCase(unit)) {
                sizeTotal /= 1024;
            }
            resourceUse.setDiskSize(sizeTotal);
        }
        return resourceUse;
    }

    private void sleep(int sleepTime) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("System monitor thread interruptedException! " + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("System monitor thread Exception! " + e.getMessage()));
        }
    }

    @Override
    public long getAvailMemInfo() {
        int[] result = this.getMemInfo();
        return result[1];
    }

    private static class CpuInfo {
        private long user;
        private long nice;
        private long sys;
        private long idle;
        private long syswa;
        private long syswi;
        private long syssi;
        private long sysst;

        private CpuInfo() {
        }
    }
}

