/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.monitor;

import com.hs.atic.collector.biz.monitor.ISystemTool;
import com.hs.atic.collector.biz.monitor.LinuxSystemTool;
import com.hs.atic.collector.biz.monitor.WindowsSystemTool;
import com.hs.atic.collector.util.LogManager;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class SystemToolFactory {
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();
    private static final Object LOCK = new Object();
    private static ISystemTool systemTool = null;

    private SystemToolFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISystemTool getSystemTool() {
        Object object = LOCK;
        synchronized (object) {
            if (systemTool != null) {
                return systemTool;
            }
            String o = System.getProperty("os.name");
            if (null == o) {
                return null;
            }
            String os = o.toLowerCase(Locale.US);
            if (os.contains("win")) {
                try {
                    systemTool = new WindowsSystemTool();
                }
                catch (Exception e) {
                    LOGGER.info((Object)("init resource tool failed!" + e.getMessage()));
                }
                LOGGER.info((Object)"use windows system tool");
            }
            if (os.contains("linux")) {
                systemTool = new LinuxSystemTool();
                LOGGER.info((Object)"use linux system tool");
            }
            return systemTool;
        }
    }

    public static boolean isLinuxSystem() {
        String o = System.getProperty("os.name");
        if (null == o) {
            return false;
        }
        String os = o.toLowerCase(Locale.US);
        return os.contains("linux");
    }
}

