/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.monitor;

import com.hs.atic.bis.model.ResourceResult;
import com.hs.atic.collector.biz.monitor.ISystemTool;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ResourceCbb;
import com.hs.atic.rmi.PcapAnalysisUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WindowsSystemTool
implements ISystemTool {
    public static final int MAX_BUFFER_LEN = 20;
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final long MB = 0x100000L;
    private static final double DBHUNDRED = 100.0;
    private static final double LHUNDRED = 100.0;
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    @Override
    public int getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return (int)percent;
    }

    @Override
    public int getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / (double)total;
        return (int)percent;
    }

    @Override
    public long getAvailMemInfo() {
        return this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    @Override
    public long getTotalMemInfo() {
        return this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    private synchronized long getCPUAndMenInfo(String para) {
        long returnVaule = 1L;
        ResourceCbb resourceCbb = null;
        try {
            byte[] bytes = new byte[20];
            resourceCbb = ResourceCbb.SYNC_INSTANCE;
            ResourceResult.ByReference result = new ResourceResult.ByReference();
            resourceCbb.getWindowsResource(para, result);
            System.arraycopy(result.getRetStr(), 0, bytes, 0, 20);
            returnVaule = Long.parseLong(PcapAnalysisUtil.byteToString(bytes));
        }
        catch (Exception e) {
            LOGGER.error((Object)("getCPUAndMenInfo error! " + e.getMessage()));
        }
        return returnVaule;
    }

    @Override
    public synchronized List<CollectorDiskObj> getDisk(long monitorTime) {
        File[] roots = File.listRoots();
        ArrayList<CollectorDiskObj> list = new ArrayList<CollectorDiskObj>();
        if (roots == null) {
            return list;
        }
        for (File file : roots) {
            CollectorDiskObj disktemp = new CollectorDiskObj();
            disktemp.setDiskName(file.getPath().substring(0, 1));
            disktemp.setMonitorTime(monitorTime);
            double totalSpace = file.getTotalSpace();
            double usableSpace = file.getUsableSpace();
            if (!(totalSpace > 0.0) || !file.canWrite() || !(usableSpace >= 0.0)) continue;
            double total = this.getDoubleValue(totalSpace / 1048576.0);
            disktemp.setDiskSize((int)total);
            double useableGB = this.getDoubleValue(usableSpace / 1048576.0);
            double percent = this.getDoubleValue((total - useableGB) / total) * 100.0;
            disktemp.setDiskUseRatio((int)percent);
            list.add(disktemp);
        }
        return list;
    }

    private double getDoubleValue(double value) {
        BigDecimal capacity = new BigDecimal(value);
        double temp = capacity.setScale(2, 4).doubleValue();
        return temp;
    }
}

