/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.biz.pcap.task.CleanPcapFileThread;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.condition.AllCondition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.condition.PcapConditionField;
import com.hs.atic.collector.db.condition.TaskConditionField;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public final class PcapBuilder
implements Processor<PcapEntity> {
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    private static PcapBuilder builder = new PcapBuilder();
    private static final int LIMIT = 80;
    private static final int LIMIT_CONDITION = 1000;
    private static final int DISK_DEL_PCAP_FILE_LIMIT = 5;
    private static final Long MAX_PCAP_FILE_NUMBER = 1000000L;
    private static final long DEFAULT_RECEIVE_FILE_SIZE = 0x100000L;
    private Set<CaptureTask> capTaskSet = new HashSet<CaptureTask>();
    private List<Object> waitCapTask = new ArrayList<Object>();
    private boolean captureOverLevel;
    private boolean captureOverThreshold;
    private int diskUseLimit;
    private long diskDelPcapFileLimit;
    private long receiveFileSize;
    private Repository pcapRepository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
    private Repository taskRepository = RepositoryFactory.getInstance().getRepository(CaptureTask.class.getName());

    private PcapBuilder() {
        try {
            this.diskUseLimit = Integer.parseInt(PcapUtil.getPcapConfigProperty("DiskUseLimitRatio"));
            this.diskDelPcapFileLimit = Integer.parseInt(PcapUtil.getPcapConfigProperty("DiskDelPcapFileLimit"));
            LOGGER.info((Object)("Disk Use Limit Ratio is : " + this.diskUseLimit + ". diskDelPcapFileLimit is : " + this.diskDelPcapFileLimit + "."));
        }
        catch (RuntimeException e) {
            this.diskUseLimit = 80;
            this.diskDelPcapFileLimit = 5L;
            LOGGER.info((Object)("Read file pcap.conf wrong, and Disk Use Limit Ratio is : " + this.diskUseLimit + ". diskDelPcapFileLimit is : " + this.diskDelPcapFileLimit + "."));
        }
    }

    public boolean isCaptureOverThreshold() {
        return this.captureOverThreshold;
    }

    public void setCaptureOverThreshold(boolean captureOverThreshold) {
        this.captureOverThreshold = captureOverThreshold;
    }

    public boolean isCaptureOverLevel() {
        return this.captureOverLevel;
    }

    public void setCaptureOverLevel(boolean captureOverLevel) {
        this.captureOverLevel = captureOverLevel;
    }

    public static PcapBuilder getInstance() {
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCaptureTask() {
        List<Object> list = this.waitCapTask;
        synchronized (list) {
            for (Object o : this.waitCapTask) {
                if (o instanceof CaptureTask) {
                    this.capTaskSet.add((CaptureTask)o);
                }
                if (!(o instanceof Long)) continue;
                long pcapId = (Long)o;
                boolean isDelete = pcapId % 2L == 0L;
                pcapId = pcapId >> 1 & 0xFFFFFFFFFFFFFFFFL;
                Iterator<CaptureTask> itor = this.capTaskSet.iterator();
                while (itor.hasNext()) {
                    CaptureTask cacelTask = itor.next();
                    if (cacelTask.getTaskId() != pcapId) continue;
                    cacelTask.finish();
                    itor.remove();
                    MBeanResourceFactory.PACKET_CAPTURE.removeCaptureTask(cacelTask);
                    this.deleteTask(pcapId);
                    LOGGER.info((Object)("Cancel task: " + cacelTask + "succeed!"));
                }
                if (!isDelete) continue;
                this.deletePcapFilesByTaskId(pcapId);
            }
            this.waitCapTask.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCaptureTask(CaptureTask task) {
        List<Object> list = this.waitCapTask;
        synchronized (list) {
            if (this.waitCapTask.add(task)) {
                this.taskRepository.createObject(task);
                MBeanResourceFactory.PACKET_CAPTURE.addCaptureTask(task);
                LOGGER.info((Object)("Add capture task : " + task + ".And create this task to DB succeed!"));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCaptureTask(long pcapId) {
        List<Object> list = this.waitCapTask;
        synchronized (list) {
            this.waitCapTask.add(pcapId);
        }
    }

    public boolean needClean(CollectorDiskObj disk) {
        return disk.getDiskUseRatio() > this.diskUseLimit;
    }

    private Long queryPcapFileCount() {
        long pcapFileNumber = 0L;
        List pcapFiles = this.pcapRepository.queryObject(new AllCondition());
        if (pcapFiles.size() > 0) {
            pcapFileNumber = pcapFiles.size();
        }
        return pcapFileNumber;
    }

    private void checkAndCleanDbPcapFileLog() {
        CollectorDiskObj disk = PcapUtil.getDiskInfo();
        if (disk != null && this.needClean(disk)) {
            this.deleteDbPcapFileLog();
        }
    }

    private void deleteDbPcapFileLog() {
        long totalFileSize;
        ArrayList<String> totalDelFilesName = new ArrayList<String>();
        long needDelFileSize = this.diskDelPcapFileLimit * 1024L * 1024L * 1024L;
        long thisDelFileSize = 1L;
        for (totalFileSize = 0L; totalFileSize < needDelFileSize && thisDelFileSize > 0L; totalFileSize += thisDelFileSize) {
            thisDelFileSize = this.getNeedDelFileSize(totalDelFilesName);
            LOGGER.info((Object)("this DelFile Size: " + thisDelFileSize));
        }
        LOGGER.info((Object)("need del pcap file totalFileSize: " + totalFileSize));
        if (!totalDelFilesName.isEmpty()) {
            LOGGER.info((Object)("need del pcap file num: " + totalDelFilesName.size()));
            CleanPcapFileThread.getInstance().addDelFileNameToList(totalDelFilesName);
        }
    }

    private long getNeedDelFileSize(List<String> totalFilesName) {
        List<PcapFileInfo> files = this.getSortedCompletedFile();
        if (null == files || files.isEmpty()) {
            return 0L;
        }
        long allFileSize = 0L;
        for (PcapFileInfo file : files) {
            allFileSize += file.getFileSize();
            totalFilesName.add(file.getFileName());
        }
        PcapFileInfo newFile = files.get(files.size() - 1);
        long newFileId = newFile.getPcapFilePkId();
        this.delPcapDbLog(newFileId);
        return allFileSize;
    }

    private void delPcapDbLog(long newFileId) {
        PcapConditionField field = new PcapConditionField("PKID");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().notBiggerThan();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(newFileId);
        clause.addValueList(clause.getValue());
        this.pcapRepository.deleteObject(clause);
    }

    private List<PcapFileInfo> getSortedCompletedFile() {
        PcapConditionField field = new PcapConditionField("state");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(0);
        clause.addValueList(clause.getValue());
        ConditionClause orderCondition = new ConditionClause();
        orderCondition.setField(new PcapConditionField("end_time"));
        orderCondition.setSeparator(ConditionSeparatorFactory.getInstance().order());
        orderCondition.setValue(" ASC ");
        ConditionClause limitCondition = new ConditionClause();
        limitCondition.setField(new PcapConditionField("0"));
        limitCondition.setSeparator(ConditionSeparatorFactory.getInstance().limit());
        limitCondition.setValue(1000);
        clause.addValueList(limitCondition.getValue());
        clause.setLimitCondition(limitCondition);
        clause.setOrderCondition(orderCondition);
        List<PcapFileInfo> pcapFiles = this.pcapRepository.queryObject(clause);
        return pcapFiles;
    }

    public void refreshCapture() {
        this.refreshCaptureTask();
    }

    @Override
    public synchronized void processMetaData(List<PcapEntity> datas) {
        if (!datas.isEmpty()) {
            this.refreshCaptureTask();
            this.receiveFileSize += (long)datas.size();
            if (this.receiveFileSize >= 0x100000L) {
                this.checkAndCleanDbPcapFileLog();
                this.receiveFileSize = 0L;
            }
            for (PcapEntity data : datas) {
                CaptureTask task = this.findCaptureTask(data);
                if (null == task) continue;
                try {
                    task.execute(data);
                    if (!task.isIsFinished()) continue;
                    this.capTaskSet.remove(task);
                    MBeanResourceFactory.PACKET_CAPTURE.removeCaptureTask(task);
                    this.deleteTask(task.getTaskId());
                }
                catch (IOException e) {
                    LOGGER.error((Object)("when proceed pcap ,error happen!" + e.getMessage()));
                }
            }
            long totalPcapFileNum = this.queryPcapFileCount();
            if (totalPcapFileNum > MAX_PCAP_FILE_NUMBER) {
                this.deleteDbPcapFileLog(totalPcapFileNum - MAX_PCAP_FILE_NUMBER);
            }
        }
    }

    private void deleteDbPcapFileLog(long size) {
        ArrayList<String> totalDelFilesName = new ArrayList<String>();
        long totalFileSize = 0L;
        while (totalFileSize < size) {
            this.getNeedDelFileSize(totalDelFilesName);
            totalFileSize = totalDelFilesName.size();
        }
        LOGGER.info((Object)("need del pcap file totalFileSize: " + totalFileSize));
        if (!totalDelFilesName.isEmpty()) {
            LOGGER.info((Object)("need del pcap file num: " + totalDelFilesName.size()));
            CleanPcapFileThread.getInstance().addDelFileNameToList(totalDelFilesName);
        }
    }

    public synchronized List<CaptureTask> getCaptureTasks() {
        ArrayList<CaptureTask> clone = new ArrayList<CaptureTask>();
        clone.addAll(this.capTaskSet);
        return clone;
    }

    private void deleteTask(long pcapId) {
        TaskConditionField field = new TaskConditionField("pcapId");
        LOGGER.info((Object)("Delete  Capture Task . taskId are " + pcapId));
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(pcapId);
        clause.addValueList(clause.getValue());
        this.taskRepository.deleteObject(clause);
    }

    private CaptureTask findCaptureTask(PcapEntity pcapData) {
        CaptureTask target = null;
        PcapIdentifier identifier = pcapData.getPcapIdentifier();
        for (CaptureTask task : this.capTaskSet) {
            if (!task.isMatch(identifier)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Find the match task:" + LogManager.NEXT_LINE + identifier));
            }
            target = task;
        }
        if (null == target) {
            LOGGER.info((Object)("can't Find the match task ,pcapDataHead is " + LogManager.NEXT_LINE + identifier));
        }
        return target;
    }

    public void loadPcapTaskFromDb() {
        List tasks;
        while (true) {
            try {
                tasks = this.taskRepository.queryObject(new AllCondition());
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("init PcapTask with error" + e.getMessage()));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.error((Object)("sleep error." + ex.getMessage()));
                }
                continue;
            }
            break;
        }
        for (CaptureTask task : tasks) {
            this.capTaskSet.add(task);
            MBeanResourceFactory.PACKET_CAPTURE.addCaptureTask(task);
        }
        LOGGER.info((Object)("load task form db " + tasks));
    }

    public void deletePcapFilesByTaskId(long taskId) {
        PcapConditionField field = new PcapConditionField("taskId");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(taskId);
        clause.addValueList(clause.getValue());
        Repository repository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
        if (null != repository) {
            List fileList = repository.queryObject(clause);
            for (PcapFileInfo file : fileList) {
                boolean deleSuccess = file.delete();
                if (deleSuccess) {
                    LOGGER.info((Object)("Delete PcapFile success, file name :" + file.getFileName()));
                    continue;
                }
                LOGGER.error((Object)("Delete PcapFile not success, file name :" + file.getFileName()));
            }
            repository.deleteObject(clause);
        }
    }
}

