/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.PacketParser;
import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;

public class PcapConsumer
extends Consumer<TimeDatagramPacket> {
    private PacketParser<PcapEntity> parser;
    private Processor<PcapEntity> processor;

    public PcapConsumer(PacketParser<PcapEntity> parser, Processor<PcapEntity> builder) {
        this.logger = LogManager.getInstance().getPcapLogger();
        this.parser = parser;
        this.processor = builder;
        this.setName("pcap consumer");
    }

    @Override
    protected void proceedPacket(List<TimeDatagramPacket> packets) {
        ArrayList<PcapEntity> pcapEntitys = new ArrayList<PcapEntity>();
        if (!packets.isEmpty()) {
            for (TimeDatagramPacket packet : packets) {
                pcapEntitys.addAll(this.parser.parsePacket(packet));
            }
            this.logger.info((Object)("this time received message packet size :" + pcapEntitys.size()));
        }
        this.processor.processMetaData(pcapEntitys);
    }
}

