/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.entity.monitor.DeviceObj;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PcapIdentifier
implements Serializable {
    public static final int DROP = 0;
    public static final int ACL = 1;
    public static final int ATTACK = 2;
    public static final int ALERT = 3;
    private static final long serialVersionUID = -3410276262811384288L;
    private int deviceType;
    private int type;
    private String pcapDeviceIP;
    private long zoneId;
    private String zoneIp;
    private int version;

    public PcapIdentifier(int type, String deviceIp, long zoneId) {
        if (type != 1 && type != 2 && type != 0 && type != 3) {
            throw new IllegalArgumentException(" type is error" + type);
        }
        this.pcapDeviceIP = deviceIp;
        this.type = type;
        this.zoneId = zoneId;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public boolean equals(Object obj) {
        PcapIdentifier task;
        return obj instanceof PcapIdentifier && this.type == (task = (PcapIdentifier)obj).getType() && (task.getType() == 0 ? this.pcapDeviceIP.equals(task.getPcapDeviceIP()) && this.deviceType == task.getDeviceType() : (task.getType() == 2 ? this.pcapDeviceIP.equals(task.getPcapDeviceIP()) && this.deviceType == task.getDeviceType() && this.zoneId == task.getZoneId() : (task.getType() == 1 ? this.pcapDeviceIP.equals(task.getPcapDeviceIP()) && this.deviceType == task.getDeviceType() : task.getType() == 3 && this.pcapDeviceIP.equals(task.getPcapDeviceIP()) && this.deviceType == task.getDeviceType() && this.zoneId == task.getZoneId())));
    }

    public String getPcapDeviceIP() {
        return this.pcapDeviceIP;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public int hashCode() {
        if (this.getType() == 0) {
            return 19 + 289 * this.type + this.pcapDeviceIP.hashCode();
        }
        if (this.getType() == 2) {
            return 19 + 289 * this.type + 17 * (int)(this.zoneId ^ this.zoneId >>> 32) + this.pcapDeviceIP.hashCode();
        }
        return 19 + 289 * this.type + this.pcapDeviceIP.hashCode();
    }

    public boolean isZoneType() {
        return this.type == 2 || this.type == 3;
    }

    public void setPcapDeviceIP(String deviceIP) {
        this.pcapDeviceIP = deviceIP;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public String toString() {
        String types = "";
        switch (this.type) {
            case 1: {
                types = "Acl";
                break;
            }
            case 2: {
                types = "zone";
                break;
            }
            case 3: {
                types = "alert";
                break;
            }
            default: {
                types = "device";
            }
        }
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("Type", (Object)types).append("DeviceIP", (Object)this.pcapDeviceIP).append("DeviceType", (Object)DeviceObj.getDeviceTypeDescriptor(this.deviceType)).append("ZoneId", this.zoneId).append("ZoneIp", (Object)this.zoneIp).toString();
    }
}

