/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.biz.CounterBuffer;
import com.hs.atic.collector.biz.DefaultConsumerFactory;
import com.hs.atic.collector.biz.event.process.EventTypeProcessor;
import com.hs.atic.collector.biz.event.process.NotifyPcapTaskFinishedHanlder;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.biz.pcap.PcapBuilder;
import com.hs.atic.collector.biz.pcap.PcapConsumer;
import com.hs.atic.collector.biz.pcap.PcapPacketFilter;
import com.hs.atic.collector.biz.pcap.task.CheckFileWriterTask;
import com.hs.atic.collector.biz.pcap.task.CleanPcapFileThread;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.init.ModelInterface;
import com.hs.atic.collector.init.UdpManagerThread;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapUtil;
import com.hs.atic.collector.util.RefreshCaptureThread;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public final class PcapModel
implements ModelInterface {
    private static EventTypeProcessor typeProcessor = new EventTypeProcessor();
    private static EventTypeProcessor typeProcessorDecrypt = new EventTypeProcessor();
    private static final int MAX_SIZE = 30000;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static CounterBuffer<TimeDatagramPacket> parseBuffer;
    private static PcapConsumer consumer;
    private static PcapModel pcapModelInstance;
    private static UdpManagerThread pcapManagerThread;

    private PcapModel() {
        String sizeStr = PcapUtil.getPcapConfigProperty("MostPacketSize");
        int size = 30000;
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Integer.parseInt NumberFormatException");
        }
        PcapModel.setParseBuffer(new CounterBuffer<TimeDatagramPacket>(size));
        typeProcessor.setFilter(new PcapPacketFilter());
        typeProcessor.setBuffer(parseBuffer);
        typeProcessorDecrypt.setFilter(new PcapPacketFilter());
        typeProcessorDecrypt.setNeedDecrypt(true);
        typeProcessorDecrypt.setBuffer(parseBuffer);
        consumer.setBuffer(parseBuffer);
        MBeanResourceFactory.UNRESOLVED_BINARY_PACKET.setCaptureBuffer(parseBuffer);
    }

    public static PcapModel getInstance() {
        return pcapModelInstance;
    }

    @Override
    public EventTypeProcessor getProcessor() {
        return typeProcessor;
    }

    public void pcapThreadInitResource() {
        PcapBuilder.getInstance().loadPcapTaskFromDb();
        CrashThreadHandler crashThreadHandler = CrashThreadHandler.getInstance();
        try {
            RefreshCaptureThread refreshThread = RefreshCaptureThread.getInstane();
            Thread refresh = new Thread((Runnable)refreshThread, "RefreshThread");
            refresh.setUncaughtExceptionHandler(crashThreadHandler);
            refresh.start();
        }
        catch (Exception e) {
            LOGGER.error((Object)("RefreshCaptureThread start failed ! Program exit !" + e.getMessage()));
        }
        this.cleanPcapFiles();
        CleanPcapFileThread cleanTask = CleanPcapFileThread.getInstance();
        cleanTask.setName("clean pcap");
        cleanTask.setUncaughtExceptionHandler(crashThreadHandler);
        cleanTask.start();
        CheckFileWriterTask checkTask = CheckFileWriterTask.getInstance();
        checkTask.setName("check pcap");
        checkTask.setBuilder(PcapBuilder.getInstance());
        checkTask.setUncaughtExceptionHandler(crashThreadHandler);
        checkTask.start();
        NotifyPcapTaskFinishedHanlder pcapTaskFinished = NotifyPcapTaskFinishedHanlder.getInstance();
        pcapTaskFinished.setName("notify pcap task over");
        pcapTaskFinished.setUncaughtExceptionHandler(crashThreadHandler);
        pcapTaskFinished.start();
        consumer.setUncaughtExceptionHandler(crashThreadHandler);
        consumer.start();
    }

    @Override
    public void start() {
        CrashThreadHandler crashThreadHandler = CrashThreadHandler.getInstance();
        this.startUdpManagers(crashThreadHandler);
    }

    @Override
    public void stop() {
    }

    protected static void freeDbResource(Connection con, PreparedStatement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanPcapFiles() {
        PreparedStatement update;
        Connection con;
        block4: {
            String sql = "update atic_pcap_file set STATUS=0 where STATUS<>0";
            con = null;
            update = null;
            try {
                con = DBConnPool.getConnection();
                if (null == con) break block4;
                update = con.prepareStatement(sql);
                update.execute();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"clean event error");
                }
                catch (Throwable throwable) {
                    PcapModel.freeDbResource(con, update);
                    throw throwable;
                }
                PcapModel.freeDbResource(con, update);
            }
        }
        PcapModel.freeDbResource(con, update);
    }

    private void startUdpManagers(CrashThreadHandler crashThreadHandler) {
        int pcapPort = 9112;
        try {
            pcapPort = Integer.parseInt(EventUtil.getEventConfigProperty("PcapPort"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"startUdpManagerst Integer.parseInt NumberFormatException");
        }
        PcapModel.setPcapManagerThread(new UdpManagerThread(pcapPort));
        pcapManagerThread.addTypeProcessor(typeProcessorDecrypt);
        pcapManagerThread.setUncaughtExceptionHandler(crashThreadHandler);
        pcapManagerThread.start();
    }

    @Override
    public CounterBuffer<TimeDatagramPacket> getBuffer() {
        return parseBuffer;
    }

    public static UdpManagerThread getPcapManagerThread() {
        return pcapManagerThread;
    }

    public static void setPcapManagerThread(UdpManagerThread pcapManagerThread) {
        PcapModel.pcapManagerThread = pcapManagerThread;
    }

    public static CounterBuffer<TimeDatagramPacket> getParseBuffer() {
        return parseBuffer;
    }

    public static void setParseBuffer(CounterBuffer<TimeDatagramPacket> parseBuffer) {
        PcapModel.parseBuffer = parseBuffer;
    }

    static {
        consumer = DefaultConsumerFactory.createPcapConsumer();
        pcapModelInstance = new PcapModel();
    }
}

