/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.biz.PacketParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.biz.pcap.IpSuitPcap;
import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PcapPacketParser
implements PacketParser<PcapEntity> {
    private static final int FILTER_ATTACK_VALUE = 62;
    private static final int TWO_THOUSAND = 2000;
    private static final int ATTACK_TYPE_TCP_BANDWIDTH_OVERFLOW = 18;
    private static final int ATTACK_TYPE_GLOBAL_TCP_ABNORMAL = 35;
    private static final int ATTACK_TYPE_UDP_BANDWIDTH_OVERFLOW = 22;
    private static final int ATTACK_TYPE_GLOBAL_UDP_ABNORMAL = 37;
    private static final int ATTACK_TYPE_ICMP_FLOOD = 23;
    private static final int ATTACK_TYPE_GLOBAL_ICMP_ABNORMAL = 38;
    private static final int ATTACK_TYPE_OTHER_BANDWIDTH_OVERFLOW = 24;
    private static final int ATTACK_TYPE_GLOBAL_OTHER_ABNORMAL = 39;
    private static final int ATTACK_TYPE_OZYMANDNS_DNS_TUNNELING_RESPONSE = 128;
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    private static final int PCAP = 3;
    private static final long DEFAULT_ZONE_ID = 1L;
    private int deviceType;
    private String deviceIp;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PcapEntity> parsePacket(TimeDatagramPacket packet) {
        byte[] allData = packet.getData();
        this.deviceIp = IpTransformer.formatIpAddress(packet.getAddress());
        UnsignedDataInputStream stream = null;
        ArrayList<PcapEntity> result = new ArrayList<PcapEntity>();
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(allData));
            this.version = stream.readUnsignedByte();
            stream.readUnsignedByte();
            stream.readUnsignedByte();
            this.deviceType = stream.readUnsignedByte();
            stream.readUnsignedShort();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("this packet data is " + CommonUtil.getByteArrayStr(allData)));
            }
            int number = stream.readUnsignedShort();
            if (this.version == 8) {
                stream.readUnsignedShort();
            }
            for (int i = 0; i < number; ++i) {
                if (this.version == 1 || this.version == 2) {
                    this.parseEvent(stream, result, this.version);
                    continue;
                }
                if (this.version != 3 && this.version != 4 && this.version != 5 && this.version != 6 && this.version != 7 && this.version != 8) continue;
                this.parseEventV3(stream, result);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("when parse packet ,error happens and packet is  " + CommonUtil.getByteArrayStr(allData) + ". " + e.getMessage()));
            ArrayList<PcapEntity> arrayList = new ArrayList<PcapEntity>();
            return arrayList;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"when parse packet close stream error");
                }
            }
        }
        int i = 0;
        LOGGER.debug((Object)("after parse ,the pcap events size=" + result.size()));
        for (PcapEntity entity : result) {
            if (i++ >= 4) continue;
            LOGGER.debug((Object)("the first " + i + " pcap event= " + entity.toString()));
        }
        return result;
    }

    private void parseEventV3(UnsignedDataInputStream stream, List<PcapEntity> result) throws IOException {
        long zoneId = stream.readUnsignedInt();
        zoneId = this.getDefaultZoneId(zoneId);
        byte[] b = new byte[16];
        if (stream.read(b) != 16) {
            LOGGER.error((Object)"stream read error");
        }
        int ucZoneIpType = stream.readUnsignedByte();
        String zoneIp = IpTransformer.byte2String(b, ucZoneIpType);
        stream.readUnsignedByte();
        stream.readUnsignedShort();
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedShort();
        stream.readUnsignedInt();
        stream.readUnsignedByte();
        int logTypeNumber = stream.readUnsignedByte();
        stream.readUnsignedShort();
        PcapIdentifier identifer = new PcapIdentifier(0, this.deviceIp, zoneId);
        identifer.setDeviceType(this.deviceType);
        identifer.setZoneIp(zoneIp);
        for (int i = 0; i < logTypeNumber; ++i) {
            int type = stream.readUnsignedByte();
            int numberOfSameType = stream.readUnsignedByte();
            int lengthOfSameType = stream.readUnsignedShort();
            byte[] logContent = new byte[lengthOfSameType];
            if (-1 == stream.read(logContent)) continue;
            result.addAll(this.parseData(logContent, identifer, type, numberOfSameType));
        }
    }

    private void parseEvent(UnsignedDataInputStream stream, List<PcapEntity> result, int newVersion) throws IOException {
        long zoneId = stream.readUnsignedInt();
        zoneId = this.getDefaultZoneId(zoneId);
        long zoneIp = stream.readUnsignedInt();
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedShort();
        stream.readUnsignedByte();
        int logTypeNumber = stream.readUnsignedByte();
        stream.readUnsignedShort();
        PcapIdentifier identifer = new PcapIdentifier(0, this.deviceIp, zoneId);
        identifer.setDeviceType(this.deviceType);
        identifer.setVersion(newVersion);
        identifer.setZoneIp(IpTransformer.long2StringFormat(zoneIp));
        for (int i = 0; i < logTypeNumber; ++i) {
            int type = stream.readUnsignedByte();
            int numberOfSameType = stream.readUnsignedByte();
            int lengthOfSameType = stream.readUnsignedShort();
            byte[] logContent = new byte[lengthOfSameType];
            if (-1 == stream.read(logContent)) continue;
            result.addAll(this.parseData(logContent, identifer, type, numberOfSameType));
        }
    }

    private long getDefaultZoneId(long zoneId) {
        if (zoneId == 1L) {
            try {
                zoneId = FoundIDUtil.getInstance().getDefaultZoneIdByDevIp(this.deviceIp);
                LOGGER.info((Object)("deviceIp: " + this.deviceIp + ".mapping default zone id is : " + zoneId));
            }
            catch (Exception e) {
                LOGGER.error((Object)("get default zone id error!" + e.getMessage()));
            }
        }
        return zoneId;
    }

    protected IpSuitPcap createIpSuitEntity(EventIdentifier identifier) {
        return new IpSuitPcap(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PcapEntity> parseData(byte[] logContent, PcapIdentifier identifier, int type, int numberOfSameType) throws IOException {
        ArrayList<PcapEntity> entity = new ArrayList<PcapEntity>();
        if (type == 3) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(logContent));
                for (int i = 0; i < numberOfSameType; ++i) {
                    PcapEntity pcapEntity = this.parse((UnsignedDataInputStream)stream, identifier);
                    if (pcapEntity == null) continue;
                    entity.add(pcapEntity);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stram error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
        return entity;
    }

    private PcapEntity parse(UnsignedDataInputStream stream, PcapIdentifier identifier) throws IOException {
        int type = stream.readUnsignedByte();
        int attackType = stream.readUnsignedByte();
        attackType = this.getAttackTypeByVersion(identifier.getVersion(), attackType);
        int port = stream.readUnsignedShort();
        stream.readUnsignedShort();
        int length = stream.readUnsignedShort();
        if (length == 0) {
            return null;
        }
        byte[] data = new byte[length];
        if (stream.read(data) != length) {
            LOGGER.error((Object)"stream read error");
        }
        PcapIdentifier newIdentifier = new PcapIdentifier(type, identifier.getPcapDeviceIP(), identifier.getZoneId());
        newIdentifier.setDeviceType(identifier.getDeviceType());
        newIdentifier.setZoneIp(identifier.getZoneIp());
        return this.getPcapEntityByPcapData(attackType, port, length, data, newIdentifier);
    }

    private PcapEntity getPcapEntityByPcapData(int attackTypeTemp, int portTemp, int length, byte[] data, PcapIdentifier newIdentifier) {
        PcapEntity entity = new PcapEntity(newIdentifier);
        entity.setData(data);
        entity.setLength(length);
        int attackType = attackTypeTemp;
        int port = portTemp;
        int protocol = 0;
        if (attackType >= 128) {
            protocol = attackType - 128;
            attackType = 0;
        } else if (this.version >= 5 && attackType == 62 && port > 0) {
            attackType = port + 2000;
            port = 0;
        } else {
            port = 0;
        }
        entity.setAttackType(AttackTypeFactory.getInstance().getAttackType(attackType, protocol, port));
        return entity;
    }

    private int getAttackTypeByVersion(int version, int attackTypeByVersion) {
        int attackType = attackTypeByVersion;
        if (version == 1) {
            switch (attackType) {
                case 18: {
                    attackType = 35;
                    break;
                }
                case 22: {
                    attackType = 37;
                    break;
                }
                case 23: {
                    attackType = 38;
                    break;
                }
                case 24: {
                    attackType = 39;
                    break;
                }
            }
        }
        return attackType;
    }
}

