/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.BizTypePoJo;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import java.util.Map;

public class AppFlowDisUtil {
    public String getTableName(DataStatCondition cds, BizTypePoJo bizTypePoJo) {
        Long time = cds.getEndTime() - cds.getStartTime();
        String tableName = "";
        if (bizTypePoJo.getBizId() > 0L) {
            tableName = null == cds.getZoneId() && null == cds.getZoneIp() ? "ATIC_ZONE_BIZ_" : (null == cds.getZoneIp() ? "ATIC_ZONE_BIZ_" : "ATIC_IP_BIZ_");
            tableName = tableName + bizTypePoJo.getBizType();
            if (cds.getAttackType() == 2) {
                tableName = tableName + "_DROP";
            }
        } else {
            tableName = null == cds.getZoneId() && null == cds.getZoneIp() ? "ATIC_ZONE" : (null == cds.getZoneIp() ? "ATIC_ZONE" : "ATIC_IP");
            int type = cds.getAttackType();
            tableName = 1 == type ? tableName + "_IN" : (2 == type ? tableName + "_DROP" : tableName + "_FORWARD");
        }
        if (bizTypePoJo.getBizId() < 0L && cds.getAppType() == 1 && !this.isMoreThanDay(time, 1)) {
            tableName = tableName + "_MAX";
        }
        if (bizTypePoJo.getBizId() > 0L && cds.getAppType() == 1) {
            tableName = tableName + "_MAX";
        }
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_H";
        } else if (this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_D";
        }
        return tableName;
    }

    private String getWherecondSql(DataStatCondition cds, String tableName, BizTypePoJo bizTypePoJo, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where ").append(tableName).append(".LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != zoneId) {
            condSql.append(" AND ").append(tableName).append(".ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ").append(tableName).append(".ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ").append(tableName).append(".ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        if (bizTypePoJo.getBizId() > 0L) {
            condSql.append(" AND ").append(tableName).append(".BIZ_ID= ? ");
            condition.put(index++, bizTypePoJo.getBizId());
        }
        return condSql.toString();
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }

    public String getAppFlowDisEachType(DataStatCondition cds, BizTypePoJo bizTypePoJo, Map<Integer, Object> condition, String tableName) {
        String sumOrMax;
        StringBuffer selectSql = new StringBuffer("SELECT ");
        StringBuffer fromSql = new StringBuffer(" FROM ").append(tableName);
        StringBuffer whereSql = null;
        String groupBySql = " GROUP BY LOG_TIME";
        String unitColumn = cds.getUnit() == 0 ? "KBPS" : "PPS";
        String string = sumOrMax = cds.getAppType() == 1 ? "MAX" : "SUM";
        if (bizTypePoJo.getBizId() < 0L) {
            String maxOrBlank;
            Long time = cds.getEndTime() - cds.getStartTime();
            String string2 = maxOrBlank = cds.getAppType() == 1 && this.isMoreThanDay(time, 1) ? "MAX_" : "";
            if (bizTypePoJo.getBizType().equalsIgnoreCase("UDP_DNS")) {
                selectSql.append(" LOG_TIME LOG_TIME, ");
                selectSql.append(sumOrMax).append('(').append(maxOrBlank).append("DNS_REQUSET_").append(unitColumn).append(" + ").append("DNS_REPLY_").append(unitColumn).append(") pps ");
                whereSql = new StringBuffer(this.getWherecondSql(cds, tableName, bizTypePoJo, condition));
            } else if (bizTypePoJo.getBizType().equalsIgnoreCase("SIP")) {
                selectSql.append(" LOG_TIME LOG_TIME, ");
                String columnName = maxOrBlank + "SIP_INVITE_" + unitColumn;
                boolean columnExist = DBStat.checkColumnExist(columnName, tableName);
                columnName = columnExist ? columnName : " 0 ";
                selectSql.append(sumOrMax).append('(').append(columnName).append(") pps ");
                whereSql = new StringBuffer(this.getWherecondSql(cds, tableName, bizTypePoJo, condition));
            } else {
                selectSql.append(" LOG_TIME LOG_TIME, ");
                selectSql.append(sumOrMax).append('(').append(maxOrBlank).append(bizTypePoJo.getBizType()).append('_').append(unitColumn).append(") pps ");
                whereSql = new StringBuffer(this.getWherecondSql(cds, tableName, bizTypePoJo, condition));
            }
        } else if (bizTypePoJo.getBizType().equalsIgnoreCase("UDP_DNS") && cds.getUnit() == 1) {
            selectSql.append(" LOG_TIME LOG_TIME, ");
            selectSql.append(sumOrMax).append("(REQUEST_PPS + REPLY_PPS) ").append(" pps ");
            whereSql = new StringBuffer(this.getWherecondSql(cds, tableName, bizTypePoJo, condition));
        } else {
            selectSql.append(" LOG_TIME LOG_TIME, ");
            selectSql.append(sumOrMax).append("(TOTAL_").append(unitColumn).append(") pps");
            whereSql = new StringBuffer(this.getWherecondSql(cds, tableName, bizTypePoJo, condition));
        }
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql).append(whereSql).append(groupBySql);
        return sql.toString();
    }
}

