/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AttackCountTrendUtil {
    private String getTableName(DataStatCondition cds) {
        Long time = cds.getEndTime() - cds.getStartTime();
        StringBuffer tableName = new StringBuffer("atic_ip_anomaly_times");
        if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        } else {
            tableName.append("_H");
        }
        return tableName.toString();
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }

    public String getAttackTrendUtilNoAttackType(DataStatCondition cds, Map<Integer, Object> condition) {
        int deviceType = cds.getDevSerType();
        String columnName = "ATTACK_TIMES";
        if (1 == deviceType) {
            columnName = "ALERT_TIMES";
        }
        StringBuffer selectSql = new StringBuffer("SELECT DEVICE_IP, LOG_TIME, attackCount, IF(attackType<10,0,attackType) attackType ");
        StringBuffer fromSql = new StringBuffer(" FROM (select DEVICE_IP,LOG_TIME,SUM(" + columnName + ") attackCount, attack_type attackType from ");
        fromSql.append(this.getTableName(cds)).append(this.getWherecondSqlNoAttackType(cds, this.getTableName(cds), condition));
        fromSql.append(" and " + columnName + " >=0 ");
        fromSql.append(" group by DEVICE_IP,LOG_TIME,IF(attackType<10,0,attackType)) a ");
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql);
        return sql.toString();
    }

    private String getWherecondSqlNoAttackType(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" AND DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    public String getAttackIpCountTrendUtil(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer selectSql = new StringBuffer("SELECT DEVICE_IP,LOG_TIME, COUNT(0) ipCount From (SELECT DEVICE_IP,LOG_TIME,ZONE_IP ");
        StringBuffer fromSql = new StringBuffer(" FROM ");
        fromSql.append(this.getTableName(cds));
        StringBuffer whereSql = new StringBuffer(this.getAttackIpCountWherecondSql(cds, this.getTableName(cds), condition));
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql).append(whereSql).append(" GROUP BY DEVICE_IP,LOG_TIME,ZONE_IP order by LOG_TIME,ZONE_IP) a GROUP BY DEVICE_IP,LOG_TIME");
        return sql.toString();
    }

    private String getAttackIpCountWherecondSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" AND DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    public String getAttackCountCompareUtil(DataStatCondition cds, Map<Integer, Object> condition) {
        int deviceType = cds.getDevSerType();
        String columnName = "ATTACK_TIMES";
        if (1 == deviceType) {
            columnName = "ALERT_TIMES";
        }
        StringBuffer selectSql = new StringBuffer("SELECT DEVICE_IP,LOG_TIME, SUM(" + columnName + ") attackCount ");
        StringBuffer fromSql = new StringBuffer(" FROM ");
        fromSql.append(this.getAttackCountTableName(cds));
        StringBuffer whereSql = new StringBuffer(this.getAttackCountCompareWherecondSql(cds, this.getTableName(cds), condition));
        whereSql.append(" and " + columnName + " >=0 ");
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql).append(whereSql).append(" group by DEVICE_IP,LOG_TIME order by LOG_TIME");
        return sql.toString();
    }

    private String getAttackCountTableName(DataStatCondition cds) {
        StringBuffer tableName = new StringBuffer("atic_ip_anomaly_times");
        if (cds.getSchedule().equalsIgnoreCase("day")) {
            tableName.append("_H");
        } else {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    private String getAttackCountCompareWherecondSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        long start = this.getScheduleStartTime(cds);
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME between  ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" AND DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    private long getScheduleStartTime(DataStatCondition cds) {
        long startTime = cds.getStartTime();
        String schedule = cds.getSchedule();
        if (schedule.equalsIgnoreCase("day")) {
            String startDayStr = this.convertTime2DayString(startTime) + " 00:00:00";
            return this.convertTimeString(startDayStr) - 86400L;
        }
        if (schedule.equalsIgnoreCase("week")) {
            String startDayStr = this.convertTime2DayString(startTime) + " 00:00:00";
            return this.convertTimeString(startDayStr) - 604800L;
        }
        if (schedule.equalsIgnoreCase("month")) {
            String yearStr = this.convertTime2YearString(startTime);
            String monthStr = this.convertTime2MonthString(startTime);
            int monthInt = Integer.parseInt(monthStr);
            int yearInt = Integer.parseInt(yearStr);
            String returnStr = "";
            returnStr = monthInt - 1 > 0 ? yearStr + "-" + (monthInt - 1) + "-01 00:00:00" : yearInt - 1 + "-12-01 00:00:00";
            return this.convertTimeString(returnStr);
        }
        if (schedule.equalsIgnoreCase("year")) {
            String yearStr = this.convertTime2YearString(startTime);
            String returnStr = Integer.parseInt(yearStr) - 1 + "-01-01 00:00:00";
            return this.convertTimeString(returnStr);
        }
        return startTime;
    }

    private String convertTime2DayString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        return formate.format(new Date(time * 1000L));
    }

    private String convertTime2MonthString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("MM");
        return formate.format(new Date(time * 1000L));
    }

    private String convertTime2YearString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy");
        return formate.format(new Date(time * 1000L));
    }

    private long convertTimeString(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public String getAttackIpCountUtil(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(0) AS ATT_NUM FROM (SELECT COUNT(0) FROM atic_ip_attack_log IGNORE index (END_START_TIME) WHERE");
        String dataStartTimeColName = "START_TIME_ALERT";
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, end);
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY ZONE_IP) a");
        return sql.toString();
    }

    public String getAttackAndAbnormalEventCountUtil(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(0) AS ATT_NUM FROM atic_ip_attack_exact_log IGNORE INDEX (DEVICE_IP_ATTACK_TIME,DEVICE_IP_END_TIME) WHERE");
        String dataStartTimeColName = "START_TIME_ALERT";
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, end);
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        return sql.toString();
    }

    public String getAttackEventCountUtil(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(0) AS ATT_NUM FROM atic_ip_attack_exact_log IGNORE INDEX (DEVICE_IP_ATTACK_TIME,DEVICE_IP_END_TIME) WHERE");
        String dataStartTimeColName = "START_TIME_ATTACK";
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <=  ? ");
        condition.put(index++, end);
        if ("START_TIME_ATTACK".equalsIgnoreCase(dataStartTimeColName)) {
            sql.append(" AND START_TIME_ALERT < ?  AND START_TIME_ALERT >= ? ");
            condition.put(index++, end);
            condition.put(index++, start - 1728000L);
        }
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID =  ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        return sql.toString();
    }

    public String getAttackCount4UnCollect(Long startDataTime, Long endDataTime, DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer selectSql = new StringBuffer("SELECT DEVICE_IP, " + startDataTime + " LOG_TIME, attackCount, IF(attackType<10,0,attackType) attackType ");
        StringBuffer fromSql = new StringBuffer(" FROM (select DEVICE_IP, count(0) attackCount, attack_type attackType from atic_ip_attack_exact_log ");
        fromSql.append(this.getWherecondSql4UnCollect(startDataTime, endDataTime, cds, condition));
        fromSql.append(" group by DEVICE_IP, IF(attackType<10,0,attackType)) a ");
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql);
        return sql.toString();
    }

    private String getWherecondSql4UnCollect(Long startDataTime, Long endDataTime, DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        int deviceType = cds.getDevSerType();
        String columnName = "START_TIME_ATTACK";
        if (1 == deviceType) {
            columnName = "START_TIME_ALERT";
        }
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where " + columnName + " < ? AND " + columnName + " >0 AND END_TIME >= ? ");
        condition.put(index++, endDataTime);
        condition.put(index++, startDataTime);
        if ("START_TIME_ATTACK".equalsIgnoreCase(columnName)) {
            condSql.append(" AND START_TIME_ALERT < ? AND START_TIME_ALERT >= ? ");
            condition.put(index++, endDataTime);
            condition.put(index++, startDataTime - 1728000L);
        }
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE =  ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" and DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, "atic_ip_attack_exact_log", condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    public String getAttackIpCount4UnCollect(Long startDataTime, Long endDataTime, DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer selectSql = new StringBuffer("SELECT DEVICE_IP, " + startDataTime + " LOG_TIME, COUNT(0) ipCount From (SELECT DEVICE_IP,ZONE_IP ");
        StringBuffer fromSql = new StringBuffer(" FROM atic_ip_attack_exact_log ");
        StringBuffer whereSql = new StringBuffer(this.getAttackIpCountWherecondSql4UnCollect(startDataTime, endDataTime, cds, "atic_ip_attack_exact_log", condition));
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql).append(whereSql).append(" GROUP BY DEVICE_IP,ZONE_IP) a GROUP BY DEVICE_IP");
        return sql.toString();
    }

    private String getAttackIpCountWherecondSql4UnCollect(Long startDataTime, Long endDataTime, DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        int deviceType = cds.getDevSerType();
        String columnName = "START_TIME_ATTACK";
        if (1 == deviceType) {
            columnName = "START_TIME_ALERT";
        }
        condSql.append(" where " + columnName + " < ? AND " + columnName + " >0 AND END_TIME >= ? ");
        condition.put(index++, endDataTime);
        condition.put(index++, startDataTime);
        if ("START_TIME_ATTACK".equalsIgnoreCase(columnName)) {
            condSql.append(" AND START_TIME_ALERT < ?  AND START_TIME_ALERT >= ? ");
            condition.put(index++, endDataTime);
            condition.put(index++, startDataTime - 1728000L);
        }
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" and DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    public String getAttackCountCompare4UnCollect(Long startDataTime, Long endDataTime, DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer selectSql = new StringBuffer("SELECT DEVICE_IP, " + startDataTime + " LOG_TIME, COUNT(0) attackCount FROM atic_ip_attack_exact_log ");
        StringBuffer whereSql = new StringBuffer(this.getAttackCountCompareWherecondSql4UnCollect(startDataTime, endDataTime, cds, "atic_ip_attack_exact_log", condition));
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(whereSql).append(" GROUP BY DEVICE_IP");
        return sql.toString();
    }

    private String getAttackCountCompareWherecondSql4UnCollect(Long startDataTime, Long endDataTime, DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        int deviceType = cds.getDevSerType();
        String columnName = "START_TIME_ATTACK";
        if (1 == deviceType) {
            columnName = "START_TIME_ALERT";
        }
        condSql.append(" where " + columnName + " < ? AND " + columnName + " >0 AND END_TIME >= ? ");
        condition.put(index++, endDataTime);
        condition.put(index++, startDataTime);
        if ("START_TIME_ATTACK".equalsIgnoreCase(columnName)) {
            condSql.append(" AND START_TIME_ALERT < ?  AND START_TIME_ALERT >= ? ");
            condition.put(index++, endDataTime);
            condition.put(index++, startDataTime - 1728000L);
        }
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" and DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }
}

