/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AttackLogUtil {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();
    private static final int PCAP_ATTACK_TYPE_CURRENT_CONNECTION = 14;
    private static final int PCAP_ATTACK_TYPE_NEW_CONNECTION = 15;
    private static final String PCAP_ATTACK_TYPE_CONNECTION_FLOOD = "40";
    private static final int PCAP_ATTACK_TYPE_NGE = 65;

    public String getAttackLogSql(DataStatCondition cds, String sortField, String sortType, Map<Integer, Object> condition) {
        int startRow = cds.getStartRow();
        int limit = cds.getLimit();
        String tableName = "ATIC_IP_ATTACK_LOG";
        StringBuffer sql = new StringBuffer();
        sql.append("select PKID,DEVICE_IP,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ALERT_TYPES,ATTACK_TYPES,EXACT_LOG_ID,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        if (!CommonUtil.isNull(sortField) && !CommonUtil.isNull(sortType)) {
            String dataBaseColumn = "";
            dataBaseColumn = "ipInFlowPeak".equals(sortField) ? (cds.getUnit() == 1 ? "IP_MAX_IN_PPS" : "IP_MAX_IN_KBPS") : ("ipAttackFlowPeak".equals(sortField) ? (cds.getUnit() == 1 ? "IP_MAX_DROP_PPS" : "IP_MAX_DROP_KBPS") : CollectorConstants.getAttackLog().get(sortField));
            if (null != dataBaseColumn && !"".equals(dataBaseColumn)) {
                String regular = "^[A-Za-z0-9|_]+$";
                if (Pattern.matches(regular, dataBaseColumn)) {
                    sql.append(" order by ").append(dataBaseColumn).append("DESC".equalsIgnoreCase(sortType) ? " desc" : "");
                }
            } else {
                sql.append(" order by START_TIME_ALERT DESC ");
            }
        } else {
            sql.append(" order by START_TIME_ALERT DESC ");
        }
        sql.append(" LIMIT ").append(startRow).append(',').append(limit);
        return sql.toString();
    }

    public String getAttackLogSqlTopN(DataStatCondition cds, String sortField, String sortType, Map<Integer, Object> condition) {
        int startRow = cds.getStartRow();
        int limit = cds.getLimit();
        String tableName = "ATIC_IP_ATTACK_LOG";
        StringBuffer sql = new StringBuffer();
        sql.append("select PKID,DEVICE_IP,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ALERT_TYPES,ATTACK_TYPES,EXACT_LOG_ID,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        if (!CommonUtil.isNull(sortField) && !CommonUtil.isNull(sortType)) {
            String dataBaseColumn = "";
            dataBaseColumn = "ipInFlowPeak".equals(sortField) ? (cds.getUnit() == 1 ? "IP_MAX_IN_PPS" : "IP_MAX_IN_KBPS") : ("ipAttackFlowPeak".equals(sortField) ? (cds.getUnit() == 1 ? "IP_MAX_DROP_PPS" : "IP_MAX_DROP_KBPS") : CollectorConstants.getAttackLog().get(sortField));
            if (null != dataBaseColumn && !"".equals(dataBaseColumn)) {
                String regular = "^[A-Za-z0-9|_]+$";
                if (Pattern.matches(regular, dataBaseColumn)) {
                    sql.append(" order by ").append(dataBaseColumn).append("DESC".equalsIgnoreCase(sortType) ? " desc" : "");
                }
            } else {
                sql.append(" order by START_TIME_ALERT DESC ");
            }
        } else {
            sql.append(" order by START_TIME_ALERT DESC ");
        }
        sql.append(" LIMIT ").append(startRow).append(',').append(limit);
        return sql.toString();
    }

    public String getAttackLogSqlTotal(DataStatCondition cds, String sortField, String sortType, Map<Integer, Object> condition) {
        int startRow = cds.getStartRow();
        int limit = cds.getLimit();
        String tableName = "ATIC_IP_ATTACK_LOG";
        StringBuffer sql = new StringBuffer();
        sql.append("select PKID,DEVICE_IP,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,SUM(CONVERT(DROP_BYTES / 8, SIGNED)) as DROP_BYTES,DROP_PACKETS,ALERT_TYPES,ATTACK_TYPES,EXACT_LOG_ID,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        if (!CommonUtil.isNull(sortField) && !CommonUtil.isNull(sortType)) {
            String dataBaseColumn = "";
            dataBaseColumn = "ipInFlowPeak".equals(sortField) ? (cds.getUnit() == 1 ? "IP_MAX_IN_PPS" : "IP_MAX_IN_KBPS") : ("ipAttackFlowPeak".equals(sortField) ? (cds.getUnit() == 1 ? "IP_MAX_DROP_PPS" : "IP_MAX_DROP_KBPS") : CollectorConstants.getAttackLog().get(sortField));
            if (null != dataBaseColumn && !"".equals(dataBaseColumn)) {
                String regular = "^[A-Za-z0-9|_]+$";
                if (Pattern.matches(regular, dataBaseColumn)) {
                    sql.append(" order by ").append(dataBaseColumn).append("DESC".equalsIgnoreCase(sortType) ? " desc" : "");
                }
            } else {
                sql.append(" order by START_TIME_ALERT DESC ");
            }
        } else {
            sql.append(" order by START_TIME_ALERT DESC ");
        }
        sql.append(" LIMIT ").append(startRow).append(',').append(limit);
        return sql.toString();
    }

    public String getAttackLogNumSql(DataStatCondition cds, Map<Integer, Object> condition) {
        String tableName = "ATIC_IP_ATTACK_LOG";
        StringBuffer sql = new StringBuffer();
        sql.append("select count(0) count from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        return sql.toString();
    }

    private String attackLogWhereSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        Integer attackType;
        int indexTemp = 1;
        int abnormalType = cds.getAbnormalType();
        Long deviceId = cds.getDeviceId();
        Long zoneId = cds.getZoneIdForCollector();
        String ip = cds.getZoneIp();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long minInFlow = cds.getMinInFlow();
        Long minAttackFlowPeak = cds.getMinAttackFlowPeak();
        int unit = cds.getUnit();
        StringBuffer sql = new StringBuffer();
        sql.append(" where END_TIME >= ?").append(" and START_TIME_ALERT <= ? ");
        condition.put(indexTemp++, start);
        condition.put(indexTemp++, end);
        if (0L < deviceId) {
            String deviceIp = cds.getDeviceIp();
            sql.append(" and DEVICE_IP = ? ");
            condition.put(indexTemp++, deviceIp);
        } else {
            int index = 0;
            for (String string : cds.getDeviceIpList()) {
                if (0 == index && cds.getDeviceIpList().size() == 1) {
                    sql.append(" and (DEVICE_IP = ? )");
                    condition.put(indexTemp++, string);
                } else if (0 == index) {
                    sql.append(" and (DEVICE_IP = ? ");
                    condition.put(indexTemp++, string);
                } else if (index == cds.getDeviceIpList().size() - 1) {
                    sql.append(" or DEVICE_IP = ? ) ");
                    condition.put(indexTemp++, string);
                } else {
                    sql.append(" or DEVICE_IP = ? ");
                    condition.put(indexTemp++, string);
                }
                ++index;
            }
        }
        if (cds.getDevSerType() != null) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(indexTemp++, cds.getDevSerType());
        }
        sql.append(" AND DIRECTION = ?");
        condition.put(indexTemp++, cds.getDirection());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(indexTemp++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(indexTemp++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, sql);
        for (Object object : list) {
            condition.put(indexTemp++, object);
        }
        if (!CommonUtil.isNull(ip) && !"0".equals(ip)) {
            sql.append(" and ZONE_IP = ? ");
            condition.put(indexTemp++, ip);
        }
        if (1 == abnormalType) {
            sql.append(" and START_TIME_ATTACK = 0");
        } else if (2 == abnormalType) {
            sql.append(" and START_TIME_ATTACK <> 0");
        }
        Long l = cds.getDropPacket();
        Long l2 = cds.getDropByte();
        boolean showDropPacket = cds.isShowDropPacket();
        if (1 != abnormalType) {
            if (showDropPacket && null != l && l > 0L) {
                sql.append(" and DROP_PACKETS >= ? ");
                condition.put(indexTemp++, l);
            }
            if (!showDropPacket && null != l2 && l2 > 0L) {
                sql.append(" and DROP_BYTES >= ? ");
                condition.put(indexTemp++, l2);
            }
        }
        if (null != (attackType = cds.getAttackType()) && attackType > 0) {
            sql.append(" and ATTACK_TYPE = ? ");
            condition.put(indexTemp++, attackType);
        }
        if (null != minInFlow && minInFlow > 0L) {
            if (unit == 0) {
                sql.append(" and IP_MAX_IN_KBPS >= ? ");
            } else {
                sql.append(" and IP_MAX_IN_PPS >= ? ");
            }
            condition.put(indexTemp++, minInFlow);
        }
        if (null != minAttackFlowPeak && minAttackFlowPeak > 0L) {
            if (unit == 0) {
                sql.append(" and IP_MAX_DROP_KBPS >= ? ");
            } else {
                sql.append(" and IP_MAX_DROP_PPS >= ? ");
            }
            condition.put(indexTemp++, minAttackFlowPeak);
        }
        return sql.toString();
    }

    public String getAttackExactLogSqlForPcap(DataStatCondition cds, String partSql, String tmpName, Map<Integer, Object> condition) {
        int index = 1;
        String deviceIp = cds.getDeviceIp();
        Integer devSerType = cds.getDevSerType();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Integer attackType = cds.getAttackType();
        Integer protocol = cds.getProtocol();
        Integer port = cds.getPort();
        if (start.equals(end)) {
            end = end + 5L;
        }
        StringBuffer iSql = new StringBuffer();
        iSql.append(" WHERE start_time_alert <= ? ");
        condition.put(index++, end);
        iSql.append(" AND end_time >= ? ");
        condition.put(index++, start);
        if (null != zoneId && (1L == zoneId || cds.isDefaultZone())) {
            iSql.append(" AND ( device_ip= ? OR zone_id= ? )");
            condition.put(index++, deviceIp);
            condition.put(index++, zoneId);
        } else {
            iSql.append(" AND device_ip= ? ");
            condition.put(index++, deviceIp);
            if (null != zoneId) {
                iSql.append(" AND zone_id= ? ");
                condition.put(index++, zoneId);
            }
        }
        if (null != devSerType) {
            iSql.append(" and device_type= ? ");
            condition.put(index++, devSerType);
        }
        if (!CommonUtil.isNull(zoneIp)) {
            iSql.append(" AND ");
            iSql.append("zone_ip= ? ");
            condition.put(index++, zoneIp);
        }
        if (attackType != null) {
            if (attackType < 10) {
                iSql.append(" AND ");
                iSql.append("attack_type < ");
                iSql.append(10);
                if (protocol != null) {
                    iSql.append(" AND ");
                    iSql.append("protocol= ? ");
                    condition.put(index++, protocol);
                }
                if (port != null) {
                    iSql.append(" AND ");
                    iSql.append("port= ? ");
                    condition.put(index++, port);
                }
            } else if (14 == attackType || 15 == attackType) {
                iSql.append(" AND ");
                iSql.append("attack_type=");
                iSql.append(PCAP_ATTACK_TYPE_CONNECTION_FLOOD);
            } else if (65 == attackType) {
                iSql.append(" AND ");
                iSql.append("attack_type >= 1008 AND attack_type <= 1011");
            } else {
                iSql.append(" AND ");
                iSql.append("attack_type= ? ");
                condition.put(index++, attackType);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("splice sql,deviceIp is " + deviceIp + ",zoneId is " + zoneId));
        }
        StringBuffer querySql = new StringBuffer(partSql);
        querySql.append(tmpName);
        querySql.append(iSql);
        querySql.append(" ORDER BY ");
        querySql.append("start_time_alert");
        if (null != zoneId) {
            querySql.append(",zone_id");
        }
        querySql.append(" DESC");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"------attack log query SQL------");
            LOG.debug((Object)"ORDER BY start_time_alert,zone_id DESC");
        }
        return querySql.toString();
    }

    public String getExactLogIdSql(Long attackLogPkid, int direction, Map<Integer, Object> condition) {
        StringBuffer querySql = new StringBuffer();
        querySql.append("select EXACT_LOG_ID from atic_ip_attack_log where PKID = ? ");
        condition.put(1, attackLogPkid);
        querySql.append(" AND DIRECTION = ?");
        condition.put(2, direction);
        return querySql.toString();
    }

    public String getAttackExactLogSql(String exactLogId, int direction, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append("select PKID, DEVICE_IP, DEVICE_TYPE ,ZONE_ID, BIZ_ID, ZONE_IP, START_TIME_ALERT, START_TIME_ATTACK,END_TIME, DURATION, ATTACK_TYPE, PROTOCOL, PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE, CURRENT_VALUE, LIMIT_VALUE, PPS_OR_KBPS,CURRENT_VALUE_1, LIMIT_VALUE_1, PPS_OR_KBPS_1,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS DESTINATION_PORT from atic_ip_attack_exact_log where PKID in (");
        String[] ids = exactLogId.split(",");
        for (int i = 0; i < ids.length; ++i) {
            condition.put(i + 1, ids[i]);
            if (0 == i) {
                sql.append("?");
                continue;
            }
            sql.append(",?");
        }
        sql.append(")");
        if (direction > 0) {
            sql.append(" AND DIRECTION = ? ");
            condition.put(ids.length + 1, direction);
        }
        return sql.toString();
    }

    public String getAttackTopnSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select device_ip,zone_id,biz_id,zone_ip,start_time_alert,start_time_attack,end_time,duration,attack_type,attack_status,DROP_KBITS,drop_packets,protocol,port,LIMIT_VALUE,PPS_OR_KBPS,LIMIT_VALUE_1, PPS_OR_KBPS_1 ,MAX_DROP_PPS,MAX_DROP_KBPS from ");
        sql.append(tableName + " IGNORE  INDEX (DEVICE_IP_ATTACK_TIME, DEVICE_IP_END_TIME)");
        sql.append(" where ");
        StringBuffer deviceCondition = new StringBuffer();
        if (-1L == cds.getDeviceId() || -2L == cds.getDeviceId()) {
            if (null != cds.getDeviceIpList()) {
                deviceCondition.append(" device_ip in (");
                for (int i = 0; i < cds.getDeviceIpList().size(); ++i) {
                    String deviceIpStr = IpTransformer.formatIpAddress(cds.getDeviceIpList().get(i));
                    deviceCondition.append('?');
                    condition.put(index++, deviceIpStr);
                    if (i == cds.getDeviceIpList().size() - 1) continue;
                    deviceCondition.append(',');
                }
                deviceCondition.append(')');
            }
        } else {
            deviceCondition.append(" device_ip = ? ");
            condition.put(index++, cds.getDeviceIp());
        }
        deviceCondition.append(" and device_type = ? ");
        condition.put(index++, cds.getDevSerType());
        deviceCondition.append(" and direction = ? ");
        condition.put(index++, cds.getDirection());
        sql.append(deviceCondition);
        if (null != cds.getZoneId()) {
            sql.append(" and zone_id = ? ");
            condition.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, sql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        StringBuffer timeCondition = new StringBuffer();
        if (0 == cds.getDevSerType()) {
            timeCondition.append(" and ( start_time_attack <> 0");
            timeCondition.append(" and start_time_attack <= ? ");
            timeCondition.append(" and end_time >= ? ");
            timeCondition.append(" )");
            condition.put(index++, cds.getEndTime());
            condition.put(index++, cds.getStartTime());
        } else {
            timeCondition.append(" and ( START_TIME_ALERT <> 0");
            timeCondition.append(" and START_TIME_ALERT <= ? ");
            timeCondition.append(" and end_time >= ? ");
            timeCondition.append(" )");
            condition.put(index++, cds.getEndTime());
            condition.put(index++, cds.getStartTime());
        }
        sql.append(timeCondition);
        if (0 == cds.getAppType()) {
            sql.append(" order by MAX_DROP_KBPS desc ");
        } else if (1 == cds.getAppType()) {
            sql.append(" order by duration desc ");
        } else if (2 == cds.getAppType()) {
            sql.append(" order by DROP_KBITS desc ");
        } else if (3 == cds.getAppType()) {
            sql.append(" order by drop_packets desc ");
        } else if (4 == cds.getAppType()) {
            sql.append(" order by MAX_DROP_PPS desc ");
        }
        if (null != cds.getTopn()) {
            sql.append(" limit 0, ? ");
            condition.put(index++, cds.getTopn());
        }
        return sql.toString();
    }

    public String getAttackExactFlowSql(String exactLogId, String tableName, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append("select LOG_TIME, DEVICE_IP, ZONE_ID, BIZ_ID, ZONE_IP, ATTACK_TYPE, PROTOCOL, PORT, DROP_PPS from ").append(tableName).append(" where EXACT_LOG_ID = ? ").append(" order by LOG_TIME");
        condition.put(1, exactLogId);
        return sql.toString();
    }

    public String getAttackExactFlowSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select LOG_TIME, DEVICE_IP, ZONE_ID, BIZ_ID, ZONE_IP, ATTACK_TYPE, PROTOCOL, PORT, DROP_KBPS, DROP_PPS from ").append(tableName).append(" where DEVICE_IP= ? AND DEVICE_TYPE= ? ").append(" and ZONE_ID= ? ").append(" and BIZ_ID= ? ").append(" and ZONE_IP= ? ").append(" and ATTACK_TYPE= ? ").append(" and PROTOCOL= ? ");
        condition.put(index++, cds.getDeviceIp());
        condition.put(index++, cds.getDevSerType());
        condition.put(index++, cds.getZoneId());
        condition.put(index++, cds.getBisId());
        condition.put(index++, cds.getZoneIp());
        condition.put(index++, cds.getAttackType());
        condition.put(index++, cds.getProtocol());
        boolean columnExist = DBStat.checkColumnExist("DIRECTION", tableName);
        if (columnExist) {
            sql.append(" and DIRECTION= ? ");
            condition.put(index++, cds.getDirection());
        }
        sql.append(" and PORT= ? ");
        sql.append(" and LOG_TIME between ? and ? ");
        sql.append(" order by LOG_TIME");
        condition.put(index++, cds.getPort());
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        return sql.toString();
    }

    public String getAttackExactLogSql4AttackEvent(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select PKID, DEVICE_IP, DEVICE_TYPE ,ZONE_ID, BIZ_ID, ZONE_IP, START_TIME_ALERT, START_TIME_ATTACK,END_TIME, DURATION, ATTACK_TYPE, PROTOCOL, PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE, CURRENT_VALUE, LIMIT_VALUE, PPS_OR_KBPS,CURRENT_VALUE_1, LIMIT_VALUE_1, PPS_OR_KBPS_1,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS DESTINATION_PORT from atic_ip_attack_exact_log where 1=1 ");
        sql.append(" and device_ip = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" and device_type = ? ");
        condition.put(index++, cds.getDevSerType());
        if (cds.getDirection() > 0) {
            sql.append(" and direction = ? ");
            condition.put(index++, cds.getDirection());
        }
        if (null != cds.getZoneId()) {
            sql.append(" and zone_id = ? ");
            condition.put(index++, cds.getZoneId());
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            sql.append(" and zone_ip= ? ");
            condition.put(index++, cds.getZoneIp());
        }
        sql.append(" and start_time_alert <= ? ");
        condition.put(index++, cds.getEndTime());
        sql.append(" and end_time >= ? ");
        condition.put(index++, cds.getStartTime());
        return sql.toString();
    }

    public String getAttackLogSql4Portal(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        String deviceIp = cds.getDeviceIp();
        Long zoneId = cds.getZoneIdForCollector();
        String ip = cds.getZoneIp();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        StringBuffer sql = new StringBuffer();
        sql.append("select PKID, DEVICE_IP, DEVICE_TYPE ,ZONE_ID, BIZ_ID, ZONE_IP, START_TIME_ALERT, START_TIME_ATTACK,END_TIME, DURATION, ATTACK_TYPE, PROTOCOL, PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW, INTERACTIVE, CURRENT_VALUE, LIMIT_VALUE, PPS_OR_KBPS,CURRENT_VALUE_1, LIMIT_VALUE_1, PPS_OR_KBPS_1,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS DESTINATION_PORT from atic_ip_attack_exact_log where 1=1 ");
        sql.append(" AND DIRECTION=? and END_TIME >= ? and START_TIME_ALERT <= ?  and DEVICE_IP = ? ");
        condition.put(index++, 1);
        condition.put(index++, start);
        condition.put(index++, end);
        condition.put(index++, deviceIp);
        if (cds.getDevSerType() != null && cds.getDevSerType() != 2) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, cds.getDevSerType());
        }
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        }
        if (!CommonUtil.isNull(ip)) {
            sql.append(" and ZONE_IP = ? ");
            condition.put(index++, ip);
        }
        return sql.toString();
    }

    public String getCur10AttackLogSql(List<String> deviceIpList, List<Long> zoneIdList, Long tempNum, int topn, Map<Integer, Object> map) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select DIRECTION, DEVICE_IP, DEVICE_TYPE ,ZONE_ID, ZONE_IP, MIN(START_TIME_ALERT) START_TIME_ALERT, MIN(START_TIME_ATTACK) START_TIME_ATTACK, MAX(ATTACK_STATUS) ATTACK_STATUS, GROUP_CONCAT(distinct ATTACK_TYPE) ATTACK_TYPE, MAX_DROP_PPS, MAX_DROP_KBPS, DURATION,PORTS DESTINATION_PORT from atic_attack_log where 1=1 ");
        if (null != deviceIpList && !deviceIpList.isEmpty() && deviceIpList.size() < 10000) {
            int devIndex = 0;
            for (String devIp : deviceIpList) {
                if (!IpTransformer.checkIpInvaild(devIp)) continue;
                if (0 == devIndex && deviceIpList.size() == 1) {
                    sql.append(" and (DEVICE_IP =  ? )");
                    map.put(index++, devIp);
                } else if (0 == devIndex) {
                    sql.append(" and (DEVICE_IP = ? ");
                    map.put(index++, devIp);
                } else if (devIndex == deviceIpList.size() - 1) {
                    sql.append(" or DEVICE_IP = ? )");
                    map.put(index++, devIp);
                } else {
                    sql.append(" or DEVICE_IP = ? ");
                    map.put(index++, devIp);
                }
                ++devIndex;
            }
        }
        if (null != zoneIdList && !zoneIdList.isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? ) ");
            map.put(index++, tempNum);
        }
        sql.append(" group by DIRECTION, ZONE_ID, ZONE_IP,DEVICE_IP, DEVICE_TYPE order by start_time_alert DESC limit 0,").append(topn);
        return sql.toString();
    }

    public String getAbnormalOrAttackCountSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int abnormalType = cds.getAbnormalType();
        String tableName = "atic_ip_attack_exact_log";
        String startTime = "START_TIME_ALERT";
        if (2 == abnormalType) {
            startTime = "START_TIME_ATTACK";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,START_TIME_ALERT,START_TIME_ATTACK,count(" + startTime + ") AS COUNT from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        sql.append(" GROUP BY ").append(startTime);
        sql.append(" ORDER BY ").append(startTime).append(" DESC ");
        return sql.toString();
    }

    public String getAttackTypeLogSql(DataStatCondition cds, String sortField, String sortType, Map<Integer, Object> condition) {
        int startRow = cds.getStartRow();
        int limit = cds.getLimit();
        String tableName = "atic_ip_attack_exact_log";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PKID,DEVICE_IP,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_STATUS,ATTACK_TYPE,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE,CURRENT_VALUE,LIMIT_VALUE,PPS_OR_KBPS,CURRENT_VALUE_1,PROTOCOL,PORT,LIMIT_VALUE_1,PPS_OR_KBPS_1,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,DEVICE_TYPE,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS DESTINATION_PORT from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        if (!CommonUtil.isNull(sortField) && !CommonUtil.isNull(sortType)) {
            String dataBaseColumn = "";
            switch (sortField) {
                case "displayDuration": {
                    dataBaseColumn = "DURATION";
                    break;
                }
                case "inFlowFeak": {
                    dataBaseColumn = "IP_MAX_IN_PPS";
                    break;
                }
                case "attackFlowFeak": {
                    dataBaseColumn = "MAX_DROP_PPS";
                    break;
                }
                default: {
                    dataBaseColumn = CollectorConstants.getAttackLog().get(sortField);
                }
            }
            if (null != dataBaseColumn && !"".equals(dataBaseColumn)) {
                String regular = "^[A-Za-z0-9|_]+$";
                if (Pattern.matches(regular, dataBaseColumn)) {
                    sql.append(" order by ").append(dataBaseColumn).append("DESC".equalsIgnoreCase(sortType) ? " desc" : "");
                }
            } else {
                sql.append(" order by START_TIME_ALERT DESC ");
            }
        } else {
            sql.append(" order by START_TIME_ALERT DESC ");
        }
        sql.append(" LIMIT ").append(startRow).append(',').append(limit);
        return sql.toString();
    }

    public String getAttackTypeLogNumSql(DataStatCondition cds, Map<Integer, Object> condition) {
        String tableName = "atic_ip_attack_exact_log";
        StringBuffer sql = new StringBuffer();
        sql.append("select count(0) count from " + tableName);
        sql.append(this.attackLogWhereSql(cds, tableName, condition));
        return sql.toString();
    }
}

