/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConnCompareUtil {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();

    public String getTablePostfixName(Long startTime, Long endTime) {
        String postfixName = "";
        long span = endTime - startTime;
        if (span < CollectorConstants.ONE_DAY && span >= 0L) {
            postfixName = "";
        } else if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            postfixName = "_H";
        } else if (span < CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK) {
            postfixName = "_D";
        }
        return postfixName;
    }

    public String getAvgOrMaxConn(DataStatCondition cds) {
        String avgOrMax = "";
        Integer type = cds.getAppType();
        String bisType = cds.getBisType();
        Long startTime = cds.getStartTime();
        Long endTime = cds.getEndTime();
        Long span = endTime - startTime;
        if (1 == type) {
            avgOrMax = "DEFAULT".equalsIgnoreCase(bisType) && span >= 86400L ? "" : "_MAX";
        } else if (2 == type) {
            avgOrMax = "";
        }
        return avgOrMax;
    }

    public String getNoBizQuerySql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        boolean columnExist = DBStat.checkColumnExist("TCP_INCREASE_CON", tableName);
        String tcpInceraseCon = columnExist ? " TCP_INCREASE_CON " : " 0 ";
        columnExist = DBStat.checkColumnExist("TCP_CUR_CON", tableName);
        String tcpCurCON = columnExist ? " TCP_CUR_CON " : " 0 ";
        StringBuffer connSql = new StringBuffer();
        connSql.append("select LOG_TIME,");
        connSql.append(tcpInceraseCon).append(" as INCREASE_CON,");
        connSql.append(tcpCurCON).append(" as CUR_CON");
        connSql.append(" from ");
        connSql.append(tableName);
        connSql.append(" where DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        connSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != cds.getZoneId()) {
            connSql.append(" and ZONE_ID = ? ");
            condition.put(index++, cds.getZoneId());
        } else if (!CommonUtil.isNull(cds.getZoneIp()) && null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            connSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            connSql.append(" and ZONE_IP = ? ");
            condition.put(index++, cds.getZoneIp());
        }
        connSql.append(" and ( LOG_TIME between ? ");
        condition.put(index++, cds.getStartTime());
        connSql.append(" and ? ");
        condition.put(index++, cds.getEndTime());
        connSql.append(" ) order by LOG_TIME");
        return connSql.toString();
    }

    public String getWithBizQuerySql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        Long startTime = cds.getStartTime();
        Long endTime = cds.getEndTime();
        Long span = endTime - startTime;
        String bisType = cds.getBisType();
        Integer type = cds.getAppType();
        StringBuffer connSql = new StringBuffer();
        connSql.append("select LOG_TIME,");
        if ("DEFAULT".equalsIgnoreCase(bisType) && 2 == type) {
            connSql.append(" SUM(TCP_INCREASE_CON) as INCREASE_CON,");
            connSql.append(" SUM(TCP_CUR_CON) as CUR_CON");
        } else if ("DEFAULT".equalsIgnoreCase(bisType) && 1 == type && span >= 86400L) {
            connSql.append(" SUM(MAX_TCP_INCREASE_CON) as INCREASE_CON,");
            connSql.append(" SUM(MAX_TCP_CUR_CON) as CUR_CON");
        } else if ("DEFAULT".equalsIgnoreCase(bisType) && 1 == type && span < 86400L) {
            connSql.append(" SUM(TCP_INCREASE_CON) as INCREASE_CON,");
            connSql.append(" SUM(TCP_CUR_CON) as CUR_CON");
        } else {
            connSql.append(" SUM(INCREASE_CON) as INCREASE_CON,");
            connSql.append(" SUM(CUR_CON) as CUR_CON");
        }
        connSql.append(" from ");
        connSql.append(tableName);
        connSql.append(" where DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        connSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != cds.getZoneId()) {
            connSql.append(" and ZONE_ID = ? ");
            condition.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            connSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithType(cds, tableName, connSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            connSql.append(" and ZONE_IP = ? ");
            condition.put(index++, cds.getZoneIp());
        }
        connSql.append(" and ( LOG_TIME between ? ");
        condition.put(index++, cds.getStartTime());
        connSql.append(" and ? ");
        condition.put(index++, cds.getEndTime());
        connSql.append(" ) group by LOG_TIME order by LOG_TIME");
        return connSql.toString();
    }

    public String getSrcTcpConnSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        ArrayList<Object> list = new ArrayList<Object>();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        ConnCompareUtil util = new ConnCompareUtil();
        String tableName = "ATIC_SRC_DNS_TOPN" + util.getTablePostfixName(start, end);
        String conditionStr = " DEVICE_IP = ? and DEVICE_TYPE = ? and  TOPN_TYPE = 5 ";
        list.add(cds.getDeviceIp());
        list.add(cds.getDevSerType());
        if (null != cds.getZoneId()) {
            conditionStr = conditionStr + " and ZONE_ID = ? ";
            list.add(cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            conditionStr = conditionStr + " and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )";
            list.add(cds.getSessionId());
        }
        conditionStr = conditionStr + " and LOG_TIME between ? and ? ";
        list.add(cds.getStartTime());
        list.add(cds.getEndTime());
        String sql = "SELECT LOG_TIME, SUM(REQUEST_PPS) REQUEST_PPS FROM " + tableName + " WHERE SRC_IP = ";
        sql = sql + "(SELECT SRC_IP FROM (SELECT SRC_IP, SUM(REQUEST_PPS) pps FROM " + tableName + " WHERE ";
        sql = sql + conditionStr + " GROUP BY SRC_IP ORDER BY pps DESC LIMIT 0,1) a)";
        for (Object e : list) {
            condition.put(index++, e);
        }
        sql = sql + " and " + conditionStr + " GROUP BY LOG_TIME";
        for (Object e : list) {
            condition.put(index++, e);
        }
        return sql;
    }
}

