/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.DataStatCondition;
import java.util.Map;

public class DeviceAttackDataUtil {
    public String getAttackDropDataSql(DataStatCondition dataStatCondition, Map<Integer, Object> condition, String flowDropTable, String flowDropMaxTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.LOG_TIME AS LOG_TIME, t1.DEVICE_IP AS DEVICE_IP, t1.TOTAL_KBPS as EVERAGE_KBPS, MAX(t2.TOTAL_KBPS) as MAX_KBPS from " + flowDropTable + " t1, " + flowDropMaxTable + " t2 where t1.LOG_TIME = t2.LOG_TIME ");
        boolean columnExist = DBStat.checkColumnExist("", flowDropTable);
        if (columnExist) {
            sql.append(" and t1.DIRECTION = t2.DIRECTION ");
        }
        int index = 1;
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP and t1.DEVICE_TYPE = t2.DEVICE_TYPE ");
        sql.append(" and t1.DEVICE_IP = ? ");
        condition.put(index++, dataStatCondition.getDeviceIp());
        sql.append("   and t1.LOG_TIME >= ? ");
        condition.put(index++, dataStatCondition.getStartTime());
        sql.append("  and t1.LOG_TIME <= ?  ");
        condition.put(index++, dataStatCondition.getEndTime());
        sql.append(" and t1.DEVICE_TYPE = ? ");
        condition.put(index++, dataStatCondition.getDevSerType());
        if (dataStatCondition.getDirection() > 0 && columnExist) {
            sql.append(" and t1.DIRECTION = 1 ");
        }
        sql.append(" GROUP BY DEVICE_IP,LOG_TIME order by LOG_TIME asc ");
        return sql.toString();
    }

    public String[] getTableName(Integer timeSpanType) {
        String[] tableName = new String[2];
        switch (timeSpanType) {
            case 0: {
                tableName[0] = "atic_dev_flow_sum_drop";
                tableName[1] = "atic_dev_flow_sum_drop_max";
                break;
            }
            case 1: {
                tableName[0] = "atic_dev_flow_sum_drop_h";
                tableName[1] = "atic_dev_flow_sum_drop_max_h";
                break;
            }
            default: {
                tableName[0] = "atic_dev_flow_sum_drop_d";
                tableName[1] = "atic_dev_flow_sum_drop_max_d";
            }
        }
        return tableName;
    }

    public String getAttackCountSql(long logTime, DataStatCondition dataStatCondition, Map<Integer, Object> condition) {
        String endTime = this.getCountDuration(logTime, dataStatCondition.getTimeSpanType());
        int index = 1;
        StringBuffer sql = new StringBuffer();
        String tableName = "ATIC_IP_ATTACK_LOG";
        sql.append("select count(0) count from " + tableName);
        sql.append(" where DEVICE_IP = ? ");
        condition.put(index++, dataStatCondition.getDeviceIp());
        sql.append("   and END_TIME >= ? ");
        condition.put(index++, logTime);
        sql.append("  and START_TIME_ALERT < ? ");
        condition.put(index++, endTime);
        sql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, dataStatCondition.getDevSerType());
        if (dataStatCondition.getDirection() > 0) {
            sql.append(" and DIRECTION = ? ");
            condition.put(index++, dataStatCondition.getDirection());
        }
        if (null != dataStatCondition.getSessionId() && !dataStatCondition.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, dataStatCondition.getSessionId());
        }
        return sql.toString();
    }

    private String getCountDuration(long logTime, Integer timeSpanType) {
        Long endTime;
        switch (timeSpanType) {
            case 0: {
                endTime = logTime + 300L;
                break;
            }
            case 1: {
                endTime = logTime + 3600L;
                break;
            }
            case 2: {
                endTime = logTime + 86400L;
                break;
            }
            default: {
                endTime = logTime + 299L;
            }
        }
        return String.valueOf(endTime);
    }
}

