/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropTrendUtil {
    static String spoofingPackets = "Spoofing packets";
    static String userDefinedPackets = "User-defined packets";
    static String dynamicFilterPackets = "Dynamic filter packets";
    static String malformedConnection = "Malformed connection packets";
    static String malformedPackets = "Malformed packets";
    static String overflowPackets = "Overflow packets";
    static String clientAttackPackets = "Client Attack packets";
    static String otherPackets = "Other packets";
    private static final Map<String, List<Integer>> DROP_TYPE_NAME = new HashMap<String, List<Integer>>();

    public String getDropTypeName(int attackType) {
        if (attackType >= 2000) {
            return userDefinedPackets;
        }
        if (DROP_TYPE_NAME.get(spoofingPackets).contains(attackType)) {
            return spoofingPackets;
        }
        if (DROP_TYPE_NAME.get(userDefinedPackets).contains(attackType)) {
            return userDefinedPackets;
        }
        if (DROP_TYPE_NAME.get(dynamicFilterPackets).contains(attackType)) {
            return dynamicFilterPackets;
        }
        if (DROP_TYPE_NAME.get(malformedConnection).contains(attackType)) {
            return malformedConnection;
        }
        if (DROP_TYPE_NAME.get(malformedPackets).contains(attackType)) {
            return malformedPackets;
        }
        if (DROP_TYPE_NAME.get(overflowPackets).contains(attackType)) {
            return overflowPackets;
        }
        if (DROP_TYPE_NAME.get(clientAttackPackets).contains(attackType)) {
            return clientAttackPackets;
        }
        if (DROP_TYPE_NAME.get(otherPackets).contains(attackType)) {
            return otherPackets;
        }
        return otherPackets;
    }

    private String getTableName(DataStatCondition cds) {
        Long time = cds.getEndTime() - cds.getStartTime();
        StringBuffer tableName = new StringBuffer();
        if (null == cds.getZoneId() && null == cds.getZoneIp()) {
            tableName.append("atic_zone_attack_flow");
        } else if (null == cds.getZoneIp()) {
            tableName.append("atic_zone_attack_flow");
        } else {
            tableName.append("atic_ip_attack_flow");
        }
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    private String getWherecondSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            condition.put(index++, zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }

    public String getDropTrendUtil(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer selectSql = new StringBuffer("SELECT LOG_TIME, SUM(DROP_PPS) DROP_PPS,ATTACK_TYPE ");
        StringBuffer fromSql = new StringBuffer(" FROM ");
        fromSql.append(this.getTableName(cds));
        StringBuffer whereSql = new StringBuffer(this.getWherecondSql(cds, this.getTableName(cds), condition));
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql).append(whereSql).append(" group by LOG_TIME, ATTACK_TYPE order by LOG_TIME");
        return sql.toString();
    }

    static {
        Integer[] sp = new Integer[]{10, 11, 12, 13, 16, 29, 30, 31, 55};
        ArrayList<Integer> spArray = new ArrayList<Integer>(Arrays.asList(sp));
        DROP_TYPE_NAME.put(spoofingPackets, spArray);
        Integer[] udp = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 32, 62, 66, 67, 68, 69, 70, 71, 99};
        ArrayList<Integer> udpArray = new ArrayList<Integer>(Arrays.asList(udp));
        DROP_TYPE_NAME.put(userDefinedPackets, udpArray);
        Integer[] dfp = new Integer[]{19, 20, 33, 51, 57};
        ArrayList<Integer> dfpArray = new ArrayList<Integer>(Arrays.asList(dfp));
        DROP_TYPE_NAME.put(dynamicFilterPackets, dfpArray);
        Integer[] mc = new Integer[]{42, 43};
        ArrayList<Integer> mcArray = new ArrayList<Integer>(Arrays.asList(mc));
        DROP_TYPE_NAME.put(malformedConnection, mcArray);
        Integer[] mp = new Integer[]{44, 49, 50, 53, 60, 61, 65, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130};
        ArrayList<Integer> mpArray = new ArrayList<Integer>(Arrays.asList(mp));
        DROP_TYPE_NAME.put(malformedPackets, mpArray);
        Integer[] op = new Integer[]{17, 18, 21, 22, 23, 24, 25, 58, 64};
        ArrayList<Integer> opArray = new ArrayList<Integer>(Arrays.asList(op));
        DROP_TYPE_NAME.put(overflowPackets, opArray);
        Integer[] cap = new Integer[]{14, 15, 26, 27, 40, 41, 45, 46, 47, 48, 52, 54, 56, 59, 63, 1008, 1009, 1010, 1011};
        ArrayList<Integer> capArray = new ArrayList<Integer>(Arrays.asList(cap));
        DROP_TYPE_NAME.put(clientAttackPackets, capArray);
        Integer[] other = new Integer[]{34, 35, 36, 37, 38, 39};
        ArrayList<Integer> otherArray = new ArrayList<Integer>(Arrays.asList(other));
        DROP_TYPE_NAME.put(otherPackets, otherArray);
    }
}

