/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowDisUtil {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();

    public String getTableType(Long startTime, Long endTime) {
        String tablePostfix = "";
        long span = endTime - startTime;
        if (span < CollectorConstants.ONE_DAY && span >= 0L) {
            tablePostfix = "";
        } else if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            tablePostfix = "_H";
        } else if (span < CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK) {
            tablePostfix = "_D";
        }
        return tablePostfix;
    }

    public String getSelectPart(String[] cols) {
        StringBuffer iSql = new StringBuffer("SELECT ");
        for (int i = 0; i < cols.length; ++i) {
            iSql.append(cols[i]);
            if (i == cols.length - 1) continue;
            iSql.append(',');
        }
        return iSql.toString();
    }

    private String[] getFlowQueryCols(int unit) {
        StringBuffer f1 = new StringBuffer("MAX(TOTAL_");
        StringBuffer f2 = new StringBuffer("MAX(TCP_");
        StringBuffer f3 = new StringBuffer("MAX(UDP_");
        StringBuffer f4 = new StringBuffer("MAX(ICMP_");
        StringBuffer f5 = new StringBuffer("MAX(OTHER_");
        StringBuffer f6 = new StringBuffer("LOG_TIME ");
        switch (unit) {
            case 0: {
                f1.append("KBPS) ");
                f2.append("KBPS) ");
                f3.append("KBPS) ");
                f4.append("KBPS) ");
                f5.append("KBPS) ");
                break;
            }
            case 1: {
                f1.append("PPS) ");
                f2.append("PPS) ");
                f3.append("PPS) ");
                f4.append("PPS) ");
                f5.append("PPS) ");
                break;
            }
        }
        f1.append("TOTAL");
        f2.append("TCP");
        f3.append("UDP");
        f4.append("ICMP");
        f5.append("OTHER");
        f6.append("LOGTIME");
        String[] cols = new String[]{f1.toString(), f2.toString(), f3.toString(), f4.toString(), f5.toString(), f6.toString()};
        return cols;
    }

    public String getQuerySql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        String[] cols = this.getFlowQueryCols(cds.getUnit());
        StringBuffer iSql = new StringBuffer();
        iSql.append(this.getSelectPart(cols));
        iSql.append(" FROM ").append(tableName).append(" WHERE ");
        boolean columnExist = DBStat.checkColumnExist("DIRECTION", tableName);
        if (columnExist) {
            iSql.append(" DIRECTION = ? AND ");
            condition.put(index++, cds.getDirection());
        }
        iSql.append(" DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        iSql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != cds.getZoneId()) {
            iSql.append(" AND ZONE_ID = ? ");
            condition.put(index++, cds.getZoneId());
        } else {
            Boolean isQueryDevice = this.isQueryDevice(cds);
            if (!isQueryDevice.booleanValue() && null == cds.getZoneId() && null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
                iSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
                condition.put(index++, cds.getSessionId());
            }
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            iSql.append(" AND ZONE_IP = ? ");
            condition.put(index++, cds.getZoneIp());
        }
        iSql.append(" AND LOG_TIME BETWEEN ? AND ? ");
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        iSql.append(" GROUP BY LOG_TIME,DEVICE_IP ORDER BY LOG_TIME ASC ");
        return iSql.toString();
    }

    public Boolean isQueryDevice(DataStatCondition cds) {
        Boolean isQueryDevice = false;
        if (null == cds.getZoneId() && null == cds.getZoneIp()) {
            isQueryDevice = true;
        }
        return isQueryDevice;
    }

    public String getDetectSelectPart(String[] cols) {
        StringBuffer iSql = new StringBuffer("SELECT ");
        iSql.append("LOG_TIME,DEVICE_IP,");
        for (int i = 0; i < cols.length; ++i) {
            iSql.append(cols[i]);
            if (i == cols.length - 1) continue;
            iSql.append(',');
        }
        return iSql.toString();
    }

    public String getAllDetectSql(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer iSql = new StringBuffer();
        String[] cols = this.getFlowQueryCols(cds.getUnit());
        iSql.append(this.getDetectSelectPart(cols));
        iSql.append(" FROM ");
        iSql.append(tableName);
        iSql.append(" WHERE ");
        iSql.append(" DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        iSql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        iSql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != cds.getZoneId()) {
            iSql.append(" AND ");
            iSql.append("ZONE_ID = ? ");
            condition.put(index++, cds.getZoneId());
        } else {
            Boolean isQueryDevice = this.isQueryDevice(cds);
            if (!isQueryDevice.booleanValue() && null == cds.getZoneId() && null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
                iSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
                condition.put(index++, cds.getSessionId());
            }
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            iSql.append(" AND ");
            iSql.append("ZONE_IP = ? ");
            condition.put(index++, cds.getZoneIp());
        }
        iSql.append(" AND ");
        iSql.append(" LOG_TIME BETWEEN ? ");
        condition.put(index++, cds.getStartTime());
        iSql.append(" AND ? ");
        condition.put(index++, cds.getEndTime());
        iSql.append(" GROUP BY LOG_TIME,DEVICE_IP");
        iSql.append(" ORDER BY LOG_TIME ASC ");
        return iSql.toString();
    }
}

