/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.BisTopN;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.DnsTopN;
import com.hs.atic.collector.entity.log.IpLocationTopN;
import com.hs.atic.collector.entity.log.IpTopN;
import com.hs.atic.collector.entity.log.ZoneTopN;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopNUtil {
    public String getZoneAttackCountTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,ZONE_ID, COUNT(*) AS ATT_NUM FROM atic_ip_attack_exact_log ignore index(DEVICE_IP_ATTACK_TIME, DEVICE_IP_END_TIME) WHERE");
        String dataStartTimeColName = "START_TIME_ALERT";
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        condition.put(index++, end);
        sql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY DEVICE_IP,ZONE_ID ORDER BY ATT_NUM DESC, ZONE_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return sql.toString();
    }

    public String getZoneAttackTimeTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        Long zoneId = cds.getZoneId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP, ZONE_ID, START_TIME, END_TIME, SUM(");
        sql.append(this.getZoneAttackDurationCondSql(cds, ""));
        sql.append(" FROM atic_zone_attack_log A");
        sql.append(" WHERE END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME<= ? ");
        condition.put(index++, end);
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY ZONE_ID ORDER BY attackTime DESC, ZONE_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return sql.toString();
    }

    public String getZoneAttackTimeTopNSql4MultiNE(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        Long zoneId = cds.getZoneId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,zone_Id,START_TIME,END_TIME, (");
        sql.append(this.getZoneAttackDurationCondSql(cds, ""));
        sql.append("FROM atic_zone_attack_log A WHERE EXISTS(SELECT DEVICE_IP,zone_id FROM (");
        sql.append("SELECT DEVICE_IP,ZONE_ID, SUM(");
        sql.append(this.getZoneAttackDurationCondSql(cds, ""));
        sql.append(" FROM atic_zone_attack_log A");
        sql.append(" WHERE END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME<= ? ");
        condition.put(index++, end);
        sql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY DEVICE_IP,ZONE_ID ORDER BY attackTime DESC, ZONE_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        sql.append(") t WHERE t.DEVICE_IP = A.DEVICE_IP AND t.zone_id = A.ZONE_ID)");
        sql.append(" AND END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME<= ? ");
        condition.put(index++, end);
        sql.append(" and ");
        List<Object> tempList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : tempList) {
            condition.put(index++, object);
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        return sql.toString();
    }

    public String getBisAttackCountTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ZONE_ID, BIZ_ID, COUNT(*) AS ATT_NUM FROM atic_ip_attack_exact_log WHERE");
        String dataStartTimeColName = "START_TIME_ALERT";
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        condition.put(index++, end);
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        sql.append(" AND BIZ_ID <>0 ");
        sql.append(" AND BIZ_ID NOT IN (SELECT BIZ_ID FROM atic_default_biz_relation WHERE DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" ) ");
        sql.append(" GROUP BY BIZ_ID ORDER BY ATT_NUM DESC, BIZ_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return sql.toString();
    }

    public String getBisAttackTimeTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,zone_Id,BIZ_ID,START_TIME,END_TIME,SUM(");
        sql.append(this.getZoneAttackDurationCondSql(cds, ""));
        sql.append(" FROM atic_biz_attack_log A");
        sql.append(" WHERE END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME<= ? ");
        condition.put(index++, end);
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        sql.append(" AND BIZ_ID <>0 ");
        sql.append(" AND BIZ_ID NOT IN (SELECT BIZ_ID FROM atic_default_biz_relation WHERE DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" ) ");
        sql.append(" GROUP BY BIZ_ID ORDER BY attackTime DESC, BIZ_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return sql.toString();
    }

    public String getBisAttackTimeTopNSql4MultiNE(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,zone_Id,BIZ_ID,START_TIME,END_TIME, (");
        sql.append(this.getZoneAttackDurationCondSql(cds, ""));
        sql.append("FROM atic_biz_attack_log A WHERE EXISTS(SELECT BIZ_ID FROM (");
        sql.append("SELECT BIZ_ID, SUM(");
        sql.append(this.getZoneAttackDurationCondSql(cds, ""));
        sql.append(" FROM atic_biz_attack_log A");
        sql.append(" WHERE END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME<= ? ");
        condition.put(index++, end);
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        sql.append(" AND BIZ_ID <>0 ");
        sql.append(" AND BIZ_ID NOT IN (SELECT BIZ_ID FROM atic_default_biz_relation WHERE DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" ) ");
        sql.append(" GROUP BY BIZ_ID ORDER BY attackTime DESC, BIZ_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ?");
            condition.put(index++, topN);
        }
        sql.append(") t WHERE t.BIZ_ID = A.BIZ_ID)");
        sql.append(" AND END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME<= ? ");
        condition.put(index++, end);
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND BIZ_ID <>0 ");
        return sql.toString();
    }

    public String getIpAttackCountTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        String tableName = "atic_ip_attack_exact_log";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,ZONE_ID, ZONE_IP, COUNT(*) AS ATT_NUM FROM " + tableName + " IGNORE index (DEVICE_IP_ATTACK_TIME, DEVICE_IP_END_TIME)  WHERE");
        String dataStartTimeColName = "START_TIME_ALERT";
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        condition.put(index++, end);
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> temList = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        sql.append(" and ");
        List<Object> tempList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : tempList) {
            condition.put(index++, object);
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (CollectorVersionRepository.getInstance().isNeedDrop()) {
            sql.append(" AND BIZ_ID <>0 AND ZONE_IP <>0");
        } else {
            sql.append(" AND ZONE_IP <>0");
        }
        sql.append(" GROUP BY DEVICE_IP,ZONE_IP,ZONE_ID ORDER BY ATT_NUM DESC,ZONE_IP,ZONE_ID ");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int n = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, n);
        }
        return sql.toString();
    }

    public String getIpAttackTimeTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        String tableName = "atic_ip_attack_log";
        String dataStartTimeColName = "START_TIME_ALERT";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,zone_Id,ZONE_IP," + dataStartTimeColName + " START_TIME,END_TIME, SUM(");
        sql.append(this.getZoneAttackDurationCondSql(cds, "ipAttack"));
        sql.append(" FROM " + tableName + " A WHERE");
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        condition.put(index++, end);
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> temList = commomSqlUtil.processServiceSqlWithNoType(cds, "A", sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        if (!CommonUtil.isNull(zoneIp) && !"0".equals(zoneIp)) {
            sql.append(" and ZONE_IP = ? ");
            condition.put(index++, zoneIp);
        }
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (CollectorVersionRepository.getInstance().isNeedDrop()) {
            sql.append(" AND BIZ_ID <>0 AND ZONE_IP <>0");
        } else {
            sql.append("  AND ZONE_IP <>0 ");
        }
        sql.append(" GROUP BY ZONE_IP,ZONE_ID ORDER BY attackTime DESC,ZONE_IP,ZONE_ID ");
        int topn = cds.getTopn();
        long deviceId = cds.getDeviceId();
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return sql.toString();
    }

    public String getIpAttackTimeTopNSql4MultiNE(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        int direction = cds.getDirection();
        String dataStartTimeColName = "START_TIME_ALERT";
        String tableName = "atic_ip_attack_log";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,zone_Id,ZONE_IP," + dataStartTimeColName + " START_TIME,END_TIME, (");
        sql.append(this.getZoneAttackDurationCondSql(cds, "ipAttack"));
        sql.append("FROM " + tableName + " A WHERE EXISTS(SELECT DEVICE_IP,ZONE_ID, ZONE_IP FROM (");
        sql.append("SELECT DEVICE_IP,ZONE_ID, ZONE_IP, SUM(");
        sql.append(this.getZoneAttackDurationCondSql(cds, "ipAttack"));
        sql.append(" FROM " + tableName + " A WHERE");
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        condition.put(index++, end);
        sql.append(" AND DIRECTION = ? ");
        condition.put(index++, direction);
        if (0L != zoneId) {
            sql.append(" and ZONE_ID =  ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> temList = commomSqlUtil.processServiceSqlWithNoType(cds, "A", sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        if (!CommonUtil.isNull(zoneIp) && !"0".equals(zoneIp)) {
            sql.append(" and ZONE_IP = ? ");
            condition.put(index++, zoneIp);
        }
        sql.append(" and ");
        List<Object> tempList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : tempList) {
            condition.put(index++, object);
        }
        sql.append(" AND DEVICE_TYPE =  ? ");
        condition.put(index++, cds.getDevSerType());
        if (CollectorVersionRepository.getInstance().isNeedDrop()) {
            sql.append(" AND BIZ_ID <>0 AND ZONE_IP <>0");
        } else {
            sql.append("  AND ZONE_IP <>0");
        }
        sql.append(" GROUP BY DEVICE_IP,ZONE_IP,ZONE_ID ORDER BY attackTime DESC,ZONE_IP,ZONE_ID ");
        int n = cds.getTopn();
        long deviceId = cds.getDeviceId();
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, n);
        } else {
            int topN = CommomSqlUtil.getTopNNum(n);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        sql.append(") t WHERE t.DEVICE_IP = A.DEVICE_IP AND t.zone_id = A.ZONE_ID AND t.ZONE_IP = A.ZONE_IP)");
        List<Object> temptList = commomSqlUtil.processServiceSqlWithNoType(cds, "A", sql);
        for (Object object : temptList) {
            condition.put(index++, object);
        }
        sql.append(" AND END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND ").append(dataStartTimeColName).append(" > 0 AND ");
        sql.append(dataStartTimeColName).append(" <= ? ");
        condition.put(index++, end);
        sql.append(" and ");
        List<Object> condiList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : condiList) {
            condition.put(index++, object);
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        if (CollectorVersionRepository.getInstance().isNeedDrop()) {
            sql.append(" AND BIZ_ID <>0 AND ZONE_IP <>0");
        } else {
            sql.append(" AND ZONE_IP <>0");
        }
        return sql.toString();
    }

    private String getZoneAttackDurationCondSql(DataStatCondition cds, String type) {
        String finalStartTime = "START_TIME";
        if (type.equalsIgnoreCase("ipAttack")) {
            finalStartTime = "START_TIME_ALERT";
        }
        StringBuffer durationCondSqlSql = new StringBuffer();
        long startTimeLong = cds.getStartTime();
        long endTimeLong = cds.getEndTime();
        durationCondSqlSql.append("CASE WHEN (A.").append(finalStartTime).append("<=");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append(" AND ");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append("<=A.END_TIME AND A.END_TIME<=");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append(") THEN (A.END_TIME-");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append(") WHEN (A.").append(finalStartTime).append("<=");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append(" AND ");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append("<=");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append(" AND ");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append("<=A.END_TIME) THEN (");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append('-');
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append(") WHEN (");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append("<=A.").append(finalStartTime).append(" AND A.").append(finalStartTime).append("<=A.END_TIME AND A.END_TIME<=");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append(") THEN A.DURATION WHEN (");
        durationCondSqlSql.append(startTimeLong);
        durationCondSqlSql.append("<=A.").append(finalStartTime).append(" AND A.").append(finalStartTime).append("<=");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append(" AND ");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append("<=A.END_TIME) THEN (");
        durationCondSqlSql.append(endTimeLong);
        durationCondSqlSql.append("-A.").append(finalStartTime).append(") END");
        durationCondSqlSql.append(") attackTime ");
        return durationCondSqlSql.toString();
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }

    public String getBisFluxSql(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getBisTopNSelectSql(cds)).append(this.getBisTopNPreTableName()).append(this.getTopNSuffixTableName(cds)).append(this.getBisTopNcondSql(cds, condition));
        return sql.toString();
    }

    private String getBisTopNSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        int statType = cds.getAppType();
        if (statType == 2) {
            selectSql.append("select ZONE_ID,BIZ_ID,sum(TOTAL_PPS) TOTAL_PPS,sum(TOTAL_KBPS) TOTAL_KBPS from ");
        } else if (statType == 1) {
            selectSql.append("select t1.LOG_TIME, t1.ZONE_ID, t1.BIZ_ID, t1.TOTAL_PPS, t1.TOTAL_KBPS from ");
        } else if (statType == 3) {
            selectSql.append("select ZONE_ID,BIZ_ID,AVG(TOTAL_PPS) TOTAL_PPS,AVG(TOTAL_KBPS) TOTAL_KBPS from ");
        }
        return selectSql.toString();
    }

    private String getBisTopNPreTableName() {
        StringBuffer preTableName = new StringBuffer();
        preTableName.append("ATIC_BIZ_FLOW_SUM");
        return preTableName.toString();
    }

    private String getBisTopNcondSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        long deviceId = cds.getDeviceId();
        long zoneId = cds.getZoneId();
        int unit = cds.getUnit();
        int topn = cds.getTopn();
        int statType = cds.getAppType();
        Integer deviceType = cds.getDevSerType();
        String deviceIp = cds.getDeviceIp();
        StringBuffer condSql = new StringBuffer();
        if (statType == 1) {
            condSql.append(" t1, ");
            if (unit == 0) {
                condSql.append("(select max(TOTAL_KBPS) ");
            } else {
                condSql.append("(select max(TOTAL_PPS) ");
            }
            condSql.append("pps,biz_id From ").append(this.getBisTopNPreTableName()).append(this.getTopNSuffixTableName(cds));
        }
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and DEVICE_IP = ? ");
        condition.put(index++, deviceIp);
        if (null != deviceType) {
            condSql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        if (0L != zoneId) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        condSql.append(" AND BIZ_ID NOT IN (SELECT BIZ_ID FROM atic_default_biz_relation WHERE DEVICE_IP = ? ");
        condition.put(index++, deviceIp);
        if (0L != zoneId) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        condSql.append(" ) ");
        if (statType == 1) {
            condSql.append(" GROUP BY BIZ_ID) t2 where t1.BIZ_ID = t2.BIZ_ID and ");
            if (unit == 0) {
                condSql.append("t1.TOTAL_KBPS");
            } else {
                condSql.append("t1.TOTAL_PPS");
            }
            condSql.append(" = t2.pps");
            condSql.append(" and DEVICE_IP = ? ");
            condition.put(index++, deviceIp);
            if (null != deviceType) {
                condSql.append(" and DEVICE_TYPE = ? ");
                condition.put(index++, deviceType);
            }
            condSql.append(" and t1.LOG_TIME between ? and ? ");
            condition.put(index++, start);
            condition.put(index++, end);
        }
        condSql.append(" group by BIZ_ID");
        condSql.append(unit == 1 ? " order by TOTAL_PPS desc" : " order by TOTAL_KBPS desc");
        condSql.append(" ,BIZ_ID  ");
        if (0L < deviceId) {
            condSql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            condSql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return condSql.toString();
    }

    public String getDnsTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getDnsTopNSelectSql(cds)).append(this.getDnsTopNTableName(cds)).append(this.getDnsTopNcondSql(cds, condition));
        return sql.toString();
    }

    public String getDnsTopNSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        int requestType = cds.getAttackType();
        int statType = cds.getAppType();
        if (requestType == 0 && statType == 0) {
            selectSql.append("select DEVICE_IP,LOG_TIME,DNS_NAME,REQUEST_TYPE,SUM(REQUEST_PPS) REQUEST_PPS,SUM(REQUEST_KBPS) REQUEST_KBPS from ATIC_DNS_TOPN");
        } else if (requestType == 0 && statType == 1) {
            selectSql.append("select DEVICE_IP,LOG_TIME,DNS_NAME,REQUEST_TYPE,AVG(REQUEST_PPS) REQUEST_PPS,AVG(REQUEST_KBPS) REQUEST_KBPS from ATIC_DNS_TOPN");
        } else if (requestType == 1 && statType == 0) {
            selectSql.append("select DEVICE_IP,LOG_TIME,SRC_IP,SUM(REQUEST_PPS) REQUEST_PPS,SUM(REQUEST_KBPS) REQUEST_KBPS from ATIC_SRC_DNS_TOPN");
        } else if (requestType == 1 && statType == 1) {
            selectSql.append("select DEVICE_IP,LOG_TIME,SRC_IP,AVG(REQUEST_PPS) REQUEST_PPS,AVG(REQUEST_KBPS) REQUEST_KBPS from ATIC_SRC_DNS_TOPN");
        }
        return selectSql.toString();
    }

    public String getDnsTopNTableName(DataStatCondition cds) {
        StringBuffer tableName = new StringBuffer();
        Long time = cds.getEndTime() - cds.getStartTime();
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    public String getDnsTopNcondSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        long deviceId = cds.getDeviceId();
        int topn = cds.getTopn();
        int statType = cds.getAppType();
        int requestType = cds.getAttackType();
        StringBuffer condSql = new StringBuffer();
        Map<String, Object> temMap = this.getWhereStr4CurrentTopN(cds);
        String whereStr = null;
        Map conditionMap = null;
        for (Map.Entry<String, Object> entry : temMap.entrySet()) {
            whereStr = entry.getKey();
            Object obj = entry.getValue();
            if (!(obj instanceof Map)) continue;
            conditionMap = (Map)obj;
        }
        if (statType == 0 && requestType == 0) {
            condSql.append(" where LOG_TIME = (select distinct max(LOG_TIME) from ATIC_DNS_TOPN");
            condSql.append(this.getDnsTopNTableName(cds)).append(" where REQUEST_PPS <> 0 and LOG_TIME between ? and ? ").append(whereStr).append(')');
            condition.put(index++, start);
            condition.put(index++, end);
            if (null != conditionMap) {
                for (Map.Entry<String, Object> entry : conditionMap.entrySet()) {
                    condition.put(index++, entry.getValue());
                }
            }
        } else if (statType == 0 && requestType == 1) {
            condSql.append(" where LOG_TIME = (select distinct max(LOG_TIME) from ATIC_SRC_DNS_TOPN");
            condSql.append(this.getDnsTopNTableName(cds)).append(" where REQUEST_PPS <> 0 and LOG_TIME between ? and ? ").append(whereStr).append(')');
            condition.put(index++, start);
            condition.put(index++, end);
            if (null != conditionMap) {
                for (Map.Entry<String, Object> entry : conditionMap.entrySet()) {
                    condition.put(index++, entry.getValue());
                }
            }
        } else {
            condSql.append(" where LOG_TIME between ? and ? ");
            condition.put(index++, start);
            condition.put(index++, end);
        }
        condSql.append(whereStr);
        if (null != conditionMap) {
            for (Map.Entry<String, Object> entry : conditionMap.entrySet()) {
                condition.put(index++, entry.getValue());
            }
        }
        if (requestType == 1) {
            condSql.append(" group by SRC_IP");
        } else if (requestType == 0) {
            condSql.append(" group by BINARY DNS_NAME");
            List<String> dnsType = cds.getRequestTrendType();
            if (null != dnsType && !dnsType.isEmpty()) {
                condSql.append(" ,REQUEST_TYPE");
            }
        }
        condSql.append(" order by REQUEST_PPS desc");
        if (0L < deviceId) {
            condSql.append(" LIMIT 0, ?");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            condSql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return condSql.toString();
    }

    private Map<String, Object> getWhereStr4CurrentTopN(DataStatCondition cds) {
        List<String> dnsType;
        int index = 1;
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        long zoneId = cds.getZoneId();
        Integer deviceType = cds.getDevSerType();
        int requestType = cds.getAttackType();
        StringBuffer condSql = new StringBuffer();
        if (null != deviceType) {
            condSql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        if (0L != zoneId) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (requestType == 0 && null != (dnsType = cds.getRequestTrendType()) && !dnsType.isEmpty()) {
            StringBuffer dnsTypeStr = new StringBuffer();
            for (String temp : dnsType) {
                dnsTypeStr.append(" ? ,");
                condition.put(index++, temp);
            }
            dnsTypeStr = new StringBuffer(dnsTypeStr.substring(0, dnsTypeStr.length() - 1));
            condSql.append(" and REQUEST_TYPE in (").append(dnsTypeStr).append(')');
        }
        condSql.append(" and TOPN_TYPE = ? ");
        condition.put(index++, cds.getTopnType());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(condSql.toString(), condition);
        return map;
    }

    public String getDnsGraphSql(DataStatCondition cds, DnsTopN dnsTopN, Map<Integer, Object> condition) {
        List<String> dnsType;
        int index = 1;
        StringBuffer sql = new StringBuffer();
        String tableName = "";
        int requestType = cds.getAttackType();
        if (requestType == 0) {
            sql.append("select DEVICE_IP,LOG_TIME,DEVICE_IP,DNS_NAME,REQUEST_TYPE,SUM(REQUEST_PPS) as REQUEST_PPS,SUM(REQUEST_KBPS) as REQUEST_KBPS from ");
            tableName = "ATIC_DNS_TOPN";
        } else if (requestType == 1) {
            sql.append("select DEVICE_IP,LOG_TIME,DEVICE_IP,SRC_IP,SUM(REQUEST_PPS) as REQUEST_PPS,SUM(REQUEST_KBPS) as REQUEST_KBPS from ");
            tableName = "ATIC_SRC_DNS_TOPN";
        }
        Long time = cds.getEndTime() - cds.getStartTime();
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_H";
        } else if (this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_D";
        }
        sql.append(tableName);
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        sql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        if (requestType == 0) {
            sql.append(" and BINARY DNS_NAME = ? ");
            condition.put(index++, dnsTopN.getDnsName());
            if (!CommonUtil.isNull(dnsTopN.getRequestType())) {
                sql.append(" and REQUEST_TYPE = ? ");
                condition.put(index++, dnsTopN.getRequestType());
            }
        } else if (requestType == 1) {
            sql.append(" and SRC_IP = ? ");
            condition.put(index++, dnsTopN.getSrcIp());
        }
        sql.append(" and TOPN_TYPE =  ? ");
        condition.put(index++, cds.getTopnType());
        if (cds.getDevSerType() != null) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, cds.getDevSerType());
        }
        sql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        if (0L != cds.getZoneId()) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (requestType == 0 && null != (dnsType = cds.getRequestTrendType()) && !dnsType.isEmpty()) {
            StringBuffer dnsTypeStr = new StringBuffer();
            for (String temp : dnsType) {
                dnsTypeStr.append(" ? ,");
                condition.put(index++, temp);
            }
            dnsTypeStr = new StringBuffer(dnsTypeStr.substring(0, dnsTypeStr.length() - 1));
            sql.append(" and REQUEST_TYPE in (").append(dnsTypeStr).append(')');
        }
        sql.append(" group by LOG_TIME");
        if (requestType == 0 && null != (dnsType = cds.getRequestTrendType()) && !dnsType.isEmpty()) {
            sql.append(" ,REQUEST_TYPE");
        }
        return sql.toString();
    }

    public String getDnsCacheSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        String tableName = "ATIC_STATIC_DNS_CACHE";
        Long time = cds.getEndTime() - cds.getStartTime();
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_H";
        } else if (this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_D";
        }
        Integer deviceType = cds.getDevSerType();
        sql.append("select LOG_TIME,DEVICE_IP,ZONE_ID,BIZ_ID,DNS_ID,DNS_NAME,REQUEST_TYPE,REQUEST_PPS from ");
        sql.append(tableName);
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        sql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        long zoneId = cds.getZoneId();
        String deviceIp = cds.getDeviceIp();
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, deviceIp);
        if (null != deviceType) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, sql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        List<String> dnsType = cds.getRequestTrendType();
        if (null != dnsType && !dnsType.isEmpty()) {
            StringBuffer dnsTypeStr = new StringBuffer();
            for (String temp : dnsType) {
                dnsTypeStr.append(" ? ,");
                condition.put(index++, temp);
            }
            dnsTypeStr = new StringBuffer(dnsTypeStr.substring(0, dnsTypeStr.length() - 1));
            sql.append(" and REQUEST_TYPE in (").append(dnsTypeStr).append(')');
        }
        return sql.toString();
    }

    private String getIPTopNSonSelect(DataStatCondition cds, Map<Integer, Object> condition, int index, String tableName) {
        StringBuffer condSql = new StringBuffer();
        int unitType = cds.getUnit();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        StringBuffer controlCol = new StringBuffer();
        if (unitType == 1) {
            controlCol.append(selectTopnCol);
            controlCol.append("_PPS");
        } else {
            controlCol.append(selectTopnCol);
            controlCol.append("_KBPS");
        }
        condSql.append(" WHERE LOG_TIME BETWEEN ? AND ? ");
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        boolean columnExist = DBStat.checkColumnExist("DIRECTION", tableName);
        if (columnExist) {
            condSql.append(" AND DIRECTION = ? ");
            condition.put(index++, cds.getDirection());
        }
        condSql.append(" AND DEVICE_IP = ? AND DEVICE_TYPE = ? AND ").append(controlCol).append(" > 0 ").append(" GROUP BY ZONE_IP, ZONE_ID ORDER BY ").append(controlCol).append(" DESC, ZONE_IP, ZONE_ID LIMIT 0, ? ");
        condition.put(index++, cds.getDeviceIp());
        condition.put(index++, cds.getDevSerType());
        condition.put(index++, cds.getTopn());
        return condSql.toString();
    }

    private String getZoneTopNSonSelect(DataStatCondition cds, Map<Integer, Object> condition, int index, String tableName) {
        StringBuffer condSql = new StringBuffer();
        int unitType = cds.getUnit();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        StringBuffer controlCol = new StringBuffer();
        if (unitType == 1) {
            controlCol.append(selectTopnCol);
            controlCol.append("_PPS");
        } else {
            controlCol.append(selectTopnCol);
            controlCol.append("_KBPS");
        }
        condSql.append(" WHERE LOG_TIME BETWEEN ? AND ? ");
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        boolean columnExist = DBStat.checkColumnExist("DIRECTION", tableName);
        if (columnExist) {
            condSql.append(" AND DIRECTION = ? ");
            condition.put(index++, cds.getDirection());
        }
        condSql.append(" AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND ").append(controlCol).append(" > 0 GROUP BY ZONE_ID ORDER BY ").append(controlCol).append(" DESC, ZONE_ID LIMIT 0, ?");
        condition.put(index++, cds.getDevSerType());
        condition.put(index++, cds.getDeviceIp());
        condition.put(index++, cds.getTopn());
        return condSql.toString();
    }

    public String getIpFluxSql(DataStatCondition cds, Map<Integer, Object> condition, String tableName) {
        StringBuffer sql = new StringBuffer();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        StringBuffer controlCol = new StringBuffer("");
        if (null != cds.getUnit() && cds.getUnit() == 1) {
            controlCol.append(selectTopnCol);
            controlCol.append("_PPS");
        } else {
            controlCol.append(selectTopnCol);
            controlCol.append("_KBPS");
        }
        boolean columnExist = DBStat.checkColumnExist("DIRECTION", tableName);
        String directionColumn = columnExist ? " DIRECTION " : " 1 as DIRECTION ";
        sql.append(this.getIpTopNSelectSql(cds)).append(" ( SELECT LOG_TIME, ZONE_ID, ZONE_IP, ").append(selectTopnCol).append("_PPS, ").append(selectTopnCol).append("_KBPS,").append(directionColumn).append(", DEVICE_TYPE, DEVICE_IP FROM ").append(tableName).append(" WHERE LOG_TIME BETWEEN ? AND ? ");
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        condition.put(index++, start);
        condition.put(index++, end);
        if (columnExist) {
            sql.append("AND DIRECTION = ? ");
            condition.put(index++, cds.getDirection());
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DEVICE_IP = ? AND ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(controlCol).append(" > 0 ");
        long zoneId = cds.getZoneId();
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" ORDER BY ").append(controlCol).append(" DESC ) AS ").append(tableName).append(this.getIPTopNSonSelect(cds, condition, index, tableName));
        return sql.toString();
    }

    public String getZoneFluxSql(DataStatCondition cds, Map<Integer, Object> condition, String tableName) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        StringBuffer controlCol = new StringBuffer(selectTopnCol);
        if (null != cds.getUnit() && cds.getUnit() == 1) {
            controlCol.append("_PPS");
        } else {
            controlCol.append("_KBPS");
        }
        boolean columnExist = DBStat.checkColumnExist("DIRECTION", tableName);
        String directionColumn = columnExist ? " DIRECTION " : " 1 as DIRECTION ";
        sql.append(this.getZoneTopNSelectSql(cds)).append(" ( SELECT LOG_TIME, ZONE_ID, ").append(selectTopnCol).append("_PPS, ").append(selectTopnCol).append("_KBPS,").append(directionColumn).append(",DEVICE_TYPE, DEVICE_IP FROM ").append(tableName).append(" WHERE ").append(" LOG_TIME BETWEEN ? AND ?");
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        if (columnExist) {
            sql.append(" AND DIRECTION = ? ");
            condition.put(index++, cds.getDirection());
        }
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND ").append(controlCol).append(" > 0 ");
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" ORDER BY ").append(controlCol).append(" DESC LIMIT 100000000000) AS ").append(tableName).append(this.getZoneTopNSonSelect(cds, condition, index, tableName));
        return sql.toString();
    }

    private String getZoneTopNSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        int statType = cds.getAppType();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        boolean iskbps = true;
        iskbps = null == cds.getUnit() || cds.getUnit() != 1;
        if (statType == 1) {
            selectSql.append("select LOG_TIME, ZONE_ID, ").append(selectTopnCol + (iskbps ? "_PPS" : "_KBPS")).append(" AS " + (iskbps ? "TOTAL_PPS" : "TOTAL_KBPS") + ", MAX(").append(selectTopnCol + (iskbps ? "_KBPS" : "_PPS")).append(") AS " + (iskbps ? "TOTAL_KBPS" : "TOTAL_PPS")).append(" FROM ");
        }
        return selectSql.toString();
    }

    public String getZoneTopNTableName(DataStatCondition cds) {
        StringBuffer tableName = new StringBuffer("ATIC_ZONE_FLOW_SUM");
        int type = cds.getAttackType();
        Long time = cds.getEndTime() - cds.getStartTime();
        if (type == 2) {
            tableName.append("_DROP");
        } else if (type == 3) {
            tableName.append("_FORWARD");
        }
        if (cds.getAppType() == 1) {
            tableName.append("_MAX");
        }
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    private String getZoneTopNcondSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        int topn = cds.getTopn();
        StringBuffer condSql = new StringBuffer();
        int unitType = cds.getUnit();
        StringBuffer controlCol = new StringBuffer();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        if (unitType == 1) {
            controlCol.append(selectTopnCol);
            controlCol.append("_PPS");
        } else {
            controlCol.append(selectTopnCol);
            controlCol.append("_KBPS");
        }
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" and DEVICE_IP = ? and ");
        condition.put(index++, cds.getDeviceIp());
        condSql.append(controlCol.toString());
        condSql.append(" > 0 ");
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        condSql.append(" group by ZONE_ID");
        condSql.append(" order by ");
        condSql.append(controlCol.toString());
        condSql.append(" desc, ZONE_ID ");
        condSql.append(" LIMIT 0, ? )");
        condition.put(index++, topn);
        condSql.append(" as b on  a.ZONE_ID = b.ZONE_ID AND a.");
        condSql.append(controlCol.toString());
        condSql.append(" = b.");
        condSql.append(controlCol.toString());
        condSql.append(" group by a.ZONE_ID");
        return condSql.toString();
    }

    public String getZoneFluxMaxSql(DataStatCondition cds, ZoneTopN zoneTopn, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getZoneTopNMaxSelectSql(cds)).append(this.getZoneTopNTableName(cds)).append(this.getZoneTopNMaxcondSql(cds, zoneTopn, condition));
        return sql.toString();
    }

    private String getZoneTopNMaxSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        selectSql.append("select LOG_TIME,DEVICE_IP,ZONE_ID,").append(selectTopnCol).append("_PPS TOTAL_PPS,").append(selectTopnCol).append("_KBPS TOTAL_KBPS from ");
        return selectSql.toString();
    }

    private String getZoneTopNMaxcondSql(DataStatCondition cds, ZoneTopN zoneTopn, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME = ? ");
        condition.put(index++, zoneTopn.getLogTime());
        condSql.append(" and DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        long deviceType = cds.getDevSerType().intValue();
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, deviceType);
        if (cds.getDeviceId() > 0L) {
            condSql.append(" and DEVICE_IP = ? ");
            condition.put(index++, cds.getDeviceIp());
        }
        if (0L != zoneTopn.getZoneId()) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneTopn.getZoneId());
        }
        return condSql.toString();
    }

    private String getTopNColName(int protocol) {
        if (1 == protocol) {
            return "TCP";
        }
        if (2 == protocol) {
            return "UDP";
        }
        if (3 == protocol) {
            return "ICMP";
        }
        if (4 == protocol) {
            return "OTHER";
        }
        return "TOTAL";
    }

    private String getIpTopNSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        int statType = cds.getAppType();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        boolean iskbps = true;
        iskbps = null == cds.getUnit() || cds.getUnit() != 1;
        if (statType == 1) {
            selectSql.append("select LOG_TIME, ZONE_ID, ZONE_IP, ").append(selectTopnCol + (iskbps ? "_PPS" : "_KBPS")).append(" AS " + (iskbps ? "TOTAL_PPS" : "TOTAL_KBPS") + ", MAX(").append(selectTopnCol + (iskbps ? "_KBPS" : "_PPS")).append(") AS " + (iskbps ? "TOTAL_KBPS" : "TOTAL_PPS")).append(" FROM ");
        }
        return selectSql.toString();
    }

    public String getIpTopNPreTableName(DataStatCondition cds) {
        StringBuffer preTableName = new StringBuffer();
        preTableName.append("ATIC_IP_FLOW_SUM");
        return preTableName.toString();
    }

    private String getIpTopNcondSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        long zoneId = cds.getZoneId();
        String deviceIp = cds.getDeviceIp();
        long deviceType = cds.getDevSerType().intValue();
        StringBuffer condSql = new StringBuffer();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        int unitType = cds.getUnit();
        StringBuffer controlCol = new StringBuffer();
        if (unitType == 1) {
            controlCol.append(selectTopnCol);
            controlCol.append("_PPS");
        } else {
            controlCol.append(selectTopnCol);
            controlCol.append("_KBPS");
        }
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        condSql.append(" and DEVICE_IP = ? ");
        condition.put(index++, deviceIp);
        condSql.append(" and DEVICE_TYPE = ? and ");
        condition.put(index++, deviceType);
        condSql.append(controlCol.toString());
        condSql.append(" > 0 ");
        if (0L != zoneId) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        condSql.append(" group by ZONE_IP,ZONE_ID");
        condSql.append(" order by ");
        condSql.append(controlCol.toString());
        condSql.append(" desc, ZONE_IP,ZONE_ID ");
        int topn = cds.getTopn();
        condSql.append(" LIMIT 0, ? )");
        condition.put(index++, topn);
        condSql.append(" as b on a.ZONE_ID = b.ZONE_ID AND a.ZONE_IP = b.ZONE_IP AND a.");
        condSql.append(controlCol.toString());
        condSql.append(" = b.");
        condSql.append(controlCol.toString());
        condSql.append(" group by a.ZONE_ID,a.ZONE_IP");
        return condSql.toString();
    }

    public String getTopNSuffixTableName(DataStatCondition cds) {
        StringBuffer suffixTableName = new StringBuffer();
        int type = cds.getAttackType();
        Long time = cds.getEndTime() - cds.getStartTime();
        String bisType = cds.getBisType();
        if (type == 2) {
            suffixTableName.append("_DROP");
        }
        if (type == 3) {
            suffixTableName.append("_FORWARD");
        }
        if (cds.getAppType() == 1 && !"DEFAULT".equals(bisType)) {
            suffixTableName.append("_MAX");
        }
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            suffixTableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            suffixTableName.append("_D");
        }
        return suffixTableName.toString();
    }

    public String getIpFluxMaxSql(DataStatCondition cds, IpTopN iptopn, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getIpTopNMaxSelectSql(cds)).append(this.getIpTopNPreTableName(cds)).append(this.getTopNSuffixTableName(cds)).append(this.getIpTopNMaxcondSql(cds, iptopn, condition));
        return sql.toString();
    }

    private String getIpTopNMaxSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        String selectTopnCol = this.getTopNColName(cds.getProtocol());
        selectSql.append("select LOG_TIME,DEVICE_IP,ZONE_ID,ZONE_IP,").append(selectTopnCol).append("_PPS TOTAL_PPS,").append(selectTopnCol).append("_KBPS TOTAL_KBPS from ");
        return selectSql.toString();
    }

    private String getIpTopNMaxcondSql(DataStatCondition cds, IpTopN iptopn, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME = ? ");
        condition.put(index++, iptopn.getLogTime());
        Long bisId = cds.getBisId();
        if (null != bisId && bisId == 0L) {
            condSql.append(" and DIRECTION = ? ");
            condition.put(index++, cds.getDirection());
        }
        long deviceType = cds.getDevSerType().intValue();
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, deviceType);
        if (cds.getDeviceId() > 0L) {
            condSql.append(" and DEVICE_IP = ? ");
            condition.put(index++, cds.getDeviceIp());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithType(cds, this.getIpTopNPreTableName(cds) + this.getTopNSuffixTableName(cds), condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        if (0L != iptopn.getZoneId()) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, iptopn.getZoneId());
        }
        if (!CommonUtil.isNull(iptopn.getZoneIp()) && !"0".equals(iptopn.getZoneIp())) {
            condSql.append(" and ZONE_IP = ? ");
            condition.put(index++, iptopn.getZoneIp());
        }
        return condSql.toString();
    }

    public String getBisFluxMaxSql(DataStatCondition cds, BisTopN bistopn, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getBisTopNMaxSelectSql()).append(this.getBisTopNPreTableName()).append(this.getTopNSuffixTableName(cds)).append(this.getBisTopNMaxcondSql(cds, bistopn, condition));
        return sql.toString();
    }

    private String getBisTopNMaxSelectSql() {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select LOG_TIME,DEVICE_IP,ZONE_ID,BIZ_ID,TOTAL_PPS TOTAL_PPS,TOTAL_KBPS TOTAL_KBPS from ");
        return selectSql.toString();
    }

    private String getBisTopNMaxcondSql(DataStatCondition cds, BisTopN bistopn, Map<Integer, Object> condition) {
        int index = 1;
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME = ? ");
        condition.put(index++, bistopn.getLogTime());
        long deviceType = cds.getDevSerType().intValue();
        int direction = cds.getDirection();
        condSql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, deviceType);
        condSql.append(" and DIRECTION = ? ");
        condition.put(index++, direction);
        if (cds.getDeviceId() > 0L) {
            condSql.append(" and DEVICE_IP = ? ");
            condition.put(index++, cds.getDeviceIp());
        }
        if (0L != bistopn.getZoneId()) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, bistopn.getZoneId());
        }
        if (0L != bistopn.getBisId()) {
            condSql.append(" and BIZ_ID = ? ");
            condition.put(index++, bistopn.getBisId());
        }
        return condSql.toString();
    }

    public String getIpLocationTopNTableSql(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getIpLocationTopNTableSelectSql(cds)).append(this.getIpLocationTopNTableName(cds)).append(this.getIpLocationTopNTableCondSql(cds, condition));
        return sql.toString();
    }

    public String getIpLocationTopNTableSelectSql(DataStatCondition cds) {
        StringBuffer selectSql = new StringBuffer();
        int unit = cds.getUnit();
        String columeStr = "TOTAL_PPS";
        if (unit == 0) {
            columeStr = "TOTAL_KBPS";
        }
        selectSql.append("select DEVICE_IP,LOCATION_ID,AVG(").append(columeStr).append(") flowValue from ");
        return selectSql.toString();
    }

    public String getIpLocationTopNTableName(DataStatCondition cds) {
        Long time;
        StringBuffer tableName = new StringBuffer("atic_location_flow_sum");
        int type = cds.getAttackType();
        if (type == 2) {
            tableName.append("_DROP");
        }
        if (this.isMoreThanDay(time = Long.valueOf(cds.getEndTime() - cds.getStartTime()), 1) && !this.isMoreThanDay(time, 7)) {
            tableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    public String getIpLocationTopNTableCondSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        long deviceId = cds.getDeviceId();
        long zoneId = cds.getZoneId();
        Integer deviceType = cds.getDevSerType();
        int topn = cds.getTopn();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        if (null != deviceType) {
            condSql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        String statisticalDimension = cds.getStatisticalDimension();
        if (null != cds.getStatisticalDimension() && !"-1".equals(cds.getStatisticalDimension())) {
            condSql.append(" AND CASE WHEN ? = '0' THEN (LOCATION_ID <= 512 OR LOCATION_ID >= 3000) WHEN ? = '1' THEN LOCATION_ID > 512 AND LOCATION_ID < 3000 END ");
            condition.put(index++, statisticalDimension);
            condition.put(index++, statisticalDimension);
        }
        if (0L != zoneId) {
            condSql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        condSql.append(" GROUP BY LOCATION_ID");
        condSql.append(" order by flowValue desc");
        if (0L < deviceId) {
            condSql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            condSql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return condSql.toString();
    }

    public String getIpLocationGraphSql(DataStatCondition cds, IpLocationTopN ipLocationTopN, Map<Integer, Object> condition) {
        long zoneId;
        int index = 1;
        int deviceType = cds.getDevSerType();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        String tableSum = "atic_location_flow_sum";
        String tableDrop = "atic_location_flow_sum_drop";
        Long time = cds.getEndTime() - cds.getStartTime();
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableSum = tableSum + "_H";
            tableDrop = tableDrop + "_H";
        } else if (this.isMoreThanDay(time, 7)) {
            tableSum = tableSum + "_D";
            tableDrop = tableDrop + "_D";
        }
        StringBuffer sql = new StringBuffer();
        int unit = cds.getUnit();
        String columeStr = "TOTAL_PPS";
        if (unit == 0) {
            columeStr = "TOTAL_KBPS";
        }
        sql.append("select a.LOG_TIME, a.DEVICE_IP, a.LOCATION_ID, SUM(a.").append(columeStr).append(") inFlow, ").append("SUM(b." + columeStr).append(") attackFlow from " + tableSum).append(" as a LEFT OUTER JOIN " + tableDrop).append(" as b on a.LOG_TIME = b.LOG_TIME and a.LOCATION_ID = b.LOCATION_ID ");
        if (null != cds.getDevSerType()) {
            sql.append(" and a.DEVICE_TYPE = b.DEVICE_TYPE and a.DEVICE_IP = b.DEVICE_IP ");
        }
        if (0L != (zoneId = cds.getZoneId().longValue())) {
            sql.append(" and a.ZONE_ID = b.ZONE_ID ");
        }
        sql.append(" where a.LOG_TIME >= ? ").append(" and a.LOG_TIME <= ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        if (null != cds.getDevSerType()) {
            sql.append(" and a.DEVICE_TYPE =  ? ");
            condition.put(index++, deviceType);
        }
        sql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpLocationSql(cds, sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        sql.append(" and a.LOCATION_ID = ? ");
        condition.put(index++, ipLocationTopN.getIpLocationId());
        if (0L == zoneId && null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and a.ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
            sql.append(" and b.ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY a.LOG_TIME, a.LOCATION_ID");
        return sql.toString();
    }

    public String getIpLocationTopNGraphSql(DataStatCondition cds, IpLocationTopN ipLocationTopN, Map<Integer, Object> condition) {
        Long time;
        int index = 1;
        int deviceType = cds.getDevSerType();
        Long end = cds.getEndTime();
        long zoneId = cds.getZoneId();
        String tableName = "atic_location_flow_sum";
        int type = cds.getAttackType();
        if (type == 2) {
            tableName = tableName + "_DROP";
        }
        if (this.isMoreThanDay(time = Long.valueOf(cds.getEndTime() - cds.getStartTime()), 1) && !this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_H";
        } else if (this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_D";
        }
        StringBuffer sql = new StringBuffer();
        int unit = cds.getUnit();
        String columeStr = "TOTAL_PPS";
        if (unit == 0) {
            columeStr = "TOTAL_KBPS";
        }
        Long start = cds.getStartTime();
        sql.append("select LOG_TIME,DEVICE_IP,LOCATION_ID,SUM(").append(columeStr).append(") flowValue from " + tableName);
        sql.append(" where LOG_TIME >= ? ").append(" and LOG_TIME <= ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        if (null != cds.getDevSerType()) {
            sql.append(" and DEVICE_TYPE =  ? ");
            condition.put(index++, deviceType);
        }
        sql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        sql.append(" and LOCATION_ID = ? ");
        condition.put(index++, ipLocationTopN.getIpLocationId());
        if (0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY LOG_TIME, LOCATION_ID");
        return sql.toString();
    }

    public String getIpAttackFlowPeakTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        String tableName = "atic_ip_attack_log";
        String dataStartTimeColName = "START_TIME_ALERT";
        String dropPps = "";
        dropPps = cds.getDevSerType() == 1 ? (cds.getUnit() == 1 ? "IP_MAX_IN_PPS" : "IP_MAX_IN_KBPS") : (cds.getUnit() == 1 ? "IP_MAX_DROP_PPS" : "IP_MAX_DROP_KBPS");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP,zone_Id,ZONE_IP," + dataStartTimeColName + " START_TIME,END_TIME, MAX(" + dropPps + ") DROP_FLOW_PEAK");
        sql.append(" FROM " + tableName + " A WHERE");
        sql.append(" END_TIME >= ? ");
        condition.put(index++, start);
        sql.append(" AND START_TIME_ALERT <= ? ");
        condition.put(index++, end);
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> temList = commomSqlUtil.processServiceSqlWithNoType(cds, "A", sql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        if (!CommonUtil.isNull(zoneIp) && !"0".equals(zoneIp)) {
            sql.append(" and ZONE_IP = ? ");
            condition.put(index++, zoneIp);
        }
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        if (null != cds.getDevSerType()) {
            sql.append(" AND DEVICE_TYPE = ? ");
            condition.put(index++, cds.getDevSerType());
        }
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (CollectorVersionRepository.getInstance().isNeedDrop()) {
            sql.append(" AND BIZ_ID <>0 AND ZONE_IP <>0");
        } else {
            sql.append("  AND ZONE_IP <>0 ");
        }
        sql.append(" GROUP BY ZONE_IP,ZONE_ID ORDER BY ").append(dropPps).append(" DESC");
        int topn = cds.getTopn();
        sql.append(" LIMIT 0, ? ");
        condition.put(index++, topn);
        return sql.toString();
    }

    public String getZoneAttackFlowPeakTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long zoneId = cds.getZoneId();
        String dropPps = "";
        dropPps = cds.getDevSerType() == 1 ? (cds.getUnit() == 1 ? "IP_MAX_IN_PPS" : "IP_MAX_IN_KBPS") : (cds.getUnit() == 1 ? "IP_MAX_DROP_PPS" : "IP_MAX_DROP_KBPS");
        String tableName = "atic_zone_attack_log";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DEVICE_IP, ZONE_ID, MAX(").append(dropPps).append(") DROP_PEAK");
        sql.append(" FROM " + tableName);
        sql.append(" WHERE END_TIME >= ? ");
        condition.put(index++, cds.getStartTime());
        sql.append(" AND START_TIME <= ? ");
        condition.put(index++, cds.getEndTime());
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        sql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (null != zoneId && 0L != zoneId) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        sql.append(" GROUP BY DEVICE_IP,ZONE_ID ORDER BY DROP_PEAK DESC ");
        if (0L < cds.getDeviceId()) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, cds.getTopn());
        } else {
            int topN = CommomSqlUtil.getTopNNum(cds.getTopn());
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        return sql.toString();
    }

    private String queryZoneFlowSumDropMaxTable(Integer devSerType, Integer timeSpanType) {
        String tableName = "";
        tableName = devSerType == 1 ? (0 == timeSpanType ? "atic_zone_flow_sum_max" : (1 == timeSpanType ? "atic_zone_flow_sum_max_h" : "atic_zone_flow_sum_max_d")) : (0 == timeSpanType ? "atic_zone_flow_sum_drop_max" : (1 == timeSpanType ? "atic_zone_flow_sum_drop_max_h" : "atic_zone_flow_sum_drop_max_d"));
        return tableName;
    }

    public String ipAattackEventSql(String deviceIp, DataStatCondition cds, Map<Integer, Object> map) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        sql.append("select DIRECTION, DEVICE_IP, DEVICE_TYPE ,ZONE_ID, ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,ATTACK_STATUS, ATTACK_TYPE, DURATION,PORTS,IP_MAX_DROP_KBPS,IP_MAX_DROP_PPS from atic_ip_attack_exact_log where 1=1 ");
        sql.append(" and DIRECTION =  ? ");
        map.put(index++, cds.getDirection());
        sql.append(" and DEVICE_IP =  ? ");
        map.put(index++, deviceIp);
        sql.append(" and DEVICE_TYPE =  ? ");
        map.put(index++, cds.getDevSerType());
        if (null != cds.getZoneId()) {
            sql.append(" and zone_id = ? ");
            map.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            map.put(index++, cds.getSessionId());
        }
        sql.append(" order by START_TIME_ATTACK DESC limit 0,").append(cds.getTopn());
        return sql.toString();
    }
}

