/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.conn;

import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.HeartBeatService;
import org.apache.log4j.Logger;

public final class ConnectionRmiThread
extends Thread {
    private static ConnectionRmiThread instance = new ConnectionRmiThread();
    private static final String SERVICE_NAME = "HeartBeatService";
    private static final long TIME_INTERVAL = 60000L;
    private static final String RETURN_STR = "hello";
    private HeartBeatService heartBeatService;
    private Logger logger = LogManager.getInstance().getRMILog();
    private Boolean rmiConnected = false;

    private ConnectionRmiThread() {
    }

    public static ConnectionRmiThread getInstance() {
        if (null == instance) {
            instance = new ConnectionRmiThread();
        }
        return instance;
    }

    public Boolean getRmiConnection() {
        return this.rmiConnected;
    }

    @Override
    public void run() {
        while (true) {
            try {
                if (this.heartBeatService == null) {
                    this.heartBeatService = (HeartBeatService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("SERVICE_NAME is" + this.heartBeatService));
                    }
                }
                if (null == this.heartBeatService) {
                    this.rmiConnected = false;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"RMI CONNECTION false!!");
                    }
                } else {
                    String backStr = this.heartBeatService.sayHello();
                    this.rmiConnected = null != backStr && backStr.equals(RETURN_STR) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"RMI CONNECTION true!!");
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("RMI CONNECTION false!!" + e.getMessage()));
                this.rmiConnected = false;
                this.heartBeatService = null;
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("Thread.sleep InterruptedException! " + e.getMessage()));
                continue;
            }
            break;
        }
    }
}

