/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public final class DbWriteTool {
    private static DbWriteTool instance = new DbWriteTool();
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final int MAX_RANDOM = Integer.MAX_VALUE;
    private SecureRandom random = new SecureRandom();

    private DbWriteTool() {
    }

    public static DbWriteTool getInstance() {
        return instance;
    }

    public void writeToDb(String tableName, String[] lines) {
        String absolutePath = null;
        try {
            absolutePath = EventUtil.EVENT_FILE_DIRECTORY + File.separator + tableName + '-' + this.random.nextInt(Integer.MAX_VALUE);
            this.write2TempFile(absolutePath, lines);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"when write to file ,error happend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2TempFile(String absolutePath, String[] values) {
        File file = new File(absolutePath + ".part");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            for (int i = 0; i < values.length; ++i) {
                stream.write(values[i].getBytes("utf-8"));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"stream.write");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("stream.write " + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)"stream.write");
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"stream.close() IOException");
            }
        }
        if (!file.renameTo(new File(absolutePath + ".txt"))) {
            LOGGER.error((Object)"file rename in error");
        }
    }
}

