/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.DefaultBizMappingEntity;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultBizMappingRepository {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMap2Db(Map<DefaultBizMappingEntity, Long> map) {
        block10: {
            String delSql = "delete from  ATIC_DEFAULT_BIZ_RELATION ";
            Connection conn = DBConnPool.getConnection();
            PreparedStatement stmt = null;
            if (conn == null) break block10;
            try {
                conn.setAutoCommit(false);
                stmt = conn.prepareStatement(delSql);
                stmt.execute();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"delSql Exception");
                }
                catch (Throwable throwable) {
                    CommonUtil.free(null, stmt);
                    throw throwable;
                }
                CommonUtil.free(null, stmt);
            }
            CommonUtil.free(null, stmt);
            try {
                String insertSql = "insert into ATIC_DEFAULT_BIZ_RELATION values(?,?,?,?)";
                stmt = conn.prepareStatement(insertSql);
                for (Map.Entry<DefaultBizMappingEntity, Long> entry : map.entrySet()) {
                    String devIp = entry.getKey().getDeviceIp();
                    long zoneId = entry.getKey().getZoneId();
                    long bizId = entry.getValue();
                    stmt.setString(1, devIp);
                    stmt.setInt(2, entry.getKey().getDirection());
                    stmt.setLong(3, zoneId);
                    stmt.setLong(4, bizId);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"insertsql Exception");
            }
            finally {
                CommonUtil.free(conn, stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefaultBizMappingEntity, Long> initCache() {
        String sql = "select t.DEVICE_IP,t.ZONE_ID,t.DIRECTION,t.BIZ_ID from ATIC_DEFAULT_BIZ_RELATION t";
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<DefaultBizMappingEntity, Long> devBizCache = new HashMap<DefaultBizMappingEntity, Long>();
        if (conn != null) {
            try {
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DefaultBizMappingEntity entry = new DefaultBizMappingEntity(rs.getString(1), rs.getLong(2), rs.getInt(3));
                    entry.setBizId(rs.getLong(4));
                    devBizCache.put(entry, rs.getLong(4));
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"initCache Exception");
                }
                catch (Throwable throwable) {
                    CommonUtil.free(conn, stmt, rs);
                    throw throwable;
                }
                CommonUtil.free(conn, stmt, rs);
            }
            CommonUtil.free(conn, stmt, rs);
        }
        return devBizCache;
    }
}

