/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.DbFileLoader;
import com.hs.atic.collector.db.DbFileTask;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultDbFileLoader
implements DbFileLoader,
Runnable {
    public static final String SEPARATOR = ";";
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private Connection con;
    private Set<DbFileTask> tasks = new HashSet<DbFileTask>();

    public DefaultDbFileLoader() {
        this.con = DBConnPool.getConnection();
    }

    public Connection getConnection() {
        return this.con;
    }

    public void setConnection(Connection cons) {
        this.con = cons;
    }

    public String mySqlFormat(String absolutePath) {
        String directory = "'" + absolutePath.replace("\\", "\\\\") + "'";
        return directory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized Set<DbFileTask> getTasks() {
        Set<DbFileTask> copy = this.tasks;
        this.tasks = new HashSet<DbFileTask>();
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void import2Db(File file, String tableName) {
        String filePath = null;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)"getCanonicalPath() throws IOException");
        }
        if (null == filePath || "".equals(filePath)) {
            LOGGER.error((Object)"filePath is wrong");
            return;
        }
        String sql = "load data concurrent local infile " + this.mySqlFormat(filePath) + "  into table  " + tableName + " FIELDS  TERMINATED BY '" + SEPARATOR + "';";
        Statement stmt = null;
        try {
            if (null != this.con) {
                stmt = this.con.prepareStatement(sql);
                stmt.execute();
                boolean delete = file.delete();
                if (delete) {
                    LOGGER.info((Object)("delete temp file ok ,file name is : " + file.getName()));
                } else {
                    LOGGER.info((Object)("delete temp file fail ,file name is : " + file.getName()));
                }
                LOGGER.info((Object)" write  db success ");
            }
        }
        catch (Exception e) {
            this.resetConnection();
            int retryTime = 1800000;
            if (System.currentTimeMillis() - file.lastModified() > (long)retryTime) {
                LOGGER.error((Object)("when import file 2 db,error happend,fileName is :" + file.getName()));
                try {
                    String errorPath = EventUtil.ERROR_EVENT_FILE_DIRECTORY + File.separator + file.getName();
                    File tempFile = new File(errorPath);
                    if (!file.renameTo(tempFile)) {
                        if (!file.delete()) {
                            LOGGER.error((Object)"I delete file in error");
                        }
                        LOGGER.error((Object)("I del file : " + file.getName()));
                    }
                }
                catch (RuntimeException e1) {
                    LOGGER.error((Object)("rename file error ,filename is:" + file.getName()));
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                LOGGER.error((Object)("import2Db thread sleep InterruptedException error. " + e1.getMessage()));
            }
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"close stmt error");
                }
            }
        }
    }

    private void resetConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)("unkonw error! " + e.getMessage()));
            }
        }
        this.con = DBConnPool.getConnection();
        LOGGER.warn((Object)"now the con is invalid ,I retrieve a new one");
    }

    @Override
    public synchronized void loadFile2Db(DbFileTask task) {
        if (this.tasks.contains(task)) {
            for (DbFileTask taskInCache : this.tasks) {
                if (!taskInCache.equals(task)) continue;
                taskInCache.merge(task);
            }
        } else {
            this.tasks.add(task);
        }
        this.notifyAll();
    }
}

