/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DbFileLoader;
import com.hs.atic.collector.db.DbFileLoaderFactory;
import com.hs.atic.collector.db.DefaultDbFileLoader;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.CrashThreadHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DefaultDbFileLoaderFactory
implements DbFileLoaderFactory {
    private static DefaultDbFileLoaderFactory factory = new DefaultDbFileLoaderFactory();
    private List<String> dayTableList = new ArrayList<String>();
    private Map<String, DbFileLoader> cache = new HashMap<String, DbFileLoader>();

    private DefaultDbFileLoaderFactory() {
        this.loadDayTables();
    }

    public static DefaultDbFileLoaderFactory getInstance() {
        return factory;
    }

    private void loadDayTables() {
        String path = "tables" + File.separator + "tableNames.txt";
        List<String> tableNames = CommonUtil.getTables(path);
        this.dayTableList.addAll(tableNames);
    }

    @Override
    public DbFileLoader getLoader(String tableName) {
        DbFileLoader loader = null;
        String key = this.getKeyByTableName(tableName);
        if (this.cache.containsKey(key)) {
            loader = this.cache.get(key);
        } else {
            loader = new DefaultDbFileLoader();
            Thread thread = new Thread((Runnable)((Object)loader));
            thread.setName(key);
            thread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            thread.start();
            this.cache.put(key, loader);
        }
        return loader;
    }

    private String getKeyByTableName(String tableName) {
        String name = this.getDayTableName(tableName);
        if (null != name) {
            return name + "Loader";
        }
        return "OtherTableLoader";
    }

    private String getDayTableName(String tableName) {
        for (String tablePrefix : this.dayTableList) {
            if (!tableName.contains(tablePrefix)) continue;
            return tablePrefix;
        }
        return null;
    }
}

