/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DefaultRepositoryFactory
extends RepositoryFactory {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private Properties properties = new Properties();
    private Map<String, Repository> cache = new HashMap<String, Repository>();
    private String file = "conf" + File.separator + "RepositoryMapping.properties";

    public DefaultRepositoryFactory() {
        this.properties = CommonUtil.openPropertyFile(this.file);
    }

    @Override
    public Repository getRepository(String type) {
        Repository repository = this.cache.get(type);
        if (null != repository) {
            return repository;
        }
        return this.findBaiscType(type);
    }

    private Repository findBaiscType(String type) {
        String className = this.properties.getProperty(type);
        try {
            Repository value = (Repository)Class.forName(className).newInstance();
            this.cache.put(type, value);
            return value;
        }
        catch (Exception e) {
            LOGGER.error((Object)("get relative repository fail. the event type is " + type + " and the relative repository classname is " + className + ". " + e.getMessage()));
            return null;
        }
    }
}

