/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.BizInfoEntity;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserDefBizMappingRepository {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMap2Db(Map<BizInfoEntity, Long> map) {
        String delSql = "delete from  ATIC_USERDEF_BIZ_RELATION ";
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        if (conn != null) {
            try {
                String sql = "insert into ATIC_USERDEF_BIZ_RELATION values(?,?,?,?,?)";
                conn.setAutoCommit(false);
                stmt = conn.prepareStatement(sql);
                stmt.execute(delSql);
                for (Map.Entry<BizInfoEntity, Long> entry : map.entrySet()) {
                    BizInfoEntity bizInfo = entry.getKey();
                    String deviceIp = bizInfo.getDeviceIp();
                    long zoneId = bizInfo.getZoneId();
                    String protocol = bizInfo.getProtocol();
                    int port = bizInfo.getPort();
                    long bizId = bizInfo.getServiceId();
                    stmt.setString(1, deviceIp);
                    stmt.setLong(2, zoneId);
                    stmt.setString(3, protocol);
                    stmt.setInt(4, port);
                    stmt.setLong(5, bizId);
                    stmt.executeUpdate();
                }
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"UserDefBizMappingRepository insertMap2Db error ");
                }
                catch (Throwable throwable) {
                    CommonUtil.free(conn, stmt);
                    throw throwable;
                }
                CommonUtil.free(conn, stmt);
            }
            CommonUtil.free(conn, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<BizInfoEntity, Long> initCache() {
        String sql = "select * from ATIC_USERDEF_BIZ_RELATION ";
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        HashMap<BizInfoEntity, Long> devZoneCache = new HashMap<BizInfoEntity, Long>();
        if (conn != null) {
            try {
                stmt = conn.prepareStatement(sql);
                result = stmt.executeQuery();
                while (result.next()) {
                    String deviceIp = result.getString("DEVICE_IP");
                    long zoneId = result.getLong("ZONE_ID");
                    String protocol = result.getString("PROTOCOL");
                    int port = result.getInt("PORT");
                    long serviceId = result.getLong("BIZ_ID");
                    BizInfoEntity entity = new BizInfoEntity(zoneId, protocol, port, deviceIp);
                    entity.setServiceId(serviceId);
                    devZoneCache.put(entity, serviceId);
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"UserDefBizMappingRepository initCache error");
                CommonUtil.free(conn, stmt, result);
            }
            catch (Exception e2) {
                LOGGER.error((Object)"UserDefBizMappingRepository initCache error");
                {
                    catch (Throwable throwable) {
                        CommonUtil.free(conn, stmt, result);
                        throw throwable;
                    }
                }
                CommonUtil.free(conn, stmt, result);
            }
            CommonUtil.free(conn, stmt, result);
        }
        return devZoneCache;
    }
}

