/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.daemon.PartitionRule;
import com.hs.atic.collector.db.daemon.RepairOrOptimizeDbTableThread;
import com.hs.atic.collector.entity.alarm.DbTableAlarmEntity;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CheckDbTableUtil {
    public static final Logger LOGGER = LogManager.getInstance().getCheckDbTableLog();
    private static final List<String> BIG_DATA_TABLES = new ArrayList<String>();
    private static final String TABLE_POSTFIX = "_67500";
    private static final Map<String, Integer> FORWARD_RULE_MAP = new HashMap<String, Integer>();

    private CheckDbTableUtil() {
    }

    public static void optimizeTable(String tableName) {
        String optimizeSql = "OPTIMIZE TABLE " + tableName;
        String repairSql = "REPAIR TABLE " + tableName;
        try {
            if (!CheckDbTableUtil.getExcuteResult(optimizeSql)) {
                LOGGER.error((Object)("db table can not optimize, table name:" + tableName));
                if (CheckDbTableUtil.getExcuteResult(repairSql)) {
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, false));
                    LOGGER.info((Object)("db table repair ok, table name:" + tableName));
                } else {
                    LOGGER.error((Object)("db table can not repair, table name:" + tableName));
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, true));
                }
            } else {
                CheckDbTableUtil.checkAndNotifyClaerAlarm(tableName);
                LOGGER.info((Object)("db table optimize ok, table name:" + tableName));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("db table optimize unknow error, table name:" + tableName + ", exception:" + e.getMessage()));
        }
    }

    private static void checkAndNotifyClaerAlarm(String tableName) {
        if (AlarmThread.getInstance().isTableAlarm(tableName)) {
            LOGGER.info((Object)("db table is ok to clear alarm, talbeName=" + tableName));
            AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getForwarTableCount(String tableName) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long count = 0L;
        if (conn != null) {
            try {
                String sql = "SELECT count(*) as COUNT FROM information_schema.TABLES WHERE table_name = ? ";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, tableName);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    count = rs.getLong("COUNT");
                }
                CommonUtil.free(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOGGER.error((Object)"getForwardDBHoldTime sql fail");
            }
            finally {
                CommonUtil.free(conn, stmt, rs);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PartitionRule getForwardDBHoldTime(int ruleId) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PartitionRule rule = null;
        if (conn != null) {
            try {
                String sql = "SELECT PARTITION_HOLD_TIME,PARTITION_HOLD_UNIT FROM atic_partition_rule WHERE RULE_ID = " + ruleId;
                StringBuffer temSql = new StringBuffer(sql);
                stmt = conn.prepareStatement(temSql.toString());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    rule = new PartitionRule();
                    rule.setRuleId(ruleId);
                    rule.setPartitionHoldTime(rs.getInt("PARTITION_HOLD_TIME"));
                    rule.setPartitionHoldUnit(rs.getString("PARTITION_HOLD_UNIT"));
                    PartitionRule partitionRule = rule;
                    CommonUtil.free(conn, stmt, rs);
                    return partitionRule;
                }
                CommonUtil.free(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOGGER.error((Object)"getForwardDBHoldTime sql fail");
            }
            finally {
                CommonUtil.free(conn, stmt, rs);
            }
        }
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getForwardDBLastLogTime(String tableName) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long logTime = 0L;
        if (conn != null) {
            try {
                String sql = "select LOG_TIME from " + tableName + " order by LOG_TIME desc limit 1";
                StringBuffer temSql = new StringBuffer(sql);
                stmt = conn.prepareStatement(temSql.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    logTime = rs.getLong("LOG_TIME");
                }
                CommonUtil.free(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOGGER.error((Object)"getForwardDBLastSaveTime sql fail");
            }
            finally {
                CommonUtil.free(conn, stmt, rs);
            }
        }
        return logTime;
    }

    private static void dropForwardTable(String tableName) {
        try {
            ArrayList<String> sql = new ArrayList<String>();
            sql.add("DROP TABLE " + tableName);
            CommonUtil.execute(sql);
        }
        catch (RuntimeException ex) {
            LOGGER.error((Object)"dropForwardTable sql fail");
        }
    }

    public static void checkForwardDB() {
        for (Map.Entry<String, Integer> entry : FORWARD_RULE_MAP.entrySet()) {
            PartitionRule rule;
            int ruleId = entry.getValue();
            String oldTableName = entry.getKey() + TABLE_POSTFIX;
            Long tableCount = CheckDbTableUtil.getForwarTableCount(oldTableName);
            if (tableCount <= 0L || (rule = CheckDbTableUtil.getForwardDBHoldTime(ruleId)) == null || rule.getPartitionHoldTime() <= 0) continue;
            long logTime = CheckDbTableUtil.getForwardDBLastLogTime(oldTableName);
            if (logTime <= 0L) {
                CheckDbTableUtil.dropForwardTable(oldTableName);
                continue;
            }
            long nowTime = System.currentTimeMillis() / 1000L;
            long dayTime = 1L;
            dayTime = "M".equals(rule.getPartitionHoldUnit().toUpperCase()) ? 30L * CollectorConstants.ONE_DAY : ("D".equals(rule.getPartitionHoldUnit().toUpperCase()) ? CollectorConstants.ONE_DAY.longValue() : CollectorConstants.ONE_HOUR.longValue());
            if (nowTime - logTime <= dayTime * (long)rule.getPartitionHoldTime()) continue;
            CheckDbTableUtil.dropForwardTable(oldTableName);
        }
    }

    public static boolean checkOldFlowTable(String tableName) {
        String tableUpName = tableName.toUpperCase();
        if (FORWARD_RULE_MAP.get(tableUpName) != null) {
            return false;
        }
        String oldTable = tableUpName + TABLE_POSTFIX;
        return CheckDbTableUtil.getForwarTableCount(oldTable) > 0L;
    }

    public static void checkDb() {
        try {
            List<String> allTableName = CheckDbTableUtil.getAllTableName();
            for (String tableName : allTableName) {
                String checkSql = "CHECK TABLE " + tableName;
                String repairSql = "REPAIR TABLE " + tableName;
                if (!CheckDbTableUtil.getExcuteResult(checkSql)) {
                    LOGGER.error((Object)("db table is damage, table name:" + tableName));
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, true));
                    RepairOrOptimizeDbTableThread repairOrOptimizeDbTableThread = new RepairOrOptimizeDbTableThread(true, tableName);
                    repairOrOptimizeDbTableThread.setName(repairSql);
                    repairOrOptimizeDbTableThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                    repairOrOptimizeDbTableThread.start();
                    continue;
                }
                CheckDbTableUtil.checkAndNotifyClaerAlarm(tableName);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"db table checkDb unknow error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getExcuteResult(String sql) {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            StringBuffer temSql = new StringBuffer(sql);
            temSql.append("");
            conn = DBConnPool.getConnection();
            st = conn.prepareStatement(temSql.toString());
            rs = st.executeQuery();
            String result = "";
            while (rs.next()) {
                result = rs.getString("Msg_text");
            }
            if (result.equalsIgnoreCase("OK") || result.equalsIgnoreCase("Table is already up to date") || result.contains("The partition engine")) {
                boolean bl = true;
                CheckDbTableUtil.freeDb(conn, st, rs);
                return bl;
            }
            CheckDbTableUtil.freeDb(conn, st, rs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"getExcuteResult SQLException");
        }
        finally {
            CheckDbTableUtil.freeDb(conn, st, rs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllTableName() {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> allTableName = new ArrayList<String>();
        String sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'collector'";
        try {
            conn = DBConnPool.getConnection();
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                allTableName.add(rs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"getAllTableName SQLException");
            }
            catch (Throwable throwable) {
                CheckDbTableUtil.freeDb(conn, st, rs);
                throw throwable;
            }
            CheckDbTableUtil.freeDb(conn, st, rs);
        }
        CheckDbTableUtil.freeDb(conn, st, rs);
        return allTableName;
    }

    private static void freeDb(Connection conn, PreparedStatement st, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rs.close() error SQLException");
            }
        }
        try {
            if (null != st) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"st.close() SQLException");
        }
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"conn.close() SQLException");
        }
    }

    static {
        FORWARD_RULE_MAP.put("ATIC_IP_FORWARD_MAX", 1);
        FORWARD_RULE_MAP.put("ATIC_ZONE_FORWARD_MAX", 1);
        FORWARD_RULE_MAP.put("ATIC_IP_FORWARD_H", 5);
        FORWARD_RULE_MAP.put("ATIC_ZONE_FORWARD_H", 2);
        FORWARD_RULE_MAP.put("ATIC_IP_FORWARD_D", 3);
        FORWARD_RULE_MAP.put("ATIC_ZONE_FORWARD_D", 3);
        FORWARD_RULE_MAP.put("ATIC_IP_FLOW_SUM_FORWARD_MAX", 1);
        FORWARD_RULE_MAP.put("ATIC_ZONE_FLOW_SUM_FORWARD_MAX", 1);
        FORWARD_RULE_MAP.put("ATIC_DEV_FLOW_SUM_FORWARD_MAX", 4);
        FORWARD_RULE_MAP.put("ATIC_IP_FLOW_SUM_FORWARD_MAX_H", 5);
        FORWARD_RULE_MAP.put("ATIC_ZONE_FLOW_SUM_FORWARD_MAX_H", 2);
        FORWARD_RULE_MAP.put("ATIC_DEV_FLOW_SUM_FORWARD_MAX_H", 2);
        FORWARD_RULE_MAP.put("ATIC_IP_FLOW_SUM_FORWARD_MAX_D", 3);
        FORWARD_RULE_MAP.put("ATIC_ZONE_FLOW_SUM_FORWARD_MAX_D", 3);
        FORWARD_RULE_MAP.put("ATIC_DEV_FLOW_SUM_FORWARD_MAX_D", 3);
        BIG_DATA_TABLES.add("atic_ip_attack_exact_log");
        BIG_DATA_TABLES.add("atic_ip_attack_log");
    }
}

