/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.daemon.CheckDbTableUtil;
import com.hs.atic.collector.db.daemon.PartitionUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PartitionRule {
    public static final Logger LOGGER = LogManager.getInstance().getPartitionLog();
    private int ruleId;
    private List<String> tableNames = new ArrayList<String>();
    private int partitionTime;
    private int partitionHoldTime;
    private String partitionUnit;
    private String partitionHoldUnit;
    private String partitionExpression;
    private long shouldPartitionDate;
    private long shouldDropPartitionDescription;
    private int refreshMark;

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public int getPartitionTime() {
        return this.partitionTime;
    }

    public void setPartitionTime(int partitionTime) {
        this.partitionTime = partitionTime;
    }

    public int getPartitionHoldTime() {
        return this.partitionHoldTime;
    }

    public void setPartitionHoldTime(int partitionHoldTime) {
        this.partitionHoldTime = partitionHoldTime;
    }

    public String getPartitionUnit() {
        return this.partitionUnit;
    }

    public void setPartitionUnit(String partitionUnit) {
        this.partitionUnit = partitionUnit;
    }

    public String getPartitionHoldUnit() {
        return this.partitionHoldUnit;
    }

    public void setPartitionHoldUnit(String partitionHoldUnit) {
        this.partitionHoldUnit = partitionHoldUnit;
    }

    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public void setPartitionExpression(String partitionExpression) {
        this.partitionExpression = partitionExpression;
    }

    public long getShouldPartitionDate() {
        return this.shouldPartitionDate;
    }

    public void setShouldPartitionDate(long shouldPartitionDate) {
        this.shouldPartitionDate = shouldPartitionDate;
    }

    public long getShouldDropPartitionDescription() {
        return this.shouldDropPartitionDescription;
    }

    public void setShouldDropPartitionDescription(long shouldDropPartitionDescription) {
        this.shouldDropPartitionDescription = shouldDropPartitionDescription;
    }

    public int getRefreshMark() {
        return this.refreshMark;
    }

    public void setRefreshMark(int refreshMark) {
        this.refreshMark = refreshMark;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    private void calShouldDropPartitionDescription() {
        Calendar calendar = Calendar.getInstance();
        if (this.partitionHoldTime == 0) {
            LOGGER.error((Object)"partitionHoldTime is 0");
        } else if ("D".equals(this.partitionHoldUnit)) {
            calendar.set(5, calendar.get(5) - this.partitionHoldTime);
            this.shouldDropPartitionDescription = calendar.getTimeInMillis() / 1000L;
        } else {
            calendar.set(2, calendar.get(2) - this.partitionHoldTime);
            this.shouldDropPartitionDescription = calendar.getTimeInMillis() / 1000L;
        }
        LOGGER.info((Object)("partition rule  " + this.ruleId + " shouldDropPartitionDescription is " + this.shouldDropPartitionDescription));
    }

    private void calShouldPartitionTime() {
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentWeek = calendar.get(3);
        int currentDay = calendar.get(6);
        boolean isPassCreateTime = PartitionUtil.isPassCreateTime(this.partitionUnit);
        if ("D".equals(this.partitionUnit)) {
            int shouldCreateWeek = isPassCreateTime ? currentWeek + 2 : currentWeek + 1;
            calendar.set(3, shouldCreateWeek);
            calendar.set(7, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            this.shouldPartitionDate = calendar.getTimeInMillis() / 1000L;
        } else if ("M".equals(this.partitionUnit)) {
            int shouldCreateYear = currentYear;
            shouldCreateYear = isPassCreateTime ? (shouldCreateYear += 2) : currentYear + 1;
            calendar.set(shouldCreateYear, 0, 1, 0, 0, 0);
            this.shouldPartitionDate = calendar.getTimeInMillis() / 1000L;
        } else if ("H".equals(this.partitionUnit)) {
            int shouldCreateDay = currentDay;
            shouldCreateDay = isPassCreateTime ? (shouldCreateDay += 2) : ++shouldCreateDay;
            calendar.set(6, shouldCreateDay);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            this.shouldPartitionDate = calendar.getTimeInMillis() / 1000L;
        }
        LOGGER.info((Object)("partition rule  " + this.ruleId + " shouldPartitionDate is " + this.shouldPartitionDate));
    }

    private void createPartiton(String tableName) {
        long currentMaxPartitionTime = PartitionUtil.getMaxPartitonTime(tableName);
        LOGGER.info((Object)("tableName  " + tableName + " currentMaxPartitionTime is " + currentMaxPartitionTime));
        if (currentMaxPartitionTime < this.shouldPartitionDate) {
            Map<String, Long> modules = PartitionUtil.getPartitionModule(currentMaxPartitionTime, this.shouldPartitionDate, this.partitionTime, this.partitionUnit);
            PartitionUtil.createPartition(modules, tableName, this.partitionExpression, currentMaxPartitionTime == 0L);
        }
    }

    private void dropPartition(String tableName, boolean optimizeTableSwitch) {
        PartitionUtil.dropPartition(tableName, this.shouldDropPartitionDescription, optimizeTableSwitch);
    }

    private void dropPartitionAccord2NewRule(String tableName, boolean optimizeTableSwitch) {
        PartitionUtil.dropPartitionAccord2NewRule(tableName, optimizeTableSwitch);
    }

    private void checkAndDropOldTable(String tableName, boolean optimizeTableSwitch) {
        if (CheckDbTableUtil.checkOldFlowTable(tableName)) {
            this.dropPartition(tableName, optimizeTableSwitch);
            this.dropPrePartition(tableName);
        }
    }

    public void doPartitionOperate(boolean optimizeTableSwitch) {
        this.calShouldPartitionTime();
        this.calShouldDropPartitionDescription();
        LOGGER.info((Object)("partition create and drop start, ruleID=" + this.ruleId + ", refreshMark is " + this.refreshMark));
        for (String table : this.tableNames) {
            String tableName = table.toLowerCase(Locale.ENGLISH);
            if (1 == this.refreshMark) {
                this.dropPartitionAccord2NewRule(tableName, optimizeTableSwitch);
            }
            this.createPartiton(tableName);
            this.dropPartition(tableName, optimizeTableSwitch);
            this.dropPrePartition(tableName);
            this.checkAndDropOldTable(tableName, optimizeTableSwitch);
        }
        PartitionUtil.refreshPartitionRuleMark(this.ruleId);
        LOGGER.info((Object)("partition create and drop end, ruleID=" + this.ruleId));
    }

    private void dropPrePartition(String table) {
        if ("D".equals(this.partitionUnit)) {
            boolean isPassDropTime = false;
            long startTime = 0L;
            long endTime = 0L;
            Calendar calendar = Calendar.getInstance();
            if (1 == this.partitionTime) {
                if (calendar.get(11) == 3) {
                    isPassDropTime = true;
                    calendar.set(6, calendar.get(6) - 1);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    startTime = calendar.getTimeInMillis();
                    endTime = startTime + 86399000L;
                }
            } else if (7 == this.partitionTime && calendar.get(7) == 1 && calendar.get(11) == 3) {
                isPassDropTime = true;
                calendar.set(3, calendar.get(3) - 1);
                calendar.set(11, 1);
                calendar.set(12, 0);
                calendar.set(13, 0);
                startTime = calendar.getTimeInMillis();
                endTime = startTime + 604799000L;
            }
            if (isPassDropTime && !PartitionUtil.isPartitionHasData(table, startTime, endTime)) {
                String partitionName = "D" + calendar.get(1) + "_" + (calendar.get(2) + 1) + "_" + calendar.get(5);
                PartitionUtil.dropPartition(table, partitionName);
            }
        }
    }
}

