/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.daemon.CheckDbTableUtil;
import com.hs.atic.collector.db.daemon.PartitionRule;
import com.hs.atic.collector.db.daemon.PartitionUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class PartitionThread
implements Runnable {
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private static final Logger LOGGER = LogManager.getInstance().getPartitionLog();
    private static boolean checkDBTableSwitch = true;
    private static boolean optimizeTableSwitch = false;
    int oldHour = -1;
    private int beforeDay = 0;

    @Override
    public void run() {
        PartitionThread.initCheckDBTableSwitch();
        while (true) {
            int newHour;
            if (this.oldHour != (newHour = Calendar.getInstance().get(11))) {
                this.readOptimizeTableSwitch();
                try {
                    List<PartitionRule> rules = PartitionUtil.getAllPartitionRules();
                    for (PartitionRule rule : rules) {
                        rule.doPartitionOperate(optimizeTableSwitch);
                    }
                    this.oldHour = newHour;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("When create table thread run,some errors happend! " + e.getMessage()));
                }
            }
            if (checkDBTableSwitch && this.isTime2Run(this.getCurrentDay()).booleanValue()) {
                try {
                    CheckDbTableUtil.checkDb();
                    CheckDbTableUtil.checkForwardDB();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("checkDb some errors happend! " + e.getMessage()));
                }
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("Monitor thread InterruptedException happened! " + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(6);
        return day;
    }

    private Boolean isTime2Run(int currentDay) {
        int hour;
        Calendar cal = Calendar.getInstance();
        if (currentDay > this.beforeDay && (hour = cal.get(11)) >= 3) {
            this.beforeDay = currentDay;
            return true;
        }
        return false;
    }

    private static void initCheckDBTableSwitch() {
        try {
            checkDBTableSwitch = Boolean.valueOf(EventUtil.getEventConfigProperty("checkDbTableUtilSwitch"));
            LOGGER.error((Object)("initCheckDBTableSwitch checkDBTableSwitch = " + checkDBTableSwitch));
        }
        catch (Exception e) {
            checkDBTableSwitch = true;
            LOGGER.error((Object)("initCheckDBTableSwitch error set checkDBTableSwitch = true. " + e.getMessage()));
        }
    }

    private void readOptimizeTableSwitch() {
        try {
            optimizeTableSwitch = Boolean.valueOf(EventUtil.getEventConfigProperty("optimizeTableSwitch"));
            LOGGER.info((Object)("readOptimizeTableSwitch optimizeTableSwitch = " + optimizeTableSwitch));
        }
        catch (Exception e) {
            optimizeTableSwitch = false;
            LOGGER.error((Object)("readOptimizeTableSwitch error set optimizeTableSwitch = false. " + e.getMessage()));
        }
    }
}

