/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.daemon.DnsCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class SummaryManager {
    private static final String INSERT = " INSERT INTO ";
    private static final String SELECT = " SELECT ";
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private static final String COMMON = " DEVICE_IP,DEVICE_TYPE,ZONE_ID";
    private static final String COMMON_DIRECION = " DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID";
    private static final String ZONE_IP = " ZONE_IP";
    private static final String BIZ_ID = " BIZ_ID";
    private static final String FROM = " from ";
    private static final String WHERE = " WHERE LOG_TIME >=";
    private static final String CASE = " AND LOG_TIME < ";
    private static final String GROUP_BY = " GROUP BY ";
    private static final String HOUR_PERFIX = "_H";
    private static final String DAY_PERFIX = "_D";
    private static final String NOT_ZONE_ID = ",ATIC_BIZ_FLOW_SUM,ATIC_BIZ_FLOW_SUM_DROP,ATIC_BIZ_FLOW_SUM_MAX,ATIC_BIZ_FLOW_SUM_DROP_MAX,ATIC_DEV_FLOW_SUM,ATIC_DEV_FLOW_SUM_DROP,ATIC_DEV_FLOW_SUM_MAX,ATIC_DEV_FLOW_SUM_DROP_MAX,";
    private static final String DEV_COMMON = "DEVICE_IP,DEVICE_TYPE";
    private static final String DEV_COMMON_DIRECTION = "DEVICE_IP,DIRECTION,DEVICE_TYPE";
    private static final String SLOT_COMMON = "DEVICE_IP,DEVICE_TYPE,SLOT_ID";
    private static final String SLOT_COMMON_DIRECTION = "DEVICE_IP,DIRECTION,DEVICE_TYPE,SLOT_ID";
    private static final String IP_LOCATION_COMMON = "DEVICE_IP,DEVICE_TYPE,ZONE_ID,LOCATION_ID";
    private static final Logger LOGGER = LogManager.getInstance().getDaySummLog();
    private static final long SECONDS_IN_ONE_DAY = 86400L;
    private static List<String> summarSqlList = new ArrayList<String>();
    private static Map<String, List<String>> defaultFlowMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> defaultCalculateMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> bizFlowMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> devFlowMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> slotFlowMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> ipLocationFlowMap = new HashMap<String, List<String>>();
    private static List<String> suportOutboundList = new ArrayList<String>();

    private SummaryManager() {
    }

    public static boolean doDailySummary(long dateTobeSummarized) throws IOException {
        summarSqlList.clear();
        List<String> defSqls = SummaryManager.getBizFlowSqlList(dateTobeSummarized, defaultFlowMap);
        List<String> defCalculateSqls = SummaryManager.getDefFlowSqlList(dateTobeSummarized, defaultCalculateMap);
        List<String> bizSqls = SummaryManager.getBizFlowSqlList(dateTobeSummarized, bizFlowMap);
        List<String> devSqls = SummaryManager.getDevFlowSqlList(dateTobeSummarized, devFlowMap);
        List<String> slotSqls = SummaryManager.getSlotFlowSqlList(dateTobeSummarized, slotFlowMap);
        List<String> ipLocationSqls = SummaryManager.getIpLocationFlowSqlList(dateTobeSummarized, ipLocationFlowMap);
        List<DnsCondition> conditons = SummaryManager.getDnsConditions();
        List<String> dnsSqls = SummaryManager.getDnsSql(dateTobeSummarized, conditons);
        ArrayList<String> sqls = new ArrayList<String>();
        for (String sql : defSqls) {
            sqls.add(sql);
        }
        for (String sql : defCalculateSqls) {
            sqls.add(sql);
        }
        for (String sql : bizSqls) {
            sqls.add(sql);
        }
        for (String sql : devSqls) {
            sqls.add(sql);
        }
        for (String sql : slotSqls) {
            sqls.add(sql);
        }
        for (String sql : ipLocationSqls) {
            sqls.add(sql);
        }
        for (String sql : dnsSqls) {
            sqls.add(sql);
        }
        return SummaryManager.exeuteSql(sqls);
    }

    private static List<DnsCondition> getDnsConditions() throws IOException {
        String dnsCommon = "DEVICE_IP,DEVICE_TYPE,ZONE_ID,BIZ_ID";
        String dnsCommonOutbound = "DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID";
        String dnsAverPath = "tables" + File.separator + "dnsStatic" + File.separator + "dnstop.conf";
        String attackAverPath = "tables" + File.separator + "dnsStatic" + File.separator + "attack.conf";
        String userDefPath = "tables" + File.separator + "dnsStatic" + File.separator + "userdef.conf";
        String dnsSumSql = SummaryManager.getTableConlum(dnsAverPath);
        String attackAverSql = SummaryManager.getTableConlum(attackAverPath);
        String userDefSql = SummaryManager.getTableConlum(userDefPath);
        ArrayList<DnsCondition> dns = new ArrayList<DnsCondition>();
        DnsCondition dnsCache = new DnsCondition();
        dnsCache.setGroupBy(dnsCommon + ",DNS_ID,DNS_NAME,REQUEST_TYPE");
        dnsCache.setSumSql(dnsSumSql);
        dnsCache.setTableName("ATIC_STATIC_DNS_CACHE");
        dns.add(dnsCache);
        DnsCondition dnsTopn = new DnsCondition();
        dnsTopn.setGroupBy(dnsCommon + ",TOPN_TYPE,DNS_NAME,REQUEST_TYPE");
        dnsTopn.setSumSql(dnsSumSql);
        dnsTopn.setTableName("ATIC_DNS_TOPN");
        dns.add(dnsTopn);
        DnsCondition dnsSrcTopn = new DnsCondition();
        dnsSrcTopn.setGroupBy(dnsCommon + ",SRC_IP,TOPN_TYPE");
        dnsSrcTopn.setSumSql(dnsSumSql);
        dnsSrcTopn.setTableName("ATIC_SRC_DNS_TOPN");
        dns.add(dnsSrcTopn);
        DnsCondition attackDns = new DnsCondition();
        attackDns.setGroupBy(dnsCommonOutbound + ",ZONE_IP,ATTACK_TYPE,PROTOCOL,PORT");
        attackDns.setSumSql(attackAverSql);
        attackDns.setTableName("ATIC_IP_ATTACK_FLOW");
        dns.add(attackDns);
        DnsCondition attackZoneDns = new DnsCondition();
        attackZoneDns.setGroupBy(dnsCommonOutbound + ",ATTACK_TYPE,PROTOCOL,PORT");
        attackZoneDns.setSumSql(attackAverSql);
        attackZoneDns.setTableName("ATIC_ZONE_ATTACK_FLOW");
        dns.add(attackZoneDns);
        DnsCondition userDefDns = new DnsCondition();
        userDefDns.setGroupBy(dnsCommon + ",ZONE_IP,TYPE_CODE");
        userDefDns.setSumSql(userDefSql);
        userDefDns.setTableName("ATIC_IP_USERDEF_DNS_TYPE");
        dns.add(userDefDns);
        DnsCondition userDefZoneDns = new DnsCondition();
        userDefZoneDns.setGroupBy(dnsCommon + ",TYPE_CODE");
        userDefZoneDns.setSumSql(userDefSql);
        userDefZoneDns.setTableName("ATIC_ZONE_USERDEF_DNS_TYPE");
        dns.add(userDefZoneDns);
        String dnsDefendGroupBy = "DEVICE_IP,DEVICE_TYPE,DNS_NAME";
        String dnsDefendPath = "tables" + File.separator + "dnsdefend" + File.separator + "merge.conf";
        String dnsDefendSumSql = SummaryManager.getTableConlum(dnsDefendPath);
        DnsCondition dnsDefendCondition = new DnsCondition();
        dnsDefendCondition.setGroupBy(dnsDefendGroupBy);
        dnsDefendCondition.setSumSql(dnsDefendSumSql);
        dnsDefendCondition.setTableName("ATIC_DNS_DEFEND");
        dns.add(dnsDefendCondition);
        return dns;
    }

    private static List<String> getDnsSql(long dateTobeSummarized, List<DnsCondition> conditions) {
        ArrayList<String> dnsSqls = new ArrayList<String>();
        for (DnsCondition condition : conditions) {
            String tableName = condition.getTableName();
            String sumSql = condition.getSumSql();
            String groupBy = condition.getGroupBy();
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(INSERT);
            sqlBuffer.append(tableName + DAY_PERFIX);
            sqlBuffer.append(SELECT);
            sqlBuffer.append(dateTobeSummarized);
            sqlBuffer.append(COMMA);
            sqlBuffer.append(groupBy);
            sqlBuffer.append(COMMA);
            sqlBuffer.append(sumSql);
            sqlBuffer.append(FROM);
            sqlBuffer.append(tableName + HOUR_PERFIX);
            sqlBuffer.append(WHERE);
            sqlBuffer.append(dateTobeSummarized);
            sqlBuffer.append(CASE);
            sqlBuffer.append(dateTobeSummarized + 86400L);
            sqlBuffer.append(GROUP_BY);
            sqlBuffer.append(groupBy);
            sqlBuffer.append(SEMICOLON);
            dnsSqls.add(sqlBuffer.toString());
        }
        return dnsSqls;
    }

    private static List<String> getDevFlowSqlList(long dateTobeSummarized, Map<String, List<String>> devFlowMaps) throws IOException {
        ArrayList<String> sumSqlList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : devFlowMaps.entrySet()) {
            String path = entry.getKey();
            List<String> tableNamList = entry.getValue();
            String sumSql = SummaryManager.getTableConlum(path);
            for (String tableName : tableNamList) {
                String sql = SummaryManager.getDevSql(dateTobeSummarized, tableName, sumSql);
                sumSqlList.add(sql);
            }
        }
        return sumSqlList;
    }

    private static List<String> getSlotFlowSqlList(long dateTobeSummarized, Map<String, List<String>> slotFlowMaps) throws IOException {
        ArrayList<String> sumSqlList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : slotFlowMaps.entrySet()) {
            String path = entry.getKey();
            List<String> tableNamList = entry.getValue();
            String sumSql = SummaryManager.getTableConlum(path);
            for (String tableName : tableNamList) {
                String sql = SummaryManager.getSlotSql(dateTobeSummarized, tableName, sumSql);
                sumSqlList.add(sql);
            }
        }
        return sumSqlList;
    }

    private static List<String> getIpLocationFlowSqlList(long dateTobeSummarized, Map<String, List<String>> ipLocatioinFlowMap) throws IOException {
        ArrayList<String> sumSqlList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : ipLocatioinFlowMap.entrySet()) {
            String path = entry.getKey();
            List<String> tableNamList = entry.getValue();
            String sumSql = SummaryManager.getTableConlum(path);
            for (String tableName : tableNamList) {
                String sql = SummaryManager.getIpLocationSql(dateTobeSummarized, tableName, sumSql);
                sumSqlList.add(sql);
            }
        }
        return sumSqlList;
    }

    private static String getIpLocationSql(long dateTobeSummarized, String tableName, String sumSql) {
        String groupBy = IP_LOCATION_COMMON;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(INSERT);
        sqlBuffer.append(tableName + DAY_PERFIX);
        sqlBuffer.append(SELECT);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(COMMA);
        sqlBuffer.append(IP_LOCATION_COMMON);
        sqlBuffer.append(COMMA);
        sqlBuffer.append(sumSql);
        sqlBuffer.append(FROM);
        sqlBuffer.append(tableName + HOUR_PERFIX);
        sqlBuffer.append(WHERE);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(CASE);
        sqlBuffer.append(dateTobeSummarized + 86400L);
        sqlBuffer.append(GROUP_BY);
        sqlBuffer.append(groupBy);
        sqlBuffer.append(SEMICOLON);
        return sqlBuffer.toString();
    }

    private static List<String> getBizFlowSqlList(long dateTobeSummarized, Map<String, List<String>> bizFlowMaps) throws IOException {
        ArrayList<String> sumSqlList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : bizFlowMaps.entrySet()) {
            String path = entry.getKey();
            List<String> tableNamList = entry.getValue();
            String sumSql = SummaryManager.getTableConlum(path);
            for (String tableName : tableNamList) {
                String sql = SummaryManager.getCommonSql(dateTobeSummarized, tableName, sumSql, true);
                sumSqlList.add(sql);
            }
        }
        return sumSqlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exeuteSql(List<String> sqls) {
        block7: {
            Connection conn = DBConnPool.getConnection();
            Statement stmt = null;
            if (conn == null) break block7;
            try {
                conn.setAutoCommit(false);
                stmt = conn.createStatement();
                for (String sql : sqls) {
                    try {
                        stmt.execute(sql);
                    }
                    catch (SQLException e) {
                        LOGGER.error((Object)"exeuteSql of DailySummary error, error sql");
                    }
                }
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"exeuteSql of DailySummary error");
                }
                catch (Throwable throwable) {
                    CommonUtil.free(conn, stmt);
                    throw throwable;
                }
                CommonUtil.free(conn, stmt);
            }
            CommonUtil.free(conn, stmt);
            return true;
        }
        return false;
    }

    private static List<String> getDefFlowSqlList(long dateTobeSummarized, Map<String, List<String>> defaultFlowMaps) throws IOException {
        ArrayList<String> sumSqlList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : defaultFlowMaps.entrySet()) {
            String path = entry.getKey();
            List<String> tableNamList = entry.getValue();
            String sumSql = SummaryManager.getTableConlum(path);
            for (String tableName : tableNamList) {
                String sql = SummaryManager.getCommonSql(dateTobeSummarized, tableName, sumSql, false);
                sumSqlList.add(sql);
            }
        }
        return sumSqlList;
    }

    private static String getDevSql(long dateTobeSummarized, String tableName, String sumSql) {
        boolean isOutbound = suportOutboundList.contains(tableName);
        String groupBy = isOutbound ? DEV_COMMON_DIRECTION : DEV_COMMON;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(INSERT);
        sqlBuffer.append(tableName + DAY_PERFIX);
        sqlBuffer.append(SELECT);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(COMMA);
        if (isOutbound) {
            sqlBuffer.append(DEV_COMMON_DIRECTION);
        } else {
            sqlBuffer.append(DEV_COMMON);
        }
        sqlBuffer.append(COMMA);
        sqlBuffer.append(sumSql);
        sqlBuffer.append(FROM);
        sqlBuffer.append(tableName + HOUR_PERFIX);
        sqlBuffer.append(WHERE);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(CASE);
        sqlBuffer.append(dateTobeSummarized + 86400L);
        sqlBuffer.append(GROUP_BY);
        sqlBuffer.append(groupBy);
        sqlBuffer.append(SEMICOLON);
        return sqlBuffer.toString();
    }

    private static String getSlotSql(long dateTobeSummarized, String tableName, String sumSql) {
        boolean isOutbound = suportOutboundList.contains(tableName);
        String groupBy = isOutbound ? SLOT_COMMON_DIRECTION : SLOT_COMMON;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(INSERT);
        sqlBuffer.append(tableName + DAY_PERFIX);
        sqlBuffer.append(SELECT);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(COMMA);
        if (isOutbound) {
            sqlBuffer.append(SLOT_COMMON_DIRECTION);
        } else {
            sqlBuffer.append(SLOT_COMMON);
        }
        sqlBuffer.append(COMMA);
        sqlBuffer.append(sumSql);
        sqlBuffer.append(FROM);
        sqlBuffer.append(tableName + HOUR_PERFIX);
        sqlBuffer.append(WHERE);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(CASE);
        sqlBuffer.append(dateTobeSummarized + 86400L);
        sqlBuffer.append(GROUP_BY);
        sqlBuffer.append(groupBy);
        sqlBuffer.append(SEMICOLON);
        return sqlBuffer.toString();
    }

    private static String getCommonSql(long dateTobeSummarized, String tableName, String sumSql, boolean isBiz) {
        boolean isOutbound = suportOutboundList.contains(tableName);
        String groupBy = isOutbound ? COMMON_DIRECION : COMMON;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(INSERT);
        sqlBuffer.append(tableName + DAY_PERFIX);
        sqlBuffer.append(SELECT);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(COMMA);
        if (isOutbound) {
            sqlBuffer.append(COMMON_DIRECION);
        } else {
            sqlBuffer.append(COMMON);
        }
        sqlBuffer.append(COMMA);
        if (isBiz) {
            sqlBuffer.append(BIZ_ID);
            sqlBuffer.append(COMMA);
            groupBy = groupBy + COMMA + BIZ_ID;
        }
        if (!tableName.contains("ZONE") && !NOT_ZONE_ID.contains(COMMA + tableName + COMMA)) {
            sqlBuffer.append(ZONE_IP);
            sqlBuffer.append(COMMA);
            groupBy = groupBy + COMMA + ZONE_IP;
        }
        sqlBuffer.append(sumSql);
        sqlBuffer.append(FROM);
        sqlBuffer.append(tableName + HOUR_PERFIX);
        sqlBuffer.append(WHERE);
        sqlBuffer.append(dateTobeSummarized);
        sqlBuffer.append(CASE);
        sqlBuffer.append(dateTobeSummarized + 86400L);
        sqlBuffer.append(GROUP_BY);
        sqlBuffer.append(groupBy);
        sqlBuffer.append(SEMICOLON);
        return sqlBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clearData(long dateTobeSummarized) {
        boolean returnValue = false;
        String del = "DELETE FROM ";
        String condition = " WHERE LOG_TIME >= ";
        ArrayList<Object> sqls = new ArrayList<Object>();
        List<String> tableNames = CommonUtil.getTables(CollectorConstants.DAY_TABLE_PATH);
        for (String name : tableNames) {
            String sql = "DELETE FROM " + name + " WHERE LOG_TIME >= " + dateTobeSummarized;
            sqls.add(sql);
        }
        Connection connection = DBConnPool.getConnection();
        Statement statement = null;
        if (connection != null) {
            try {
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                for (String string : sqls) {
                    statement.execute(string);
                }
                connection.commit();
                returnValue = true;
            }
            catch (SQLException e) {
                LOGGER.error((Object)"Cleartrash Data error ");
                returnValue = false;
            }
            finally {
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException e1) {
                    LOGGER.error((Object)"Closing database statement failed after deleting daily summarized data.");
                }
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"Closing database connection failed after deleting daily summarized data.");
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableConlum(String path) {
        FileInputStream in = null;
        BufferedReader reader = null;
        try {
            String line;
            StringBuffer buffer = new StringBuffer();
            in = new FileInputStream(path);
            reader = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0 || line.trim().startsWith("#")) continue;
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"read file error!!System will try retry a moment!");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("read file error!!System will try retry a moment!" + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)"read file error!!System will try retry a moment!");
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"reader close error");
            }
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"in close error ");
            }
        }
        return null;
    }

    static {
        String defInPath = "tables" + File.separator + "defBiz" + File.separator + "in.conf";
        String defDropPath = "tables" + File.separator + "defBiz" + File.separator + "drop.conf";
        String defForwardPath = "tables" + File.separator + "defBiz" + File.separator + "forward.conf";
        String tcpAverPath = "tables" + File.separator + "tcpBiz" + File.separator + "average.conf";
        String tcpAverDropPath = "tables" + File.separator + "tcpBiz" + File.separator + "drop.conf";
        String tcpAndDnsAverPath = "tables" + File.separator + "tcpBiz" + File.separator + "averageForDns.conf";
        String tcpAndDnsDropAverPath = "tables" + File.separator + "tcpBiz" + File.separator + "dropForDns.conf";
        String tcpMaxPath = "tables" + File.separator + "tcpBiz" + File.separator + "max.conf";
        String tcpAndDnsMaxPath = "tables" + File.separator + "tcpBiz" + File.separator + "maxForDns.conf";
        String udpAverPath = "tables" + File.separator + "udpBiz" + File.separator + "average.conf";
        String udpAverDropPath = "tables" + File.separator + "udpBiz" + File.separator + "drop.conf";
        String udpMaxPath = "tables" + File.separator + "udpBiz" + File.separator + "max.conf";
        String httpAverPath = "tables" + File.separator + "httpBiz" + File.separator + "average.conf";
        String httpAverDropPath = "tables" + File.separator + "httpBiz" + File.separator + "drop.conf";
        String httpMaxPath = "tables" + File.separator + "httpBiz" + File.separator + "max.conf";
        String httpsAverPath = "tables" + File.separator + "httpsBiz" + File.separator + "average.conf";
        String httpsAverDropPath = "tables" + File.separator + "httpsBiz" + File.separator + "drop.conf";
        String httpsMaxPath = "tables" + File.separator + "httpsBiz" + File.separator + "max.conf";
        String udpDnsAverPath = "tables" + File.separator + "udpDnsBiz" + File.separator + "average.conf";
        String udpDnsAverDropPath = "tables" + File.separator + "udpDnsBiz" + File.separator + "drop.conf";
        String udpDnsMaxPath = "tables" + File.separator + "udpDnsBiz" + File.separator + "max.conf";
        String sipAverPath = "tables" + File.separator + "sipBiz" + File.separator + "average.conf";
        String sipAverDropPath = "tables" + File.separator + "sipBiz" + File.separator + "drop.conf";
        String sipMaxPath = "tables" + File.separator + "sipBiz" + File.separator + "max.conf";
        String sumAverPath = "tables" + File.separator + "sumBiz" + File.separator + "average.conf";
        String sumAverDropPath = "tables" + File.separator + "sumBiz" + File.separator + "drop.conf";
        String sumMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "max.conf";
        String sumIpForwardMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "ipforwardmax.conf";
        String sumZoneForwardMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "zoneforwardmax.conf";
        String sumBizAverPath = "tables" + File.separator + "sumBiz" + File.separator + "bizaverage.conf";
        String sumBizAverDropPath = "tables" + File.separator + "sumBiz" + File.separator + "bizdrop.conf";
        String sumBizMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "bizmax.conf";
        String sumDevAverPath = "tables" + File.separator + "sumBiz" + File.separator + "devaverage.conf";
        String sumDevAverDropPath = "tables" + File.separator + "sumBiz" + File.separator + "devdrop.conf";
        String sumDevMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "devmax.conf";
        String sumDevDropMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "devdropmax.conf";
        String sumDevForwardMaxPath = "tables" + File.separator + "sumBiz" + File.separator + "devforwardmax.conf";
        String sumSlotAverPath = "tables" + File.separator + "sumBiz" + File.separator + "slotaverage.conf";
        String sumIpLocationAverPath = "tables" + File.separator + "sumBiz" + File.separator + "iplocationaverage.conf";
        String otherAverPath = "tables" + File.separator + "otherbiz" + File.separator + "average.conf";
        String otherMaxPath = "tables" + File.separator + "otherbiz" + File.separator + "max.conf";
        suportOutboundList.add("ATIC_DEV_FLOW_SUM");
        suportOutboundList.add("ATIC_DEV_FLOW_SUM_DROP");
        suportOutboundList.add("ATIC_DEV_FLOW_SUM_DROP_MAX");
        suportOutboundList.add("ATIC_DEV_FLOW_SUM_MAX");
        suportOutboundList.add("ATIC_IP_DROP");
        suportOutboundList.add("ATIC_IP_FLOW_SUM");
        suportOutboundList.add("ATIC_IP_FLOW_SUM_DROP");
        suportOutboundList.add("ATIC_IP_FLOW_SUM_DROP_MAX");
        suportOutboundList.add("ATIC_IP_FLOW_SUM_MAX");
        suportOutboundList.add("ATIC_IP_IN");
        suportOutboundList.add("ATIC_SLOT_FLOW_SUM");
        suportOutboundList.add("ATIC_SLOT_FLOW_SUM_DROP");
        suportOutboundList.add("ATIC_ZONE_DROP");
        suportOutboundList.add("ATIC_ZONE_FLOW_SUM");
        suportOutboundList.add("ATIC_ZONE_FLOW_SUM_DROP");
        suportOutboundList.add("ATIC_ZONE_FLOW_SUM_MAX");
        suportOutboundList.add("ATIC_ZONE_IN");
        suportOutboundList.add("ATIC_ZONE_FLOW_SUM_DROP_MAX");
        suportOutboundList.add("ATIC_ZONE_ATTACK_FLOW");
        suportOutboundList.add("ATIC_IP_ATTACK_FLOW");
        suportOutboundList.add("ATIC_IP_FLOW_SUM_FORWARD_MAX");
        suportOutboundList.add("ATIC_ZONE_FLOW_SUM_FORWARD_MAX");
        suportOutboundList.add("ATIC_DEV_FLOW_SUM_FORWARD_MAX");
        suportOutboundList.add("ATIC_IP_FORWARD");
        suportOutboundList.add("ATIC_ZONE_FORWARD");
        ArrayList<String> defInList = new ArrayList<String>();
        defInList.add("ATIC_IP_IN");
        defInList.add("ATIC_ZONE_IN");
        ArrayList<String> defDropList = new ArrayList<String>();
        defDropList.add("ATIC_IP_DROP");
        defDropList.add("ATIC_ZONE_DROP");
        ArrayList<String> defForwardList = new ArrayList<String>();
        defForwardList.add("ATIC_IP_FORWARD");
        defForwardList.add("ATIC_ZONE_FORWARD");
        ArrayList<String> tcpAndDnsAverList = new ArrayList<String>();
        tcpAndDnsAverList.add("ATIC_IP_BIZ_TCP");
        tcpAndDnsAverList.add("ATIC_ZONE_BIZ_TCP");
        ArrayList<String> tcpAndDnsAverDropList = new ArrayList<String>();
        tcpAndDnsAverDropList.add("ATIC_IP_BIZ_TCP_DROP");
        tcpAndDnsAverDropList.add("ATIC_ZONE_BIZ_TCP_DROP");
        ArrayList<String> tcpAndDnsAverForSpeList = new ArrayList<String>();
        tcpAndDnsAverForSpeList.add("ATIC_IP_BIZ_TCP_DNS");
        tcpAndDnsAverForSpeList.add("ATIC_ZONE_BIZ_TCP_DNS");
        ArrayList<String> tcpAndDnsAverDropForSpeList = new ArrayList<String>();
        tcpAndDnsAverDropForSpeList.add("ATIC_IP_BIZ_TCP_DNS_DROP");
        tcpAndDnsAverDropForSpeList.add("ATIC_ZONE_BIZ_TCP_DNS_DROP");
        ArrayList<String> tcpAndDnsMaxList = new ArrayList<String>();
        tcpAndDnsMaxList.add("ATIC_IP_BIZ_TCP_MAX");
        tcpAndDnsMaxList.add("ATIC_IP_BIZ_TCP_DROP_MAX");
        tcpAndDnsMaxList.add("ATIC_ZONE_BIZ_TCP_MAX");
        tcpAndDnsMaxList.add("ATIC_ZONE_BIZ_TCP_DROP_MAX");
        ArrayList<String> tcpAndDnsMaxForSpeList = new ArrayList<String>();
        tcpAndDnsMaxForSpeList.add("ATIC_IP_BIZ_TCP_DNS_MAX");
        tcpAndDnsMaxForSpeList.add("ATIC_IP_BIZ_TCP_DNS_DROP_MAX");
        tcpAndDnsMaxForSpeList.add("ATIC_ZONE_BIZ_TCP_DNS_MAX");
        tcpAndDnsMaxForSpeList.add("ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX");
        ArrayList<String> udpAverList = new ArrayList<String>();
        udpAverList.add("ATIC_IP_BIZ_UDP");
        udpAverList.add("ATIC_ZONE_BIZ_UDP");
        ArrayList<String> udpAverDropList = new ArrayList<String>();
        udpAverDropList.add("ATIC_IP_BIZ_UDP_DROP");
        udpAverDropList.add("ATIC_ZONE_BIZ_UDP_DROP");
        ArrayList<String> udpMaxList = new ArrayList<String>();
        udpMaxList.add("ATIC_IP_BIZ_UDP_MAX");
        udpMaxList.add("ATIC_IP_BIZ_UDP_DROP_MAX");
        udpMaxList.add("ATIC_ZONE_BIZ_UDP_MAX");
        udpMaxList.add("ATIC_ZONE_BIZ_UDP_DROP_MAX");
        ArrayList<String> httpAverList = new ArrayList<String>();
        httpAverList.add("ATIC_IP_BIZ_HTTP");
        httpAverList.add("ATIC_ZONE_BIZ_HTTP");
        ArrayList<String> httpAverDropList = new ArrayList<String>();
        httpAverDropList.add("ATIC_IP_BIZ_HTTP_DROP");
        httpAverDropList.add("ATIC_ZONE_BIZ_HTTP_DROP");
        ArrayList<String> httpMaxList = new ArrayList<String>();
        httpMaxList.add("ATIC_IP_BIZ_HTTP_MAX");
        httpMaxList.add("ATIC_IP_BIZ_HTTP_DROP_MAX");
        httpMaxList.add("ATIC_ZONE_BIZ_HTTP_MAX");
        httpMaxList.add("ATIC_ZONE_BIZ_HTTP_DROP_MAX");
        ArrayList<String> httpsAverList = new ArrayList<String>();
        httpsAverList.add("ATIC_IP_BIZ_HTTPS");
        httpsAverList.add("ATIC_ZONE_BIZ_HTTPS");
        ArrayList<String> httpsAverDropList = new ArrayList<String>();
        httpsAverDropList.add("ATIC_IP_BIZ_HTTPS_DROP");
        httpsAverDropList.add("ATIC_ZONE_BIZ_HTTPS_DROP");
        ArrayList<String> httpsMaxList = new ArrayList<String>();
        httpsMaxList.add("ATIC_IP_BIZ_HTTPS_MAX");
        httpsMaxList.add("ATIC_IP_BIZ_HTTPS_DROP_MAX");
        httpsMaxList.add("ATIC_ZONE_BIZ_HTTPS_MAX");
        httpsMaxList.add("ATIC_ZONE_BIZ_HTTPS_DROP_MAX");
        ArrayList<String> udpDnsAverList = new ArrayList<String>();
        udpDnsAverList.add("ATIC_IP_BIZ_UDP_DNS");
        udpDnsAverList.add("ATIC_ZONE_BIZ_UDP_DNS");
        ArrayList<String> udpDnsAverDropList = new ArrayList<String>();
        udpDnsAverDropList.add("ATIC_IP_BIZ_UDP_DNS_DROP");
        udpDnsAverDropList.add("ATIC_ZONE_BIZ_UDP_DNS_DROP");
        ArrayList<String> udpDnsMaxList = new ArrayList<String>();
        udpDnsMaxList.add("ATIC_IP_BIZ_UDP_DNS_MAX");
        udpDnsMaxList.add("ATIC_IP_BIZ_UDP_DNS_DROP_MAX");
        udpDnsMaxList.add("ATIC_ZONE_BIZ_UDP_DNS_MAX");
        udpDnsMaxList.add("ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX");
        ArrayList<String> sipAverList = new ArrayList<String>();
        sipAverList.add("ATIC_IP_BIZ_SIP");
        sipAverList.add("ATIC_ZONE_BIZ_SIP");
        ArrayList<String> sipAverDropList = new ArrayList<String>();
        sipAverDropList.add("ATIC_IP_BIZ_SIP_DROP");
        sipAverDropList.add("ATIC_ZONE_BIZ_SIP_DROP");
        ArrayList<String> sipMaxList = new ArrayList<String>();
        sipMaxList.add("ATIC_IP_BIZ_SIP_MAX");
        sipMaxList.add("ATIC_IP_BIZ_SIP_DROP_MAX");
        sipMaxList.add("ATIC_ZONE_BIZ_SIP_MAX");
        sipMaxList.add("ATIC_ZONE_BIZ_SIP_DROP_MAX");
        ArrayList<String> otherAverList = new ArrayList<String>();
        otherAverList.add("ATIC_IP_BIZ_OTHER");
        otherAverList.add("ATIC_IP_BIZ_OTHER_DROP");
        otherAverList.add("ATIC_ZONE_BIZ_OTHER");
        otherAverList.add("ATIC_ZONE_BIZ_OTHER_DROP");
        ArrayList<String> otherMaxList = new ArrayList<String>();
        otherMaxList.add("ATIC_IP_BIZ_OTHER_MAX");
        otherMaxList.add("ATIC_IP_BIZ_OTHER_DROP_MAX");
        otherMaxList.add("ATIC_ZONE_BIZ_OTHER_MAX");
        otherMaxList.add("ATIC_ZONE_BIZ_OTHER_DROP_MAX");
        ArrayList<String> sumAverList = new ArrayList<String>();
        sumAverList.add("ATIC_IP_FLOW_SUM");
        sumAverList.add("ATIC_ZONE_FLOW_SUM");
        ArrayList<String> sumAverDropList = new ArrayList<String>();
        sumAverDropList.add("ATIC_IP_FLOW_SUM_DROP");
        sumAverDropList.add("ATIC_ZONE_FLOW_SUM_DROP");
        ArrayList<String> sumMaxList = new ArrayList<String>();
        sumMaxList.add("ATIC_IP_FLOW_SUM_MAX");
        sumMaxList.add("ATIC_IP_FLOW_SUM_DROP_MAX");
        sumMaxList.add("ATIC_ZONE_FLOW_SUM_MAX");
        sumMaxList.add("ATIC_ZONE_FLOW_SUM_DROP_MAX");
        ArrayList<String> sumIpForwardMaxList = new ArrayList<String>();
        sumIpForwardMaxList.add("ATIC_IP_FLOW_SUM_FORWARD_MAX");
        ArrayList<String> sumZoneForwardMaxList = new ArrayList<String>();
        sumZoneForwardMaxList.add("ATIC_ZONE_FLOW_SUM_FORWARD_MAX");
        ArrayList<String> sumBizAverList = new ArrayList<String>();
        sumBizAverList.add("ATIC_BIZ_FLOW_SUM");
        ArrayList<String> sumBizAverDropList = new ArrayList<String>();
        sumBizAverDropList.add("ATIC_BIZ_FLOW_SUM_DROP");
        ArrayList<String> sumBizMaxList = new ArrayList<String>();
        sumBizMaxList.add("ATIC_BIZ_FLOW_SUM_MAX");
        sumBizMaxList.add("ATIC_BIZ_FLOW_SUM_DROP_MAX");
        ArrayList<String> sumDevAverList = new ArrayList<String>();
        sumDevAverList.add("ATIC_DEV_FLOW_SUM");
        ArrayList<String> sumDevAverDropList = new ArrayList<String>();
        sumDevAverDropList.add("ATIC_DEV_FLOW_SUM_DROP");
        ArrayList<String> sumDevMaxList = new ArrayList<String>();
        sumDevMaxList.add("ATIC_DEV_FLOW_SUM_MAX");
        ArrayList<String> sumDevDropMaxList = new ArrayList<String>();
        sumDevDropMaxList.add("ATIC_DEV_FLOW_SUM_DROP_MAX");
        ArrayList<String> sumDevForwardMaxList = new ArrayList<String>();
        sumDevForwardMaxList.add("ATIC_DEV_FLOW_SUM_FORWARD_MAX");
        ArrayList<String> sumSlotAverList = new ArrayList<String>();
        sumSlotAverList.add("ATIC_SLOT_FLOW_SUM");
        sumSlotAverList.add("ATIC_SLOT_FLOW_SUM_DROP");
        ArrayList<String> sumIpLocationAverList = new ArrayList<String>();
        sumIpLocationAverList.add("ATIC_LOCATION_FLOW_SUM");
        sumIpLocationAverList.add("ATIC_LOCATION_FLOW_SUM_DROP");
        defaultFlowMap.put(defInPath, defInList);
        defaultFlowMap.put(defDropPath, defDropList);
        defaultFlowMap.put(defForwardPath, defForwardList);
        defaultCalculateMap.put(sumAverPath, sumAverList);
        defaultCalculateMap.put(sumMaxPath, sumMaxList);
        defaultCalculateMap.put(sumAverDropPath, sumAverDropList);
        defaultCalculateMap.put(sumIpForwardMaxPath, sumIpForwardMaxList);
        defaultCalculateMap.put(sumZoneForwardMaxPath, sumZoneForwardMaxList);
        bizFlowMap.put(tcpAverPath, tcpAndDnsAverList);
        bizFlowMap.put(tcpAverDropPath, tcpAndDnsAverDropList);
        bizFlowMap.put(tcpAndDnsAverPath, tcpAndDnsAverForSpeList);
        bizFlowMap.put(tcpAndDnsDropAverPath, tcpAndDnsAverDropForSpeList);
        bizFlowMap.put(tcpMaxPath, tcpAndDnsMaxList);
        bizFlowMap.put(tcpAndDnsMaxPath, tcpAndDnsMaxForSpeList);
        bizFlowMap.put(udpAverPath, udpAverList);
        bizFlowMap.put(udpAverDropPath, udpAverDropList);
        bizFlowMap.put(udpMaxPath, udpMaxList);
        bizFlowMap.put(httpAverPath, httpAverList);
        bizFlowMap.put(httpAverDropPath, httpAverDropList);
        bizFlowMap.put(httpMaxPath, httpMaxList);
        bizFlowMap.put(httpsAverPath, httpsAverList);
        bizFlowMap.put(httpsAverDropPath, httpsAverDropList);
        bizFlowMap.put(httpsMaxPath, httpsMaxList);
        bizFlowMap.put(udpDnsAverPath, udpDnsAverList);
        bizFlowMap.put(udpDnsAverDropPath, udpDnsAverDropList);
        bizFlowMap.put(udpDnsMaxPath, udpDnsMaxList);
        bizFlowMap.put(sipAverPath, sipAverList);
        bizFlowMap.put(sipAverDropPath, sipAverDropList);
        bizFlowMap.put(sipMaxPath, sipMaxList);
        bizFlowMap.put(sumBizAverPath, sumBizAverList);
        bizFlowMap.put(sumBizAverDropPath, sumBizAverDropList);
        bizFlowMap.put(sumBizMaxPath, sumBizMaxList);
        bizFlowMap.put(otherAverPath, otherAverList);
        bizFlowMap.put(otherMaxPath, otherMaxList);
        devFlowMap.put(sumDevAverPath, sumDevAverList);
        devFlowMap.put(sumDevAverDropPath, sumDevAverDropList);
        devFlowMap.put(sumDevMaxPath, sumDevMaxList);
        devFlowMap.put(sumDevDropMaxPath, sumDevDropMaxList);
        devFlowMap.put(sumDevForwardMaxPath, sumDevForwardMaxList);
        slotFlowMap.put(sumSlotAverPath, sumSlotAverList);
        ipLocationFlowMap.put(sumIpLocationAverPath, sumIpLocationAverList);
    }
}

