/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.BizAttackEvent;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.CommonUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BizAttackRepository
extends RepositoryAdaptor<BizAttackEvent> {
    private static final String TABLE_NAME = "ATIC_BIZ_ATTACK_LOG";
    private static final String INSERATIC_ROW_INFO = "(DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,START_TIME,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ATTACK_TYPES,SRC_IP,DST_IP,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ROW_INFO = "START_TIME= ?,END_TIME= ?,DURATION=?,ATTACK_TIMES=?,ATTACK_STATUS=?,DROP_BYTES=?,DROP_PACKETS=?,ATTACK_TYPES=?,SRC_IP=?,DST_IP=?,MAX_DROP_PPS=?,MAX_DROP_KBPS=?,IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=? where PKID = ?";

    @Override
    public void createObjects(List<BizAttackEvent> objs) {
        this.createBizAttackEvents(objs);
    }

    @Override
    public List<BizAttackEvent> queryObject(Condition condition) {
        ArrayList<BizAttackEvent> events = new ArrayList<BizAttackEvent>();
        events.addAll(this.retreiveBizAttackEvents(condition));
        LOGGER.debug((Object)("after query , sql is " + condition.toSql() + " the result is " + events));
        return events;
    }

    @Override
    public void updateObjects(List<BizAttackEvent> objs) {
        this.updateExceptionEvents(objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBizAttackEvents(List<BizAttackEvent> events) {
        PreparedStatement insert = null;
        Connection con = null;
        try {
            con = this.getConnection();
            insert = con.prepareStatement("insert into ATIC_BIZ_ATTACK_LOG(DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,START_TIME,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ATTACK_TYPES,SRC_IP,DST_IP,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            for (BizAttackEvent each : events) {
                this.doInsertBizAttack(insert, each);
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"create BizAttackEvents  to DB error");
            }
            catch (Throwable throwable) {
                BizAttackRepository.freeDbResource(con, insert);
                throw throwable;
            }
            BizAttackRepository.freeDbResource(con, insert);
        }
        BizAttackRepository.freeDbResource(con, insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertBizAttack(PreparedStatement insert, BizAttackEvent each) {
        ResultSet result = null;
        try {
            insert.setString(1, each.getDeviceIp());
            insert.setLong(2, each.getDirection());
            insert.setLong(3, each.getDeviceType());
            insert.setLong(4, each.getZoneId());
            insert.setLong(5, each.getBizId());
            insert.setLong(6, each.getAlertStartTime() / 1000L);
            insert.setLong(7, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
            insert.setLong(8, each.getDuration());
            insert.setLong(9, each.getAttackCount());
            insert.setByte(10, (byte)each.getCurrentState());
            insert.setLong(11, each.getDropKbits());
            insert.setLong(12, each.getDropPkgs());
            insert.setString(13, this.getAttackTypeString(each.getAttackedTypes()));
            insert.setString(14, CommonUtil.getIpString(each.getAttackers(), 5000));
            insert.setString(15, CommonUtil.getIpString(each.getAttackedZoneIps(), 5000));
            insert.setLong(16, each.getAttackPeakPpsOrQps());
            insert.setLong(17, each.getAttackPeakKbps());
            insert.setLong(18, each.getIpAttackPeakPps());
            insert.setLong(19, each.getIpAttackPeakKbps());
            insert.setLong(20, each.getIpInPeakPps());
            insert.setLong(21, each.getIpInPeakKbps());
            insert.setLong(22, each.getTcpNewConnNum());
            insert.setLong(23, each.getTcpCurConnNum());
            insert.execute();
            result = insert.getGeneratedKeys();
            while (result.next()) {
                each.setAbnormalPkId(result.getLong(1));
            }
            BizAttackRepository.freeDbResource(null, null, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"create BizAttackEvents  to DB error");
        }
        finally {
            BizAttackRepository.freeDbResource(null, null, result);
        }
    }

    private String getTable() {
        return TABLE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BizAttackEvent> queryBizEvents(Condition condition, boolean isFromClean) {
        ArrayList<BizAttackEvent> list = new ArrayList<BizAttackEvent>();
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        try {
            con = this.getConnection();
            String sql = "select * from ATIC_BIZ_ATTACK_LOG where " + condition.toSql();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> conlist = conditionClause.getValueList();
                for (int i = 0; i < conlist.size(); ++i) {
                    query.setObject(i + 1, conlist.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                long pkId = result.getLong("PKID");
                String deviceIp = result.getString("DEVICE_IP");
                int deviceType = result.getInt("DEVICE_TYPE");
                long zoneId = result.getLong("ZONE_ID");
                long bizId = result.getLong("BIZ_ID");
                long startTimeAttack = result.getLong("START_TIME") * 1000L;
                long endTime = result.getLong("END_TIME") * 1000L;
                long attackCount = result.getInt("ATTACK_TIMES");
                int attackStatus = result.getInt("ATTACK_STATUS");
                long dropBytes = result.getLong("DROP_BYTES");
                long dropPackgets = result.getLong("DROP_PACKETS");
                String attackTypes = result.getString("ATTACK_TYPES");
                Set<String> attackers = CommonUtil.transIpString2Set(result.getString("SRC_IP"));
                Set<String> attackedIps = CommonUtil.transIpString2Set(result.getString("DST_IP"));
                EventIdentifier identifier = new EventIdentifier();
                BizAttackEvent event = new BizAttackEvent(identifier);
                identifier.setDeviceIp(deviceIp);
                identifier.setDeviceType(deviceType);
                identifier.setZoneId(zoneId);
                identifier.setBizId(bizId);
                identifier.setLogTime(startTimeAttack);
                if (isFromClean) {
                    event.setEverAttacked(true);
                    event.setAttackStartTime(startTimeAttack);
                }
                event.setEverAlerted(true);
                event.setAlertStartTime(startTimeAttack);
                event.setAlertEndTime(endTime);
                event.setAttackers(attackers);
                event.setCurrentState(attackStatus);
                event.setAttackCount(attackCount);
                event.setDropKbits(dropBytes);
                event.setDropPkgs(dropPackgets);
                event.setAttackZoneIps(attackedIps);
                event.setAttackedTypes(this.getAttackTypesFromString(attackTypes));
                event.setEverAttacked(true);
                event.setAbnormalPkId(pkId);
                list.add(event);
            }
            ArrayList<BizAttackEvent> arrayList = list;
            BizAttackRepository.freeDbResource(con, query, result);
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query ipAttacks to DB error");
            ArrayList<BizAttackEvent> arrayList = new ArrayList<BizAttackEvent>();
            return arrayList;
        }
        finally {
            BizAttackRepository.freeDbResource(con, query, result);
        }
    }

    private Collection<? extends BizAttackEvent> retreiveBizAttackEvents(Condition condition) {
        ArrayList<BizAttackEvent> bizEvents = new ArrayList<BizAttackEvent>();
        bizEvents.addAll(this.queryBizEvents(condition, true));
        bizEvents.addAll(this.queryBizEvents(condition, false));
        return bizEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExceptionEvents(List<BizAttackEvent> events) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement("update " + this.getTable() + " set " + UPDATE_ROW_INFO);
            for (BizAttackEvent each : events) {
                insert.setLong(1, each.getAlertStartTime() / 1000L);
                insert.setLong(2, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
                insert.setLong(3, each.getDuration());
                insert.setLong(4, each.getAttackCount());
                insert.setByte(5, (byte)each.getCurrentState());
                insert.setLong(6, each.getDropKbits());
                insert.setLong(7, each.getDropPkgs());
                StringBuffer types = new StringBuffer();
                Iterator<AttackType> itor = each.getAttackedTypes().iterator();
                while (itor.hasNext()) {
                    AttackType type = itor.next();
                    types.append(type.getTypeValue());
                    if (!itor.hasNext()) continue;
                    types.append(',');
                }
                insert.setString(8, this.getAttackTypeString(each.getAttackedTypes()));
                insert.setString(9, CommonUtil.getIpString(each.getAttackers(), 5000));
                insert.setString(10, CommonUtil.getIpString(each.getAttackedZoneIps(), 5000));
                insert.setLong(11, each.getAttackPeakPpsOrQps());
                insert.setLong(12, each.getAttackPeakKbps());
                insert.setLong(13, each.getIpAttackPeakPps());
                insert.setLong(14, each.getIpAttackPeakKbps());
                insert.setLong(15, each.getIpInPeakPps());
                insert.setLong(16, each.getIpInPeakKbps());
                insert.setLong(17, each.getTcpNewConnNum());
                insert.setLong(18, each.getTcpCurConnNum());
                insert.setLong(19, each.getAbnormalPkId());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            BizAttackRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"update BizAttackEvents  to DB error");
        }
        finally {
            BizAttackRepository.freeDbResource(con, insert);
        }
    }
}

