/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.BizEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class BizEventRepository
extends RepositoryAdaptor<BizEvent> {
    private static final String TABLE_NAME = "ATIC_BIZ_INFO";
    private static final String INSERT_SQL = "INSERT INTO ATIC_BIZ_INFO (PKID,DEVICE_IP,DEVICE_TYPE,ZONE_ID,ZONE_IP,SERVICE_NAME,PROTOCOL,DST_PORT,DEEP_PROTOCOL_ID,DEEP_PROTOCOL_NAME,APPID,APPNAME,SRVID,SRVNAME,BIZ_PPS,BIZ_KBPS,SUM_SIZE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,1)";
    private static final String UPDATE_SQL = "UPDATE  ATIC_BIZ_INFO SET BIZ_PPS =(BIZ_PPS * SUM_SIZE + ?)/(SUM_SIZE +1)  ,BIZ_KBPS = (BIZ_KBPS * SUM_SIZE + ?)/(SUM_SIZE +1),SUM_SIZE = SUM_SIZE +1  WHERE PKID = ?";

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObjects(List<BizEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        if (null == objs || objs.isEmpty()) {
            LOGGER.debug((Object)"The input objs is empty to create.");
            return;
        }
        try {
            con = this.getConnection();
            ps = con.prepareStatement(INSERT_SQL);
            for (BizEvent e : objs) {
                if (e.getServiceName().startsWith("Other_") && (e.getIpProtocol() == 1 || e.getIpProtocol() == 6 || e.getIpProtocol() == 17)) {
                    LOGGER.info((Object)("Other protocol for 1,6,17 service.The protocol is " + e.getIpProtocol()));
                    continue;
                }
                LOGGER.info((Object)("The serviceName is " + e.getServiceName() + ", protocal is " + e.getIpProtocol()));
                ps.setLong(1, e.getPkid());
                ps.setString(2, e.getDeviceIp());
                ps.setLong(3, e.getDeviceType());
                ps.setLong(4, e.getZoneId());
                ps.setString(5, e.getZoneIp());
                ps.setString(6, e.getServiceName() == null ? "" : e.getServiceName());
                ps.setLong(7, e.getIpProtocol());
                ps.setLong(8, e.getBizDstPort());
                ps.setLong(9, e.getProtoId());
                ps.setString(10, e.getProtoName() == null ? "" : e.getProtoName());
                ps.setLong(11, e.getAppId());
                ps.setString(12, e.getAppnName() == null ? "" : e.getAppnName());
                ps.setLong(13, e.getSrvId());
                ps.setString(14, e.getSrvName() == null ? "" : e.getSrvName());
                ps.setLong(15, e.getSrvPps());
                ps.setLong(16, e.getSrvKbps());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"createObjects error!!");
            }
            catch (Throwable throwable) {
                BizEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BizEventRepository.freeDbResource(con, ps);
        }
        BizEventRepository.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObjects(List<BizEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        if (null == objs || objs.isEmpty()) {
            LOGGER.debug((Object)"The input objs is empty to update.");
            return;
        }
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_SQL);
            for (BizEvent e : objs) {
                ps.setLong(1, e.getSrvPps());
                ps.setLong(2, e.getSrvKbps());
                ps.setLong(3, e.getPkid());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"updateObjects error!");
            }
            catch (Throwable throwable) {
                BizEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BizEventRepository.freeDbResource(con, ps);
        }
        BizEventRepository.freeDbResource(con, ps);
    }
}

