/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.EventFileRepository;
import com.hs.atic.collector.entity.event.BizTotalFlowEvent;

public class BizTotalFlowRepository
extends EventFileRepository<BizTotalFlowEvent> {
    private static final String BIZ_SUM_TABLE = "ATIC_BIZ_FLOW_SUM";
    private static final String BIZ_SUM_H_TABLE = "ATIC_BIZ_FLOW_SUM_H";
    private static final String BIZ_SUM_MAX_H_TABLE = "ATIC_BIZ_FLOW_SUM_MAX_H";
    private static final String BIZ_SUM_DROP_TABLE = "ATIC_BIZ_FLOW_SUM_DROP";
    private static final String BIZ_SUM_DROP_H_TABLE = "ATIC_BIZ_FLOW_SUM_DROP_H";
    private static final String BIZ_SUM_DROP_MAX_H_TABLE = "ATIC_BIZ_FLOW_SUM_DROP_MAX_H";
    private static final String BIZ_SUM_TABLE_MAX = "ATIC_BIZ_FLOW_SUM_MAX";
    private static final String BIZ_DROP_SUM_TABLE_MAX = "ATIC_BIZ_FLOW_SUM_DROP_MAX";

    @Override
    protected String getTableName(BizTotalFlowEvent o) {
        if (o.isIsDropFlow()) {
            if (o.isIsHourEvent()) {
                if (o.isIsMaxEvent()) {
                    return BIZ_SUM_DROP_MAX_H_TABLE;
                }
                return BIZ_SUM_DROP_H_TABLE;
            }
            if (o.isIsMaxEvent()) {
                return BIZ_DROP_SUM_TABLE_MAX;
            }
            return BIZ_SUM_DROP_TABLE;
        }
        if (o.isIsHourEvent()) {
            if (o.isIsMaxEvent()) {
                return BIZ_SUM_MAX_H_TABLE;
            }
            return BIZ_SUM_H_TABLE;
        }
        if (o.isIsMaxEvent()) {
            return BIZ_SUM_TABLE_MAX;
        }
        return BIZ_SUM_TABLE;
    }

    @Override
    protected String getEventHeader(BizTotalFlowEvent o) {
        BizTotalFlowEvent event = o;
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getLogTime() / 1000L);
        buffer.append(";");
        buffer.append(event.getDeviceIp());
        buffer.append(";");
        buffer.append(event.getDeviceType());
        buffer.append(";");
        buffer.append(event.getZoneId());
        buffer.append(";");
        buffer.append(event.getBizId());
        buffer.append(";");
        return buffer.toString();
    }

    @Override
    protected String getDbString(BizTotalFlowEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getTotalPps());
        buffer.append(";");
        buffer.append(event.getTotalKbps());
        if (!event.isIsMaxEvent() && event.isIsDropFlow()) {
            buffer.append(";");
            buffer.append(event.getAllReboundPps());
            buffer.append(";");
            buffer.append(event.getAllReboundKbps());
        }
        return buffer.toString();
    }
}

