/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.DnsRequestType2Str;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.ContentTopnEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ContentTopnEventRepository
extends RepositoryAdaptor<ContentTopnEvent> {
    private static final String DNS_TOPN_INSERT_SQL = " (LOG_TIME, DEVICE_IP ,DEVICE_TYPE,ZONE_ID,BIZ_ID,TOPN_TYPE,DNS_NAME,REQUEST_TYPE,REQUEST_PPS,REQUEST_KBPS) Values(?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_PREFIX = "INSERT INTO ";
    private static final String DNS_TOPN_TABLE_NAME = "ATIC_DNS_TOPN";
    private static final String DNS_TOPN_TABLE_NAME_H = "ATIC_DNS_TOPN_H";
    private List<ContentTopnEvent> dnsTopnList = new ArrayList<ContentTopnEvent>();
    private List<ContentTopnEvent> dnsTopnHourList = new ArrayList<ContentTopnEvent>();

    @Override
    public void createObjects(List<ContentTopnEvent> eventList) {
        this.dnsTopnList.clear();
        this.dnsTopnHourList.clear();
        this.dividEvents(eventList);
        if (!this.dnsTopnList.isEmpty()) {
            this.createDnsTopnBatch(this.dnsTopnList, DNS_TOPN_TABLE_NAME);
        }
        if (!this.dnsTopnHourList.isEmpty()) {
            this.createDnsTopnBatch(this.dnsTopnHourList, DNS_TOPN_TABLE_NAME_H);
        }
    }

    private void dividEvents(List<ContentTopnEvent> eventList) {
        if (!eventList.isEmpty()) {
            for (ContentTopnEvent each : eventList) {
                if (each.isIsHourEvent()) {
                    this.dnsTopnHourList.add(each);
                    continue;
                }
                this.dnsTopnList.add(each);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDnsTopnBatch(List<ContentTopnEvent> dnsStatisList, String tableName) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement(INSERT_PREFIX + tableName + DNS_TOPN_INSERT_SQL);
            for (ContentTopnEvent each : dnsStatisList) {
                insert.setLong(1, each.getLogTime() / 1000L);
                insert.setString(2, each.getDeviceIp());
                insert.setLong(3, each.getDeviceType());
                insert.setLong(4, each.getZoneId());
                insert.setLong(5, each.getBizId());
                insert.setLong(6, each.getTopnType());
                insert.setString(7, each.getDomianName());
                insert.setString(8, DnsRequestType2Str.int2Str(each.getRequestType()));
                insert.setLong(9, each.getRequestPps());
                insert.setLong(10, each.getRequsetKbps());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            ContentTopnEventRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"insert DnsTopnEvent to DB error");
        }
        finally {
            ContentTopnEventRepository.freeDbResource(con, insert);
        }
    }
}

