/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.DbWriteTool;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class EventFileRepository<T extends Event>
extends RepositoryAdaptor<T> {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private DbWriteTool writer = DbWriteTool.getInstance();
    private List<String> classLst = new ArrayList<String>();

    @Override
    public void createObjects(List<T> objs) {
        List<T> events = this.filter(objs);
        if (!events.isEmpty()) {
            Event o = (Event)events.get(0);
            String tableName = this.getTableName(o);
            try {
                String[] lines = new String[events.size()];
                int i = 0;
                for (Event each : events) {
                    lines[i] = this.getEventHeader(each) + this.getDbString(each) + LogManager.NEXT_LINE;
                    ++i;
                }
                this.writer.writeToDb(tableName, lines);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"writeToDb error");
            }
        }
    }

    protected List<T> filter(List<T> objs) {
        return objs;
    }

    protected abstract String getDbString(T var1);

    protected abstract String getTableName(T var1);

    protected String getEventHeader(T o) {
        T event = o;
        this.setClassStr();
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Event)event).getLogTime() / 1000L);
        buffer.append(";");
        buffer.append(((Event)event).getDeviceIp());
        buffer.append(";");
        if (this.classLst.contains(event.getClass().getName())) {
            buffer.append(((Event)event).getDirection());
            buffer.append(";");
        }
        buffer.append(((Event)event).getDeviceType());
        buffer.append(";");
        if (((Event)event).isDeviceEvent()) {
            return buffer.toString();
        }
        if (((Event)event).isSlotEvent()) {
            buffer.append(((Event)event).getSlotId());
            buffer.append(";");
            return buffer.toString();
        }
        if (((Event)event).isZoneEvent()) {
            buffer.append(((Event)event).getZoneId());
            buffer.append(";");
            buffer.append(((Event)event).getBizId());
            buffer.append(";");
            return buffer.toString();
        }
        if (((Event)event).isIpLocationEvent()) {
            buffer.append(((Event)event).getZoneId());
            buffer.append(";");
            buffer.append(((Event)event).getIpLocationId());
            buffer.append(";");
            return buffer.toString();
        }
        buffer.append(((Event)event).getZoneId());
        buffer.append(";");
        buffer.append(((Event)event).getBizId());
        buffer.append(";");
        buffer.append(((Event)event).getZoneIp());
        buffer.append(";");
        return buffer.toString();
    }

    private void setClassStr() {
        if (0 == this.classLst.size()) {
            this.classLst.add("com.hs.atic.collector.entity.event.InFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.DiscardFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.ForwardFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.AttackTypeEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.BaseLineEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.BaseLineNfaEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.DevTotalFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.IpTotalFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.SumDiscardEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.SumInFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.SumForwardFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.ZoneTotalFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.SlotTotalFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.SumMinFlowEvent");
            this.classLst.add("com.hs.atic.collector.entity.event.ZoneAttackEvent");
        }
    }
}

