/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExceptionRepository
extends RepositoryAdaptor<ExceptionEvent> {
    public static final int NORMAL = 0;
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final String TABLE = "ATIC_IP_ATTACK_EXACT_LOG";
    private static final String ONLY_ATTACK_TABLE = "ATIC_ATTACK_LOG";
    private static final String INSERATIC_ROW_INFO = "(PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TYPE,PROTOCOL,PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE,CURRENT_VALUE,LIMIT_VALUE,PPS_OR_KBPS,MAX_DROP_PPS,MAX_DROP_KBPS,CURRENT_VALUE_1,LIMIT_VALUE_1,PPS_OR_KBPS_1,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERATIC_ONLY_ATTACK_ROW_INFO = "(PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TYPE,PROTOCOL,PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE,CURRENT_VALUE,LIMIT_VALUE,MAX_DROP_PPS,MAX_DROP_KBPS,PPS_OR_KBPS,CURRENT_VALUE_1,LIMIT_VALUE_1,PPS_OR_KBPS_1,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ROW_INFO = "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_STATUS=?,DROP_KBITS = ?,DROP_PACKETS=?,SRC_IP=?,SRC_IP_FLOW=?,CURRENT_VALUE=?,LIMIT_VALUE=?,PPS_OR_KBPS= ?,MAX_DROP_PPS = ? ,MAX_DROP_KBPS = ?,CURRENT_VALUE_1 = ? ,LIMIT_VALUE_1 = ? , PPS_OR_KBPS_1 = ?, IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=?,PORTS=? where PKID = ?";
    private static final String UPDATE_ONLY_ATTACK_ROW_INFO = "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_STATUS=?,DROP_KBITS = ?,DROP_PACKETS=?,SRC_IP=?,SRC_IP_FLOW=?,CURRENT_VALUE=?,LIMIT_VALUE=?,PPS_OR_KBPS= ?,MAX_DROP_PPS = ? ,MAX_DROP_KBPS = ?,CURRENT_VALUE_1 = ? ,LIMIT_VALUE_1 = ? , PPS_OR_KBPS_1 = ?, IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=?,PORTS=? where PKID = ?";
    private static final String UPDATE_ROW_INFO_WITH_DEFEND = "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_STATUS=?,DROP_KBITS = ?,DROP_PACKETS=?,SRC_IP=?,SRC_IP_FLOW=?,INTERACTIVE=?,CURRENT_VALUE=?,LIMIT_VALUE=? ,PPS_OR_KBPS= ?,MAX_DROP_PPS = ? ,MAX_DROP_KBPS = ?,CURRENT_VALUE_1 = ? ,LIMIT_VALUE_1 = ? , PPS_OR_KBPS_1 = ?, IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=?,PORTS=? where PKID = ?";
    private static final String UPDATE_ONLY_ATTACK_ROW_INFO_WITH_DEFEND = "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_STATUS=?,DROP_KBITS = ?,DROP_PACKETS=?,SRC_IP=?,SRC_IP_FLOW=?,INTERACTIVE=?,CURRENT_VALUE=?,LIMIT_VALUE=? ,PPS_OR_KBPS= ?,MAX_DROP_PPS = ? ,MAX_DROP_KBPS = ?,CURRENT_VALUE_1 = ? ,LIMIT_VALUE_1 = ? , PPS_OR_KBPS_1 = ? ,IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=?,PORTS=? where PKID = ?";

    @Override
    public void createObjects(List<ExceptionEvent> objs) {
        if (!objs.isEmpty()) {
            this.createExceptionEvent(objs);
        }
    }

    @Override
    public List<ExceptionEvent> queryObject(Condition condition) {
        Calendar calendar = Calendar.getInstance();
        int yearNum = calendar.get(1);
        calendar.set(1, yearNum - 1);
        ArrayList<ExceptionEvent> events = new ArrayList<ExceptionEvent>();
        events.addAll(this.retreiveExceptionEvents(condition));
        events.addAll(this.retreiveExceptionEvents(condition));
        LOGGER.info((Object)("after query result is :" + events));
        return events;
    }

    @Override
    public void updateObjects(List<ExceptionEvent> objs) {
        if (!objs.isEmpty()) {
            this.updateExceptionEvents(objs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExceptionEvent(List<ExceptionEvent> events) {
        PreparedStatement insert = null;
        PreparedStatement attackSt = null;
        Connection con = null;
        try {
            con = this.getConnection();
            insert = con.prepareStatement("insert into ATIC_IP_ATTACK_EXACT_LOG(PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TYPE,PROTOCOL,PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE,CURRENT_VALUE,LIMIT_VALUE,PPS_OR_KBPS,MAX_DROP_PPS,MAX_DROP_KBPS,CURRENT_VALUE_1,LIMIT_VALUE_1,PPS_OR_KBPS_1,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            attackSt = con.prepareStatement("insert into ATIC_ATTACK_LOG(PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TYPE,PROTOCOL,PORT,ATTACK_STATUS,DROP_KBITS,DROP_PACKETS,SRC_IP,SRC_IP_FLOW,INTERACTIVE,CURRENT_VALUE,LIMIT_VALUE,MAX_DROP_PPS,MAX_DROP_KBPS,PPS_OR_KBPS,CURRENT_VALUE_1,LIMIT_VALUE_1,PPS_OR_KBPS_1,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN,PORTS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (ExceptionEvent each : events) {
                int insertIndex = 2;
                int attackIndex = 2;
                long endTime = (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L;
                String ipAttackors = "";
                String srcAttackorFow = "";
                if ("NFA".equals(each.getIdentifier().getDeviceTypeName())) {
                    List<String> attackSrcIpAndFlowString = CommonUtil.getAttackSrcIpAndFlowString(each.getAttackers(), each.getAttackerFlowData());
                    if (2 == attackSrcIpAndFlowString.size()) {
                        ipAttackors = attackSrcIpAndFlowString.get(0);
                        srcAttackorFow = attackSrcIpAndFlowString.get(1);
                    }
                } else {
                    ipAttackors = CommonUtil.getIpString(each.getAttackers(), 5000);
                }
                insert.setString(insertIndex++, each.getDeviceIp());
                insert.setInt(insertIndex++, each.getDirection());
                insert.setLong(insertIndex++, each.getDeviceType());
                insert.setLong(insertIndex++, each.getZoneId());
                insert.setLong(insertIndex++, each.getBizId());
                insert.setString(insertIndex++, each.getZoneIp());
                insert.setLong(insertIndex++, each.getAlertStartTime() / 1000L);
                insert.setLong(insertIndex++, each.getAttackStartTime() / 1000L);
                insert.setLong(insertIndex++, endTime);
                insert.setLong(insertIndex++, each.getDuration());
                insert.setLong(insertIndex++, each.getAttackType().getTypeValue());
                int insetProtocol = each.getAttackType().getProtocol();
                if (insetProtocol == 0) {
                    insetProtocol = each.getAttackType().getFilterProtocol();
                }
                insert.setLong(insertIndex++, insetProtocol);
                insert.setLong(insertIndex++, each.getAttackType().getPort());
                insert.setByte(insertIndex++, (byte)each.getCurrentState());
                insert.setLong(insertIndex++, each.getDropKbits());
                insert.setLong(insertIndex++, each.getDropPkgs());
                insert.setString(insertIndex++, ipAttackors);
                insert.setString(insertIndex++, srcAttackorFow);
                attackSt.setString(attackIndex++, each.getDeviceIp());
                attackSt.setInt(attackIndex++, each.getDirection());
                attackSt.setLong(attackIndex++, each.getDeviceType());
                attackSt.setLong(attackIndex++, each.getZoneId());
                attackSt.setLong(attackIndex++, each.getBizId());
                attackSt.setString(attackIndex++, each.getZoneIp());
                attackSt.setLong(attackIndex++, each.getAlertStartTime() / 1000L);
                attackSt.setLong(attackIndex++, each.getAttackStartTime() / 1000L);
                attackSt.setLong(attackIndex++, endTime);
                attackSt.setLong(attackIndex++, each.getDuration());
                attackSt.setLong(attackIndex++, each.getAttackType().getTypeValue());
                attackSt.setLong(attackIndex++, each.getAttackType().getProtocol());
                int attackProtocol = each.getAttackType().getProtocol();
                if (attackProtocol == 0) {
                    attackProtocol = each.getAttackType().getFilterProtocol();
                }
                attackSt.setLong(attackIndex++, attackProtocol);
                attackSt.setByte(attackIndex++, (byte)each.getCurrentState());
                attackSt.setLong(attackIndex++, each.getDropKbits());
                attackSt.setLong(attackIndex++, each.getDropPkgs());
                attackSt.setString(attackIndex++, ipAttackors);
                attackSt.setString(attackIndex++, srcAttackorFow);
                if (each.isAttack()) {
                    insert.setLong(insertIndex++, 2L);
                    attackSt.setLong(attackIndex++, 2L);
                } else {
                    insert.setLong(insertIndex++, 0L);
                    attackSt.setLong(attackIndex++, 0L);
                }
                insert.setLong(insertIndex++, each.getRealValue());
                insert.setLong(insertIndex++, each.getNormalValue());
                insert.setInt(insertIndex++, each.getPpsOrKbps());
                insert.setLong(insertIndex++, each.getAttackPeakPpsOrQps());
                insert.setLong(insertIndex++, each.getAttackPeakKbps());
                insert.setLong(insertIndex++, each.getRealValue1());
                insert.setLong(insertIndex++, each.getNormalValue1());
                insert.setInt(insertIndex++, each.getPpsOrKbps1());
                insert.setLong(insertIndex++, each.getIpAttackPeakPps());
                insert.setLong(insertIndex++, each.getIpAttackPeakKbps());
                insert.setLong(insertIndex++, each.getIpInPeakPps());
                insert.setLong(insertIndex++, each.getIpInPeakKbps());
                insert.setLong(insertIndex++, each.getTcpNewConnNum());
                insert.setLong(insertIndex++, each.getTcpCurConnNum());
                insert.setString(insertIndex++, CommonUtil.tansPortsSet2String(each.getPorts()));
                attackSt.setLong(attackIndex++, each.getRealValue());
                attackSt.setLong(attackIndex++, each.getNormalValue());
                attackSt.setLong(attackIndex++, each.getAttackPeakPpsOrQps());
                attackSt.setLong(attackIndex++, each.getAttackPeakKbps());
                attackSt.setInt(attackIndex++, each.getPpsOrKbps());
                attackSt.setLong(attackIndex++, each.getRealValue1());
                attackSt.setLong(attackIndex++, each.getNormalValue1());
                attackSt.setInt(attackIndex++, each.getPpsOrKbps1());
                attackSt.setLong(attackIndex++, each.getIpAttackPeakPps());
                attackSt.setLong(attackIndex++, each.getIpAttackPeakKbps());
                attackSt.setLong(attackIndex++, each.getIpInPeakPps());
                attackSt.setLong(attackIndex++, each.getIpInPeakKbps());
                attackSt.setLong(attackIndex++, each.getTcpNewConnNum());
                attackSt.setLong(attackIndex++, each.getTcpCurConnNum());
                attackSt.setString(attackIndex++, CommonUtil.tansPortsSet2String(each.getPorts()));
                attackSt.setLong(1, each.getAbnormalPkId());
                insert.setLong(1, each.getAbnormalPkId());
                if (!each.isNormal()) {
                    attackSt.addBatch();
                }
                insert.addBatch();
            }
            insert.executeBatch();
            attackSt.executeBatch();
            for (ExceptionEvent each : events) {
                each.setHasInserted(true);
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"create originalExceptionEvents to DB error");
                for (ExceptionEvent each : events) {
                    each.setHasInserted(true);
                }
            }
            catch (Throwable throwable) {
                ExceptionRepository.freeDbResource(con, insert);
                ExceptionRepository.freeDbResource(null, attackSt);
                throw throwable;
            }
            ExceptionRepository.freeDbResource(con, insert);
            ExceptionRepository.freeDbResource(null, attackSt);
        }
        ExceptionRepository.freeDbResource(con, insert);
        ExceptionRepository.freeDbResource(null, attackSt);
    }

    private Collection<ExceptionEvent> retreiveExceptionEvents(Condition condition) {
        ArrayList<ExceptionEvent> events = new ArrayList<ExceptionEvent>();
        events.addAll(this.retrieveExceptionEvents(true, condition));
        events.addAll(this.retrieveExceptionEvents(false, condition));
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ExceptionEvent> retrieveExceptionEvents(boolean isFromCleanDevice, Condition condition) {
        ArrayList<ExceptionEvent> pkId2;
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<ExceptionEvent> list = new ArrayList<ExceptionEvent>();
        String sql = "select * from ATIC_IP_ATTACK_EXACT_LOG where " + condition.toSql();
        try {
            con = this.getConnection();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> conList = conditionClause.getValueList();
                for (int i = 0; i < conList.size(); ++i) {
                    query.setObject(i + 1, conList.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                long pkId2 = result.getLong(1);
                long zoneId = result.getLong(3);
                long startTimeAlert = result.getLong(5) * 1000L;
                long startTimeAttack = result.getLong(6) * 1000L;
                long endTime = result.getLong(7) * 1000L;
                int alertType = result.getInt(9);
                int protocol = result.getInt(10);
                int port = result.getInt(11);
                int attackStatus = result.getInt(12);
                long dropKbits = result.getLong(13);
                long dropPackgets = result.getLong(14);
                Set<String> attackers = CommonUtil.transIpString2Set(result.getString(15));
                EventIdentifier identifier = new EventIdentifier();
                identifier.setDeviceIp(result.getString(2));
                identifier.setZoneIp(result.getString(4));
                identifier.setZoneId(zoneId);
                identifier.setLogTime(startTimeAlert);
                if (isFromCleanDevice) {
                    identifier.setDeviceType(0);
                } else {
                    identifier.setDeviceType(1);
                }
                ExceptionEvent event = new ExceptionEvent(identifier);
                if (event.isFromCleanDevice() && startTimeAttack > 0L) {
                    event.setEverAttacked(true);
                }
                event.setEverAlerted(true);
                AttackType type = AttackTypeFactory.getInstance().getAttackType(alertType, protocol, port);
                event.setAttackType(type);
                event.setAlertStartTime(startTimeAlert);
                event.setAttackStartTime(startTimeAttack);
                event.setAlertEndTime(endTime);
                event.setAttackers(attackers);
                event.setCurrentState(attackStatus);
                event.setDropKbits(dropKbits);
                event.setDropPkgs(dropPackgets);
                event.setAbnormalPkId(pkId2);
                list.add(event);
            }
            pkId2 = list;
        }
        catch (SQLException e) {
            ArrayList<ExceptionEvent> arrayList;
            try {
                LOGGER.error((Object)"query ExceptionEvents from DB error");
                arrayList = new ArrayList<ExceptionEvent>();
            }
            catch (Throwable throwable) {
                ExceptionRepository.freeDbResource(con, query, result);
                throw throwable;
            }
            ExceptionRepository.freeDbResource(con, query, result);
            return arrayList;
        }
        ExceptionRepository.freeDbResource(con, query, result);
        return pkId2;
    }

    private void updateExceptionEvents(List<ExceptionEvent> events) {
        ArrayList<ExceptionEvent> defends = new ArrayList<ExceptionEvent>();
        ArrayList<ExceptionEvent> other = new ArrayList<ExceptionEvent>();
        for (ExceptionEvent each : events) {
            if (each.isAttack()) {
                defends.add(each);
                continue;
            }
            other.add(each);
        }
        this.updateBatch(other, TABLE, "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_STATUS=?,DROP_KBITS = ?,DROP_PACKETS=?,SRC_IP=?,SRC_IP_FLOW=?,CURRENT_VALUE=?,LIMIT_VALUE=?,PPS_OR_KBPS= ?,MAX_DROP_PPS = ? ,MAX_DROP_KBPS = ?,CURRENT_VALUE_1 = ? ,LIMIT_VALUE_1 = ? , PPS_OR_KBPS_1 = ?, IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=?,PORTS=? where PKID = ?");
        this.updateAttackTableBatch(other, ONLY_ATTACK_TABLE, "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_STATUS=?,DROP_KBITS = ?,DROP_PACKETS=?,SRC_IP=?,SRC_IP_FLOW=?,CURRENT_VALUE=?,LIMIT_VALUE=?,PPS_OR_KBPS= ?,MAX_DROP_PPS = ? ,MAX_DROP_KBPS = ?,CURRENT_VALUE_1 = ? ,LIMIT_VALUE_1 = ? , PPS_OR_KBPS_1 = ?, IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=?,PORTS=? where PKID = ?");
        this.updateBatchDefends(defends, TABLE, UPDATE_ROW_INFO_WITH_DEFEND);
        this.updateBatchDefends(defends, ONLY_ATTACK_TABLE, UPDATE_ONLY_ATTACK_ROW_INFO_WITH_DEFEND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatchDefends(List<ExceptionEvent> events, String tableName, String updateStr) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement("update " + tableName + " set " + updateStr);
            for (ExceptionEvent each : events) {
                insert.setLong(1, each.getAttackStartTime() / 1000L);
                insert.setLong(2, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
                insert.setLong(3, each.getDuration());
                insert.setByte(4, (byte)each.getCurrentState());
                insert.setLong(5, each.getDropKbits());
                insert.setLong(6, each.getDropPkgs());
                String ipAttackors = "";
                String srcAttackorFow = "";
                if ("NFA".equals(each.getIdentifier().getDeviceTypeName())) {
                    List<String> attackSrcIpAndFlowString = CommonUtil.getAttackSrcIpAndFlowString(each.getAttackers(), each.getAttackerFlowData());
                    if (2 == attackSrcIpAndFlowString.size()) {
                        ipAttackors = attackSrcIpAndFlowString.get(0);
                        srcAttackorFow = attackSrcIpAndFlowString.get(1);
                    }
                } else {
                    ipAttackors = CommonUtil.getIpString(each.getAttackers(), 5000);
                }
                insert.setString(7, ipAttackors);
                insert.setString(8, srcAttackorFow);
                insert.setInt(9, 2);
                insert.setLong(10, each.getRealValue());
                insert.setLong(11, each.getNormalValue());
                insert.setInt(12, each.getPpsOrKbps());
                insert.setLong(13, each.getAttackPeakPpsOrQps());
                insert.setLong(14, each.getAttackPeakKbps());
                insert.setLong(15, each.getRealValue1());
                insert.setLong(16, each.getNormalValue1());
                insert.setInt(17, each.getPpsOrKbps1());
                insert.setLong(18, each.getIpAttackPeakPps());
                insert.setLong(19, each.getIpAttackPeakKbps());
                insert.setLong(20, each.getIpInPeakPps());
                insert.setLong(21, each.getIpInPeakKbps());
                insert.setLong(22, each.getTcpNewConnNum());
                insert.setLong(23, each.getTcpCurConnNum());
                insert.setString(24, CommonUtil.tansPortsSet2String(each.getPorts()));
                insert.setLong(25, each.getAbnormalPkId());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            ExceptionRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"update originalExceptionEvents to DB error");
        }
        finally {
            ExceptionRepository.freeDbResource(con, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatch(List<ExceptionEvent> events, String tableName, String updateStr) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement("update " + tableName + " set " + updateStr);
            for (ExceptionEvent each : events) {
                insert.setLong(1, each.getAttackStartTime() / 1000L);
                insert.setLong(2, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
                insert.setLong(3, each.getDuration());
                insert.setByte(4, (byte)each.getCurrentState());
                insert.setLong(5, each.getDropKbits());
                insert.setLong(6, each.getDropPkgs());
                String ipAttackors = "";
                String srcAttackorFow = "";
                if ("NFA".equals(each.getIdentifier().getDeviceTypeName())) {
                    List<String> attackSrcIpAndFlowString = CommonUtil.getAttackSrcIpAndFlowString(each.getAttackers(), each.getAttackerFlowData());
                    if (2 == attackSrcIpAndFlowString.size()) {
                        ipAttackors = attackSrcIpAndFlowString.get(0);
                        srcAttackorFow = attackSrcIpAndFlowString.get(1);
                    }
                } else {
                    ipAttackors = CommonUtil.getIpString(each.getAttackers(), 5000);
                }
                insert.setString(7, ipAttackors);
                insert.setString(8, srcAttackorFow);
                insert.setLong(9, each.getRealValue());
                insert.setLong(10, each.getNormalValue());
                insert.setInt(11, each.getPpsOrKbps());
                insert.setLong(12, each.getAttackPeakPpsOrQps());
                insert.setLong(13, each.getAttackPeakKbps());
                insert.setLong(14, each.getRealValue1());
                insert.setLong(15, each.getNormalValue1());
                insert.setInt(16, each.getPpsOrKbps1());
                insert.setLong(17, each.getIpAttackPeakPps());
                insert.setLong(18, each.getIpAttackPeakKbps());
                insert.setLong(19, each.getIpInPeakPps());
                insert.setLong(20, each.getIpInPeakKbps());
                insert.setLong(21, each.getTcpNewConnNum());
                insert.setLong(22, each.getTcpCurConnNum());
                insert.setString(23, CommonUtil.tansPortsSet2String(each.getPorts()));
                insert.setLong(24, each.getAbnormalPkId());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            ExceptionRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"update originalExceptionEvents to DB error");
        }
        finally {
            ExceptionRepository.freeDbResource(con, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttackTableBatch(List<ExceptionEvent> events, String tableName, String updateStr) {
        block10: {
            Connection con = null;
            PreparedStatement insert = null;
            PreparedStatement delete = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                insert = con.prepareStatement("update " + tableName + " set " + updateStr);
                delete = con.prepareStatement("DELETE FROM  " + tableName + " WHERE PKID = ?  ");
                for (ExceptionEvent each : events) {
                    if (each.getCurrentState() == 0) {
                        delete.setLong(1, each.getAbnormalPkId());
                        delete.addBatch();
                        continue;
                    }
                    insert.setLong(1, each.getAttackStartTime() / 1000L);
                    insert.setLong(2, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
                    insert.setLong(3, each.getDuration());
                    insert.setByte(4, (byte)each.getCurrentState());
                    insert.setLong(5, each.getDropKbits());
                    insert.setLong(6, each.getDropPkgs());
                    String ipAttackors = "";
                    String srcAttackorFow = "";
                    if ("NFA".equals(each.getIdentifier().getDeviceTypeName())) {
                        List<String> attackSrcIpAndFlowString = CommonUtil.getAttackSrcIpAndFlowString(each.getAttackers(), each.getAttackerFlowData());
                        if (2 == attackSrcIpAndFlowString.size()) {
                            ipAttackors = attackSrcIpAndFlowString.get(0);
                            srcAttackorFow = attackSrcIpAndFlowString.get(1);
                        }
                    } else {
                        ipAttackors = CommonUtil.getIpString(each.getAttackers(), 5000);
                    }
                    insert.setString(7, ipAttackors);
                    insert.setString(8, srcAttackorFow);
                    insert.setLong(9, each.getRealValue());
                    insert.setLong(10, each.getNormalValue());
                    insert.setInt(11, each.getPpsOrKbps());
                    insert.setLong(12, each.getAttackPeakPpsOrQps());
                    insert.setLong(13, each.getAttackPeakKbps());
                    insert.setLong(14, each.getRealValue1());
                    insert.setLong(15, each.getNormalValue1());
                    insert.setInt(16, each.getPpsOrKbps1());
                    insert.setLong(17, each.getIpAttackPeakPps());
                    insert.setLong(18, each.getIpAttackPeakKbps());
                    insert.setLong(19, each.getIpInPeakPps());
                    insert.setLong(20, each.getIpInPeakKbps());
                    insert.setLong(21, each.getTcpNewConnNum());
                    insert.setLong(22, each.getTcpCurConnNum());
                    insert.setString(23, CommonUtil.tansPortsSet2String(each.getPorts()));
                    insert.setLong(24, each.getAbnormalPkId());
                    insert.addBatch();
                }
                insert.executeBatch();
                delete.executeBatch();
                con.commit();
                ExceptionRepository.freeDbResource(con, insert);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"update originalExceptionEvents to DB error");
                break block10;
            }
            finally {
                ExceptionRepository.freeDbResource(con, insert);
                ExceptionRepository.freeDbResource(null, delete);
            }
            ExceptionRepository.freeDbResource(null, delete);
        }
    }

    private int parseDefendState(List<Integer> state) {
        if (state.size() == 1) {
            int s = state.get(0);
            return s != 0 ? 2 : 0;
        }
        for (Integer stateTmp : state) {
            if (0 != stateTmp) continue;
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getZoneDfendState(long zoneId) {
        int n;
        ArrayList<Integer> state;
        ResultSet result;
        Connection con;
        PreparedStatement query;
        block6: {
            query = null;
            con = null;
            result = null;
            String sql = "select INTERACTIVE from ATIC_ATTACK_LOG where ZONE_ID = ? And DEVICE_TYPE = 0 AND ATTACK_STATUS <> 0  Group by  INTERACTIVE";
            con = this.getConnection();
            query = con.prepareStatement(sql);
            query.setLong(1, zoneId);
            result = query.executeQuery();
            state = new ArrayList<Integer>();
            while (result.next()) {
                int iResult = result.getInt("INTERACTIVE");
                state.add(iResult);
            }
            if (!state.isEmpty()) break block6;
            n = 0;
            ExceptionRepository.freeDbResource(con, query, result);
            return n;
        }
        try {
            n = this.parseDefendState(state);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"when get getZoneDfendState error happend ");
            }
            catch (Throwable throwable) {
                ExceptionRepository.freeDbResource(con, query, result);
                throw throwable;
            }
            ExceptionRepository.freeDbResource(con, query, result);
            return 0;
        }
        ExceptionRepository.freeDbResource(con, query, result);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDefendState(long zoneId, String deviceIp) {
        int n;
        ArrayList<Integer> state;
        ResultSet result;
        Connection con;
        PreparedStatement query;
        block6: {
            query = null;
            deviceIp = IpTransformer.formatIpAddress(deviceIp);
            con = null;
            result = null;
            String sql = "select INTERACTIVE from ATIC_ATTACK_LOG where ZONE_ID = ? And DEVICE_TYPE = 0 AND DEVICE_IP = ? AND ATTACK_STATUS <> 0  Group by  INTERACTIVE";
            con = this.getConnection();
            query = con.prepareStatement(sql);
            query.setLong(1, zoneId);
            query.setString(2, deviceIp);
            result = query.executeQuery();
            state = new ArrayList<Integer>();
            while (result.next()) {
                int iResult = result.getInt("INTERACTIVE");
                state.add(iResult);
            }
            if (!state.isEmpty()) break block6;
            n = 4;
            ExceptionRepository.freeDbResource(con, query, result);
            return n;
        }
        try {
            n = this.parseDefendState(state);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"when get getZoneDfendState error happend ");
            }
            catch (Throwable throwable) {
                ExceptionRepository.freeDbResource(con, query, result);
                throw throwable;
            }
            ExceptionRepository.freeDbResource(con, query, result);
            return 0;
        }
        ExceptionRepository.freeDbResource(con, query, result);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getAttackStatus(long zoneId, String zoneIp, String deviceIp) {
        boolean bl;
        ArrayList<Integer> state;
        ResultSet result;
        Connection con;
        PreparedStatement query;
        block6: {
            query = null;
            con = null;
            result = null;
            String sql = "select ATTACK_STATUS from ATIC_ATTACK_LOG where ZONE_ID = ? AND ZONE_IP = ? AND DEVICE_IP = ? ";
            con = this.getConnection();
            query = con.prepareStatement(sql);
            query.setLong(1, zoneId);
            query.setString(2, zoneIp);
            query.setString(3, deviceIp);
            result = query.executeQuery();
            state = new ArrayList<Integer>();
            while (result.next()) {
                int iResult = result.getInt("ATTACK_STATUS");
                state.add(iResult);
            }
            if (!state.isEmpty()) break block6;
            bl = false;
            ExceptionRepository.freeDbResource(con, query, result);
            return bl;
        }
        try {
            bl = this.parseAttackStatus(state);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"when get getAttackStatusByIp error happend ");
            }
            catch (Throwable throwable) {
                ExceptionRepository.freeDbResource(con, query, result);
                throw throwable;
            }
            ExceptionRepository.freeDbResource(con, query, result);
            return false;
        }
        ExceptionRepository.freeDbResource(con, query, result);
        return bl;
    }

    private boolean parseAttackStatus(List<Integer> state) {
        for (Integer stateTmp : state) {
            if (2 != stateTmp) continue;
            return true;
        }
        return false;
    }
}

