/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class RepositoryAdaptor<T>
implements Repository<T> {
    public static final int CAPACITY_RATE = 1024;
    public static final int TIME_RATE = 1000;
    protected static final Logger LOGGER = LogManager.getInstance().getDBLog();

    @Override
    public void createObject(T obj) {
        ArrayList<T> events = new ArrayList<T>();
        events.add(obj);
        this.createObjects(events);
    }

    @Override
    public void createObjects(List<T> objs) {
    }

    @Override
    public void deleteObject(Condition condition) {
    }

    @Override
    public void deleteObjectList(List<Condition> conditionList) {
    }

    @Override
    public List<T> queryObject(Condition condition) {
        return new ArrayList();
    }

    @Override
    public void updateObject(T obj) {
        ArrayList<T> events = new ArrayList<T>();
        events.add(obj);
        this.updateObjects(events);
    }

    @Override
    public void updateObjects(List<T> objs) {
    }

    @Override
    public void deleteDeailObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteObjectByJdbc(Condition condition, String tableName) {
        PreparedStatement delete = null;
        Connection con = null;
        try {
            con = DBConnPool.getConnection();
            delete = con.prepareStatement("delete from " + tableName + " where " + condition.toSql());
            LOGGER.info((Object)("in the deleteObjectByJdbc " + condition.toSql()));
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    delete.setObject(i + 1, list.get(i));
                }
            }
            delete.execute();
            RepositoryAdaptor.freeDbResource(con, delete);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delete table  error");
        }
        finally {
            RepositoryAdaptor.freeDbResource(con, delete);
        }
    }

    public static void freeDbResource(Connection con, PreparedStatement delete) {
        try {
            if (null != delete) {
                delete.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        if (null != con) {
            try {
                con.setAutoCommit(true);
                con.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when close connection error");
            }
        }
    }

    public static void freeDbResource(Connection con, PreparedStatement delete, ResultSet result) {
        if (null != result) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when resultSet close is error");
            }
        }
        try {
            if (null != delete) {
                delete.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        if (null != con) {
            try {
                con.setAutoCommit(true);
                con.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when close connection error");
            }
        }
    }

    protected Set<AttackType> getAttackTypesFromString(String types) {
        if (types.equals("  ")) {
            return new HashSet<AttackType>();
        }
        String[] typeArrays = types.split(",");
        HashSet<AttackType> result = new HashSet<AttackType>();
        for (String type : typeArrays) {
            result.add(AttackTypeFactory.getInstance().getAttackType(Integer.parseInt(type), 0, 0));
        }
        return result;
    }

    protected String getAttackTypeString(Set<AttackType> types) {
        try {
            StringBuffer value = new StringBuffer();
            if (types.isEmpty()) {
                value.append("  ");
            } else {
                HashSet<Integer> typesCollections = new HashSet<Integer>();
                for (AttackType type : types) {
                    typesCollections.add(type.getTypeValue());
                }
                Iterator<AttackType> itor = typesCollections.iterator();
                while (itor.hasNext()) {
                    Integer typeValues = (Integer)((Object)itor.next());
                    if (CommonUtil.overLength(value.toString() + typeValues + ",", 255)) break;
                    value.append(typeValues);
                    if (!itor.hasNext()) continue;
                    value.append(",");
                }
            }
            return value.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("getAttackTypeString error!!" + e.getMessage()));
            return "  ";
        }
    }

    protected Connection getConnection() throws SQLException {
        return DBConnPool.getConnection();
    }
}

