/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.SrcTopnEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SrcTopnEventRepository
extends RepositoryAdaptor<SrcTopnEvent> {
    private static final String DNS_SRC_TOPN_TABLE_NAME = "ATIC_SRC_DNS_TOPN";
    private static final String DNS_SRC_TOPN_TABLE_NAME_H = "ATIC_SRC_DNS_TOPN_H";
    private static final String DNS_SRC_TOPN_INSERT_SQL = " (LOG_TIME, DEVICE_IP ,DEVICE_TYPE,ZONE_ID,BIZ_ID,SRC_IP,TOPN_TYPE,REQUEST_PPS,REQUEST_KBPS) Values(?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_PREFIX = "INSERT INTO ";
    private List<SrcTopnEvent> dnsSrcTopnList = new ArrayList<SrcTopnEvent>();
    private List<SrcTopnEvent> dnsSrcTopnHourList = new ArrayList<SrcTopnEvent>();

    @Override
    public void createObjects(List<SrcTopnEvent> eventList) {
        this.dnsSrcTopnList.clear();
        this.dnsSrcTopnHourList.clear();
        this.dividEvents(eventList);
        if (!this.dnsSrcTopnList.isEmpty()) {
            this.createDnsTopnBatch(this.dnsSrcTopnList, DNS_SRC_TOPN_TABLE_NAME);
        }
        if (!this.dnsSrcTopnHourList.isEmpty()) {
            this.createDnsTopnBatch(this.dnsSrcTopnHourList, DNS_SRC_TOPN_TABLE_NAME_H);
        }
    }

    private void dividEvents(List<SrcTopnEvent> eventList) {
        if (!eventList.isEmpty()) {
            for (SrcTopnEvent each : eventList) {
                if (each.isIsHourEvent()) {
                    this.dnsSrcTopnHourList.add(each);
                    continue;
                }
                this.dnsSrcTopnList.add(each);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDnsTopnBatch(List<SrcTopnEvent> dnsStatisList, String tableName) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement(INSERT_PREFIX + tableName + DNS_SRC_TOPN_INSERT_SQL);
            for (SrcTopnEvent each : dnsStatisList) {
                insert.setLong(1, each.getLogTime() / 1000L);
                insert.setString(2, each.getDeviceIp());
                insert.setInt(3, each.getDeviceType());
                insert.setLong(4, each.getZoneId());
                insert.setLong(5, each.getBizId());
                insert.setString(6, each.getSrcIp());
                insert.setLong(7, each.getTopnType());
                insert.setLong(8, each.getRequestPps());
                insert.setLong(9, each.getRequestKbps());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            SrcTopnEventRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"insert DnsSrcTopnEvent to DB error");
        }
        finally {
            SrcTopnEventRepository.freeDbResource(con, insert);
        }
    }
}

