/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.BasicFlowRepository;
import com.hs.atic.collector.db.event.EventFileRepository;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.SumDiscardEvent;

public class SumDiscardRepository
extends EventFileRepository<SumDiscardEvent> {
    private static final String IP_PREFIX = "ATIC_IP_DROP_H";
    private static final String ZONE_PREFIX = "ATIC_ZONE_DROP_H";
    private EventFileRepository<FlowEvent> flowReposity = new BasicFlowRepository();

    @Override
    protected String getDbString(SumDiscardEvent event) {
        if (null == event) {
            return "";
        }
        String averageString = null;
        String peakString = this.flowReposity.getDbString(event.getPeakFlow());
        StringBuffer reboundString = new StringBuffer();
        reboundString.append(";");
        FlowEvent flowEvent = event.getAverageFlow();
        if (null != flowEvent && flowEvent instanceof DiscardFlowEvent) {
            averageString = this.flowReposity.getDbString(event.getAverageFlow());
            DiscardFlowEvent fEvent = (DiscardFlowEvent)flowEvent;
            reboundString.append(fEvent.getAllReboundPps());
            reboundString.append(";");
            reboundString.append(fEvent.getAllReboundKbps());
            reboundString.append(";");
            reboundString.append(fEvent.getTcpReboundPps());
            reboundString.append(";");
            reboundString.append(fEvent.getTcpReboundKbps());
            reboundString.append(";");
            reboundString.append(fEvent.getUdpReboundPps());
            reboundString.append(";");
            reboundString.append(fEvent.getUdpReboundKbps());
        }
        return averageString + reboundString.toString() + ";" + peakString;
    }

    @Override
    protected String getTableName(SumDiscardEvent event) {
        if (event.isZoneEvent()) {
            return ZONE_PREFIX;
        }
        return IP_PREFIX;
    }
}

