/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.EventFileRepository;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.SumMinFlowEvent;

public class SumMinFlowRepository
extends EventFileRepository<SumMinFlowEvent> {
    private static final String MIN_SUM_IP_TABLE = "ATIC_MIN_SUM_IP_FLOW";
    private static final String MIN_SUM_ZONE_TABLE = "ATIC_MIN_SUM_ZONE_FLOW";
    private static final String MIN_SUM_DEVICE_TABLE = "ATIC_MIN_SUM_DEV_FLOW";

    @Override
    protected String getEventHeader(SumMinFlowEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getLogTime() / 1000L);
        buffer.append(";");
        buffer.append(event.getDeviceIp());
        buffer.append(";");
        buffer.append(event.getDirection());
        buffer.append(";");
        buffer.append(event.getDeviceType());
        buffer.append(";");
        String sumType = event.getSumType();
        if ("DEVICE".equals(sumType)) {
            return buffer.toString();
        }
        if ("ZONE".equals(sumType)) {
            buffer.append(event.getZoneId());
            buffer.append(";");
            return buffer.toString();
        }
        buffer.append(event.getZoneId());
        buffer.append(";");
        buffer.append(event.getZoneIp());
        buffer.append(";");
        return buffer.toString();
    }

    @Override
    protected String getDbString(SumMinFlowEvent o) {
        StringBuffer buff = new StringBuffer();
        FlowEvent inFlowEvent = o.getInFlowEvent();
        FlowEvent inFlowMax = o.getInFlowMax();
        FlowEvent dropFlowEvent = o.getDropFlowEvent();
        FlowEvent dropFlowMax = o.getDropFlowMax();
        buff.append(inFlowEvent.getAllPps());
        buff.append(";");
        buff.append(inFlowMax.getAllPps());
        buff.append(";");
        buff.append(dropFlowEvent.getAllPps());
        buff.append(";");
        buff.append(dropFlowMax.getAllPps());
        buff.append(";");
        buff.append(inFlowEvent.getAllKbps());
        buff.append(";");
        buff.append(inFlowMax.getAllKbps());
        buff.append(";");
        buff.append(dropFlowEvent.getAllKbps());
        buff.append(";");
        buff.append(dropFlowMax.getAllKbps());
        buff.append(";");
        buff.append(inFlowEvent.getTcpPps());
        buff.append(";");
        buff.append(inFlowMax.getTcpPps());
        buff.append(";");
        buff.append(dropFlowEvent.getTcpPps());
        buff.append(";");
        buff.append(dropFlowMax.getTcpPps());
        buff.append(";");
        buff.append(inFlowEvent.getTcpKbps());
        buff.append(";");
        buff.append(inFlowMax.getTcpKbps());
        buff.append(";");
        buff.append(dropFlowEvent.getTcpKbps());
        buff.append(";");
        buff.append(dropFlowMax.getTcpKbps());
        buff.append(";");
        buff.append(inFlowEvent.getUdpPps());
        buff.append(";");
        buff.append(inFlowMax.getUdpPps());
        buff.append(";");
        buff.append(dropFlowEvent.getUdpPps());
        buff.append(";");
        buff.append(dropFlowMax.getUdpPps());
        buff.append(";");
        buff.append(inFlowEvent.getUdpKbps());
        buff.append(";");
        buff.append(inFlowMax.getUdpKbps());
        buff.append(";");
        buff.append(dropFlowEvent.getUdpKbps());
        buff.append(";");
        buff.append(dropFlowMax.getUdpKbps());
        buff.append(";");
        buff.append(inFlowEvent.getIcmpPps());
        buff.append(";");
        buff.append(inFlowMax.getIcmpPps());
        buff.append(";");
        buff.append(dropFlowEvent.getIcmpPps());
        buff.append(";");
        buff.append(dropFlowMax.getIcmpPps());
        buff.append(";");
        buff.append(inFlowEvent.getIcmpKbps());
        buff.append(";");
        buff.append(inFlowMax.getIcmpKbps());
        buff.append(";");
        buff.append(dropFlowEvent.getIcmpKbps());
        buff.append(";");
        buff.append(dropFlowMax.getIcmpKbps());
        buff.append(";");
        buff.append(inFlowEvent.getOtherPps());
        buff.append(";");
        buff.append(inFlowMax.getOtherPps());
        buff.append(";");
        buff.append(dropFlowEvent.getOtherPps());
        buff.append(";");
        buff.append(dropFlowMax.getOtherPps());
        buff.append(";");
        buff.append(inFlowEvent.getOtherKbps());
        buff.append(";");
        buff.append(inFlowMax.getOtherKbps());
        buff.append(";");
        buff.append(dropFlowEvent.getOtherKbps());
        buff.append(";");
        buff.append(dropFlowMax.getOtherKbps());
        buff.append(";");
        return buff.toString();
    }

    @Override
    protected String getTableName(SumMinFlowEvent o) {
        String sumType = o.getSumType();
        if ("DEVICE".equals(sumType)) {
            return MIN_SUM_DEVICE_TABLE;
        }
        if ("ZONE".equals(sumType)) {
            return MIN_SUM_ZONE_TABLE;
        }
        return MIN_SUM_IP_TABLE;
    }
}

