/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.ThirdPartLogServer;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ThirdPartLogServerRepository
extends RepositoryAdaptor<ThirdPartLogServer> {
    private static final String SYS_CONF_TABLE_NAME = "ATIC_SYSTEM_CONF";
    private static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static final String UPDATE_INFO = "SYS_VALUE= ? where SYS_VAR = \"logserver_ip\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ThirdPartLogServer> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<ThirdPartLogServer> logServerList = new ArrayList<ThirdPartLogServer>();
        try {
            con = this.getConnection();
            String tableName = SYS_CONF_TABLE_NAME;
            String sql = "select *  from " + tableName + " where " + condition.toSql();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                String logServerIps = result.getString("SYS_VALUE");
                Set<String> ips = CommonUtil.transIpString2Set(logServerIps);
                for (String ip : ips) {
                    ThirdPartLogServer logServer = new ThirdPartLogServer(ip);
                    logServerList.add(logServer);
                }
            }
            ThirdPartLogServerRepository.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Query Third Part LogServer  error");
        }
        finally {
            ThirdPartLogServerRepository.freeDbResource(con, query, result);
        }
        return logServerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObjects(List<ThirdPartLogServer> logservers) {
        PreparedStatement update = null;
        Connection con = null;
        StringBuffer ips = new StringBuffer();
        try {
            con = this.getConnection();
            String tableName = SYS_CONF_TABLE_NAME;
            String sql = "update " + tableName + " set " + UPDATE_INFO;
            update = con.prepareStatement(sql);
            for (ThirdPartLogServer logserver : logservers) {
                String ip = logserver.getIp();
                ips.append(ip);
                ips.append(',');
            }
            if (logservers.isEmpty()) {
                update.setString(1, "  ");
            } else {
                update.setString(1, ips.toString());
            }
            update.executeUpdate();
            ThirdPartLogServerRepository.freeDbResource(con, update);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Create Third Part Log Server to DB Error");
        }
        finally {
            ThirdPartLogServerRepository.freeDbResource(con, update);
        }
    }
}

