/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ZoneAttackEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ZoneAttackRepository
extends RepositoryAdaptor<ZoneAttackEvent> {
    private static final String TABLE_NAME = "ATIC_ZONE_ATTACK_LOG";
    private static final String INSERATIC_ROW_INFO = "(DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,START_TIME,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ATTACK_TYPES,SRC_IP,DST_IP,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ROW_INFO = "START_TIME= ?,END_TIME= ?,DURATION=?,ATTACK_TIMES=?,ATTACK_STATUS=?,DROP_BYTES=?,DROP_PACKETS=?,ATTACK_TYPES=?,SRC_IP=?,DST_IP=?,MAX_DROP_PPS=?,MAX_DROP_KBPS=?,IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=? where PKID = ?";

    @Override
    public void createObjects(List<ZoneAttackEvent> objs) {
        this.createZoneAttackEvents(objs);
    }

    @Override
    public List<ZoneAttackEvent> queryObject(Condition condition) {
        ArrayList<ZoneAttackEvent> events = new ArrayList<ZoneAttackEvent>();
        events.addAll(this.retreiveZoneAttackEvents(condition));
        LOGGER.debug((Object)("after query , sql is " + condition.toSql() + " the result is " + events));
        return events;
    }

    @Override
    public void updateObjects(List<ZoneAttackEvent> objs) {
        this.updateExceptionEvents(objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZoneAttackEvents(List<ZoneAttackEvent> events) {
        PreparedStatement insert = null;
        Connection con = null;
        String tableName = this.getTable();
        try {
            con = this.getConnection();
            insert = con.prepareStatement("insert into " + tableName + INSERATIC_ROW_INFO, 1);
            for (ZoneAttackEvent each : events) {
                this.doInsertZoneAttack(insert, each);
            }
            ZoneAttackRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"create zoneAttackEvents  to DB error");
        }
        finally {
            ZoneAttackRepository.freeDbResource(con, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertZoneAttack(PreparedStatement insert, ZoneAttackEvent each) {
        ResultSet result = null;
        try {
            int index = 1;
            insert.setString(index++, each.getDeviceIp());
            insert.setInt(index++, each.getDirection());
            insert.setLong(index++, each.getDeviceType());
            insert.setLong(index++, each.getZoneId());
            insert.setLong(index++, each.getAlertStartTime() / 1000L);
            insert.setLong(index++, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
            insert.setLong(index++, each.getDuration());
            insert.setLong(index++, each.getAttackCount());
            insert.setByte(index++, (byte)each.getCurrentState());
            insert.setLong(index++, each.getDropKbits());
            insert.setLong(index++, each.getDropPkgs());
            insert.setString(index++, this.getAttackTypeString(each.getAttackedTypes()));
            insert.setString(index++, CommonUtil.getIpString(each.getAttackers(), 5000));
            insert.setString(index++, CommonUtil.getIpString(each.getAttackedZoneIps(), 5000));
            insert.setLong(index++, each.getAttackPeakPpsOrQps());
            insert.setLong(index++, each.getAttackPeakKbps());
            insert.setLong(index++, each.getIpAttackPeakPps());
            insert.setLong(index++, each.getIpAttackPeakKbps());
            insert.setLong(index++, each.getIpInPeakPps());
            insert.setLong(index++, each.getIpInPeakKbps());
            insert.setLong(index++, each.getTcpNewConnNum());
            insert.setLong(index++, each.getTcpCurConnNum());
            insert.execute();
            result = insert.getGeneratedKeys();
            while (result.next()) {
                each.setAbnormalPkId(result.getLong(1));
            }
            ZoneAttackRepository.freeDbResource(null, null, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"create zoneAttackEvents  to DB error");
        }
        finally {
            ZoneAttackRepository.freeDbResource(null, null, result);
        }
    }

    private String getTable() {
        return TABLE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZoneAttackEvent> queryZoneEvents(Condition condition, boolean isFromClean) {
        ArrayList<ZoneAttackEvent> list = new ArrayList<ZoneAttackEvent>();
        PreparedStatement query = null;
        Connection con = null;
        String tableName = this.getTable();
        ResultSet result = null;
        try {
            con = this.getConnection();
            String sql = "select * from " + tableName + " where " + condition.toSql();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> conList = conditionClause.getValueList();
                for (int i = 0; i < conList.size(); ++i) {
                    query.setObject(i + 1, conList.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                long pkId = result.getLong("PKID");
                String deviceIp = result.getString("DEVICE_IP");
                int direction = result.getInt("DIRECTION");
                int deviceType = result.getInt("DEVICE_TYPE");
                long zoneId = result.getLong("ZONE_ID");
                long startTimeAttack = result.getLong("START_TIME") * 1000L;
                long endTime = result.getLong("END_TIME") * 1000L;
                long attackCount = result.getInt("ATTACK_TIMES");
                int attackStatus = result.getInt("ATTACK_STATUS");
                long dropBytes = result.getLong("DROP_BYTES");
                long dropPackgets = result.getLong("DROP_PACKETS");
                String attackTypes = result.getString("ATTACK_TYPES");
                Set<String> attackers = CommonUtil.transIpString2Set(result.getString("SRC_IP"));
                Set<String> attackedIps = CommonUtil.transIpString2Set(result.getString("DST_IP"));
                EventIdentifier identifier = new EventIdentifier();
                ZoneAttackEvent event = new ZoneAttackEvent(identifier);
                identifier.setDeviceIp(deviceIp);
                identifier.setDirection(direction);
                identifier.setDeviceType(deviceType);
                identifier.setZoneId(zoneId);
                identifier.setLogTime(startTimeAttack);
                if (isFromClean) {
                    event.setEverAttacked(true);
                    event.setAttackStartTime(startTimeAttack);
                }
                event.setEverAlerted(true);
                event.setAlertStartTime(startTimeAttack);
                event.setAlertEndTime(endTime);
                event.setAttackers(attackers);
                event.setCurrentState(attackStatus);
                event.setAttackCount(attackCount);
                event.setDropKbits(dropBytes);
                event.setDropPkgs(dropPackgets);
                event.setAttackZoneIps(attackedIps);
                event.setAttackedTypes(this.getAttackTypesFromString(attackTypes));
                event.setEverAttacked(true);
                event.setAbnormalPkId(pkId);
                list.add(event);
            }
            ArrayList<ZoneAttackEvent> arrayList = list;
            ZoneAttackRepository.freeDbResource(con, query, result);
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query ipAttacks to DB error");
            ArrayList<ZoneAttackEvent> arrayList = new ArrayList<ZoneAttackEvent>();
            return arrayList;
        }
        finally {
            ZoneAttackRepository.freeDbResource(con, query, result);
        }
    }

    private Collection<? extends ZoneAttackEvent> retreiveZoneAttackEvents(Condition condition) {
        ArrayList<ZoneAttackEvent> zoneEvents = new ArrayList<ZoneAttackEvent>();
        zoneEvents.addAll(this.queryZoneEvents(condition, true));
        zoneEvents.addAll(this.queryZoneEvents(condition, false));
        return zoneEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExceptionEvents(List<ZoneAttackEvent> events) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement("update " + this.getTable() + " set " + UPDATE_ROW_INFO);
            for (ZoneAttackEvent each : events) {
                insert.setLong(1, each.getAlertStartTime() / 1000L);
                insert.setLong(2, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
                insert.setLong(3, each.getDuration());
                insert.setLong(4, each.getAttackCount());
                insert.setByte(5, (byte)each.getCurrentState());
                insert.setLong(6, each.getDropKbits());
                insert.setLong(7, each.getDropPkgs());
                StringBuffer types = new StringBuffer();
                Iterator<AttackType> itor = each.getAttackedTypes().iterator();
                while (itor.hasNext()) {
                    AttackType type = itor.next();
                    types.append(type.getTypeValue());
                    if (!itor.hasNext()) continue;
                    types.append(',');
                }
                insert.setString(8, this.getAttackTypeString(each.getAttackedTypes()));
                insert.setString(9, CommonUtil.getIpString(each.getAttackers(), 5000));
                insert.setString(10, CommonUtil.getIpString(each.getAttackedZoneIps(), 5000));
                insert.setLong(11, each.getAttackPeakPpsOrQps());
                insert.setLong(12, each.getAttackPeakKbps());
                insert.setLong(13, each.getIpAttackPeakPps());
                insert.setLong(14, each.getIpAttackPeakKbps());
                insert.setLong(15, each.getIpInPeakPps());
                insert.setLong(16, each.getIpInPeakKbps());
                insert.setLong(17, each.getTcpNewConnNum());
                insert.setLong(18, each.getTcpCurConnNum());
                insert.setLong(19, each.getAbnormalPkId());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            ZoneAttackRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"update ZoneAttackEvents  to DB error");
        }
        finally {
            ZoneAttackRepository.freeDbResource(con, insert);
        }
    }
}

