/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class ZoneBlacklistHistoryRepository {
    private static final String TABLE_NAME = "atic_zone_blacklist_history";
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final int TIME_RATE = 1000;
    private static final String INSERATIC_ROW_INFO = "INSERT INTO atic_zone_blacklist_history( DEVICE_IP,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME,END_TIME,BLACK_IP,PROTOCOL,PORT,BLACK_TYPE,STATUS,ENABLE ) values(?,?,?,?,?,?,?,?,?,?,?,?)";

    public void createObjects(List<ZoneBlackListEvent> objs) throws SQLException {
        if (objs != null && !objs.isEmpty()) {
            LOGGER.info((Object)("create blacklist history begin, list.size=" + objs.size()));
            PreparedStatement insert = null;
            Connection con = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                insert = con.prepareStatement(INSERATIC_ROW_INFO);
                for (ZoneBlackListEvent each : objs) {
                    insert.setString(1, each.getDeviceIp());
                    insert.setLong(2, each.getZoneId());
                    insert.setLong(3, each.getBizId());
                    insert.setString(4, each.getZoneIp());
                    insert.setLong(5, each.getLogTime() / 1000L);
                    insert.setLong(6, each.getEndTime() / 1000L);
                    insert.setString(7, each.getBlackIp());
                    insert.setInt(8, each.getProtocol());
                    insert.setInt(9, each.getPort());
                    insert.setInt(10, each.getBlackListType());
                    insert.setInt(11, each.getStatus());
                    insert.setInt(12, each.getEnable());
                    insert.addBatch();
                }
                insert.executeBatch();
                con.commit();
                LOGGER.info((Object)("create blacklist history end, list.size=" + objs.size()));
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)("create zoneBlackEvent to DB error, list.size=" + objs.size()));
                    throw new SQLException("create zoneBlackEvent to DB error.");
                }
                catch (Throwable throwable) {
                    ZoneBlacklistHistoryRepository.freeDbResource(con, insert);
                    throw throwable;
                }
            }
            ZoneBlacklistHistoryRepository.freeDbResource(con, insert);
        }
    }

    protected Connection getConnection() throws SQLException {
        return DBConnPool.getConnection();
    }

    public static void freeDbResource(Connection con, PreparedStatement delete) {
        try {
            if (null != delete) {
                delete.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        if (null != con) {
            try {
                con.setAutoCommit(true);
                con.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when close connection error");
            }
        }
    }
}

