/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.EventFileRepository;
import com.hs.atic.collector.entity.event.ZoneTotalFlowEvent;

public class ZoneTotalFlowRepository
extends EventFileRepository<ZoneTotalFlowEvent> {
    private static final String MIN_ZONE_SUM_TABLE = "ATIC_MIN_ZONE_FLOW_SUM";
    private static final String MIN_ZONE_SUM_DROP_TABLE = "ATIC_MIN_ZONE_FLOW_SUM_DROP";
    private static final String MIN_ZONE_SUM_MAX_TABLE = "ATIC_MIN_ZONE_FLOW_SUM_MAX";
    private static final String MIN_ZONE_SUM_DROP_MAX_TABLE = "ATIC_MIN_ZONE_FLOW_SUM_DROP_MAX";
    private static final String ZONE_SUM_TABLE = "ATIC_ZONE_FLOW_SUM";
    private static final String ZONE_SUM_H_TABLE = "ATIC_ZONE_FLOW_SUM_H ";
    private static final String ZONE_SUM_MAX_H_TABLE = "ATIC_ZONE_FLOW_SUM_MAX_H ";
    private static final String ZONE_DROP_SUM_TABLE = "ATIC_ZONE_FLOW_SUM_DROP";
    private static final String ZONE_DROP_SUM_H_TABLE = "ATIC_ZONE_FLOW_SUM_DROP_H ";
    private static final String ZONE_DROP_SUM_MAX_H_TABLE = "ATIC_ZONE_FLOW_SUM_DROP_MAX_H ";
    private static final String ZONE_SUM_TABLE_MAX = "ATIC_ZONE_FLOW_SUM_MAX";
    private static final String ZONE_DROP_SUM_TABLE_MAX = "ATIC_ZONE_FLOW_SUM_DROP_MAX";
    private static final String MIN_ZONE_SUM_FOWWARD_MAX_TABLE = "ATIC_MIN_ZONE_FLOW_SUM_FORWARD_MAX";
    private static final String ZONE_SUM_FOWWARD_MAX_TABLE = "ATIC_ZONE_FLOW_SUM_FORWARD_MAX";
    private static final String ZONE_SUM_FOWWARD_MAX_H_TABLE = "ATIC_ZONE_FLOW_SUM_FORWARD_MAX_H";

    @Override
    protected String getTableName(ZoneTotalFlowEvent o) {
        if (o.isIsDropFlow()) {
            if (o.isIsMinSumEvent()) {
                if (o.isIsMaxEvent()) {
                    return MIN_ZONE_SUM_DROP_MAX_TABLE;
                }
                return MIN_ZONE_SUM_DROP_TABLE;
            }
            if (o.isIsHourEvent()) {
                if (o.isIsMaxEvent()) {
                    return ZONE_DROP_SUM_MAX_H_TABLE;
                }
                return ZONE_DROP_SUM_H_TABLE;
            }
            if (o.isIsMaxEvent()) {
                return ZONE_DROP_SUM_TABLE_MAX;
            }
            return ZONE_DROP_SUM_TABLE;
        }
        if (o.isIsForwardFlow()) {
            if (o.isIsMinSumEvent()) {
                return MIN_ZONE_SUM_FOWWARD_MAX_TABLE;
            }
            if (o.isIsHourEvent()) {
                return ZONE_SUM_FOWWARD_MAX_H_TABLE;
            }
            return ZONE_SUM_FOWWARD_MAX_TABLE;
        }
        if (o.isIsMinSumEvent()) {
            if (o.isIsMaxEvent()) {
                return MIN_ZONE_SUM_MAX_TABLE;
            }
            return MIN_ZONE_SUM_TABLE;
        }
        if (o.isIsHourEvent()) {
            if (o.isIsMaxEvent()) {
                return ZONE_SUM_MAX_H_TABLE;
            }
            return ZONE_SUM_H_TABLE;
        }
        if (o.isIsMaxEvent()) {
            return ZONE_SUM_TABLE_MAX;
        }
        return ZONE_SUM_TABLE;
    }

    @Override
    protected String getEventHeader(ZoneTotalFlowEvent o) {
        ZoneTotalFlowEvent event = o;
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getLogTime() / 1000L);
        buffer.append(";");
        buffer.append(event.getDeviceIp());
        buffer.append(";");
        buffer.append(event.getDirection());
        buffer.append(";");
        buffer.append(event.getDeviceType());
        buffer.append(";");
        buffer.append(event.getZoneId());
        buffer.append(";");
        return buffer.toString();
    }

    @Override
    protected String getDbString(ZoneTotalFlowEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getAllPps());
        buffer.append(";");
        buffer.append(event.getAllKbps());
        buffer.append(";");
        buffer.append(event.getTcpPps());
        buffer.append(";");
        buffer.append(event.getTcpKbps());
        buffer.append(";");
        buffer.append(event.getUdpPps());
        buffer.append(";");
        buffer.append(event.getUdpKbps());
        buffer.append(";");
        buffer.append(event.getIcmpPps());
        buffer.append(";");
        buffer.append(event.getIcmpKbps());
        buffer.append(";");
        buffer.append(event.getOtherPps());
        buffer.append(";");
        buffer.append(event.getOtherKbps());
        buffer.append(";");
        buffer.append(event.getHttpPps());
        buffer.append(";");
        buffer.append(event.getHttpKbps());
        buffer.append(";");
        buffer.append(event.getHttpsPps());
        buffer.append(";");
        buffer.append(event.getHttpsKbps());
        buffer.append(";");
        buffer.append(event.getDnsRequestPps());
        buffer.append(";");
        buffer.append(event.getDnsRequestKbps());
        buffer.append(";");
        buffer.append(event.getDnsReplyPps());
        buffer.append(";");
        buffer.append(event.getDnsReplyKbps());
        buffer.append(";");
        buffer.append(event.getSipInvitePps());
        buffer.append(";");
        buffer.append(event.getSipInviteKbps());
        buffer.append(";");
        buffer.append(event.getSipInviteQps());
        buffer.append(";");
        if (!event.isIsForwardFlow()) {
            buffer.append(event.getTcpIncreaseCon());
            buffer.append(";");
            buffer.append(event.getUdpIncreaseCon());
            buffer.append(";");
            buffer.append(event.getIcmpIncreaseCon());
            buffer.append(";");
            buffer.append(event.getOtherIncreaseCon());
            buffer.append(";");
            buffer.append(event.getTcpConcurCon());
            buffer.append(";");
            buffer.append(event.getUdpConcurCon());
            buffer.append(";");
            buffer.append(event.getIcmpConcurCon());
            buffer.append(";");
            buffer.append(event.getOtherConcurCon());
            buffer.append(";");
        }
        buffer.append(event.getTcpFragPps());
        buffer.append(";");
        buffer.append(event.getTcpFragKbps());
        buffer.append(";");
        buffer.append(event.getUdpFragPps());
        buffer.append(";");
        buffer.append(event.getUdpFragKbps());
        buffer.append(";");
        buffer.append(event.getSynPps());
        buffer.append(";");
        buffer.append(event.getSynAckPps());
        buffer.append(";");
        buffer.append(event.getAckPps());
        buffer.append(";");
        buffer.append(event.getFinRstPps());
        if (!event.isIsForwardFlow() && !event.isIsMaxEvent() && event.isIsDropFlow()) {
            buffer.append(";");
            buffer.append(event.getAllReboundPps());
            buffer.append(";");
            buffer.append(event.getAllReboundKbps());
            buffer.append(";");
            buffer.append(event.getTcpReboundPps());
            buffer.append(";");
            buffer.append(event.getTcpReboundKbps());
            buffer.append(";");
            buffer.append(event.getUdpReboundPps());
            buffer.append(";");
            buffer.append(event.getUdpReboundKbps());
            buffer.append(";");
            buffer.append(event.getSynReboundPps());
            buffer.append(";");
            buffer.append(event.getSynAckReboundPps());
        }
        return buffer.toString();
    }
}

