/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.monitor;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DBCollectorDisk {
    public static final long ONE_MINUTE = 60L;
    public static final long ZERO_MINUTE = 0L;
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(List<CollectorDiskObj> cdList) {
        Connection conn = DBConnPool.getConnection();
        Statement stmt = null;
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                conn.setAutoCommit(false);
                String str = "DELETE from ATIC_COLLECTOR_DISK";
                stmt = conn.createStatement();
                stmt.execute(str);
                conn.commit();
                String str2 = "INSERT into ATIC_COLLECTOR_DISK ( MONITOR_TIME, DISK_NAME, DISK_SIZE, DISK_USE_RATIO) Values(?,?,?,?)";
                pstmt = conn.prepareStatement(str2);
                for (int i = 0; i < cdList.size(); ++i) {
                    pstmt.setLong(1, cdList.get(i).getMonitorTime());
                    pstmt.setString(2, cdList.get(i).getDiskName());
                    pstmt.setInt(3, cdList.get(i).getDiskSize());
                    pstmt.setInt(4, cdList.get(i).getDiskUseRatio());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                conn.commit();
                flag = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBCollectorDisk.freeDbResource(conn, stmt, pstmt);
                    throw throwable;
                }
                DBCollectorDisk.freeDbResource(conn, stmt, pstmt);
            }
            DBCollectorDisk.freeDbResource(conn, stmt, pstmt);
        }
        return flag;
    }

    public static void freeDbResource(Connection conn, Statement stmt, PreparedStatement pstmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close statement,some errors happened");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    public static void freeDbResource(Connection conn, PreparedStatement pstmt, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close result,some errors happened");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statment,some errors happened");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CollectorDiskObj> queryCollectorDiskInfo() {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        ArrayList<CollectorDiskObj> list = new ArrayList<CollectorDiskObj>();
        if (conn != null) {
            try {
                long curTime = System.currentTimeMillis() / 1000L;
                String str = "select * from atic_collector_disk where Monitor_time = (select max(MONITOR_TIME) from atic_collector_disk)";
                pstmt = conn.prepareStatement(str);
                result = pstmt.executeQuery();
                while (result.next()) {
                    long monitorTime = result.getLong("MONITOR_TIME");
                    String diskName = result.getString("DISK_NAME");
                    int diskSize = result.getInt("DISK_SIZE");
                    int diskUseRatio = result.getInt("DISK_USE_RATIO");
                    if (curTime - monitorTime > 60L) continue;
                    CollectorDiskObj curCollectorDiskInfo = new CollectorDiskObj(monitorTime, diskName, diskSize, diskUseRatio);
                    list.add(curCollectorDiskInfo);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBCollectorDisk.freeDbResource(conn, pstmt, result);
                    throw throwable;
                }
                DBCollectorDisk.freeDbResource(conn, pstmt, result);
            }
            DBCollectorDisk.freeDbResource(conn, pstmt, result);
        }
        return list;
    }
}

