/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.monitor;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.monitor.CollectorPerfObj;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBCollectorPerf {
    public static final long FIVE_MINUTES = 300L;
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int testDbConn() {
        Connection conn = null;
        try {
            conn = DBConnPool.getConnection();
            if (conn != null) {
                int n = 0;
                return n;
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When close DB connection,some errors happened");
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(CollectorPerfObj cp) {
        Connection conn = DBConnPool.getConnection();
        Statement stmt = null;
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                conn.setAutoCommit(false);
                String strDel = "DELETE from ATIC_COLLECTOR_PERF";
                stmt = conn.createStatement();
                stmt.execute(strDel);
                String str = "INSERT into ATIC_COLLECTOR_PERF(MONITOR_TIME, CPU_USE_RATIO, MEM_USE_RATIO) Values(?,?,?)";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, cp.getMonitorTime());
                pstmt.setInt(2, cp.getCpuUseRatio());
                pstmt.setInt(3, cp.getMemUseRatio());
                pstmt.execute();
                conn.commit();
                flag = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBCollectorPerf.freeDbResource(conn, pstmt, stmt);
                    throw throwable;
                }
                DBCollectorPerf.freeDbResource(conn, pstmt, stmt);
            }
            DBCollectorPerf.freeDbResource(conn, pstmt, stmt);
        }
        return flag;
    }

    public static void freeDbResource(Connection conn, PreparedStatement pstmt, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare stmt,some errors happened");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare pstmt,some errors happened");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    public static void freeDbResource(Connection conn, PreparedStatement pstmt, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close result,some errors happened");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectorPerfObj queryCollectorPerformanceInfo() {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        CollectorPerfObj collectorPerfObj = new CollectorPerfObj();
        if (conn != null) {
            block6: {
                try {
                    long curTime = System.currentTimeMillis() / 1000L;
                    String str = "select * from atic_collector_perf where MONITOR_TIME = (select max(MONITOR_TIME) from atic_collector_perf)";
                    pstmt = conn.prepareStatement(str);
                    result = pstmt.executeQuery();
                    if (!result.next()) break block6;
                    long monitorTime = result.getLong("MONITOR_TIME");
                    int cpuUseRatio = result.getInt("CPU_USE_RATIO");
                    int memUseRatio = result.getInt("MEM_USE_RATIO");
                    if (curTime - monitorTime <= 300L) {
                        collectorPerfObj.setMonitorTime(monitorTime);
                        collectorPerfObj.setCpuUseRatio(cpuUseRatio);
                        collectorPerfObj.setMemUseRatio(memUseRatio);
                        break block6;
                    }
                    LOGGER.error((Object)"Collector update cpu and mem usage more than five minites!");
                }
                catch (SQLException e) {
                    try {
                        LOGGER.error((Object)"When excute sql,some errors happened");
                    }
                    catch (Throwable throwable) {
                        DBCollectorPerf.freeDbResource(conn, pstmt, result);
                        throw throwable;
                    }
                    DBCollectorPerf.freeDbResource(conn, pstmt, result);
                }
            }
            DBCollectorPerf.freeDbResource(conn, pstmt, result);
        }
        return collectorPerfObj;
    }
}

