/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.monitor;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.LogManager;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DBDevice {
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(DeviceObj device) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                String str = "INSERT into ATIC_DEVICE (MO_ID,DEVICE_IP,LOG_IP,DEVICE_TYPE,SERVICE_TYPE,ENCRYPT_TYPE,LOG_PWD) values (?,?,?,?,?,?,?);";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, device.getMoId());
                pstmt.setString(2, device.getDeviceIp());
                pstmt.setString(3, device.getLogIp());
                pstmt.setInt(4, device.getDeviceType());
                pstmt.setInt(5, device.getServiceType());
                pstmt.setInt(6, device.getEncryptType());
                pstmt.setString(7, AticDataProtector.sdpEncrypt(0L, new StringBuffer(device.getLogPwd())));
                pstmt.execute();
                flag = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBDevice.closeConn(pstmt, conn);
                    throw throwable;
                }
                DBDevice.closeConn(pstmt, conn);
            }
            DBDevice.closeConn(pstmt, conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(long deviceId) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                String str = "DELETE FROM  ATIC_DEVICE WHERE MO_ID = ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, deviceId);
                pstmt.execute();
                flag = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBDevice.closeConn(pstmt, conn);
                    throw throwable;
                }
                DBDevice.closeConn(pstmt, conn);
            }
            DBDevice.closeConn(pstmt, conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDdosLogIpByDevId(Long devId) {
        String devIp = null;
        ResultSet result = null;
        PreparedStatement pstmt = null;
        Connection conn = DBConnPool.getConnection();
        if (conn != null) {
            try {
                String str = "SELECT LOG_IP FROM ATIC_DEVICE WHERE MO_ID = ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, devId);
                result = pstmt.executeQuery();
                if (result.next()) {
                    devIp = result.getString("LOG_IP");
                }
                DBDevice.closeConn(pstmt, conn, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened");
            }
            finally {
                DBDevice.closeConn(pstmt, conn, result);
            }
        }
        return devIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceObj queryByDevId(Long devId) {
        DeviceObj deviceObj = null;
        ResultSet result = null;
        PreparedStatement pstmt = null;
        Connection conn = DBConnPool.getConnection();
        if (conn != null) {
            try {
                String str = "SELECT *  FROM ATIC_DEVICE WHERE MO_ID = ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, devId);
                result = pstmt.executeQuery();
                if (result.next()) {
                    deviceObj = new DeviceObj();
                    int deviceType = result.getInt("DEVICE_TYPE");
                    short serType = result.getShort("SERVICE_TYPE");
                    int encryptType = result.getInt("ENCRYPT_TYPE");
                    String logPwd = result.getString("LOG_PWD");
                    String deviceIP = result.getString("DEVICE_IP");
                    StringBuffer decryptPwd = AticDataProtector.sdpDecrypt(0L, logPwd);
                    deviceObj.setDeviceIp(deviceIP);
                    deviceObj.setDeviceType(deviceType);
                    deviceObj.setServiceType(serType);
                    deviceObj.setEncryptType(encryptType);
                    deviceObj.setLogPwd(decryptPwd.toString());
                }
                DBDevice.closeConn(pstmt, conn, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened");
            }
            finally {
                DBDevice.closeConn(pstmt, conn, result);
            }
        }
        return deviceObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceObj query(String deviceIP) {
        DeviceObj deviceObj = null;
        ResultSet result = null;
        PreparedStatement pstmt = null;
        Connection conn = DBConnPool.getConnection();
        if (conn != null) {
            try {
                String str = "SELECT *  FROM ATIC_DEVICE WHERE DEVICE_IP = ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, deviceIP);
                result = pstmt.executeQuery();
                if (result.next()) {
                    deviceObj = new DeviceObj();
                    int deviceType = result.getInt("DEVICE_TYPE");
                    short serType = result.getShort("SERVICE_TYPE");
                    int encryptType = result.getInt("ENCRYPT_TYPE");
                    String logPwd = result.getString("LOG_PWD");
                    StringBuffer decryptPwd = AticDataProtector.sdpDecrypt(0L, logPwd);
                    deviceObj.setDeviceIp(deviceIP);
                    deviceObj.setDeviceType(deviceType);
                    deviceObj.setServiceType(serType);
                    deviceObj.setEncryptType(encryptType);
                    deviceObj.setLogPwd(decryptPwd.toString());
                }
                DBDevice.closeConn(pstmt, conn, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened");
            }
            finally {
                DBDevice.closeConn(pstmt, conn, result);
            }
        }
        return deviceObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceObj> queryDevices() {
        ArrayList<DeviceObj> deviceList = new ArrayList<DeviceObj>();
        ResultSet result = null;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        if (conn != null) {
            try {
                String str = "SELECT *  FROM ATIC_DEVICE ";
                stmt = conn.prepareStatement(str);
                result = stmt.executeQuery();
                while (result.next()) {
                    DeviceObj device = new DeviceObj();
                    long deviceId = result.getLong("MO_ID");
                    String deviceIP = result.getString("DEVICE_IP");
                    String logIP = result.getString("LOG_IP");
                    short serType = result.getShort("SERVICE_TYPE");
                    int deviceType = result.getInt("DEVICE_TYPE");
                    int encryptType = result.getInt("ENCRYPT_TYPE");
                    String logPwd = result.getString("LOG_PWD");
                    StringBuffer decryptPwd = AticDataProtector.sdpDecrypt(0L, logPwd);
                    device.setMoId(deviceId);
                    device.setDeviceIp(deviceIP);
                    device.setLogIp(logIP);
                    device.setServiceType(serType);
                    device.setDeviceType(deviceType);
                    device.setEncryptType(encryptType);
                    device.setLogPwd(decryptPwd.toString());
                    deviceList.add(device);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBDevice.closeConn(stmt, conn, result);
                    throw throwable;
                }
                DBDevice.closeConn(stmt, conn, result);
            }
            DBDevice.closeConn(stmt, conn, result);
        }
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(DeviceObj device) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                String str = "UPDATE ATIC_DEVICE  SET DEVICE_TYPE = ? ,SERVICE_TYPE = ? , LOG_IP = ?, ENCRYPT_TYPE = ?, LOG_PWD = ?   WHERE MO_ID = ? ";
                pstmt = conn.prepareStatement(str);
                pstmt.setInt(1, device.getDeviceType());
                pstmt.setInt(2, device.getServiceType());
                pstmt.setString(3, device.getLogIp());
                pstmt.setInt(4, device.getEncryptType());
                pstmt.setString(5, AticDataProtector.sdpEncrypt(0L, new StringBuffer(device.getLogPwd())));
                pstmt.setLong(6, device.getMoId());
                pstmt.execute();
                flag = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened");
                }
                catch (Throwable throwable) {
                    DBDevice.closeConn(pstmt, conn);
                    throw throwable;
                }
                DBDevice.closeConn(pstmt, conn);
            }
            DBDevice.closeConn(pstmt, conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryConfirmStat(DeviceObj devObj) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            String str = "SELECT IFCHANGE_CONFIRM  FROM ATIC_DEVICE  WHERE DEVICE_IP = ? ";
            try {
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, devObj.getDeviceIp());
                result = pstmt.executeQuery();
                if (result.next()) {
                    int stat = result.getInt("IFCHANGE_CONFIRM");
                    if (stat == 0) {
                        LOGGER.info((Object)"confirm stat is confirmed.");
                    } else if (stat == 1) {
                        LOGGER.info((Object)"confirm stat is unconfirmed.");
                    }
                    int n = stat;
                    DBDevice.closeConn(pstmt, conn, result);
                    return n;
                }
                DBDevice.closeConn(pstmt, conn, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened");
            }
            finally {
                DBDevice.closeConn(pstmt, conn, result);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeConfirmStat(String deviceIp, boolean state) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        if (conn != null) {
            String str = "UPDATE ATIC_DEVICE  SET IF_STATUS =? , IFCHANGE_CONFIRM =?  WHERE DEVICE_IP = ? ";
            try {
                pstmt = conn.prepareStatement(str);
                pstmt.setInt(1, state ? 0 : 1);
                pstmt.setInt(2, state ? 0 : 1);
                pstmt.setString(3, deviceIp);
                pstmt.execute();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened");
                boolean bl = false;
                return bl;
            }
            finally {
                DBDevice.closeConn(pstmt, conn);
            }
        }
        return true;
    }

    public static void closeConn(PreparedStatement pstmt, Connection conn) {
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    public static void closeConn(PreparedStatement pstmt, Connection conn, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close result,some errors happened");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }
}

