/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.report;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.log.AnalyzeSuccessRate;
import com.hs.atic.collector.entity.log.AppFlow;
import com.hs.atic.collector.entity.log.AttackCountCompare;
import com.hs.atic.collector.entity.log.AttackCountTrend;
import com.hs.atic.collector.entity.log.AttackExactFlow;
import com.hs.atic.collector.entity.log.AttackExactLog;
import com.hs.atic.collector.entity.log.AttackFlowPeakTopN;
import com.hs.atic.collector.entity.log.AttackIpCountTrend;
import com.hs.atic.collector.entity.log.AttackLog;
import com.hs.atic.collector.entity.log.AttackTopn;
import com.hs.atic.collector.entity.log.AttackTrend;
import com.hs.atic.collector.entity.log.BisAttackCountTopN;
import com.hs.atic.collector.entity.log.BisAttackTimeTopN;
import com.hs.atic.collector.entity.log.BisTopN;
import com.hs.atic.collector.entity.log.BizTypePoJo;
import com.hs.atic.collector.entity.log.BotLog;
import com.hs.atic.collector.entity.log.BotRequestTimeTopN;
import com.hs.atic.collector.entity.log.ConnCompare;
import com.hs.atic.collector.entity.log.DeviceAttackData;
import com.hs.atic.collector.entity.log.DeviceStopTime;
import com.hs.atic.collector.entity.log.DnsCache;
import com.hs.atic.collector.entity.log.DnsDefendLog;
import com.hs.atic.collector.entity.log.DnsDefendTopN;
import com.hs.atic.collector.entity.log.DnsGraph;
import com.hs.atic.collector.entity.log.DnsTopN;
import com.hs.atic.collector.entity.log.DropTrend;
import com.hs.atic.collector.entity.log.FlowCompare;
import com.hs.atic.collector.entity.log.FlowDistributing;
import com.hs.atic.collector.entity.log.IpAttackCountTopN;
import com.hs.atic.collector.entity.log.IpAttackTimeTopN;
import com.hs.atic.collector.entity.log.IpLocationTopN;
import com.hs.atic.collector.entity.log.IpTopN;
import com.hs.atic.collector.entity.log.NormalAndExceptObject;
import com.hs.atic.collector.entity.log.RequestTrend;
import com.hs.atic.collector.entity.log.SlotFlow;
import com.hs.atic.collector.entity.log.VersionUpgrade;
import com.hs.atic.collector.entity.log.ZoneAttackCountTopN;
import com.hs.atic.collector.entity.log.ZoneAttackTimeTopN;
import com.hs.atic.collector.entity.log.ZoneTopN;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.LogUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DBStat
implements Serializable {
    protected static final Logger LOG = LogManager.getInstance().getDBLog();
    private static final long serialVersionUID = 1305890177944553341L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnCompare> findConnCompare(String sql, Map<Integer, Object> condition) {
        ArrayList<ConnCompare> ccs = new ArrayList<ConnCompare>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ConnCompare cc = new ConnCompare();
                    cc.setLogTime(rs.getLong("LOG_TIME"));
                    cc.setIncreaseConn(rs.getLong("INCREASE_CON"));
                    cc.setCurrentConn(rs.getLong("CUR_CON"));
                    ccs.add(cc);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnCompare> findSrcTcpConn(String sql, Map<Integer, Object> condition) {
        ArrayList<ConnCompare> ccs = new ArrayList<ConnCompare>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ConnCompare cc = new ConnCompare();
                    cc.setLogTime(rs.getLong("LOG_TIME"));
                    cc.setIncreaseConn(rs.getLong("REQUEST_PPS"));
                    cc.setCurrentConn(0L);
                    ccs.add(cc);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IpTopN> findIps(String sql, int gra, boolean isMax, Map<Integer, Object> condition) {
        ArrayList<IpTopN> ips = new ArrayList<IpTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpTopN ipn = new IpTopN();
                    String disIp = rs.getString("ZONE_IP");
                    ipn.setDisIp(disIp);
                    if (isMax) {
                        ipn.setLogTime(rs.getLong("LOG_TIME"));
                    }
                    ipn.setZoneId(rs.getLong("ZONE_ID"));
                    ipn.setZoneIp(disIp);
                    ipn.setKbps(BigDecimal.valueOf(rs.getLong("TOTAL_KBPS")).divide(BigDecimal.valueOf(gra), 2).longValue());
                    ipn.setPps(BigDecimal.valueOf(rs.getLong("TOTAL_PPS")).divide(BigDecimal.valueOf(gra), 2).longValue());
                    ips.add(ipn);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ip top n data----");
            for (IpTopN z : ips) {
                LOG.debug((Object)(z.getDisIp() + " | " + z.getZoneId() + " | " + z.getKbps() + " | " + z.getPps()));
            }
        }
        return ips;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IpTopN> findMaxIps(String sql, Map<Integer, Object> condition) {
        ArrayList<IpTopN> ips = new ArrayList<IpTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpTopN ipn = new IpTopN();
                    String disIp = rs.getString("ZONE_IP");
                    ipn.setDisIp(disIp);
                    ipn.setZoneId(rs.getLong("ZONE_ID"));
                    ipn.setZoneIp(disIp);
                    ipn.setKbps(rs.getLong("TOTAL_KBPS"));
                    ipn.setPps(rs.getLong("TOTAL_PPS"));
                    ipn.setDeviceIp(rs.getString("DEVICE_IP"));
                    ipn.setLogTime(rs.getLong("LOG_TIME"));
                    ips.add(ipn);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ip top n data----");
            for (IpTopN z : ips) {
                LOG.debug((Object)(z.getDisIp() + " | " + z.getZoneId() + " | " + z.getKbps() + " | " + z.getPps()));
            }
        }
        return ips;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BisTopN> findMaxBis(String sql, Map<Integer, Object> condition) {
        ArrayList<BisTopN> bises = new ArrayList<BisTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BisTopN bistopn = new BisTopN();
                    bistopn.setZoneId(rs.getLong("ZONE_ID"));
                    bistopn.setBisId(rs.getLong("BIZ_ID"));
                    bistopn.setKbps(rs.getLong("TOTAL_KBPS"));
                    bistopn.setPps(rs.getLong("TOTAL_PPS"));
                    bistopn.setDeviceIp(rs.getString("DEVICE_IP"));
                    bistopn.setLogTime(rs.getLong("LOG_TIME"));
                    bises.add(bistopn);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---bis top n data----");
            for (BisTopN z : bises) {
                LOG.debug((Object)(z.getBisId() + " | " + z.getZoneId() + " | " + z.getKbps() + " | " + z.getPps()));
            }
        }
        return bises;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<DnsTopN>> findDnsTopN(String sql, int requestType, Map<Integer, Object> condition) {
        HashMap<String, List<DnsTopN>> map = new HashMap<String, List<DnsTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DnsTopN ipn = new DnsTopN();
                    ipn.setLogTime(rs.getLong("LOG_TIME"));
                    if (requestType == 0) {
                        ipn.setDnsName(rs.getString("DNS_NAME"));
                        ipn.setRequestType(rs.getString("REQUEST_TYPE"));
                    } else {
                        ipn.setSrcIp(rs.getString("SRC_IP"));
                    }
                    ipn.setPps(rs.getLong("REQUEST_PPS"));
                    ipn.setKbps(rs.getLong("REQUEST_KBPS"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (map.containsKey(deviceIp)) {
                        ((List)map.get(deviceIp)).add(ipn);
                        continue;
                    }
                    ArrayList<DnsTopN> dnsTopNList = new ArrayList<DnsTopN>();
                    dnsTopNList.add(ipn);
                    map.put(deviceIp, dnsTopNList);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<DnsGraph>> findDnsGraph(String sql, int requestType, Map<Integer, Object> condition) {
        HashMap<String, List<DnsGraph>> map = new HashMap<String, List<DnsGraph>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DnsGraph ipn = new DnsGraph();
                    if (requestType == 0) {
                        ipn.setDnsName(rs.getString("DNS_NAME"));
                        ipn.setRequestType(rs.getString("REQUEST_TYPE"));
                    } else {
                        ipn.setSrcIp(rs.getString("SRC_IP"));
                    }
                    String deviceIp = rs.getString("DEVICE_IP");
                    ipn.setDeviceIp(deviceIp);
                    ipn.setDateTime(rs.getLong("LOG_TIME"));
                    ipn.setPps(rs.getLong("REQUEST_PPS"));
                    ipn.setKbps(rs.getLong("REQUEST_KBPS"));
                    if (map.containsKey(deviceIp)) {
                        ((List)map.get(deviceIp)).add(ipn);
                        continue;
                    }
                    ArrayList<DnsGraph> dnsGraphList = new ArrayList<DnsGraph>();
                    dnsGraphList.add(ipn);
                    map.put(deviceIp, dnsGraphList);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DnsCache> findDnsCache(String sql, Map<Integer, Object> condition) {
        ArrayList<DnsCache> dnsCacheList = new ArrayList<DnsCache>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DnsCache dc = new DnsCache();
                    dc.setDnsId(rs.getLong("DNS_ID"));
                    dc.setDnsName(rs.getString("DNS_NAME"));
                    dc.setRequestType(rs.getString("REQUEST_TYPE"));
                    dc.setBisId(rs.getLong("BIZ_ID"));
                    dc.setZoneId(rs.getLong("ZONE_ID"));
                    dc.setDateTime(rs.getLong("LOG_TIME"));
                    dc.setPps(rs.getLong("REQUEST_PPS"));
                    dnsCacheList.add(dc);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---dns cache n data----");
            for (DnsCache z : dnsCacheList) {
                LOG.debug((Object)(z.getDateTime() + " | " + z.getDnsId() + " |  | " + z.getPps()));
            }
        }
        return dnsCacheList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BisTopN> findBisTopN(String sql, int gra, boolean isMax, Map<Integer, Object> condition) {
        ArrayList<BisTopN> bisTopNList = new ArrayList<BisTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BisTopN bisTopN = new BisTopN();
                    bisTopN.setBisId(rs.getLong("BIZ_ID"));
                    if (isMax) {
                        bisTopN.setLogTime(rs.getLong("LOG_TIME"));
                    }
                    bisTopN.setZoneId(rs.getLong("ZONE_ID"));
                    bisTopN.setKbps(BigDecimal.valueOf(rs.getLong("TOTAL_KBPS")).divide(BigDecimal.valueOf(gra), 2).longValue());
                    bisTopN.setPps(BigDecimal.valueOf(rs.getLong("TOTAL_PPS")).divide(BigDecimal.valueOf(gra), 2).longValue());
                    bisTopNList.add(bisTopN);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---bis top n data----");
            for (BisTopN z : bisTopNList) {
                LOG.debug((Object)(z.getBisId() + " | " + z.getKbps() + " | " + z.getPps()));
            }
        }
        return bisTopNList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoneTopN> findZones(String sql, int gra, Map<Integer, Object> condition) {
        ArrayList<ZoneTopN> zones = new ArrayList<ZoneTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ZoneTopN zone = new ZoneTopN();
                    long zoneId = rs.getLong("ZONE_ID");
                    zone.setZoneId(zoneId);
                    zone.setLogTime(rs.getLong("LOG_TIME"));
                    zone.setKbps(BigDecimal.valueOf(rs.getLong("TOTAL_KBPS")).divide(BigDecimal.valueOf(gra), 2).longValue());
                    zone.setPps(BigDecimal.valueOf(rs.getLong("TOTAL_PPS")).divide(BigDecimal.valueOf(gra), 2).longValue());
                    zones.add(zone);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ip top n data----");
            for (ZoneTopN z : zones) {
                LOG.debug((Object)(z.getZoneId() + " | " + z.getKbps() + " | " + z.getPps()));
            }
        }
        return zones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoneTopN> findMaxZones(String sql, Map<Integer, Object> condition) {
        ArrayList<ZoneTopN> zones = new ArrayList<ZoneTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ZoneTopN zone = new ZoneTopN();
                    zone.setZoneId(rs.getLong("ZONE_ID"));
                    zone.setKbps(rs.getLong("TOTAL_KBPS"));
                    zone.setPps(rs.getLong("TOTAL_PPS"));
                    zone.setLogTime(rs.getLong("LOG_TIME"));
                    zone.setDeviceIp(rs.getString("DEVICE_IP"));
                    zones.add(zone);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---zone top n data----");
            for (ZoneTopN z : zones) {
                LOG.debug((Object)(z.getZoneId() + " | " + z.getKbps() + " | " + z.getPps() + " | " + z.getLogTime()));
            }
        }
        return zones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowDistributing> getFlowDis(String sql, int gra, Map<Integer, Object> condition) {
        ArrayList<FlowDistributing> fds = new ArrayList<FlowDistributing>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        double base = 1.0;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    FlowDistributing tcp = new FlowDistributing();
                    FlowDistributing udp = new FlowDistributing();
                    FlowDistributing icmp = new FlowDistributing();
                    FlowDistributing other = new FlowDistributing();
                    double tcpFlow = (double)rs.getLong("TCP") * base / (double)gra;
                    double udpFlow = (double)rs.getLong("UDP") * base / (double)gra;
                    double icmpFlow = (double)rs.getLong("ICMP") * base / (double)gra;
                    double otherFlow = (double)rs.getLong("OTHER") * base / (double)gra;
                    Long logTime = rs.getLong("LOGTIME");
                    tcp.setProtocol(1);
                    tcp.setFlow(tcpFlow);
                    tcp.setLogTime(logTime);
                    fds.add(tcp);
                    udp.setProtocol(2);
                    udp.setFlow(udpFlow);
                    udp.setLogTime(logTime);
                    fds.add(udp);
                    icmp.setProtocol(3);
                    icmp.setFlow(icmpFlow);
                    icmp.setLogTime(logTime);
                    fds.add(icmp);
                    other.setProtocol(4);
                    other.setFlow(otherFlow);
                    other.setLogTime(logTime);
                    fds.add(other);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---flow dis(no zoneId,no zoneIp) data----");
            for (FlowDistributing fd : fds) {
                LOG.debug((Object)(fd.getProtocol() + " : " + fd.getFlow()));
            }
        }
        return fds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowDistributing> getFlowDisMax(String sql, Map<Integer, Object> condition) {
        ArrayList<FlowDistributing> fds = new ArrayList<FlowDistributing>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        double base = 1.0;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    FlowDistributing tcp = new FlowDistributing();
                    FlowDistributing udp = new FlowDistributing();
                    FlowDistributing icmp = new FlowDistributing();
                    FlowDistributing other = new FlowDistributing();
                    double tcpFlow = (double)rs.getLong("TCP") * base;
                    double udpFlow = (double)rs.getLong("UDP") * base;
                    double icmpFlow = (double)rs.getLong("ICMP") * base;
                    double otherFlow = (double)rs.getLong("OTHER") * base;
                    Long logTime = rs.getLong("LOGTIME") * 1000L;
                    tcp.setProtocol(1);
                    tcp.setFlow(tcpFlow);
                    tcp.setLogTime(logTime);
                    fds.add(tcp);
                    udp.setProtocol(2);
                    udp.setFlow(udpFlow);
                    udp.setLogTime(logTime);
                    fds.add(udp);
                    icmp.setProtocol(3);
                    icmp.setFlow(icmpFlow);
                    icmp.setLogTime(logTime);
                    fds.add(icmp);
                    other.setProtocol(4);
                    other.setFlow(otherFlow);
                    other.setLogTime(logTime);
                    fds.add(other);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---flow dis(no zoneId,no zoneIp) data----");
            for (FlowDistributing fd : fds) {
                LOG.debug((Object)(fd.getProtocol() + " : " + fd.getFlow()));
            }
        }
        return fds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowDistributing> getAllDetectFlowDis(String sql, Map<Integer, Object> condition) {
        ArrayList<FlowDistributing> fds = new ArrayList<FlowDistributing>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    FlowDistributing flow = new FlowDistributing();
                    flow.setLogTime(rs.getLong("LOG_TIME"));
                    flow.setDeviceIp(rs.getString("DEVICE_IP"));
                    flow.setTcpFlow(rs.getLong("TCP"));
                    flow.setUdpFlow(rs.getLong("UDP"));
                    flow.setIcmpFlow(rs.getLong("ICMP"));
                    flow.setOtherFlow(rs.getLong("OTHER"));
                    fds.add(flow);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---flow dis(no zoneId,no zoneIp) data----");
            for (FlowDistributing fd : fds) {
                LOG.debug((Object)("logTime:" + fd.getLogTime() + " deviceIp:" + fd.getDeviceIp() + " tcpFlow:" + fd.getTcpFlow() + " udpFlow:" + fd.getUdpFlow() + " icmpFlow:" + fd.getIcmpFlow() + " otherFlow:" + fd.getOtherFlow()));
            }
        }
        return fds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackLog> findAttackLog(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackLog> als = new ArrayList<AttackLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                String collectorIp = System.getProperty("java.rmi.server.hostname");
                while (rs.next()) {
                    AttackLog al = new AttackLog();
                    al.setPkid(rs.getLong("PKID"));
                    al.setZoneIp(rs.getString("zone_ip"));
                    al.setZoneId(rs.getLong("zone_id"));
                    al.setBizId(rs.getLong("biz_id"));
                    al.setDeviceIp(rs.getString("device_ip"));
                    Long startAlert = rs.getLong("start_time_alert");
                    al.setAbnormalTime(startAlert);
                    Long startAttack = rs.getLong("start_time_attack");
                    al.setAttackTime(startAttack);
                    if (null == startAttack || startAttack <= 0L) {
                        al.setAttackStartTime("-");
                    } else {
                        al.setAttackStartTime(LogUtil.formateTime(startAttack));
                    }
                    al.setAbnormalStartTime(LogUtil.formateTime(startAlert));
                    Long end = rs.getLong("end_time");
                    al.setEndTimeLong(end);
                    String disEndTime = LogUtil.formateTime(end);
                    al.setEndTime(disEndTime);
                    al.setDuration(String.valueOf(rs.getLong("duration")));
                    al.setAttackTimes(String.valueOf(rs.getLong("attack_times")));
                    al.setAttackType(rs.getString("attack_types"));
                    al.setDropBytes(rs.getLong("DROP_BYTES"));
                    al.setDropPackets(rs.getLong("drop_packets"));
                    al.setAbnormalType(rs.getString("alert_types"));
                    al.setStatus(String.valueOf(rs.getInt("attack_status")));
                    al.setExactLogId(rs.getString("EXACT_LOG_ID"));
                    al.setCollectorIp(collectorIp);
                    al.setIpInPeakPps(rs.getLong("IP_MAX_IN_PPS"));
                    al.setIpInPeakKbps(rs.getLong("IP_MAX_IN_KBPS"));
                    al.setIpAttackPeakKbps(rs.getLong("IP_MAX_DROP_KBPS"));
                    al.setIpAttackPeakPps(rs.getLong("IP_MAX_DROP_PPS"));
                    al.setTcpNewConnNum(rs.getLong("IP_TCP_NEW_CONN"));
                    al.setTcpCurConnNum(rs.getLong("IP_TCP_CONCUR_CONN"));
                    al.setDropKbps(rs.getLong("MAX_DROP_KBPS"));
                    al.setDropPps(rs.getLong("MAX_DROP_PPS"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---attack log data----");
            for (AttackLog al : als) {
                LOG.debug((Object)(al.getZoneIp() + " |  | " + al.getAbnormalStartTime() + " | " + al.getEndTime() + " | " + al.getAttackType() + " | " + al.getDuration() + " |  | " + al.getDropPackets()));
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findAttackLogNum(String sql, Map<Integer, Object> condition) {
        Integer number = 0;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    number = rs.getInt("count");
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("---attack log data  total number is----" + number));
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttackExactLogId(String sql, Map<Integer, Object> condition) {
        String exactLogId = "";
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                if (rs.next()) {
                    exactLogId = rs.getString("EXACT_LOG_ID");
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAttackExactLogId :" + exactLogId));
        }
        return exactLogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackExactLog> findAttackExactLog(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackExactLog> als = new ArrayList<AttackExactLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackExactLog al = new AttackExactLog();
                    al.setId(rs.getLong("pkid"));
                    al.setDeviceIp(rs.getString("device_ip"));
                    al.setZoneIp(rs.getString("zone_ip"));
                    al.setZoneId(rs.getLong("zone_id"));
                    al.setBizId(rs.getLong("biz_id"));
                    long startAlert = rs.getLong("start_time_alert");
                    long startAttack = rs.getLong("start_time_attack");
                    String disStartAlert = startAlert == 0L ? "-" : LogUtil.formateTime(startAlert);
                    al.setDisStartTimeAlert(disStartAlert);
                    al.setStartTimeAlert(startAlert);
                    String disStartAttack = startAttack == 0L ? "-" : LogUtil.formateTime(startAttack);
                    al.setDisStartTimeAttack(disStartAttack);
                    al.setStartTimeAttack(startAttack);
                    long end = rs.getLong("end_time");
                    String disEndTime = end == 0L ? "-" : LogUtil.formateTime(end);
                    al.setDisEndTime(disEndTime);
                    al.setEndTime(end);
                    al.setDuration(rs.getLong("duration"));
                    String attackTypeStr = rs.getString("attack_type");
                    al.setAttackType(attackTypeStr);
                    al.setAttackTypeValue(Integer.parseInt(attackTypeStr));
                    al.setDropKbits(rs.getLong("DROP_KBITS"));
                    al.setDropPackets(rs.getLong("drop_packets"));
                    al.setAttackStatus(rs.getInt("attack_status"));
                    al.setSrcIp(rs.getString("src_ip"));
                    al.setAttackSrcIpFlow(rs.getString("SRC_IP_FLOW"));
                    al.setCurrent(rs.getLong("current_value"));
                    al.setLimit(rs.getLong("limit_value"));
                    al.setPpsOrKbps(rs.getInt("pps_or_kbps"));
                    al.setDeviceType(rs.getInt("device_type"));
                    al.setProtocol(rs.getInt("PROTOCOL"));
                    al.setPort(rs.getInt("PORT"));
                    al.setLimit1(rs.getLong("limit_value_1"));
                    al.setCurrent1(rs.getLong("current_value_1"));
                    al.setPpsOrKbps1(rs.getInt("pps_or_kbps_1"));
                    al.setMultiCurrent(AttackTypeFactory.getInstance().isConnectionFlood(new AttackType(al.getAttackTypeValue(), al.getProtocol(), al.getPort())));
                    al.setMaxAttackPeakbps(rs.getLong("MAX_DROP_KBPS"));
                    al.setMaxAttackPeakPps(rs.getLong("MAX_DROP_PPS"));
                    al.setIpAttackPeakKbps(rs.getLong("IP_MAX_DROP_KBPS"));
                    al.setIpAttackPeakPps(rs.getLong("IP_MAX_DROP_PPS"));
                    al.setIpInPeakKbps(rs.getLong("IP_MAX_IN_KBPS"));
                    al.setIpInPeakPps(rs.getLong("IP_MAX_IN_PPS"));
                    al.setTcpCurConnNum(rs.getLong("IP_TCP_CONCUR_CONN"));
                    al.setTcpNewConnNum(rs.getLong("IP_TCP_NEW_CONN"));
                    al.setDestinationPort(this.queryDestinationPort(rs.getString("DESTINATION_PORT")));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("attack log detail are :" + als));
        }
        return als;
    }

    private String queryDestinationPort(String destinationPort) {
        if (CommonUtil.isNull(destinationPort) || "0".equals(destinationPort)) {
            return "\u2014";
        }
        Set<String> portSet = CommonUtil.transString2Set(destinationPort);
        String[] ports = new String[portSet.size()];
        portSet.toArray(ports);
        int len = ports.length >= 5 ? 5 : ports.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(ports[i]).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackExactLog> findAttackExactLogOfClean(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackExactLog> als = new ArrayList<AttackExactLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackExactLog al = new AttackExactLog();
                    al.setDeviceIp(rs.getString("device_ip"));
                    al.setZoneIp(rs.getString("zone_ip"));
                    al.setZoneId(rs.getLong("zone_id"));
                    al.setBizId(rs.getLong("biz_id"));
                    long startAlert = rs.getLong("start_time_alert");
                    long startAttack = rs.getLong("start_time_attack");
                    String disStartAlert = startAlert == 0L ? "--" : LogUtil.formateTime(startAlert);
                    al.setDisStartTimeAlert(disStartAlert);
                    al.setStartTimeAlert(startAlert);
                    String disStartAttack = startAttack == 0L ? "--" : LogUtil.formateTime(startAttack);
                    al.setDisStartTimeAttack(disStartAttack);
                    al.setStartTimeAttack(startAttack);
                    long end = rs.getLong("end_time");
                    String disEndTime = end == 0L ? "--" : LogUtil.formateTime(end);
                    al.setDisEndTime(disEndTime);
                    al.setEndTime(end);
                    al.setDuration(rs.getLong("duration"));
                    Integer attackType = rs.getInt("attack_type");
                    al.setAttackType(String.valueOf(attackType));
                    al.setAttackTypeValue(attackType);
                    al.setDropKbits(rs.getLong("DROP_KBITS"));
                    al.setDropPackets(rs.getLong("drop_packets"));
                    al.setAttackStatus(rs.getInt("attack_status"));
                    al.setSrcIp(rs.getString("src_ip"));
                    al.setCurrent(rs.getLong("current_value"));
                    al.setLimit(rs.getLong("limit_value"));
                    al.setDeviceType(rs.getInt("device_type"));
                    al.setPort(rs.getInt("PROTOCOL"));
                    al.setProtocol(rs.getInt("PORT"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("attack log detail are :" + als));
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackExactLog> findAttackExactLogOfDetect(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackExactLog> als = new ArrayList<AttackExactLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackExactLog al = new AttackExactLog();
                    al.setDeviceIp(rs.getString("device_ip"));
                    al.setZoneIp(rs.getString("zone_ip"));
                    al.setZoneId(rs.getLong("zone_id"));
                    al.setBizId(rs.getLong("biz_id"));
                    long startAlert = rs.getLong("start_time_alert");
                    String disStartAlert = startAlert == 0L ? "--" : LogUtil.formateTime(startAlert);
                    al.setDisStartTimeAlert(disStartAlert);
                    al.setStartTimeAlert(startAlert);
                    long end = rs.getLong("end_time");
                    String disEndTime = end == 0L ? "--" : LogUtil.formateTime(end);
                    al.setDisEndTime(disEndTime);
                    al.setEndTime(end);
                    al.setDuration(rs.getLong("duration"));
                    Integer attackType = rs.getInt("attack_type");
                    al.setAttackType(String.valueOf(attackType));
                    al.setAttackTypeValue(attackType);
                    al.setAttackStatus(rs.getInt("attack_status"));
                    al.setSrcIp("-");
                    al.setProtocol(rs.getInt("protocol"));
                    al.setPort(rs.getInt("port"));
                    al.setCurrent(rs.getLong("current_value"));
                    al.setLimit(rs.getLong("limit_value"));
                    al.setDropPackets(0L);
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ZoneAttackCountTopN>> findZoneAttackCountTopN(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<ZoneAttackCountTopN>> zoneAttackCountMap = new HashMap<String, List<ZoneAttackCountTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ZoneAttackCountTopN zoneAttackCountTopN = new ZoneAttackCountTopN();
                    long zoneId = rs.getLong("ZONE_ID");
                    zoneAttackCountTopN.setZoneId(zoneId);
                    zoneAttackCountTopN.setAttackTimes(rs.getLong("ATT_NUM"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (zoneAttackCountMap.containsKey(deviceIp)) {
                        ((List)zoneAttackCountMap.get(deviceIp)).add(zoneAttackCountTopN);
                        continue;
                    }
                    ArrayList<ZoneAttackCountTopN> zoneAttackCountTopNs = new ArrayList<ZoneAttackCountTopN>();
                    zoneAttackCountTopNs.add(zoneAttackCountTopN);
                    zoneAttackCountMap.put(deviceIp, zoneAttackCountTopNs);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return zoneAttackCountMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ZoneAttackTimeTopN>> findZoneAttackTimeTopN(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<ZoneAttackTimeTopN>> zoneAttackTimeMap = new HashMap<String, List<ZoneAttackTimeTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ZoneAttackTimeTopN zoneAttackTimeTopN = new ZoneAttackTimeTopN();
                    Long zoneId = rs.getLong("ZONE_ID");
                    Long totalDate = rs.getLong("attackTime");
                    Long startDate = rs.getLong("START_TIME");
                    Long endDate = rs.getLong("END_TIME");
                    String deviceIp = rs.getString("DEVICE_IP");
                    zoneAttackTimeTopN.setZoneId(zoneId);
                    zoneAttackTimeTopN.setTotalDate(totalDate);
                    zoneAttackTimeTopN.setStartDate(startDate);
                    zoneAttackTimeTopN.setEndData(endDate);
                    zoneAttackTimeTopN.setDeviceIp(deviceIp);
                    if (zoneAttackTimeMap.containsKey(deviceIp)) {
                        ((List)zoneAttackTimeMap.get(deviceIp)).add(zoneAttackTimeTopN);
                        continue;
                    }
                    ArrayList<ZoneAttackTimeTopN> zoneAttackTimeTopNs = new ArrayList<ZoneAttackTimeTopN>();
                    zoneAttackTimeTopNs.add(zoneAttackTimeTopN);
                    zoneAttackTimeMap.put(deviceIp, zoneAttackTimeTopNs);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return zoneAttackTimeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BisAttackCountTopN> findBisAttackCountTopN(String sql, Map<Integer, Object> condition) {
        ArrayList<BisAttackCountTopN> bisAttackCountTopNs = new ArrayList<BisAttackCountTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BisAttackCountTopN bisAttackCountTopN = new BisAttackCountTopN();
                    Long zoneId = rs.getLong("ZONE_ID");
                    Long bisId = rs.getLong("BIZ_ID");
                    bisAttackCountTopN.setZoneId(zoneId);
                    bisAttackCountTopN.setBisId(bisId);
                    bisAttackCountTopN.setAttackTimes(rs.getLong("ATT_NUM"));
                    bisAttackCountTopNs.add(bisAttackCountTopN);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---zone attack top n data----");
            for (BisAttackCountTopN z : bisAttackCountTopNs) {
                LOG.debug((Object)(z.getBisId() + " | " + z.getAttackTimes()));
            }
        }
        return bisAttackCountTopNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BisAttackTimeTopN> findBisAttackTimeTopN(String sql, Map<Integer, Object> condition) {
        ArrayList<BisAttackTimeTopN> bisAttackTimeTopNs = new ArrayList<BisAttackTimeTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BisAttackTimeTopN bisAttackTimeTopN = new BisAttackTimeTopN();
                    Long zoneId = rs.getLong("ZONE_ID");
                    Long bisId = rs.getLong("BIZ_ID");
                    Long totalData = rs.getLong("attackTime");
                    Long startDate = rs.getLong("START_TIME");
                    Long endData = rs.getLong("END_TIME");
                    String deviceIp = rs.getString("DEVICE_IP");
                    bisAttackTimeTopN.setZoneId(zoneId);
                    bisAttackTimeTopN.setBisId(bisId);
                    bisAttackTimeTopN.setTotalDate(totalData);
                    bisAttackTimeTopN.setStartDate(startDate);
                    bisAttackTimeTopN.setEndData(endData);
                    bisAttackTimeTopN.setDeviceIp(deviceIp);
                    bisAttackTimeTopNs.add(bisAttackTimeTopN);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ZoneAttackTimeTopN data----");
            for (BisAttackTimeTopN z : bisAttackTimeTopNs) {
                LOG.debug((Object)(z.getBisId() + " | " + z.getTotalDate()));
            }
        }
        return bisAttackTimeTopNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<IpAttackCountTopN>> findIpAttackCountTopN(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<IpAttackCountTopN>> ipAttackMap = new HashMap<String, List<IpAttackCountTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpAttackCountTopN ipAttackCountTopN = new IpAttackCountTopN();
                    String zoneIp = rs.getString("ZONE_IP");
                    Long zoneId = rs.getLong("ZONE_ID");
                    ipAttackCountTopN.setDisIp(zoneIp);
                    ipAttackCountTopN.setZoneId(zoneId);
                    ipAttackCountTopN.setZoneIp(zoneIp);
                    ipAttackCountTopN.setAttackTimes(rs.getLong("ATT_NUM"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (ipAttackMap.containsKey(deviceIp)) {
                        ((List)ipAttackMap.get(deviceIp)).add(ipAttackCountTopN);
                        continue;
                    }
                    ArrayList<IpAttackCountTopN> ipAttackCountTopNs = new ArrayList<IpAttackCountTopN>();
                    ipAttackCountTopNs.add(ipAttackCountTopN);
                    ipAttackMap.put(deviceIp, ipAttackCountTopNs);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return ipAttackMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<IpAttackTimeTopN>> findIpAttackTimeTopN(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<IpAttackTimeTopN>> ipAttackMap = new HashMap<String, List<IpAttackTimeTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpAttackTimeTopN ipAttackTimeTopN = new IpAttackTimeTopN();
                    String zoneIp = rs.getString("ZONE_IP");
                    Long zoneId = rs.getLong("ZONE_ID");
                    Long startDate = rs.getLong("START_TIME");
                    Long endData = rs.getLong("END_TIME");
                    String deviceIp = rs.getString("DEVICE_IP");
                    Long attackTime = rs.getLong("attackTime");
                    ipAttackTimeTopN.setDisIp(zoneIp);
                    ipAttackTimeTopN.setZoneId(zoneId);
                    ipAttackTimeTopN.setZoneIp(zoneIp);
                    ipAttackTimeTopN.setStartDate(startDate);
                    ipAttackTimeTopN.setEndData(endData);
                    ipAttackTimeTopN.setDeviceIp(deviceIp);
                    ipAttackTimeTopN.setTotalDate(attackTime);
                    if (ipAttackMap.containsKey(deviceIp)) {
                        ((List)ipAttackMap.get(deviceIp)).add(ipAttackTimeTopN);
                        continue;
                    }
                    ArrayList<IpAttackTimeTopN> ipAttackTimeTopNs = new ArrayList<IpAttackTimeTopN>();
                    ipAttackTimeTopNs.add(ipAttackTimeTopN);
                    ipAttackMap.put(deviceIp, ipAttackTimeTopNs);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return ipAttackMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DropTrend> findDropTrend(String sql, Map<Integer, Object> condition) {
        ArrayList<DropTrend> dropTrends = new ArrayList<DropTrend>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DropTrend dropTrend = new DropTrend();
                    dropTrend.setDateTime(rs.getLong("LOG_TIME"));
                    dropTrend.setDropPackagePps(rs.getLong("DROP_PPS"));
                    dropTrend.setAttackType(rs.getInt("ATTACK_TYPE"));
                    dropTrends.add(dropTrend);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ip top n data----");
            for (DropTrend z : dropTrends) {
                LOG.debug((Object)(z.getDateTime() + " | " + z.getAttackType() + " | " + z.getDropPackagePps()));
            }
        }
        return dropTrends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RequestTrend> findRequestTrend(String sql, String requestType, Map<Integer, Object> condition) {
        ArrayList<RequestTrend> requestTrends = new ArrayList<RequestTrend>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    RequestTrend requestTrend = new RequestTrend();
                    long dateTime = rs.getLong("LOG_TIME");
                    requestTrend.setDateTime(dateTime);
                    requestTrend.setRequestPackageName(requestType);
                    requestTrend.setRequestPackagePps(rs.getLong(requestType));
                    requestTrends.add(requestTrend);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ip top n data----");
            for (RequestTrend z : requestTrends) {
                LOG.debug((Object)(z.getDateTime() + " | " + z.getRequestPackageName() + " | " + z.getRequestPackagePps()));
            }
        }
        return requestTrends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackTrend> findAttackTrend(String sql, String attackTypeKey, String attackTypeValue, Map<Integer, Object> condition) {
        ArrayList<AttackTrend> attackTrends = new ArrayList<AttackTrend>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackTrend attackTrend = new AttackTrend();
                    long dateTime = rs.getLong("LOG_TIME");
                    attackTrend.setDateTime(dateTime);
                    attackTrend.setAttackTypePackagePps(rs.getLong("DROP_PPS"));
                    attackTrend.setAttackTypeName(attackTypeValue);
                    attackTrend.setAttackType(Long.parseLong(attackTypeKey));
                    attackTrends.add(attackTrend);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---ip top n data----");
            for (AttackTrend z : attackTrends) {
                LOG.debug((Object)(z.getDateTime() + " | " + z.getAttackTypeName() + " | " + z.getAttackTypePackagePps()));
            }
        }
        return attackTrends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttackTrend>> findAttackTrend(String sql, Map<String, String> attackTypeKeyNameMap, Map<Integer, Object> condition) {
        HashMap<String, List<AttackTrend>> attacktTrendMap = new HashMap<String, List<AttackTrend>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ArrayList<AttackTrend> attackTrends;
                    AttackTrend attackTrend = new AttackTrend();
                    String deviceIp = rs.getString("DEVICE_IP");
                    long dateTime = rs.getLong("LOG_TIME");
                    attackTrend.setDateTime(dateTime);
                    attackTrend.setAttackTypePackagePps(rs.getLong("DROP_PPS"));
                    attackTrend.setAttackTypePackageKbps(rs.getLong("DROP_KBPS"));
                    attackTrend.setAttackType(rs.getLong("attackType"));
                    if (attackTypeKeyNameMap.containsKey(String.valueOf(attackTrend.getAttackType()))) {
                        attackTrend.setAttackTypeName(attackTypeKeyNameMap.get(String.valueOf(attackTrend.getAttackType())));
                        if (attacktTrendMap.containsKey(deviceIp)) {
                            ((List)attacktTrendMap.get(deviceIp)).add(attackTrend);
                            continue;
                        }
                        attackTrends = new ArrayList();
                        attackTrends.add(attackTrend);
                        attacktTrendMap.put(deviceIp, attackTrends);
                        continue;
                    }
                    if (attackTrend.getAttackType() <= 2000L) continue;
                    if (attacktTrendMap.containsKey(deviceIp)) {
                        ((List)attacktTrendMap.get(deviceIp)).add(attackTrend);
                        continue;
                    }
                    attackTrends = new ArrayList<AttackTrend>();
                    attackTrends.add(attackTrend);
                    attacktTrendMap.put(deviceIp, attackTrends);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attacktTrendMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceStopTime> getDeviceStopTimeList(String sql, Map<Integer, Object> condition) {
        ArrayList<DeviceStopTime> stopTimeList = new ArrayList<DeviceStopTime>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DeviceStopTime stopTime = new DeviceStopTime();
                    stopTime.setDeviceIp(rs.getString("device_ip"));
                    stopTime.setDeviceType(rs.getInt("device_type"));
                    stopTime.setStopTime(rs.getLong("stop_time"));
                    stopTime.setStartTime(rs.getLong("start_time"));
                    stopTime.setHave(1);
                    stopTimeList.add(stopTime);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException e) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return stopTimeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackTopn> getAttackTopn(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackTopn> attackTopnList = new ArrayList<AttackTopn>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackTopn attackTopn = new AttackTopn();
                    attackTopn.setDeviceIp(rs.getString("device_ip"));
                    attackTopn.setZoneId(rs.getLong("zone_id"));
                    attackTopn.setZoneIp(rs.getString("zone_ip"));
                    attackTopn.setBizId(rs.getLong("biz_id"));
                    attackTopn.setStartTimeAlert(rs.getLong("start_time_alert"));
                    attackTopn.setStartTimeAttack(rs.getLong("start_time_attack"));
                    attackTopn.setEndTime(rs.getLong("end_time"));
                    attackTopn.setDuration(rs.getLong("duration"));
                    attackTopn.setDropKbits(rs.getLong("DROP_KBITS"));
                    attackTopn.setDropPackets(rs.getLong("drop_packets"));
                    attackTopn.setAttackType(rs.getInt("attack_type"));
                    attackTopn.setAttackStatus(rs.getInt("attack_status"));
                    attackTopn.setProtocol(rs.getInt("protocol"));
                    attackTopn.setPort(rs.getInt("port"));
                    attackTopn.setLimit(rs.getLong("LIMIT_VALUE"));
                    attackTopn.setPpsOrKbps(rs.getInt("PPS_OR_KBPS"));
                    attackTopn.setMaxDropKbps(rs.getLong("MAX_DROP_KBPS"));
                    attackTopn.setMaxDropPps(rs.getLong("MAX_DROP_PPS"));
                    attackTopn.setLimit1(rs.getLong("limit_value_1"));
                    attackTopn.setPpsOrKbps1(rs.getInt("pps_or_kbps_1"));
                    attackTopn.setMultiCurrent(AttackTypeFactory.getInstance().isConnectionFlood(new AttackType(attackTopn.getAttackType(), attackTopn.getProtocol(), attackTopn.getPort())));
                    attackTopnList.add(attackTopn);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---AttackTopn data----");
            for (AttackTopn attack : attackTopnList) {
                LOG.debug((Object)(attack.getZoneIp() + " | " + attack.getDuration() + " | " + attack.getDropPackets()));
            }
        }
        return attackTopnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackExactFlow> getAttackExactFlow(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackExactFlow> attackExactFlowList = new ArrayList<AttackExactFlow>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackExactFlow attackExactFlow = new AttackExactFlow();
                    attackExactFlow.setLogTime(rs.getLong("log_time"));
                    attackExactFlow.setDeviceIp(rs.getString("device_ip"));
                    attackExactFlow.setZoneId(rs.getLong("zone_id"));
                    attackExactFlow.setBizId(rs.getLong("biz_id"));
                    attackExactFlow.setZoneIp(rs.getString("zone_ip"));
                    attackExactFlow.setAttackType(rs.getLong("attack_type"));
                    attackExactFlow.setProtocol(rs.getInt("protocol"));
                    attackExactFlow.setPort(rs.getInt("port"));
                    attackExactFlow.setDropKbps(rs.getLong("DROP_KBPS"));
                    attackExactFlow.setDropPps(rs.getLong("drop_pps"));
                    attackExactFlowList.add(attackExactFlow);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---AttackExactFlow data----");
            for (AttackExactFlow attack : attackExactFlowList) {
                LOG.debug((Object)(attack.getLogTime() + " | " + attack.getDeviceIp() + " | " + attack.getZoneIp() + " | " + attack.getDropPps()));
            }
        }
        return attackExactFlowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SlotFlow> findCleanSlotFlow(String sql, Map<Integer, Object> condition) {
        ArrayList<SlotFlow> slotFlowList = new ArrayList<SlotFlow>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SlotFlow slotFlow = new SlotFlow();
                    slotFlow.setLogTime(rs.getLong("LOG_TIME"));
                    slotFlow.setSlotId(rs.getLong("SLOT_ID"));
                    slotFlow.setInFlow(rs.getLong("IN_FLOW"));
                    slotFlow.setAttackFlow(rs.getLong("DROP_FLOW"));
                    slotFlowList.add(slotFlow);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---slotFlow data----");
            for (SlotFlow flow : slotFlowList) {
                LOG.debug((Object)(flow.getLogTime() + " | " + flow.getSlotId() + " | " + flow.getInFlow() + " | " + flow.getAttackFlow()));
            }
        }
        return slotFlowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SlotFlow> findDetectSlotFlow(String sql, Map<Integer, Object> condition) {
        ArrayList<SlotFlow> slotFlowList = new ArrayList<SlotFlow>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SlotFlow slotFlow = new SlotFlow();
                    slotFlow.setLogTime(rs.getLong("LOG_TIME"));
                    slotFlow.setSlotId(rs.getLong("SLOT_ID"));
                    slotFlow.setInFlow(rs.getLong("IN_FLOW"));
                    slotFlowList.add(slotFlow);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---slotFlow data----");
            for (SlotFlow flow : slotFlowList) {
                LOG.debug((Object)(flow.getLogTime() + " | " + flow.getSlotId() + " | " + flow.getInFlow()));
            }
        }
        return slotFlowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BotLog> findBotLog(String sql, Map<Integer, Object> condition) {
        ArrayList<BotLog> als = new ArrayList<BotLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BotLog al = new BotLog();
                    al.setAccessTime(rs.getLong("LOG_TIME"));
                    al.setDeviceIp(rs.getString("DEVICE_IP"));
                    al.setType(rs.getInt("BOT_TYPE"));
                    al.setBotId(rs.getInt("BOT_ID"));
                    al.setSourceIp(rs.getString("SRC_IP"));
                    al.setDescIp(rs.getString("DEST_IP"));
                    al.setFilterPackets(rs.getLong("FILTER_PACKETS"));
                    al.setPassPackets(rs.getLong("PASS_PACKETS"));
                    al.setZoneId(rs.getLong("ZONE_ID"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findBotLogNum(String sql, Map<Integer, Object> condition) {
        Integer number = 0;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    number = rs.getInt("count");
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("---Bot log data  total number is----" + number));
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DnsDefendLog> findDnsDefendLog(String sql, Map<Integer, Object> condition) {
        ArrayList<DnsDefendLog> als = new ArrayList<DnsDefendLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DnsDefendLog al = new DnsDefendLog();
                    al.setLogTime(rs.getLong("LOG_TIME"));
                    al.setDeviceIp(rs.getString("DEVICE_IP"));
                    al.setDomain(rs.getString("DNS_NAME"));
                    al.setSourceIpStr(rs.getString("SRC_IP"));
                    al.setRequestTime(rs.getInt("REQUEST_TIME"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findDnsDefendLogNum(String sql, Map<Integer, Object> condition) {
        Integer number = 0;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    number = rs.getInt("count");
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("---DnsDefend log data  total number is----" + number));
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DnsDefendTopN> findDnsDefendTopN(String sql, Map<Integer, Object> condition) {
        ArrayList<DnsDefendTopN> als = new ArrayList<DnsDefendTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DnsDefendTopN al = new DnsDefendTopN();
                    al.setDateTime(rs.getLong("LOG_TIME"));
                    al.setDomain(rs.getString("DNS_NAME"));
                    al.setRequestTime(rs.getInt("REQUEST_TIME"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BotRequestTimeTopN> findBotTopN(String sql, String colName, Map<Integer, Object> condition) {
        ArrayList<BotRequestTimeTopN> als = new ArrayList<BotRequestTimeTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BotRequestTimeTopN al = new BotRequestTimeTopN();
                    al.setDateTime(rs.getLong("LOG_TIME"));
                    if ("1".equals(colName)) {
                        al.setName(rs.getString("SRC_IP"));
                    } else if ("2".equals(colName)) {
                        al.setName(rs.getString("DEST_IP"));
                    } else {
                        al.setName(rs.getInt("BOT_ID") + "");
                        al.setBotId(rs.getInt("BOT_ID"));
                    }
                    al.setAccessTime(rs.getInt("REQUEST_TIME"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttackCountTrend>> findAttackCountTrend(String sql, Map<String, String> attackTypeKeyNameMap, Map<Integer, Object> condition) {
        HashMap<String, List<AttackCountTrend>> attackTrends = new HashMap<String, List<AttackCountTrend>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ArrayList<AttackCountTrend> attackTrendsTemp;
                    AttackCountTrend attackTrend = new AttackCountTrend();
                    String deviceIp = rs.getString("DEVICE_IP");
                    long dateTime = rs.getLong("LOG_TIME");
                    attackTrend.setDateTime(dateTime);
                    attackTrend.setAttackTypeCount(rs.getLong("attackCount"));
                    attackTrend.setAttackType(rs.getLong("attackType"));
                    if (attackTypeKeyNameMap.containsKey(String.valueOf(attackTrend.getAttackType()))) {
                        attackTrend.setAttackTypeName(attackTypeKeyNameMap.get(String.valueOf(attackTrend.getAttackType())));
                        if (attackTrends.containsKey(deviceIp)) {
                            ((List)attackTrends.get(deviceIp)).add(attackTrend);
                            continue;
                        }
                        attackTrendsTemp = new ArrayList();
                        attackTrendsTemp.add(attackTrend);
                        attackTrends.put(deviceIp, attackTrendsTemp);
                        continue;
                    }
                    if (attackTrend.getAttackType() <= 2000L) continue;
                    if (attackTrends.containsKey(deviceIp)) {
                        ((List)attackTrends.get(deviceIp)).add(attackTrend);
                        continue;
                    }
                    attackTrendsTemp = new ArrayList<AttackCountTrend>();
                    attackTrendsTemp.add(attackTrend);
                    attackTrends.put(deviceIp, attackTrendsTemp);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attackTrends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttackIpCountTrend>> findAttackIpCountTrend(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<AttackIpCountTrend>> attacktTrend = new HashMap<String, List<AttackIpCountTrend>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackIpCountTrend attackTrend = new AttackIpCountTrend();
                    String deviceIp = rs.getString("DEVICE_IP");
                    long dateTime = rs.getLong("LOG_TIME");
                    attackTrend.setDateTime(dateTime);
                    attackTrend.setAttackNum(rs.getLong("ipCount"));
                    if (attacktTrend.containsKey(deviceIp)) {
                        ((List)attacktTrend.get(deviceIp)).add(attackTrend);
                        continue;
                    }
                    ArrayList<AttackIpCountTrend> attackTrends = new ArrayList<AttackIpCountTrend>();
                    attackTrends.add(attackTrend);
                    attacktTrend.put(deviceIp, attackTrends);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attacktTrend;
    }

    public static void freeDbResource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex2) {
            LOG.error((Object)"when close rs error");
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex3) {
            LOG.error((Object)"when close stmt error");
        }
        try {
            conn.close();
        }
        catch (SQLException ex1) {
            LOG.error((Object)"when close conn error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttackCountCompare>> findAttackCountCompare(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<AttackCountCompare>> attacktTrend = new HashMap<String, List<AttackCountCompare>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackCountCompare attackTrend = new AttackCountCompare();
                    long dateTime = rs.getLong("LOG_TIME");
                    attackTrend.setDateTime(dateTime);
                    attackTrend.setAttackCount(rs.getLong("attackCount"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (attacktTrend.containsKey(deviceIp)) {
                        ((List)attacktTrend.get(deviceIp)).add(attackTrend);
                        continue;
                    }
                    ArrayList<AttackCountCompare> attackTrends = new ArrayList<AttackCountCompare>();
                    attackTrends.add(attackTrend);
                    attacktTrend.put(deviceIp, attackTrends);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attacktTrend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findTotalCount(String sql, Map<Integer, Object> condition) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int attNum = 0;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    attNum = rs.getInt("ATT_NUM");
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AppFlow> findAppFlowDis(String sql, BizTypePoJo bizType, Map<Integer, Object> condition) {
        ArrayList<AppFlow> appFlowList = new ArrayList<AppFlow>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AppFlow appFlow = new AppFlow();
                    long dateTime = rs.getLong("LOG_TIME");
                    appFlow.setDateTime(dateTime);
                    appFlow.setAppName(bizType.getBizName());
                    appFlow.setAppValue(rs.getLong("pps"));
                    appFlowList.add(appFlow);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return appFlowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowCompare> getFlowCompare(String sql, Map<Integer, Object> condition) {
        ArrayList<FlowCompare> flowCompareList = new ArrayList<FlowCompare>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Long maxDropFlow;
                    Long dropFlow;
                    Long attackFlow;
                    Long inFlow;
                    String deviceIp;
                    ResultSetMetaData metaData = rs.getMetaData();
                    FlowCompare flowCompare = new FlowCompare();
                    Long time = rs.getLong(1);
                    if (null != time) {
                        flowCompare.setLogTime(time * 1000L);
                    }
                    if (!CommonUtil.isNull(deviceIp = rs.getString(2))) {
                        flowCompare.setDeviceIp(deviceIp);
                    }
                    if (null != (inFlow = Long.valueOf(rs.getLong(3)))) {
                        flowCompare.setInFlow(inFlow);
                    }
                    if (metaData.getColumnCount() == 4) {
                        attackFlow = rs.getLong(4);
                        if (null != attackFlow) {
                            flowCompare.setAttackFlow(attackFlow);
                        }
                    } else if (metaData.getColumnCount() == 6) {
                        attackFlow = rs.getLong(4);
                        if (null != attackFlow) {
                            flowCompare.setMaxInFlow(attackFlow);
                        }
                        if (null != (dropFlow = Long.valueOf(rs.getLong(5)))) {
                            flowCompare.setAttackFlow(dropFlow);
                        }
                        if (null != (maxDropFlow = Long.valueOf(rs.getLong(6)))) {
                            flowCompare.setMaxAttackFlow(maxDropFlow);
                        }
                    } else if (metaData.getColumnCount() == 7) {
                        Long maxOutFlow;
                        attackFlow = rs.getLong(4);
                        if (null != attackFlow) {
                            flowCompare.setMaxInFlow(attackFlow);
                        }
                        if (null != (dropFlow = Long.valueOf(rs.getLong(5)))) {
                            flowCompare.setAttackFlow(dropFlow);
                        }
                        if (null != (maxDropFlow = Long.valueOf(rs.getLong(6)))) {
                            flowCompare.setMaxAttackFlow(maxDropFlow);
                        }
                        if (null != (maxOutFlow = Long.valueOf(rs.getLong(7)))) {
                            flowCompare.setMaxOutFlow(maxOutFlow);
                        }
                    } else if (metaData.getColumnCount() == 8) {
                        attackFlow = rs.getLong(4);
                        if (null != attackFlow) {
                            flowCompare.setMaxInFlow(attackFlow);
                        }
                        if (null != (dropFlow = Long.valueOf(rs.getLong(5)))) {
                            flowCompare.setAttackFlow(dropFlow);
                        }
                        if (null != (maxDropFlow = Long.valueOf(rs.getLong(6)))) {
                            flowCompare.setMaxAttackFlow(maxDropFlow);
                        }
                        Long reboundFlow = rs.getLong(7);
                        flowCompare.setReboundFlow(reboundFlow);
                        Long maxOutFlow = rs.getLong(8);
                        if (null != maxOutFlow) {
                            flowCompare.setMaxOutFlow(maxOutFlow);
                        }
                    }
                    flowCompareList.add(flowCompare);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return flowCompareList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnalyzeSuccessRate> getAnalyzeSuccessRate(String sql, Map<Integer, Object> condition) {
        ArrayList<AnalyzeSuccessRate> analyzeSuccessRateList = new ArrayList<AnalyzeSuccessRate>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AnalyzeSuccessRate analyzeSuccessRate = new AnalyzeSuccessRate();
                    analyzeSuccessRate.setLogTime(rs.getLong("LOG_TIME") * 1000L);
                    analyzeSuccessRate.setRequestPps(rs.getLong("REQUEST_PPS"));
                    analyzeSuccessRate.setReplyPps(rs.getLong("SERVER_REPLY_PPS"));
                    analyzeSuccessRate.setDeviceIp(rs.getString("DEVICE_IP"));
                    analyzeSuccessRateList.add(analyzeSuccessRate);
                }
                ArrayList<AnalyzeSuccessRate> arrayList = analyzeSuccessRateList;
                DBStat.freeDbResource(conn, stmt, rs);
                return arrayList;
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return analyzeSuccessRateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NormalAndExceptObject> queryNormalAndException(String sql, Map<Integer, Object> map) {
        ArrayList<NormalAndExceptObject> normalAndExceptionList = new ArrayList<NormalAndExceptObject>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer sql1 = new StringBuffer(sql);
                sql1.append("");
                stmt = conn.prepareStatement(sql1.toString());
                if (null != map && !map.isEmpty()) {
                    for (int i = 0; i < map.size(); ++i) {
                        stmt.setObject(i + 1, map.get(i + 1));
                    }
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    NormalAndExceptObject normalAndException = new NormalAndExceptObject();
                    normalAndException.setLogTime(rs.getLong("LOG_TIME") * 1000L);
                    normalAndException.setLarge(rs.getLong("LARGE_PPS"));
                    normalAndException.setIlegal(rs.getLong("ILEGAL_PPS"));
                    normalAndException.setTtlDenied(rs.getLong("TTL_DENIED_PPS"));
                    normalAndException.setNormal(rs.getLong("NORMAL_PPS"));
                    normalAndException.setTotal(rs.getLong("TOTAL_PPS"));
                    normalAndException.setDeviceIp(rs.getString("DEVICE_IP"));
                    normalAndExceptionList.add(normalAndException);
                }
                ArrayList<NormalAndExceptObject> arrayList = normalAndExceptionList;
                DBStat.freeDbResource(conn, stmt, rs);
                return arrayList;
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return normalAndExceptionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackExactLog> findAttackExactLogAndPKID(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackExactLog> als = new ArrayList<AttackExactLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackExactLog al = new AttackExactLog();
                    al.setId(rs.getLong("pkid"));
                    al.setZoneIp(rs.getString("zone_ip"));
                    al.setZoneId(rs.getLong("zone_id"));
                    long startAlert = rs.getLong("start_time_alert");
                    long startAttack = rs.getLong("start_time_attack");
                    String disStartAlert = LogUtil.formateTime(startAlert);
                    al.setDisStartTimeAlert(disStartAlert);
                    al.setStartTimeAlert(startAlert);
                    String disStartAttack = LogUtil.formateTime(startAttack);
                    al.setDisStartTimeAttack(disStartAttack);
                    al.setStartTimeAttack(startAttack);
                    long end = rs.getLong("end_time");
                    String disEndTime = LogUtil.formateTime(end);
                    al.setDisEndTime(disEndTime);
                    al.setEndTime(end);
                    al.setDuration(rs.getLong("duration"));
                    al.setAttackType(rs.getString("attack_type"));
                    al.setDropKbits(rs.getLong("drop_kbits"));
                    al.setDropPackets(rs.getLong("drop_packets"));
                    al.setAttackStatus(rs.getInt("attack_status"));
                    al.setSrcIp(rs.getString("src_ip"));
                    al.setProtocol(rs.getInt("protocol"));
                    al.setPort(rs.getInt("port"));
                    als.add(al);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"---attack exact log data----");
            for (AttackExactLog al : als) {
                LOG.debug((Object)(al.getZoneIp() + " | " + al.getZoneId() + " | " + al.getDisStartTimeAlert() + " | " + al.getDisEndTime() + " | " + al.getAttackType() + " | " + al.getSrcIp() + " | " + al.getDuration() + " | " + al.getAttackStatus() + " | " + al.getDropKbits() + " | " + al.getDropPackets()));
            }
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<IpLocationTopN>> findIpLocationTopNTable(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<IpLocationTopN>> map = new HashMap<String, List<IpLocationTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpLocationTopN ipn = new IpLocationTopN();
                    ipn.setIpLocationId(rs.getInt("LOCATION_ID"));
                    ipn.setFlowValue(rs.getLong("flowValue"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (map.containsKey(deviceIp)) {
                        ((List)map.get(deviceIp)).add(ipn);
                        continue;
                    }
                    ArrayList<IpLocationTopN> dnsTopNList = new ArrayList<IpLocationTopN>();
                    dnsTopNList.add(ipn);
                    map.put(deviceIp, dnsTopNList);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<IpLocationTopN>> findIpLocationGraph(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<IpLocationTopN>> map = new HashMap<String, List<IpLocationTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpLocationTopN ipn = new IpLocationTopN();
                    ipn.setDateTime(rs.getLong("LOG_TIME"));
                    ipn.setIpLocationId(rs.getInt("LOCATION_ID"));
                    ipn.setInFlow(rs.getLong("inFlow"));
                    ipn.setAttackFlow(rs.getLong("attackFlow"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (map.containsKey(deviceIp)) {
                        ((List)map.get(deviceIp)).add(ipn);
                        continue;
                    }
                    ArrayList<IpLocationTopN> dnsTopNList = new ArrayList<IpLocationTopN>();
                    dnsTopNList.add(ipn);
                    map.put(deviceIp, dnsTopNList);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<IpLocationTopN>> findIpLocationTopNGraph(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<IpLocationTopN>> map = new HashMap<String, List<IpLocationTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    IpLocationTopN ipn = new IpLocationTopN();
                    ipn.setDateTime(rs.getLong("LOG_TIME"));
                    ipn.setIpLocationId(rs.getInt("LOCATION_ID"));
                    ipn.setFlowValue(rs.getLong("flowValue"));
                    String deviceIp = rs.getString("DEVICE_IP");
                    if (map.containsKey(deviceIp)) {
                        ((List)map.get(deviceIp)).add(ipn);
                        continue;
                    }
                    ArrayList<IpLocationTopN> dnsTopNList = new ArrayList<IpLocationTopN>();
                    dnsTopNList.add(ipn);
                    map.put(deviceIp, dnsTopNList);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackLog> findCur10AttackLog(String sql, Map<Integer, Object> map) {
        ArrayList<AttackLog> returnAttackLogs = new ArrayList<AttackLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : map.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = AlarmThread.getInstance().getIpAlarmMap();
                while (rs.next()) {
                    AttackLog attackLog = new AttackLog();
                    attackLog.setDirection(rs.getInt("DIRECTION"));
                    attackLog.setDeviceIp(rs.getString("DEVICE_IP"));
                    attackLog.setDeviceType(rs.getInt("DEVICE_TYPE"));
                    attackLog.setZoneId(rs.getLong("ZONE_ID"));
                    attackLog.setZoneIp(rs.getString("ZONE_IP"));
                    attackLog.setAbnormalTime(rs.getLong("START_TIME_ALERT"));
                    long startTimeAttack = rs.getLong("START_TIME_ATTACK");
                    if (startTimeAttack <= 0L) {
                        startTimeAttack = rs.getLong("START_TIME_ALERT");
                    }
                    attackLog.setAttackTime(startTimeAttack);
                    attackLog.setAttackStartTime(LogUtil.formateTime(startTimeAttack));
                    attackLog.setStatus(String.valueOf(rs.getInt("ATTACK_STATUS")));
                    attackLog.setAttackType(rs.getString("ATTACK_TYPE"));
                    attackLog.setIpAttackPeakPps(rs.getLong("MAX_DROP_PPS"));
                    attackLog.setIpAttackPeakKbps(rs.getLong("MAX_DROP_KBPS"));
                    String duration = String.valueOf(rs.getLong("DURATION"));
                    attackLog.setDuration(duration);
                    attackLog.setPort(this.queryDestinationPort(rs.getString("DESTINATION_PORT")));
                    this.setAttackLogFlowInfo(attackLog, ipAlarmMap);
                    returnAttackLogs.add(attackLog);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return returnAttackLogs;
    }

    private void setAttackLogFlowInfo(AttackLog attackLog, Map<IpInfoKey, IpAlarmEntity> ipAlarmMap) {
        long ipInPeakPps = 0L;
        long ipInPeakKbps = 0L;
        long ipAttackPeakKbps = 0L;
        long ipAttackPeakPps = 0L;
        long tcpNewConnNum = 0L;
        long tcpCurConnNum = 0L;
        if (null != ipAlarmMap && !ipAlarmMap.isEmpty()) {
            for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : ipAlarmMap.entrySet()) {
                IpInfoKey ipInfoKey = entry.getKey();
                IpAlarmEntity ipAlarmEntity = entry.getValue();
                if (!attackLog.getDeviceType().equals(ipInfoKey.getDeviceType()) || attackLog.getZoneId().longValue() != ipInfoKey.getZoneId() || !attackLog.getZoneIp().equals(ipInfoKey.getZoneIp()) || attackLog.getDirection().intValue() != ipInfoKey.getDirection() || !attackLog.getDeviceIp().equals(ipInfoKey.getDeviceIp())) continue;
                ipInPeakPps = ipInPeakPps >= ipAlarmEntity.getMaxInPps() ? ipInPeakPps : ipAlarmEntity.getMaxInPps();
                ipInPeakKbps = ipInPeakKbps >= ipAlarmEntity.getMaxInKbps() ? ipInPeakKbps : ipAlarmEntity.getMaxInKbps();
                ipAttackPeakKbps = attackLog.getIpAttackPeakKbps() >= ipAlarmEntity.getMaxDropKbps() ? attackLog.getIpAttackPeakKbps().longValue() : ipAlarmEntity.getMaxDropKbps();
                ipAttackPeakPps = attackLog.getIpAttackPeakPps() >= ipAlarmEntity.getMaxDropPps() ? attackLog.getIpAttackPeakPps().longValue() : ipAlarmEntity.getMaxDropPps();
                tcpCurConnNum = tcpCurConnNum >= ipAlarmEntity.getCurrConn() ? tcpCurConnNum : ipAlarmEntity.getCurrConn();
                tcpNewConnNum = tcpNewConnNum >= ipAlarmEntity.getNewConn() ? tcpNewConnNum : ipAlarmEntity.getNewConn();
            }
        }
        attackLog.setIpInPeakPps(ipInPeakPps);
        attackLog.setIpInPeakKbps(ipInPeakKbps);
        attackLog.setIpAttackPeakKbps(ipAttackPeakKbps);
        attackLog.setIpAttackPeakPps(ipAttackPeakPps);
        attackLog.setTcpNewConnNum(tcpNewConnNum);
        attackLog.setTcpCurConnNum(tcpCurConnNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackFlowPeakTopN> findIpAttackFlowPeakTopN(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackFlowPeakTopN> ipAttacks = new ArrayList<AttackFlowPeakTopN>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackFlowPeakTopN ipAttackFlowPeakTopN = new AttackFlowPeakTopN();
                    String zoneIp = rs.getString("ZONE_IP");
                    Long zoneId = rs.getLong("ZONE_ID");
                    String deviceIp = rs.getString("DEVICE_IP");
                    Long startDate = rs.getLong("START_TIME");
                    Long endData = rs.getLong("END_TIME");
                    ipAttackFlowPeakTopN.setDisIp(zoneIp);
                    ipAttackFlowPeakTopN.setZoneId(zoneId);
                    ipAttackFlowPeakTopN.setZoneIp(zoneIp);
                    ipAttackFlowPeakTopN.setDeviceIp(deviceIp);
                    ipAttackFlowPeakTopN.setAttackFlowPeak(rs.getLong("DROP_FLOW_PEAK"));
                    ipAttackFlowPeakTopN.setStartDate(startDate);
                    ipAttackFlowPeakTopN.setEndData(endData);
                    ipAttacks.add(ipAttackFlowPeakTopN);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return ipAttacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttackFlowPeakTopN>> findZoneAttackFlowPeakTopN(String sql, Map<Integer, Object> condition) {
        HashMap<String, List<AttackFlowPeakTopN>> zoneAttackFlowPeakMap = new HashMap<String, List<AttackFlowPeakTopN>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackFlowPeakTopN zoneAttackFlowPeakTopN = new AttackFlowPeakTopN();
                    Long zoneId = rs.getLong("ZONE_ID");
                    String deviceIp = rs.getString("DEVICE_IP");
                    zoneAttackFlowPeakTopN.setZoneId(zoneId);
                    zoneAttackFlowPeakTopN.setDeviceIp(deviceIp);
                    zoneAttackFlowPeakTopN.setAttackFlowPeak(rs.getLong("DROP_PEAK"));
                    if (zoneAttackFlowPeakMap.containsKey(deviceIp)) {
                        ((List)zoneAttackFlowPeakMap.get(deviceIp)).add(zoneAttackFlowPeakTopN);
                        continue;
                    }
                    ArrayList<AttackFlowPeakTopN> zoneAttackFlowPeakTopNs = new ArrayList<AttackFlowPeakTopN>();
                    zoneAttackFlowPeakTopNs.add(zoneAttackFlowPeakTopN);
                    zoneAttackFlowPeakMap.put(deviceIp, zoneAttackFlowPeakTopNs);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return zoneAttackFlowPeakMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackTrend> findAttackTypeAnalysis(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackTrend> attackTrends = new ArrayList<AttackTrend>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackTrend attackTrend = new AttackTrend();
                    long dateTime = rs.getLong("LOG_TIME");
                    attackTrend.setDateTime(dateTime);
                    attackTrend.setAttackTypePackagePps(rs.getLong("DROP_PPS"));
                    attackTrend.setAttackTypePackageKbps(rs.getLong("DROP_KBPS"));
                    attackTrends.add(attackTrend);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attackTrends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackExactLog> getAbnormalOrAttackCount(String sql, Map<Integer, Object> condition) {
        ArrayList<AttackExactLog> attacktLogs = new ArrayList<AttackExactLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackExactLog attackLog = new AttackExactLog();
                    attackLog.setDeviceIp(rs.getString("DEVICE_IP"));
                    long startAlert = rs.getLong("start_time_alert");
                    long startAttack = rs.getLong("start_time_attack");
                    String disStartAlert = startAlert == 0L ? "-" : LogUtil.formateTime(startAlert);
                    attackLog.setDisStartTimeAlert(disStartAlert);
                    attackLog.setStartTimeAlert(startAlert);
                    String disStartAttack = startAttack == 0L ? "-" : LogUtil.formateTime(startAttack);
                    attackLog.setDisStartTimeAttack(disStartAttack);
                    attackLog.setStartTimeAttack(startAttack);
                    attackLog.setAttackCount(rs.getInt("COUNT"));
                    attacktLogs.add(attackLog);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return attacktLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackLog> findIpAattackEvent(String sql, Map<Integer, Object> map) {
        ArrayList<AttackLog> returnAttackLogs = new ArrayList<AttackLog>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : map.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackLog attackLog = new AttackLog();
                    attackLog.setDirection(rs.getInt("DIRECTION"));
                    attackLog.setDeviceIp(rs.getString("DEVICE_IP"));
                    attackLog.setDeviceType(rs.getInt("DEVICE_TYPE"));
                    attackLog.setZoneId(rs.getLong("ZONE_ID"));
                    attackLog.setZoneIp(rs.getString("ZONE_IP"));
                    attackLog.setAbnormalTime(rs.getLong("START_TIME_ALERT"));
                    long startTimeAttack = rs.getLong("START_TIME_ATTACK");
                    if (startTimeAttack <= 0L) {
                        startTimeAttack = rs.getLong("START_TIME_ALERT");
                    }
                    attackLog.setAttackTime(startTimeAttack);
                    attackLog.setAttackStartTime(LogUtil.formateTime(startTimeAttack));
                    attackLog.setStatus(String.valueOf(rs.getInt("ATTACK_STATUS")));
                    attackLog.setAttackType(rs.getString("ATTACK_TYPE"));
                    String duration = String.valueOf(rs.getLong("DURATION"));
                    attackLog.setDuration(duration);
                    attackLog.setPort(this.queryDestinationPort(rs.getString("PORTS")));
                    attackLog.setIpAttackPeakKbps(rs.getLong("IP_MAX_DROP_KBPS"));
                    attackLog.setIpAttackPeakPps(rs.getLong("IP_MAX_DROP_PPS"));
                    returnAttackLogs.add(attackLog);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return returnAttackLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceAttackData> findDeviceAttackDropData(String sql, Map<Integer, Object> condition, List<DeviceAttackData> deviceAttackDataList) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DeviceAttackData deviceAttackData = new DeviceAttackData();
                    deviceAttackData.setLogTime(rs.getLong("LOG_TIME"));
                    deviceAttackData.setDeviceIp(rs.getString("DEVICE_IP"));
                    deviceAttackData.setAttackFlow(rs.getLong("EVERAGE_KBPS"));
                    deviceAttackData.setMaxAttackFlow(rs.getLong("MAX_KBPS"));
                    deviceAttackDataList.add(deviceAttackData);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return deviceAttackDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long findDeviceAttackCount(String sql, Map<Integer, Object> condition) {
        Long count = 0L;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    count = rs.getLong("count");
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return count;
    }

    public static List<String> queryTablePostfixList(String tableName, Long startTime, Long endTime) {
        ArrayList<String> tablePostfixList = new ArrayList<String>();
        List<VersionUpgrade> versionUpgradeList = DBStat.getVersionUpgradeList();
        if (versionUpgradeList.size() == 0) {
            tablePostfixList.add("");
            return tablePostfixList;
        }
        for (VersionUpgrade versionInfo : versionUpgradeList) {
            if (startTime >= versionInfo.getUpTime()) continue;
            if (DBStat.checkTableExist(tableName + versionInfo.getTablePostfix()) && DBStat.checkTablePostFixByTablename(tableName, versionInfo.getTablePostfix())) {
                tablePostfixList.add(versionInfo.getTablePostfix());
            }
            if (endTime > versionInfo.getUpTime()) continue;
            return tablePostfixList;
        }
        VersionUpgrade lastUpgrade = versionUpgradeList.get(versionUpgradeList.size() - 1);
        if (startTime >= lastUpgrade.getUpTime() || endTime > lastUpgrade.getUpTime()) {
            tablePostfixList.add("");
        }
        return tablePostfixList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VersionUpgrade> getVersionUpgradeList() {
        ArrayList<VersionUpgrade> versionUpgradeList = new ArrayList<VersionUpgrade>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                String sql = "select id, v_code, r_code, b_code, up_time, table_postfix from ATIC_VERSION_UPGRADE_INFO order by id asc ";
                StringBuffer temSql = new StringBuffer(sql);
                stmt = conn.prepareStatement(temSql.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    VersionUpgrade versionUpgrade = new VersionUpgrade();
                    versionUpgrade.setId(rs.getLong("id"));
                    versionUpgrade.setvCode(rs.getLong("v_code"));
                    versionUpgrade.setrCode(rs.getLong("r_code"));
                    versionUpgrade.setbCode(rs.getLong("b_code"));
                    versionUpgrade.setUpTime(rs.getLong("up_time"));
                    versionUpgrade.setTablePostfix(rs.getString("table_postfix"));
                    versionUpgradeList.add(versionUpgrade);
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"getVersionUpgradeList:execute sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return versionUpgradeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkTablePostFixByTablename(String tableName, String tablePostFix) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean tablePostfixExist = false;
        if (conn != null) {
            try {
                String str2 = "select table_postfix from atic_column_upgrade_info  where table_name = ? and table_postfix = ? group by table_postfix ";
                stmt = conn.prepareStatement(str2);
                stmt.setString(1, tableName);
                stmt.setString(2, tablePostFix);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (!tablePostFix.trim().equals(rs.getString("table_postfix"))) continue;
                    tablePostfixExist = true;
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"queryTablePostfixList sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return tablePostfixExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkColumnExist(String columnName, String tableName) {
        boolean columnExist = false;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                String str2 = "select count(0) as count from information_schema.columns  where table_name = ? and column_name = ? ";
                stmt = conn.prepareStatement(str2);
                stmt.setString(1, tableName);
                stmt.setString(2, columnName);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getInt("count") <= 0) continue;
                    columnExist = true;
                }
                DBStat.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"checkColumnExist sql fail");
            }
            finally {
                DBStat.freeDbResource(conn, stmt, rs);
            }
        }
        return columnExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkTableExist(String tableName) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean tableExist = false;
        if (conn != null) {
            try {
                String str2 = "SELECT count(*) as COUNT FROM information_schema.TABLES where table_name = ?";
                stmt = conn.prepareStatement(str2);
                stmt.setString(1, tableName);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (rs.getLong("COUNT") <= 0L) continue;
                    tableExist = true;
                }
                CommonUtil.free(conn, stmt, rs);
            }
            catch (SQLException ex) {
                LOG.error((Object)"getForwardDBHoldTime sql fail");
            }
            finally {
                CommonUtil.free(conn, stmt, rs);
            }
        }
        return tableExist;
    }
}

