/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.zonedynblacklist;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.log.ZoneBlackCondition;
import com.hs.atic.collector.entity.zonedynblacklist.ZoneDynBlackListObj;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZoneDynBlackListDb {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final int INVALIDATE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoneDynBlackListObj> queryDynBlackList(Long zoneId) {
        ArrayList<ZoneDynBlackListObj> blackList = new ArrayList<ZoneDynBlackListObj>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            String sql = "SELECT * FROM ATIC_ZONE_BLACKLIST Where ZONE_ID = ? AND STATUS <> ? ";
            try {
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, zoneId);
                pstmt.setInt(2, 0);
                result = pstmt.executeQuery();
                while (result.next()) {
                    ZoneDynBlackListObj blist = new ZoneDynBlackListObj();
                    blist.setId(result.getLong("PKID"));
                    blist.setDeviceIp(result.getLong("DEVICE_IP"));
                    blist.setZoneId(result.getLong("ZONE_ID"));
                    blist.setBlackIp(result.getLong("BLACK_IP"));
                    blist.setPort(result.getInt("PORT"));
                    blist.setProtocol(result.getInt("PROTOCOL"));
                    blist.setBlackListType(result.getInt("BLACK_TYPE"));
                    blist.setState(result.getInt("STATUS"));
                    blist.setEnable(result.getInt("ENABLE"));
                    blackList.add(blist);
                }
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"queryDynBlackList SQLException");
            }
            finally {
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
        }
        LOGGER.info(blackList);
        return blackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZoneDynBlackListObj> queryDynBlackListForDefaultZone(String condition) {
        ArrayList<ZoneDynBlackListObj> blackList = new ArrayList<ZoneDynBlackListObj>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            String sql = "SELECT * FROM ATIC_ZONE_BLACKLIST Where ZONE_ID = 1 AND DEVICE_IP IN (?) AND STATUS <> ? ";
            try {
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, condition);
                pstmt.setInt(2, 0);
                result = pstmt.executeQuery();
                while (result.next()) {
                    ZoneDynBlackListObj blist = new ZoneDynBlackListObj();
                    blist.setId(result.getLong("PKID"));
                    blist.setDeviceIp(result.getLong("DEVICE_IP"));
                    blist.setZoneId(result.getLong("ZONE_ID"));
                    blist.setBlackIp(result.getLong("BLACK_IP"));
                    blist.setPort(result.getInt("PORT"));
                    blist.setProtocol(result.getInt("PROTOCOL"));
                    blist.setBlackListType(result.getInt("BLACK_TYPE"));
                    blist.setState(result.getInt("STATUS"));
                    blist.setEnable(result.getInt("ENABLE"));
                    blackList.add(blist);
                }
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"queryDynBlackListForDefaultZone SQLException");
            }
            finally {
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
        }
        LOGGER.info(blackList);
        return blackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBlackListState(List<Long> pkids, int enable) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = DBConnPool.getConnection();
            conn.setAutoCommit(false);
            String sql = "UPDATE ATIC_ZONE_BLACKLIST SET ENABLE = ? WHERE PKID = ? ";
            pstmt = conn.prepareStatement(sql);
            for (long pkid : pkids) {
                pstmt.setInt(1, enable);
                pstmt.setLong(2, pkid);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
            this.closeConn(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"When excute query ,some errors happened");
                int n = -1;
                this.closeConn(conn, pstmt);
                return n;
            }
            catch (Throwable throwable) {
                this.closeConn(conn, pstmt);
                throw throwable;
            }
        }
        return enable;
    }

    private void closeConn(Connection conn, PreparedStatement pstmt) {
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            if (conn != null) {
                conn.setAutoCommit(true);
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    private void closeResult(ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close result,some errors happened");
        }
    }

    public List<ZoneDynBlackListObj> queryDynBlackList(ZoneBlackCondition condition) {
        HashMap<Integer, Object> sqlCondition = new HashMap<Integer, Object>();
        String sql = this.getSql(condition, sqlCondition);
        String dataSql = "select * " + sql + " limit " + condition.getStartRow() + " , " + condition.getLimit();
        List<ZoneDynBlackListObj> data = this.queryDynBlackList(dataSql, sqlCondition);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long queryDynBlackListCount(String sql, Map<Integer, Object> condition) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                pstmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    pstmt.setObject(entry.getKey(), entry.getValue());
                }
                result = pstmt.executeQuery();
                if (result.next()) {
                    Long l = result.getLong("count(*)");
                    this.closeResult(result);
                    this.closeConn(conn, pstmt);
                    return l;
                }
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"queryDynBlackListCount SQLException");
            }
            finally {
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZoneDynBlackListObj> queryDynBlackList(String sql, Map<Integer, Object> condition) {
        ArrayList<ZoneDynBlackListObj> blackList = new ArrayList<ZoneDynBlackListObj>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                pstmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : condition.entrySet()) {
                    pstmt.setObject(entry.getKey(), entry.getValue());
                }
                result = pstmt.executeQuery();
                while (result.next()) {
                    ZoneDynBlackListObj blist = new ZoneDynBlackListObj();
                    blist.setId(result.getLong("PKID"));
                    blist.setDeviceIp(result.getLong("DEVICE_IP"));
                    blist.setZoneId(result.getLong("ZONE_ID"));
                    blist.setBlackIp(result.getLong("BLACK_IP"));
                    blist.setPort(result.getInt("PORT"));
                    blist.setProtocol(result.getInt("PROTOCOL"));
                    blist.setBlackListType(result.getInt("BLACK_TYPE"));
                    blist.setState(result.getInt("STATUS"));
                    blist.setEnable(result.getInt("ENABLE"));
                    blackList.add(blist);
                }
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"queryDynBlackList SQLException");
            }
            finally {
                this.closeResult(result);
                this.closeConn(conn, pstmt);
            }
        }
        LOGGER.info(blackList);
        return blackList;
    }

    private String getSql(ZoneBlackCondition condition, Map<Integer, Object> sqlCondition) {
        int index = 1;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" from atic_zone_blacklist where 1=1 ");
        if (condition.isIsDefault().booleanValue()) {
            buffer.append(" and zone_id = 1 and device_ip in ( ");
            for (int i = 0; i < condition.getDeviceIp().size(); ++i) {
                buffer.append('?');
                sqlCondition.put(index++, condition.getDeviceIp().get(i));
                if (i >= condition.getDeviceIp().size() - 1) continue;
                buffer.append(" , ");
            }
            buffer.append("  ) ");
        } else {
            buffer.append(" and zone_id = ? ");
            sqlCondition.put(index++, condition.getZoneId());
        }
        if (condition.getBlackState() != null) {
            buffer.append(" and enable  = ? ");
            sqlCondition.put(index++, condition.getBlackState());
        }
        if (condition.getBlackIp() != null) {
            buffer.append(" and black_ip = ? ");
            sqlCondition.put(index++, condition.getBlackIp());
        }
        if (condition.getBlackAttackType() != null) {
            buffer.append(" and black_type  = ? ");
            sqlCondition.put(index++, condition.getBlackAttackType());
        }
        buffer.append(" order by black_ip ");
        return buffer.toString();
    }

    public Long queryDynBlackListCount(ZoneBlackCondition condition) {
        HashMap<Integer, Object> sqlCondition = new HashMap<Integer, Object>();
        String sql = this.getSql(condition, sqlCondition);
        String dataSql = "select count(*) " + sql;
        Long count = this.queryDynBlackListCount(dataSql, sqlCondition);
        return count;
    }
}

