/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.zonepacket;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.collector.entity.pcap.PcapFileQueryObj;
import com.hs.atic.collector.entity.pcap.PcapObj;
import com.hs.atic.collector.entity.zonepacket.ZonePacketInfoObj;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBZonePacketInfo
implements Serializable {
    protected static final Logger LOGGER = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = 1L;
    private static Map<String, String> sortFieldMap = new HashMap<String, String>();
    private static final int NGE_ATTACK_VALUE = 65;

    private static Connection getConnection() {
        Connection conn = DBConnPool.getConnection();
        return conn;
    }

    public List<ZonePacketInfoObj> findZonePacketList(PcapFileQueryObj pcapFileQueryObj) {
        if (pcapFileQueryObj != null) {
            String sortType = pcapFileQueryObj.getSortType();
            int startPage = pcapFileQueryObj.getStartPage();
            int pageSize = pcapFileQueryObj.getPageSize();
            String sortField = pcapFileQueryObj.getSortField();
            HashMap<Integer, Object> queryMap = new HashMap<Integer, Object>();
            String sql = "SELECT * from " + this.createSql(pcapFileQueryObj, queryMap);
            LOGGER.info((Object)("queryMap:" + ((Object)queryMap).toString()));
            if (null != this.getSortColumn(sortField) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
                sql = sql + " order by " + this.getSortColumn(sortField) + " " + sortType;
            }
            sql = sql + " limit " + startPage + ',' + pageSize;
            LOGGER.info((Object)("sql: zoneId is" + pcapFileQueryObj.getZoneId()));
            return this.findZonePacketList(sql, queryMap);
        }
        return new ArrayList<ZonePacketInfoObj>();
    }

    public int findZonePacketSize(PcapFileQueryObj pcapFileQueryObj) {
        HashMap<Integer, Object> queryMap = new HashMap<Integer, Object>();
        if (pcapFileQueryObj != null) {
            String sql = "SELECT count(*) number from " + this.createSql(pcapFileQueryObj, queryMap);
            return this.findZonePacketSize(sql, queryMap);
        }
        return 0;
    }

    private String createSql(PcapFileQueryObj pcapFileQueryObj, Map<Integer, Object> queryMap) {
        List<String> taskIdList = pcapFileQueryObj.getTaskIdList();
        Long zoneId = pcapFileQueryObj.getZoneId();
        long begintime = pcapFileQueryObj.getBeginTime();
        long endtime = pcapFileQueryObj.getEndTime();
        String filename = pcapFileQueryObj.getFileName();
        String zoneStat = pcapFileQueryObj.getFileState();
        String pcapType = pcapFileQueryObj.getPcapType();
        Integer attackType = pcapFileQueryObj.getAttackType();
        Integer deviceType = pcapFileQueryObj.getDeviceType();
        String queryPacketIp = pcapFileQueryObj.getQueryPacketIp();
        String queryDeviceIp = pcapFileQueryObj.getQueryDeviceIp();
        Integer protocol = pcapFileQueryObj.getProtocol();
        Integer port = pcapFileQueryObj.getPort();
        StringBuffer sb = new StringBuffer("atic_pcap_file WHERE 1=1");
        int index = 1;
        if (null != zoneId) {
            sb.append(" AND ZONE_ID = ?");
            queryMap.put(index++, zoneId);
        }
        if (null != queryDeviceIp && !"".equals(queryDeviceIp)) {
            sb.append(" AND DEVICE_IP = ?");
            queryMap.put(index++, IpTransformer.formatIpAddress(queryDeviceIp));
        }
        if (null != queryPacketIp && !"".equals(queryPacketIp)) {
            sb.append(" AND ZONE_IP = ?");
            queryMap.put(index++, IpTransformer.formatIpAddress(queryPacketIp));
        }
        if (null != pcapType && !"".equals(pcapType) && !"4".equals(pcapType)) {
            sb.append(" AND PCAP_TYPE = ?");
            queryMap.put(index++, pcapType);
        }
        if (null != deviceType) {
            sb.append(" AND DEVICE_TYPE= ?");
            queryMap.put(index++, deviceType);
        }
        if (null != zoneStat && !"".equals(zoneStat) && !"2".equals(zoneStat)) {
            sb.append(" AND STATUS = ?");
            queryMap.put(index++, zoneStat);
        }
        if (endtime == CollectorConstants.ZONE_PACKET_TIME && begintime != CollectorConstants.ZONE_PACKET_TIME) {
            sb.append(" AND start_time >= ?");
            queryMap.put(index++, begintime);
        }
        if (endtime != CollectorConstants.ZONE_PACKET_TIME && begintime == CollectorConstants.ZONE_PACKET_TIME) {
            sb.append(" AND end_time <= ?");
            queryMap.put(index++, endtime);
        }
        if (endtime != CollectorConstants.ZONE_PACKET_TIME && begintime != CollectorConstants.ZONE_PACKET_TIME) {
            sb.append(" AND (start_time BETWEEN ? AND ?) ");
            queryMap.put(index++, begintime);
            queryMap.put(index++, endtime);
        }
        if (attackType != null) {
            if (attackType < 10) {
                if (protocol != null) {
                    sb.append(" AND attack_type = ?");
                    queryMap.put(index++, attackType);
                }
                if (port != null) {
                    sb.append(" AND PORT = ?");
                    queryMap.put(index++, port);
                }
            } else if (attackType >= 1008 && attackType <= 1011 || attackType == 1000) {
                sb.append(" AND attack_type = ?");
                queryMap.put(index++, 65);
            } else {
                sb.append(" AND attack_type = ?");
                queryMap.put(index++, attackType);
            }
        }
        if (filename != null && !"".equals(filename)) {
            sb.append(" AND file_name like ?");
            queryMap.put(index++, "%" + filename + "%");
        }
        if (null != taskIdList && !taskIdList.isEmpty()) {
            sb.append(" AND pcap_id IN ( ");
            for (int i = 0; i < taskIdList.size(); ++i) {
                if (i == 0) {
                    sb.append('?');
                    queryMap.put(index++, taskIdList.get(i));
                    continue;
                }
                sb.append(',');
                sb.append('?');
                queryMap.put(index++, taskIdList.get(i));
            }
            sb.append(" )");
        }
        LOGGER.info((Object)queryMap.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcapObj findZonePacketPcapList(long pkid) {
        String sql = "SELECT * FROM atic_pcap WHERE pkid= ?";
        Connection conn = DBZonePacketInfo.getConnection();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        if (conn != null) {
            try {
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, pkid);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    PcapObj pcapObj = new PcapObj();
                    pcapObj.setId(pkid);
                    pcapObj.setPcapName(rs.getString("pcap_name"));
                    pcapObj.setPcapType(rs.getLong("pcap_type"));
                    PcapObj pcapObj2 = pcapObj;
                    DBZonePacketInfo.close(rs, stmt, conn);
                    return pcapObj2;
                }
                DBZonePacketInfo.close(rs, stmt, conn);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"findZonePacketPcapList SQLException");
            }
            finally {
                DBZonePacketInfo.close(rs, stmt, conn);
            }
        }
        return null;
    }

    public RmiTuple<List<ZonePacketInfoObj>, Long> findZonePacketPage(PcapFileQueryObj pcapFileQueryObj) {
        List<ZonePacketInfoObj> list = this.findZonePacketList(pcapFileQueryObj);
        long total = this.findZonePacketSize(pcapFileQueryObj);
        RmiTuple<List<ZonePacketInfoObj>, Long> result = new RmiTuple<List<ZonePacketInfoObj>, Long>(list, total);
        return result;
    }

    public ZonePacketInfoObj findZonePacketByFileName(String fileName) {
        HashMap<Integer, Object> queryMap = new HashMap<Integer, Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM atic_pcap_file WHERE file_name = ?");
        queryMap.put(1, fileName);
        List<ZonePacketInfoObj> list = this.findZonePacketList(sb.toString(), queryMap);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZonePacketInfoObj> findZonePacketList(String sql, Map<Integer, Object> queryMap) {
        Connection conn = DBZonePacketInfo.getConnection();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        ArrayList<ZonePacketInfoObj> list = new ArrayList<ZonePacketInfoObj>();
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : queryMap.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ZonePacketInfoObj zonePacketInfoObj = new ZonePacketInfoObj();
                    zonePacketInfoObj.setZonePacketId(Long.valueOf(rs.getString("pkid")));
                    zonePacketInfoObj.setFileName(rs.getString("file_Name"));
                    zonePacketInfoObj.setStatus(rs.getString("status"));
                    zonePacketInfoObj.setDeviceIp(rs.getString("device_ip"));
                    zonePacketInfoObj.setZoneId(rs.getLong("zone_id"));
                    zonePacketInfoObj.setPcapNumber(rs.getLong("pcap_number"));
                    zonePacketInfoObj.setFileSize(rs.getLong("file_size"));
                    zonePacketInfoObj.setStartTime(rs.getLong("start_time"));
                    zonePacketInfoObj.setEndTime(rs.getLong("end_time"));
                    zonePacketInfoObj.setPcapId(rs.getLong("pcap_id"));
                    zonePacketInfoObj.setPcapType(rs.getInt("pcap_type"));
                    zonePacketInfoObj.setDeviceType(rs.getInt("device_type"));
                    zonePacketInfoObj.setAttackType(rs.getInt("attack_type"));
                    zonePacketInfoObj.setProtocol(rs.getInt("protocol"));
                    zonePacketInfoObj.setPort(rs.getInt("port"));
                    zonePacketInfoObj.setZoneIp(rs.getString("ZONE_IP"));
                    list.add(zonePacketInfoObj);
                }
                ArrayList<ZonePacketInfoObj> arrayList = list;
                DBZonePacketInfo.close(rs, stmt, conn);
                return arrayList;
            }
            catch (SQLException e) {
                LOGGER.error((Object)"findZonePacketList SQLException ");
            }
            finally {
                DBZonePacketInfo.close(rs, stmt, conn);
            }
        }
        return new ArrayList<ZonePacketInfoObj>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findZonePacketSize(String sql, Map<Integer, Object> queryMap) {
        Connection conn = DBZonePacketInfo.getConnection();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                for (Map.Entry<Integer, Object> entry : queryMap.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int n = rs.getInt("number");
                    DBZonePacketInfo.close(rs, stmt, conn);
                    return n;
                }
                DBZonePacketInfo.close(rs, stmt, conn);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"findZonePacketSize SQLException");
            }
            finally {
                DBZonePacketInfo.close(rs, stmt, conn);
            }
        }
        return 0;
    }

    private String getSortColumn(String sortField) {
        return sortFieldMap.get(sortField);
    }

    private static void close(ResultSet rs, PreparedStatement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e1) {
                LOGGER.error((Object)"close rs error");
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e2) {
                    LOGGER.error((Object)"close stmt error");
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e3) {
                        LOGGER.error((Object)"close rs error");
                    }
                }
            }
        }
    }

    static {
        sortFieldMap.put("fileName", "FILE_NAME");
        sortFieldMap.put("pcapId", "PCAP_ID");
        sortFieldMap.put("deviceName", "DEVICE_IP");
        sortFieldMap.put("zoneIp", "ZONE_IP");
        sortFieldMap.put("pcapType", "PCAP_TYPE");
        sortFieldMap.put("status", "STATUS");
        sortFieldMap.put("pcapNumber", "PCAP_NUMBER");
        sortFieldMap.put("fileSize", "FILE_SIZE");
        sortFieldMap.put("startTime", "START_TIME");
        sortFieldMap.put("attackType", "ATTACK_TYPE");
    }
}

