/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity;

import com.hs.atic.collector.biz.pcap.AESDecryptorFactory;
import com.hs.atic.collector.db.DeviceCondition;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.HmacUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public final class Collector {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private static Collector instance = new Collector();
    private Map<String, DeviceObj> devices = null;

    public static synchronized Collector getInstance() {
        if (null == Collector.instance.devices) {
            Collector.instance.devices = new ConcurrentHashMap<String, DeviceObj>();
            Collector.loadDevices();
        }
        return instance;
    }

    private static void loadDevices() {
        Repository repository = RepositoryFactory.getInstance().getRepository(DeviceObj.class.getName());
        if (null != repository) {
            List devices = repository.queryObject(new DeviceCondition());
            for (DeviceObj device : devices) {
                if (CommonUtil.isNull(device.getLogIp())) {
                    device.setLogIp(device.getDeviceIp());
                }
                Collector.instance.devices.put(device.getLogIp(), device);
                HmacUtil.getInstance().modifyDeviceMac(device);
                AESDecryptorFactory.getInstance().modifyDevDecryptor(device);
            }
        }
    }

    public boolean addDevice(DeviceObj device) {
        this.devices.put(device.getLogIp(), device);
        HmacUtil.getInstance().modifyDeviceMac(device);
        AESDecryptorFactory.getInstance().modifyDevDecryptor(device);
        return true;
    }

    public DeviceObj getDeviceByIp(String logip) {
        return this.devices.get(logip);
    }

    public List<DeviceObj> getDevices() {
        ArrayList<DeviceObj> values = new ArrayList<DeviceObj>();
        values.addAll(this.devices.values());
        return values;
    }

    public boolean modifyDevice(DeviceObj device) {
        this.devices.put(device.getLogIp(), device);
        HmacUtil.getInstance().modifyDeviceMac(device);
        AESDecryptorFactory.getInstance().modifyDevDecryptor(device);
        return true;
    }

    public void removeAllDevices() {
        this.devices.clear();
    }

    public boolean removeDevice(DeviceObj device) {
        String ddosLogIp = device.getLogIp();
        return this.removeDevice(ddosLogIp);
    }

    public boolean removeDevice(String ddosLogIp) {
        this.devices.remove(ddosLogIp);
        return true;
    }
}

